/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage.serializer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.garbage.serializer.Serializer;
import org.apache.garbage.serializer.encoding.Charset;
import org.apache.garbage.serializer.encoding.CharsetFactory;
import org.apache.garbage.serializer.util.Namespaces;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractSerializer
implements Serializer,
Locator {
    private static final char[] S_EOL = System.getProperty("line.separator").toCharArray();
    public static final int ATTRIBUTE_NSURI = 0;
    public static final int ATTRIBUTE_LOCAL = 1;
    public static final int ATTRIBUTE_QNAME = 2;
    public static final int ATTRIBUTE_VALUE = 3;
    public static final int ATTRIBUTE_LENGTH = 4;
    private Locator locator = null;
    private Writer out = null;
    private boolean prolog = true;
    private boolean processing = false;
    protected String encoding = null;
    protected Charset charset = null;
    protected Namespaces namespaces = new Namespaces();

    public AbstractSerializer() {
        this.reset();
    }

    public void reset() {
        if (this.processing) {
            throw new IllegalStateException();
        }
        this.locator = null;
        this.out = null;
        this.prolog = true;
        this.encoding = null;
        this.charset = null;
        this.namespaces = new Namespaces();
    }

    public void setOutput(OutputStream outputStream) {
        this.setOutput(new OutputStreamWriter(outputStream));
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this.setOutput(new OutputStreamWriter(outputStream, string));
    }

    public void setOutput(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("Null writer");
        }
        if (writer instanceof OutputStreamWriter) {
            this.encoding = ((OutputStreamWriter)writer).getEncoding();
        }
        CharsetFactory charsetFactory = CharsetFactory.newInstance();
        try {
            this.charset = charsetFactory.getCharset(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.charset = charsetFactory.getCharset();
        }
        this.encoding = this.charset.getName();
        this.out = new BufferedWriter(writer);
    }

    public final void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public String getPublicId() {
        return this.locator == null ? null : this.locator.getPublicId();
    }

    public String getSystemId() {
        return this.locator == null ? null : this.locator.getSystemId();
    }

    public int getLineNumber() {
        return this.locator == null ? -1 : this.locator.getLineNumber();
    }

    public int getColumnNumber() {
        return this.locator == null ? -1 : this.locator.getColumnNumber();
    }

    protected String getLocation() {
        if (this.locator == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(" (");
        if (this.getSystemId() != null) {
            stringBuffer.append(this.getSystemId());
            stringBuffer.append(' ');
        }
        stringBuffer.append("line " + this.getLineNumber());
        stringBuffer.append(" col " + this.getColumnNumber());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    protected void flush() throws SAXException {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error flushing: " + iOException.getMessage(), iOException);
        }
    }

    protected void write(char[] cArray) throws SAXException {
        try {
            this.out.write(cArray, 0, cArray.length);
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error writing: " + iOException.getMessage(), iOException);
        }
    }

    protected void write(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.out.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error writing: " + iOException.getMessage(), iOException);
        }
    }

    protected void write(int n) throws SAXException {
        try {
            this.out.write(n);
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error writing: " + iOException.getMessage(), iOException);
        }
    }

    protected void write(String string) throws SAXException {
        try {
            this.out.write(string);
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error writing: " + iOException.getMessage(), iOException);
        }
    }

    protected void write(String string, int n, int n2) throws SAXException {
        try {
            this.out.write(string, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error writing: " + iOException.getMessage(), iOException);
        }
    }

    protected void writeln() throws SAXException {
        try {
            this.out.write(S_EOL);
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error writing: " + iOException.getMessage(), iOException);
        }
    }

    protected void writeln(String string) throws SAXException {
        try {
            this.out.write(string);
            this.out.write(S_EOL);
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error writing: " + iOException.getMessage(), iOException);
        }
    }

    public void startDocument() throws SAXException {
        this.processing = true;
    }

    public void endDocument() throws SAXException {
        this.processing = false;
        this.flush();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.namespaces.push(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.namespaces.pop(string);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = this.namespaces.qualify(string, string2, string3);
        if (this.prolog) {
            this.body(string, string2, string4);
            this.prolog = false;
        }
        String[][] stringArray = this.namespaces.commit();
        String[][] stringArray2 = new String[attributes.getLength()][4];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n][0] = attributes.getURI(n);
            stringArray2[n][1] = attributes.getLocalName(n);
            stringArray2[n][2] = this.namespaces.qualify(attributes.getURI(n), attributes.getLocalName(n), attributes.getQName(n));
            stringArray2[n][3] = attributes.getValue(n);
            ++n;
        }
        this.startElementImpl(string, string2, string4, stringArray, stringArray2);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = this.namespaces.qualify(string, string2, string3);
        this.endElementImpl(string, string2, string4);
    }

    public abstract void body(String var1, String var2, String var3) throws SAXException;

    public abstract void startElementImpl(String var1, String var2, String var3, String[][] var4, String[][] var5) throws SAXException;

    public abstract void endElementImpl(String var1, String var2, String var3) throws SAXException;
}

