/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Vector;
import org.apache.garbage.parser.JavaCharStream;
import org.apache.garbage.parser.ParseException;
import org.apache.garbage.parser.ParserConstants;
import org.apache.garbage.parser.ParserTables;
import org.apache.garbage.parser.ParserTokenManager;
import org.apache.garbage.parser.Token;
import org.apache.garbage.parser.TokenMgrError;
import org.apache.garbage.tree.Attribute;
import org.apache.garbage.tree.CData;
import org.apache.garbage.tree.Characters;
import org.apache.garbage.tree.Comment;
import org.apache.garbage.tree.DocType;
import org.apache.garbage.tree.ElementEnd;
import org.apache.garbage.tree.ElementStart;
import org.apache.garbage.tree.Events;
import org.apache.garbage.tree.Expression;
import org.apache.garbage.tree.ProcessingInstruction;
import org.apache.garbage.tree.TemplateFor;
import org.apache.garbage.tree.TemplateIf;
import org.apache.garbage.tree.TemplateVar;
import org.apache.garbage.tree.Tree;
import org.apache.garbage.tree.TreeException;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Parser
implements Locator,
ParserTables,
ParserConstants {
    private InputSource source = null;
    public int[] statesStk = new int[4096];
    int statesPos = 0;
    public ParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[16];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public Parser() {
        this((Reader)null);
    }

    public Tree parse(InputSource inputSource) throws SAXException, SAXParseException, IOException {
        Tree tree = new Tree();
        this.source = inputSource;
        if (inputSource == null) {
            throw new SAXException("Null source specified");
        }
        if (inputSource.getCharacterStream() != null) {
            this.ReInit(inputSource.getCharacterStream());
        } else if (inputSource.getByteStream() != null) {
            this.ReInit(inputSource.getByteStream());
        } else if (inputSource.getSystemId() != null) {
            File file = new File(System.getProperty("user.dir")).getCanonicalFile();
            URL uRL = new URL(file.toURL(), inputSource.getSystemId());
            InputStream inputStream = uRL.openStream();
            this.ReInit(new InputStreamReader(inputStream));
        } else {
            throw new SAXException("Cannot access source char or byte stream");
        }
        try {
            this.p_start(tree);
            this.ReInit((Reader)null);
        }
        catch (ParseException parseException) {
            if (parseException.currentToken != null) {
                throw new SAXParseException(parseException.getMessage(), this.getPublicId(), this.getSystemId(), parseException.currentToken.endLine, parseException.currentToken.endColumn, parseException);
            }
            throw new SAXParseException(parseException.getMessage(), this, parseException);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new SAXParseException(tokenMgrError.getMessage(), this);
        }
        catch (TreeException treeException) {
            throw new SAXParseException(treeException.getMessage(), treeException, treeException);
        }
        return tree;
    }

    public String getPublicId() {
        if (this.source != null) {
            return this.source.getPublicId();
        }
        return null;
    }

    public String getSystemId() {
        if (this.source != null) {
            return this.source.getSystemId();
        }
        return null;
    }

    public int getLineNumber() {
        if (this.token != null) {
            return this.token.endLine;
        }
        return -1;
    }

    public int getColumnNumber() {
        if (this.token != null) {
            return this.token.endColumn;
        }
        return -1;
    }

    public final Token getNextToken(int[] nArray) throws ParseException {
        Token token = this.token;
        Token token2 = this.getNextToken();
        int n = 0;
        while (n < nArray.length) {
            if (token2.kind == nArray[n]) {
                return token2;
            }
            ++n;
        }
        int[][] nArray2 = new int[nArray.length][1];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray2[n2][0] = nArray[n2];
            ++n2;
        }
        throw new ParseException(token, nArray2, ParserConstants.tokenImage);
    }

    public final Token getNextToken(int n) throws ParseException {
        int[] nArray = new int[]{n};
        return this.getNextToken(nArray);
    }

    public final Token getNextToken(int[] nArray, int n) throws ParseException {
        this.pushState(n);
        Token token = this.getNextToken(nArray);
        this.popState();
        return token;
    }

    public final Token getNextToken(int n, int n2) throws ParseException {
        int[] nArray = new int[]{n};
        return this.getNextToken(nArray, n2);
    }

    public void generateParseInternalError() throws ParseException {
        this.generateParseInternalError(null);
    }

    public void generateParseInternalError(String string) throws ParseException {
        if (string == null) {
            string = "Unrecoverable internal error";
        }
        string = this.token != null ? string + " at line " + this.token.beginLine + ", column " + this.token.beginColumn + "." : string + ".";
        ParseException parseException = new ParseException(string);
        parseException.currentToken = this.token;
        parseException.tokenImage = ParserConstants.tokenImage;
        throw parseException;
    }

    private final void pushState(int n) {
        this.statesStk[this.statesPos++] = this.token_source.curLexState;
        this.token_source.SwitchTo(n);
    }

    private final void popState() {
        int n = this.statesStk[--this.statesPos];
        this.token_source.SwitchTo(n);
    }

    protected char p_entityref_byname(String string) throws NumberFormatException {
        int n = string.hashCode();
        int n2 = 0;
        while (n2 < ParserTables.entityReferences.length) {
            if (n == ParserTables.entityReferences[n2][0]) {
                return (char)ParserTables.entityReferences[n2][1];
            }
            ++n2;
        }
        String string2 = string.length() == 0 ? " (zero length)" : "";
        throw new NumberFormatException("Invalid entity name supplied: \"" + string + "\"" + string2 + ".");
    }

    public final void p_start(Events events) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.p_doctype(events);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        this.p_block(events);
        this.jj_consume_token(0);
    }

    public final void p_block(Events events) throws ParseException {
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: {
                    this.p_characters(events);
                    break;
                }
                case 22: 
                case 23: {
                    this.p_element(events);
                    break;
                }
                case 33: {
                    this.p_entityref(events);
                    break;
                }
                case 38: {
                    this.p_comment(events);
                    break;
                }
                case 41: {
                    this.p_cdata(events);
                    break;
                }
                case 44: {
                    this.p_procinstr(events);
                    break;
                }
                case 49: {
                    this.p_expression(events);
                    break;
                }
                case 52: {
                    this.p_template_if(events);
                    break;
                }
                case 55: {
                    this.p_template_foreach(events);
                    break;
                }
                case 57: {
                    this.p_template_variable(events);
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: 
                case 22: 
                case 23: 
                case 33: 
                case 38: 
                case 41: 
                case 44: 
                case 49: 
                case 52: 
                case 55: 
                case 57: {
                    continue block15;
                }
            }
            break;
        }
        this.jj_la1[2] = this.jj_gen;
    }

    public final void p_characters(Events events) throws ParseException {
        this.jj_consume_token(11);
        events.append(new Characters((Locator)this, this.token.image));
    }

    public final void p_doctype(Events events) throws ParseException {
        String string = null;
        String string2 = null;
        String string3 = null;
        this.jj_consume_token(12);
        this.jj_consume_token(14);
        string = this.token.image;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 16: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        string2 = this.p_doctype_id(2);
                        break block0;
                    }
                    case 16: {
                        this.jj_consume_token(16);
                        string3 = this.p_doctype_id(3);
                        string2 = this.p_doctype_id(2);
                        break block0;
                    }
                }
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        this.jj_consume_token(13);
        events.append(new DocType(this, string, string3, string2));
    }

    public final String p_doctype_id(int n) throws ParseException {
        Token token = null;
        int n2 = -1;
        switch (n) {
            case 2: {
                n2 = 20;
                break;
            }
            case 3: {
                n2 = 21;
                break;
            }
            default: {
                this.generateParseInternalError("Invalid state " + n + "specified");
            }
        }
        this.jj_consume_token(17);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = this.token.kind;
        int[] nArray = new int[]{n2, 18, 19};
        this.pushState(n);
        token = this.getNextToken(nArray);
        while (token.kind != n3) {
            stringBuffer.append(token.image);
            token = this.getNextToken(nArray);
        }
        this.popState();
        return stringBuffer.toString();
    }

    public final void p_element(Events events) throws ParseException {
        ElementStart elementStart = null;
        String string = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                events.append(new ElementEnd(this, this.token.image.substring(2)));
                this.jj_consume_token(24);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                string = this.token.image.substring(1);
                elementStart = new ElementStart(this, string);
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 26: {
                            break;
                        }
                        default: {
                            this.jj_la1[6] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.p_attribute(elementStart);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        break;
                    }
                    case 25: {
                        this.jj_consume_token(25);
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                events.append(elementStart);
                if (this.token.kind != 25) break;
                events.append(new ElementEnd(this, string));
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void p_attribute(ElementStart elementStart) throws ParseException {
        Object var2_2 = null;
        Attribute attribute = null;
        this.jj_consume_token(26);
        attribute = new Attribute(this, this.token.image.trim());
        this.p_attribute_data(attribute);
        elementStart.put(attribute);
        this.token_source.SwitchTo(4);
    }

    public final void p_attribute_data(Attribute attribute) throws ParseException {
        Token token = null;
        this.jj_consume_token(27);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        int n = this.token.kind;
        int[] nArray = new int[]{32, 28, 29, 31, 30};
        this.pushState(6);
        token = this.getNextToken(nArray);
        while (token.kind != n) {
            switch (token.kind) {
                case 31: {
                    this.pushState(7);
                    attribute.append(new Characters(this.p_entityref_data()));
                    this.popState();
                    break;
                }
                case 30: {
                    this.pushState(12);
                    attribute.append(new Expression(this.p_expression_data()));
                    this.popState();
                    break;
                }
                default: {
                    attribute.append(new Characters(token.image));
                }
            }
            token = this.getNextToken(nArray);
        }
        this.popState();
    }

    public final void p_entityref(Events events) throws ParseException {
        char c = '\u0000';
        this.jj_consume_token(33);
        this.pushState(7);
        c = this.p_entityref_data();
        events.append(new Characters((Locator)this, c));
        this.popState();
    }

    public final char p_entityref_data() throws ParseException {
        int n = -1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        try {
            switch (this.token.kind) {
                case 35: {
                    n = Integer.parseInt(this.token.image.substring(1));
                    break;
                }
                case 36: {
                    n = Integer.parseInt(this.token.image.substring(2), 16);
                    break;
                }
                case 37: {
                    n = this.p_entityref_byname(this.token.image);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n < 0 || n > 65535) {
            this.generateParseInternalError("Invalid entity reference &" + this.token.image + ";");
        }
        this.jj_consume_token(34);
        return (char)n;
    }

    public final void p_comment(Events events) throws ParseException {
        String string = "";
        this.jj_consume_token(38);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                string = this.token.image;
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        this.jj_consume_token(39);
        events.append(new Comment((Locator)this, string));
    }

    public final void p_cdata(Events events) throws ParseException {
        String string = "";
        this.jj_consume_token(41);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: {
                this.jj_consume_token(43);
                string = this.token.image;
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        this.jj_consume_token(42);
        events.append(new CData((Locator)this, string));
    }

    public final void p_procinstr(Events events) throws ParseException {
        String string = null;
        String string2 = null;
        this.jj_consume_token(44);
        this.jj_consume_token(47);
        string = this.token.image;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                this.jj_consume_token(46);
                this.jj_consume_token(48);
                string2 = this.token.image;
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        this.jj_consume_token(45);
        events.append(new ProcessingInstruction(this, string, string2));
    }

    public final void p_expression(Events events) throws ParseException {
        String string = null;
        this.jj_consume_token(49);
        this.pushState(12);
        string = this.p_expression_data();
        events.append(new Expression(this, string));
        this.popState();
    }

    public final String p_expression_data() throws ParseException {
        String string = null;
        this.jj_consume_token(51);
        string = this.token.image;
        this.jj_consume_token(50);
        return string;
    }

    public final void p_template_foreach(Events events) throws ParseException {
        TemplateFor templateFor = null;
        this.jj_consume_token(55);
        this.pushState(12);
        templateFor = new TemplateFor(this, this.p_expression_data());
        this.popState();
        this.p_block(templateFor);
        this.jj_consume_token(56);
        events.append(templateFor);
    }

    public final void p_template_variable(Events events) throws ParseException {
        String string = null;
        String string2 = null;
        this.jj_consume_token(57);
        string = this.token.image.substring(2, this.token.image.indexOf(61)).trim();
        this.pushState(12);
        string2 = this.p_expression_data();
        this.popState();
        events.append(new TemplateVar(this, string, string2));
        System.err.println("Processed #$" + string + "={" + string2 + "}");
    }

    public final void p_template_if(Events events) throws ParseException {
        String string = null;
        TemplateIf templateIf = new TemplateIf(this);
        this.jj_consume_token(52);
        this.pushState(12);
        string = this.p_expression_data();
        this.popState();
        this.p_block(templateIf.addCondition(this, string));
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 53: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(53);
            this.pushState(12);
            string = this.p_expression_data();
            this.popState();
            this.p_block(templateIf.addCondition(this, string));
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                this.jj_consume_token(54);
                this.p_block(templateIf.addCondition(this));
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        this.jj_consume_token(56);
        events.append(templateIf);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{4096, 0xC00800, 0xC00800, 98304, 98304, 786432, 0x4000000, 0x3000000, 0xC00000, 0x30000000, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 43127362, 43127362, 0, 0, 0, 0, 0, 0, 0, 56, 256, 2048, 16384, 0x200000, 0x400000};
    }

    public Parser(InputStream inputStream) {
        this.jj_input_stream = new JavaCharStream(inputStream, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 16) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 16) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public Parser(Reader reader) {
        this.jj_input_stream = new JavaCharStream(reader, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 16) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public void ReInit(Reader reader) {
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 16) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public Parser(ParserTokenManager parserTokenManager) {
        this.token_source = parserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 16) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public void ReInit(ParserTokenManager parserTokenManager) {
        this.token_source = parserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 16) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        int n2 = 0;
        while (n2 < n) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
            ++n2;
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int n;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[58];
        int n2 = 0;
        while (n2 < 58) {
            blArray[n2] = false;
            ++n2;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int n3 = 0;
        while (n3 < 16) {
            if (this.jj_la1[n3] == this.jj_gen) {
                n = 0;
                while (n < 32) {
                    if ((jj_la1_0[n3] & 1 << n) != 0) {
                        blArray[n] = true;
                    }
                    if ((jj_la1_1[n3] & 1 << n) != 0) {
                        blArray[32 + n] = true;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        n = 0;
        while (n < 58) {
            if (blArray[n]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = n;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++n;
        }
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        int n4 = 0;
        while (n4 < this.jj_expentries.size()) {
            nArrayArray[n4] = (int[])this.jj_expentries.elementAt(n4);
            ++n4;
        }
        return new ParseException(this.token, nArrayArray, ParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        Parser.jj_la1_0();
        Parser.jj_la1_1();
    }
}

