/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.garbage.serializer.Serializer;
import org.apache.garbage.tree.Event;
import org.apache.garbage.tree.Events;
import org.apache.garbage.tree.Runtime;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class Processor
implements Runtime {
    private ContentHandler content = null;
    private LexicalHandler lexical = null;
    private Stack prefixes = null;
    private Stack elements = null;

    public Processor(Serializer serializer) {
        this(serializer, serializer);
    }

    public Processor(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        this.content = contentHandler;
        this.lexical = lexicalHandler;
        if (contentHandler == null) {
            throw new NullPointerException("No ContentHandler specifed");
        }
    }

    public void process(Events events, JXPathContext jXPathContext) throws SAXException {
        this.prefixes = new Stack();
        this.elements = new Stack();
        String[][] stringArrayArray = new String[][]{{"", ""}};
        this.prefixes.push(stringArrayArray);
        Iterator iterator = events.iterator();
        this.content.startDocument();
        while (iterator.hasNext()) {
            ((Event)iterator.next()).process(this, jXPathContext);
        }
        this.content.endDocument();
    }

    public void doctype(String string, String string2, String string3) throws SAXException {
        if (this.lexical == null) {
            return;
        }
        this.lexical.startDTD(string, string2, string3);
        this.lexical.endDTD();
    }

    public void cdata(char[] cArray) throws SAXException {
        if (this.lexical != null) {
            this.lexical.startCDATA();
            this.content.characters(cArray, 0, cArray.length);
            this.lexical.endCDATA();
            return;
        }
        this.content.characters(cArray, 0, cArray.length);
    }

    public void characters(char[] cArray) throws SAXException {
        this.content.characters(cArray, 0, cArray.length);
    }

    public void comment(char[] cArray) throws SAXException {
        if (this.lexical != null) {
            this.lexical.comment(cArray, 0, cArray.length);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.content.processingInstruction(string, string2);
    }

    public void startElement(String string, String string2, String string3, String[][] stringArray, String[][] stringArray2) throws SAXException {
        this.prefixes.push(stringArray2);
        String string4 = this.resolve(string);
        AttributesImpl attributesImpl = new AttributesImpl();
        int n = 0;
        while (n < stringArray.length) {
            String string5;
            String string6 = stringArray[n][0];
            String string7 = stringArray[n][1];
            String string8 = stringArray[n][2];
            String string9 = stringArray[n][3];
            String string10 = string5 = string6.length() > 0 ? this.resolve(string6) : "";
            if (attributesImpl.getValue(string5, string7) != null) {
                throw new SAXException("Duplicate attribute \"" + string + "\"");
            }
            attributesImpl.addAttribute(string5, string7, string8, "CDATA", string9);
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.content.startPrefixMapping(stringArray2[n2][0], stringArray2[n2][1]);
            ++n2;
        }
        this.content.startElement(string4, string2, string3, attributesImpl);
        this.elements.push(string4 + '\u0000' + string2);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = this.resolve(string);
        String string5 = string4 + '\u0000' + string2;
        if (!string5.equals(this.elements.pop())) {
            throw new SAXException("Expecting another element");
        }
        this.content.endElement(string4, string2, string3);
        String[][] stringArray = (String[][])this.prefixes.pop();
        int n = 0;
        while (n < stringArray.length) {
            this.content.endPrefixMapping(stringArray[n][0]);
            ++n;
        }
    }

    private String resolve(String string) throws SAXException {
        int n = this.prefixes.size() - 1;
        while (n >= 0) {
            String[][] stringArray = (String[][])this.prefixes.get(n);
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (string.equals(stringArray[n2][0])) {
                    return stringArray[n2][1];
                }
                ++n2;
            }
            --n;
        }
        throw new SAXException("Cannot resolve namespace URI for prefix \"" + string + "\"");
    }

    public static final class Stack
    extends ArrayList {
        private Stack() {
        }

        private void push(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            this.add(object);
        }

        private Object pop() {
            if (this.size() == 0) {
                return null;
            }
            return this.remove(this.size() - 1);
        }
    }
}

