/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util.resourcekind;

import java.util.Set;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.apache.slide.webdav.util.resourcekind.Version;

public class VersionImpl
extends AbstractResourceKind
implements Version {
    protected static ResourceKind singleton = null;

    protected VersionImpl() {
    }

    public static ResourceKind getInstance() {
        if (singleton == null) {
            singleton = new VersionImpl();
        }
        return singleton;
    }

    public Set getSupportedLiveProperties(String[] excludedFeatures) {
        Set s = super.getSupportedLiveProperties(excludedFeatures);
        if (AbstractResourceKind.isSupportedFeature("version-control", excludedFeatures)) {
            s.add("predecessor-set");
            s.add("successor-set");
            s.add("checkout-set");
            s.add("version-name");
        }
        if (AbstractResourceKind.isSupportedFeature("checkout-in-place", excludedFeatures) || AbstractResourceKind.isSupportedFeature("working-resource", excludedFeatures)) {
            s.add("checkout-fork");
            s.add("checkin-fork");
        }
        if (AbstractResourceKind.isSupportedFeature("version-history", excludedFeatures)) {
            s.add("version-history");
        }
        if (AbstractResourceKind.isSupportedFeature("label", excludedFeatures)) {
            s.add("label-name-set");
        }
        if (AbstractResourceKind.isSupportedFeature("activity", excludedFeatures)) {
            s.add("activity-set");
        }
        return s;
    }

    public Set getSupportedMethods() {
        Set s = super.getSupportedMethods();
        if (AbstractResourceKind.isSupportedFeature("label")) {
            s.add("LABEL");
        }
        if (AbstractResourceKind.isSupportedFeature("working-resource")) {
            s.add("CHECKOUT");
        }
        return s;
    }

    public Set getSupportedReports() {
        Set s = super.getSupportedReports();
        if (AbstractResourceKind.isSupportedFeature("version-control")) {
            s.add("version-tree");
        }
        return s;
    }

    public String toString() {
        return "version";
    }
}

