/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util.resourcekind;

import java.util.Set;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.DeltavCompliant;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;

public class DeltavCompliantImpl
extends AbstractResourceKind
implements DeltavCompliant {
    protected static ResourceKind singleton = null;

    protected DeltavCompliantImpl() {
    }

    public static ResourceKind getInstance() {
        if (singleton == null) {
            singleton = new DeltavCompliantImpl();
        }
        return singleton;
    }

    public Set getSupportedLiveProperties(String[] excludedFeatures) {
        Set s = super.getSupportedLiveProperties(excludedFeatures);
        s.add("creationdate");
        s.add("displayname");
        s.add("getcontentlanguage");
        s.add("getcontentlength");
        s.add("getcontenttype");
        s.add("getetag");
        s.add("getlastmodified");
        s.add("resourcetype");
        s.add("source");
        if (AbstractResourceKind.isSupportedFeature("2", excludedFeatures)) {
            s.add("lockdiscovery");
            s.add("supportedlock");
        }
        if (AbstractResourceKind.isSupportedFeature("access-control", excludedFeatures)) {
            s.add("owner");
            s.add("supported-privilege-set");
            s.add("current-user-privilege-set");
            s.add("acl");
            s.add("acl-semantics");
            s.add("principal-collection-set");
        }
        if (AbstractResourceKind.isSupportedFeature("version-control", excludedFeatures)) {
            s.add("comment");
            s.add("creator-displayname");
            s.add("supported-method-set");
            s.add("supported-live-property-set");
            s.add("supported-report-set");
        }
        if (AbstractResourceKind.isSupportedFeature("workspace", excludedFeatures)) {
            s.add("workspace");
        }
        if (AbstractResourceKind.isSupportedFeature("baseline", excludedFeatures)) {
            s.add("version-controlled-configuration");
        }
        return s;
    }

    public Set getSupportedMethods() {
        Set s = super.getSupportedMethods();
        s.add("CONNECT");
        s.add("COPY");
        s.add("DELETE");
        s.add("GET");
        s.add("HEAD");
        s.add("MOVE");
        s.add("OPTIONS");
        s.add("POST");
        s.add("PROPFIND");
        s.add("PROPPATCH");
        s.add("PUT");
        s.add("TRACE");
        if (AbstractResourceKind.isSupportedFeature("2")) {
            s.add("LOCK");
            s.add("UNLOCK");
        }
        if (AbstractResourceKind.isSupportedFeature("access-control")) {
            s.add("ACL");
        }
        if (AbstractResourceKind.isSupportedFeature("access-control") || AbstractResourceKind.isSupportedFeature("version-control")) {
            s.add("REPORT");
        }
        if (AbstractResourceKind.isSupportedFeature("searching-and-locating")) {
            s.add("SEARCH");
        }
        return s;
    }

    public Set getSupportedReports() {
        Set s = super.getSupportedReports();
        if (AbstractResourceKind.isSupportedFeature("access-control") || AbstractResourceKind.isSupportedFeature("version-control")) {
            s.add("expand-property");
        }
        return s;
    }
}

