/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLValue
implements Cloneable {
    public static final String ELEMENT_MUST_NOT_BE_NULL = "'null' Element is not allowed";
    public static final String TYPE_MISMATCH = "Only objects of type Element are allowed";
    protected static final String START_TAG = "<root>";
    protected static final String END_TAG = "</root>";
    protected ArrayList elementList = new ArrayList();

    public XMLValue() {
        this((List)null);
    }

    public XMLValue(String xmlString) throws JDOMException {
        this(xmlString, null);
    }

    public XMLValue(String xmlString, Namespace defaultNamespace) throws JDOMException {
        this((List)null);
        this.add(xmlString, defaultNamespace);
    }

    public XMLValue(List elementList) throws IllegalArgumentException {
        this.add(elementList);
    }

    public XMLValue(Element element) throws IllegalArgumentException {
        this((List)null);
        this.add(element);
    }

    public void add(String xmlString) throws JDOMException {
        this.add(xmlString, null);
    }

    public void add(String xmlString, Namespace defaultNamespace) throws JDOMException {
        if (xmlString != null) {
            StringBuffer buffer = new StringBuffer(START_TAG.length() + xmlString.length() + END_TAG.length());
            buffer.append(START_TAG);
            buffer.append(xmlString);
            buffer.append(END_TAG);
            SAXBuilder builder = new SAXBuilder();
            if (defaultNamespace != null) {
                builder.setXMLFilter((XMLFilter)new DefaultNamespaceXMLFilter(defaultNamespace));
            }
            try {
                Document document = builder.build((Reader)new StringReader(buffer.toString()));
                List children = document.getRootElement().getChildren();
                this.add(children);
                document.getRootElement().removeChildren();
            }
            catch (Exception e) {
                throw new JDOMException(e.getMessage());
            }
        }
    }

    public void add(List elementList) throws IllegalArgumentException {
        if (elementList != null) {
            Iterator iterator = elementList.iterator();
            while (iterator.hasNext()) {
                try {
                    this.add((Element)iterator.next());
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException(TYPE_MISMATCH);
                }
            }
        }
    }

    public void add(Element element) throws IllegalArgumentException {
        if (element == null) {
            throw new IllegalArgumentException(ELEMENT_MUST_NOT_BE_NULL);
        }
        this.elementList.add(element);
    }

    public Object clone() {
        return new XMLValue(this.elementList);
    }

    public boolean equals(Object other) {
        if (!(other instanceof XMLValue)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public List getList() {
        return (List)this.elementList.clone();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Iterator iterator() {
        return ((AbstractList)this.elementList).iterator();
    }

    public int size() {
        return this.elementList.size();
    }

    public String toString() {
        XMLOutputter outputter = new XMLOutputter();
        StringWriter stringWriter = new StringWriter();
        Iterator iterator = ((AbstractList)this.elementList).iterator();
        while (iterator.hasNext()) {
            try {
                outputter.output((Element)iterator.next(), (Writer)stringWriter);
            }
            catch (IOException e) {
                throw new RuntimeException("IOException occurred: " + e.getMessage());
            }
        }
        return stringWriter.toString();
    }

    protected static class DefaultNamespaceXMLFilter
    extends XMLFilterImpl {
        Namespace defaultNamespace = null;

        public DefaultNamespaceXMLFilter(Namespace defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (namespaceURI == null || namespaceURI.length() == 0) {
                namespaceURI = this.defaultNamespace.getURI();
                qName = String.valueOf(this.defaultNamespace.getPrefix()) + ":" + qName;
            }
            super.endElement(namespaceURI, localName, qName);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (namespaceURI == null || namespaceURI.length() == 0) {
                namespaceURI = this.defaultNamespace.getURI();
                qName = String.valueOf(this.defaultNamespace.getPrefix()) + ":" + qName;
            }
            super.startElement(namespaceURI, localName, qName, atts);
        }
    }
}

