/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.slide.common.Domain;
import org.apache.slide.webdav.util.UriHandler;

public class WorkspacePathHandler
extends UriHandler {
    static final String WORKSPACE_PATH = Domain.getParameter((String)"workspacepath", (String)"/workspace");
    static WorkspacePathHandler workspacePathHandler = new WorkspacePathHandler(WORKSPACE_PATH);
    static boolean parameterized = WORKSPACE_PATH.indexOf("${store}") >= 0;
    private Set resolvedWorkspacePaths = null;

    protected WorkspacePathHandler(String uri) {
        super(uri);
    }

    public static UriHandler getResolvedWorkspacePathHandler(String storeName) {
        if (parameterized) {
            String rp = workspacePathHandler.toString();
            int k = rp.indexOf("${store}");
            if (k >= 0) {
                StringBuffer b = new StringBuffer(rp);
                while (k >= 0) {
                    b.replace(k, k + "${store}".length(), storeName);
                    k = b.toString().indexOf("${store}");
                }
                rp = b.toString();
            }
            return new UriHandler(rp);
        }
        return workspacePathHandler;
    }

    public static UriHandler getResolvedWorkspacePathHandler(String namespaceName, UriHandler uh) {
        if (parameterized) {
            return WorkspacePathHandler.getResolvedWorkspacePathHandler(uh.getAssociatedBaseStoreName(namespaceName));
        }
        return workspacePathHandler;
    }

    public List getResolvedWorkspacePaths() {
        return this.getResolvedWorkspacePaths(null);
    }

    public List getResolvedWorkspacePaths(String storeName) {
        ArrayList<Object> result;
        if (parameterized) {
            if (storeName != null) {
                result = new ArrayList();
                result.add(WorkspacePathHandler.getResolvedWorkspacePathHandler(storeName));
            } else {
                this.resolve();
                result = new ArrayList(this.resolvedWorkspacePaths);
            }
        } else {
            result = new ArrayList<Object>();
            result.add(WORKSPACE_PATH);
        }
        return result;
    }

    public static String getWorkspacePath() {
        return WORKSPACE_PATH;
    }

    public static WorkspacePathHandler getWorkspacePathHandler() {
        return workspacePathHandler;
    }

    public boolean isWorkspacePathUri(UriHandler uh) {
        if (!parameterized) {
            return this.equals(uh);
        }
        if (!Domain.namespacesAreInitialized()) {
            return false;
        }
        if (this.resolvedWorkspacePaths == null) {
            this.resolve();
        }
        return this.resolvedWorkspacePaths.contains(uh);
    }

    private void resolve() {
        this.resolvedWorkspacePaths = new HashSet();
        Iterator i = UriHandler.allStoreNames.iterator();
        while (i.hasNext()) {
            String storeName = (String)i.next();
            UriHandler rpuh = WorkspacePathHandler.getResolvedWorkspacePathHandler(storeName);
            if (!UriHandler.allScopes.contains(rpuh)) continue;
            this.resolvedWorkspacePaths.add(rpuh);
        }
    }
}

