/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.slide.common.Domain;
import org.apache.slide.webdav.util.UriHandler;

public class WorkingresourcePathHandler
extends UriHandler {
    static final String WORKINGRESOURCE_PATH = Domain.getParameter((String)"workingresourcepath", (String)"/workingresource");
    static WorkingresourcePathHandler workingresourcePathHandler = new WorkingresourcePathHandler(WORKINGRESOURCE_PATH);
    static boolean parameterized = WORKINGRESOURCE_PATH.indexOf("${store}") >= 0;
    private Set resolvedWorkingresourcePaths = null;

    protected WorkingresourcePathHandler(String uri) {
        super(uri);
    }

    public static UriHandler getResolvedWorkingresourcePathHandler(String storeName) {
        if (parameterized) {
            String rp = workingresourcePathHandler.toString();
            int k = rp.indexOf("${store}");
            if (k >= 0) {
                StringBuffer b = new StringBuffer(rp);
                while (k >= 0) {
                    b.replace(k, k + "${store}".length(), storeName);
                    k = b.toString().indexOf("${store}");
                }
                rp = b.toString();
            }
            return new UriHandler(rp);
        }
        return workingresourcePathHandler;
    }

    public static UriHandler getResolvedWorkingresourcePathHandler(String namespaceName, UriHandler uh) {
        if (parameterized) {
            return WorkingresourcePathHandler.getResolvedWorkingresourcePathHandler(uh.getAssociatedBaseStoreName(namespaceName));
        }
        return workingresourcePathHandler;
    }

    public List getResolvedWorkingresourcePaths() {
        ArrayList<String> result;
        if (parameterized) {
            this.resolve();
            result = new ArrayList(this.resolvedWorkingresourcePaths);
        } else {
            result = new ArrayList<String>();
            result.add(WORKINGRESOURCE_PATH);
        }
        return result;
    }

    public static String getWorkingresourcePath() {
        return WORKINGRESOURCE_PATH;
    }

    public static WorkingresourcePathHandler getWorkingresourcePathHandler() {
        return workingresourcePathHandler;
    }

    public boolean isWorkingresourcePathUri(UriHandler uh) {
        if (!parameterized) {
            return this.equals(uh);
        }
        if (!Domain.namespacesAreInitialized()) {
            return false;
        }
        if (this.resolvedWorkingresourcePaths == null) {
            this.resolve();
        }
        return this.resolvedWorkingresourcePaths.contains(uh);
    }

    private void resolve() {
        this.resolvedWorkingresourcePaths = new HashSet();
        Iterator i = UriHandler.allStoreNames.iterator();
        while (i.hasNext()) {
            String storeName = (String)i.next();
            UriHandler rpuh = WorkingresourcePathHandler.getResolvedWorkingresourcePathHandler(storeName);
            if (!UriHandler.allScopes.contains(rpuh)) continue;
            this.resolvedWorkingresourcePaths.add(rpuh);
        }
    }
}

