/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.SlideTokenImpl;
import org.apache.slide.common.SlideTokenWrapper;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.util.URLUtil;

public class WebdavUtils {
    private static final String PRINCIPAL_ATTRIBUTE = "org.apache.slide.webdav.method.principal";
    protected static final String[] hexadecimal = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    private static String convertHexDigit(byte toEncode) {
        int low = toEncode & 0xF;
        int high = (toEncode & 0xF0) >> 4;
        String result = String.valueOf(hexadecimal[high]) + hexadecimal[low];
        return result;
    }

    public static String decodeURL(String path) {
        return WebdavUtils.decodeURL(path, Configuration.urlEncoding());
    }

    public static String decodeURL(String path, String enc) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = URLUtil.URLDecode((String)path, (String)enc);
        if (normalized == null) {
            return null;
        }
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = String.valueOf(normalized.substring(0, index2)) + normalized.substring(index + 3);
        }
        return normalized;
    }

    public static String encodeURL(String path) {
        return URLUtil.URLEncode((String)path, (String)Configuration.urlEncoding());
    }

    public static String encodeURL(String path, String enc) {
        return URLUtil.URLEncode((String)path, (String)enc);
    }

    public static String fixTomcatHeader(String header, String toEncoding) {
        if (header == null) {
            return null;
        }
        String result = null;
        try {
            result = URLUtil.URLDecode((String)new String(header.getBytes("ISO-8859-1"), toEncoding), (String)toEncoding);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String fixTomcatURL(String input, String fromEncoding) {
        if (input == null) {
            return null;
        }
        String result = null;
        try {
            result = WebdavUtils.encodeURL(new String(input.getBytes(fromEncoding), Configuration.urlEncoding()), Configuration.urlEncoding());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getAbsolutePath(String uri, HttpServletRequest req, WebdavServletConfig config) {
        String result = uri;
        int scopeLength = config.getScope().length();
        if (scopeLength > 0) {
            result = uri.substring(scopeLength);
        }
        String contextPath = req.getContextPath();
        if (!config.isDefaultServlet()) {
            contextPath = String.valueOf(contextPath) + req.getServletPath();
        }
        result = String.valueOf(contextPath) + result;
        return WebdavUtils.encodeURL(result);
    }

    public static String getRelativePath(HttpServletRequest req, WebdavServletConfig config) {
        String result = null;
        result = config.isDefaultServlet() ? req.getServletPath() : req.getPathInfo();
        if (result == null || result.length() == 0) {
            result = "/";
        }
        result = String.valueOf(config.getScope()) + result;
        return WebdavUtils.decodeURL(WebdavUtils.fixTomcatURL(result, "UTF-8"));
    }

    public static SlideToken getSlideToken(HttpServletRequest req) {
        Principal principal = req.getUserPrincipal();
        HttpSession session = req.getSession();
        if (principal == null) {
            principal = (Principal)session.getAttribute(PRINCIPAL_ATTRIBUTE);
        } else {
            session.setAttribute(PRINCIPAL_ATTRIBUTE, (Object)principal);
        }
        CredentialsToken credentials = principal == null ? new CredentialsToken("") : new CredentialsToken(principal);
        SlideTokenImpl token = new SlideTokenImpl(credentials);
        token.setEnforceLockTokens(true);
        return token;
    }

    public static boolean isCollection(NamespaceAccessToken token, HttpServletRequest req, WebdavServletConfig config) {
        return WebdavUtils.isCollection(token, WebdavUtils.getSlideToken(req), WebdavUtils.getRelativePath(req, config));
    }

    public static boolean isCollection(NamespaceAccessToken token, SlideToken slideToken, String path) {
        slideToken = new SlideTokenWrapper(slideToken, false);
        if (Configuration.useVersionControl()) {
            UriHandler uh = UriHandler.getUriHandler(path);
            if (uh.isWorkspaceUri()) {
                return true;
            }
            if (uh.isHistoryUri()) {
                return true;
            }
            if (uh.isVersionUri()) {
                return false;
            }
        }
        try {
            Content content = token.getContentHelper();
            NodeRevisionDescriptors revisionDescriptors = content.retrieve(slideToken, path);
            if (revisionDescriptors.hasRevisions()) {
                NodeRevisionDescriptor revisionDescriptor = content.retrieve(slideToken, revisionDescriptors);
                return WebdavUtils.isCollection(revisionDescriptor);
            }
            return true;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return false;
        }
        catch (SlideException slideException) {
            return true;
        }
    }

    public static boolean isCollection(NodeRevisionDescriptor revisionDescriptor) {
        boolean result = false;
        if (revisionDescriptor == null) {
            return true;
        }
        if (revisionDescriptor.propertyValueContains("resourcetype", "collection")) {
            result = true;
        }
        return result;
    }

    private static void printHexString(String path, String enc) {
        try {
            byte[] ba = enc == null ? path.getBytes() : path.getBytes("ISO-8859-1");
            System.out.print("@@@@ bytes= " + enc + "  \t");
            int i = 0;
            while (i < ba.length) {
                System.out.print(WebdavUtils.convertHexDigit(ba[i]));
                if (i < ba.length - 1) {
                    System.out.print(" ");
                } else {
                    String s = enc == null ? new String(ba) : new String(ba, enc);
                    System.out.print("  ( " + s + " )" + "\n");
                }
                ++i;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private static void printString(String path) {
        System.out.println("");
        System.out.println("@@@@ string=" + path);
        WebdavUtils.printHexString(path, Configuration.urlEncoding());
        WebdavUtils.printHexString(path, "UTF-8");
        WebdavUtils.printHexString(path, null);
    }
}

