/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import org.apache.util.WebdavStatus;

public class ViolatedPrecondition {
    public static final String PRECONDITION_MUST_NOT_BE_NULL = "Parameter 'precondition' must not be null";
    private static final String INVALID_STATUS_CODE = "Status code must be eiter 404 (Forbidden) or 409 (Conflict), but is: ";
    protected int statusCode = 403;
    protected String precondition = null;
    protected String stringRepresentation = null;

    public ViolatedPrecondition(String precondition, int statusCode) {
        if (precondition == null) {
            throw new IllegalArgumentException(PRECONDITION_MUST_NOT_BE_NULL);
        }
        if (statusCode != 403 && statusCode != 409) {
            throw new IllegalArgumentException(ViolatedPrecondition.getInvalidStatusCodeMessage(statusCode));
        }
        this.precondition = precondition;
        this.statusCode = statusCode;
    }

    public boolean equals(Object other) {
        boolean isEqual = false;
        if (other instanceof ViolatedPrecondition) {
            ViolatedPrecondition otherViolatedPrecondition = (ViolatedPrecondition)other;
            isEqual = this.getPrecondition().equals(otherViolatedPrecondition.getPrecondition());
            isEqual &= this.getStatusCode() == otherViolatedPrecondition.getStatusCode();
        }
        return isEqual;
    }

    public static String getInvalidStatusCodeMessage(int actualStatusCode) {
        return INVALID_STATUS_CODE + actualStatusCode;
    }

    public String getPrecondition() {
        return this.precondition;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int hashCode() {
        return 13 * this.getPrecondition().hashCode() + this.getStatusCode();
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            StringBuffer buffer = new StringBuffer("ViolatedPrecondition[");
            buffer.append(this.getPrecondition());
            buffer.append(", ");
            buffer.append(this.getStatusCode());
            buffer.append(" ");
            buffer.append(WebdavStatus.getStatusText((int)this.getStatusCode()));
            buffer.append("]");
            this.stringRepresentation = buffer.toString();
        }
        return this.stringRepresentation;
    }
}

