/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.slide.common.Domain;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.SlideTokenWrapper;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.lock.Lock;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.macro.Macro;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.Search;
import org.apache.slide.search.SearchQuery;
import org.apache.slide.search.SearchQueryResult;
import org.apache.slide.search.SlideUri;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.Structure;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.MethodNotAllowedException;
import org.apache.slide.webdav.util.AbstractWebdavHelper;
import org.apache.slide.webdav.util.LabeledRevisionNotFoundException;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.PropertyHelper;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.XMLValue;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.CheckedInVersionControlled;
import org.apache.slide.webdav.util.resourcekind.CheckedInVersionControlledImpl;
import org.apache.slide.webdav.util.resourcekind.CheckedOut;
import org.apache.slide.webdav.util.resourcekind.CheckedOutVersionControlled;
import org.apache.slide.webdav.util.resourcekind.DeltavCompliantUnmappedUrl;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.apache.slide.webdav.util.resourcekind.Version;
import org.apache.slide.webdav.util.resourcekind.VersionControlled;
import org.apache.slide.webdav.util.resourcekind.VersionControlledImpl;
import org.apache.slide.webdav.util.resourcekind.VersionHistoryImpl;
import org.apache.slide.webdav.util.resourcekind.VersionImpl;
import org.apache.slide.webdav.util.resourcekind.Working;
import org.apache.slide.webdav.util.resourcekind.WorkingImpl;
import org.apache.slide.webdav.util.resourcekind.WorkspaceImpl;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class VersioningHelper
extends AbstractWebdavHelper {
    protected static SAXBuilder saxBuilder = null;
    private Content content = null;
    private Structure structure = null;
    private Macro macro = null;
    private Lock lock = null;
    private HttpServletRequest req = null;
    private HttpServletResponse resp = null;
    private WebdavServletConfig sConf = null;
    private PropertyHelper pHelp = null;
    private String serverURL = null;
    protected final String modifyMetadataUri;
    protected final String modifyContentUri;

    protected VersioningHelper(SlideToken sToken, NamespaceAccessToken nsaToken, HttpServletRequest req, HttpServletResponse resp, WebdavServletConfig sConf) {
        super(sToken, nsaToken);
        this.req = req;
        this.resp = resp;
        this.sConf = sConf;
        this.content = nsaToken.getContentHelper();
        this.structure = nsaToken.getStructureHelper();
        this.macro = nsaToken.getMacroHelper();
        this.lock = nsaToken.getLockHelper();
        this.pHelp = PropertyHelper.getPropertyHelper(sToken, nsaToken, sConf);
        ActionNode actionNode = nsaToken.getNamespaceConfig().getModifyRevisionMetadataAction();
        this.modifyMetadataUri = actionNode != null ? actionNode.getUri() : "";
        actionNode = nsaToken.getNamespaceConfig().getModifyRevisionContentAction();
        this.modifyContentUri = actionNode != null ? actionNode.getUri() : "";
        this.serverURL = "http://" + req.getServerName() + ":" + req.getServerPort();
    }

    protected void backupSpecificLiveProperties(NodeRevisionDescriptors rNrds, NodeRevisionDescriptor rNrd) throws SlideException {
        NodeRevisionDescriptor backupNrd = new NodeRevisionDescriptor(NodeRevisionNumber.HIDDEN_0_0, "backup", new Vector(), new Hashtable());
        NodeProperty p = rNrd.getProperty("auto-version");
        if (p != null) {
            backupNrd.setProperty(p);
        }
        if ((p = rNrd.getProperty("comment")) != null) {
            backupNrd.setProperty(p);
        }
        if ((p = rNrd.getProperty("displayname")) != null) {
            backupNrd.setProperty(p);
        }
        if ((p = rNrd.getProperty("creator-displayname")) != null) {
            backupNrd.setProperty(p);
        }
        try {
            this.content.retrieve(this.sToken, rNrds, NodeRevisionNumber.HIDDEN_0_0);
            this.content.store(this.sToken, rNrds.getUri(), backupNrd, null);
        }
        catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {
            this.content.create(this.sToken, rNrds.getUri(), null, backupNrd, null);
        }
    }

    public String checkin(String resourcePath, boolean forkOk, boolean keepCheckedOut, boolean autoVersion) throws SlideException, JDOMException, IOException, PreconditionViolationException {
        NodeRevisionDescriptors rNrds = this.content.retrieve(this.sToken, resourcePath);
        NodeRevisionDescriptor rNrd = this.content.retrieve(this.sToken, rNrds);
        return this.checkin(rNrds, rNrd, forkOk, keepCheckedOut, autoVersion);
    }

    public String checkin(NodeRevisionDescriptors rNrds, NodeRevisionDescriptor rNrd, boolean forkOk, boolean keepCheckedOut, boolean autoVersion) throws SlideException, JDOMException, IOException, PreconditionViolationException {
        String rUri = this.getUri(rNrds, rNrd);
        ResourceKind rRk = AbstractResourceKind.determineResourceKind(this.nsaToken, rNrds, rNrd);
        if (!rRk.isSupportedMethod(this.req.getMethod())) {
            if (rRk instanceof CheckedInVersionControlled) {
                throw new PreconditionViolationException(new ViolatedPrecondition("must-be-checked-out", 409), rUri);
            }
            throw new MethodNotAllowedException(rRk);
        }
        if (rRk instanceof CheckedOutVersionControlled || rRk instanceof Working) {
            String comment;
            boolean isWorkingResource = rRk instanceof Working;
            NodeProperty coutProp = rNrd.getProperty("checked-out");
            NodeProperty predSetProp = rNrd.getProperty("predecessor-set");
            NodeProperty autoUpdProp = rNrd.getProperty("auto-update");
            NodeRevisionDescriptors autoUpdNrds = null;
            NodeRevisionDescriptor autoUpdNrd = null;
            if (autoUpdProp != null) {
                Element autoUpdElm = this.pHelp.parsePropertyValue((String)autoUpdProp.getValue());
                String autoUpdUri = autoUpdElm.getTextTrim();
                autoUpdNrds = this.content.retrieve(this.sToken, autoUpdUri);
                autoUpdNrd = this.content.retrieve(this.sToken, autoUpdNrds);
            }
            Element coutElm = this.pHelp.parsePropertyValue((String)coutProp.getValue());
            String vrUriOld = coutElm.getTextTrim();
            UriHandler vrUhOld = UriHandler.getUriHandler(vrUriOld);
            NodeRevisionNumber vrNrnOld = new NodeRevisionNumber(vrUhOld.getVersionName());
            String vhrUri = vrUhOld.getAssociatedHistoryUri();
            NodeRevisionDescriptors vhrNrds = this.content.retrieve(this.sToken, vhrUri);
            NodeRevisionDescriptor vhrNrd = this.content.retrieve(this.sToken, vhrNrds);
            NodeProperty vSetProp = vhrNrd.getProperty("version-set");
            NodeRevisionDescriptor vrNrdOld = this.content.retrieve(this.sToken, vhrNrds, vrNrnOld);
            PropertyHelper.removeHrefFromProperty(vrNrdOld, "checkout-set", rUri);
            this.content.store(this.sToken, vhrNrds.getUri(), vrNrdOld, null);
            ViolatedPrecondition violatedPrecondition = this.getCheckinPreconditionViolation(predSetProp, vhrNrds, forkOk, autoUpdNrd);
            if (violatedPrecondition != null) {
                throw new PreconditionViolationException(violatedPrecondition, rUri);
            }
            String forkBranch = this.getForkBranch(predSetProp, vhrNrds, forkOk);
            NodeRevisionDescriptor vrNrdNew = null;
            if (forkBranch != null) {
                NodeRevisionNumber branchedRevisionNumber = this.content.fork(this.sToken, vhrNrds.getUri(), forkBranch, vrNrdOld);
                vhrNrds = this.content.retrieve(this.sToken, vhrUri);
                vrNrdNew = this.content.retrieve(this.sToken, vhrNrds, branchedRevisionNumber);
                vrNrdNew.setContentLength(rNrd.getContentLength());
            } else {
                vrNrdNew = new NodeRevisionDescriptor(rNrd.getContentLength());
            }
            Iterator i = this.pHelp.createInitialProperties(VersionImpl.getInstance()).iterator();
            while (i.hasNext()) {
                vrNrdNew.setProperty((NodeProperty)i.next());
            }
            Enumeration j = rNrd.enumerateProperties();
            while (j.hasMoreElements()) {
                NodeProperty p = (NodeProperty)j.nextElement();
                if (p.isLiveProperty() || vrNrdNew.exists(p.getName())) continue;
                vrNrdNew.setProperty(p);
            }
            vrNrdNew.setContentType(rNrd.getContentType());
            vrNrdNew.setContentLength(rNrd.getContentLength());
            vrNrdNew.setContentLanguage(rNrd.getContentLanguage());
            String string = comment = autoVersion ? "CREATED BY AUTO-VERSIONING. " : "";
            if (rNrd.exists("comment")) {
                comment = String.valueOf(comment) + (String)rNrd.getProperty("comment").getValue();
            }
            vrNrdNew.setProperty(new NodeProperty("comment", (Object)comment));
            vrNrdNew.setProperty(rNrd.getProperty("checkout-fork"));
            vrNrdNew.setProperty(rNrd.getProperty("checkin-fork"));
            NodeRevisionContent rNrc = this.content.retrieve(this.sToken, rNrds, rNrd);
            if (forkBranch != null) {
                this.content.store(this.sToken, vhrUri, vrNrdNew, rNrc);
            } else {
                String branch = vrNrdOld.getBranchName();
                this.content.create(this.sToken, vhrUri, branch, vrNrdNew, rNrc);
            }
            String vrUriNew = String.valueOf(vhrUri) + "/" + vrNrdNew.getRevisionNumber().toString();
            UriHandler vrUhNew = UriHandler.getUriHandler(vrUriNew);
            SubjectNode vrNodeNew = new SubjectNode();
            this.structure.create(this.sToken, (ObjectNode)vrNodeNew, vrUriNew);
            if (keepCheckedOut) {
                rNrd.setProperty(new NodeProperty("checked-out", this.pHelp.createHrefValue(vrUriNew)));
                rNrd.setProperty(new NodeProperty("predecessor-set", vrNrdNew.getProperty("predecessor-set").getValue()));
            } else if (!isWorkingResource) {
                rNrd.removeProperty(coutProp);
                rNrd.setProperty(new NodeProperty("checked-in", this.pHelp.createHrefValue(vrUriNew)));
                rNrd.removeProperty("checkin-locktoken", "http://jakarta.apache.org/slide/");
                rNrd.removeProperty("checkin-locktoken");
                rNrd.removeProperty("predecessor-set");
                rNrd.removeProperty("checkout-fork");
                rNrd.removeProperty("checkin-fork");
            }
            vhrNrd.setLastModified(new Date());
            vhrNrd.setProperty(new NodeProperty("version-set", (Object)(String.valueOf((String)vSetProp.getValue()) + this.pHelp.createHrefValue(vrUriNew))));
            vrNrdNew.setName(rNrd.getName());
            vrNrdNew.setETag(String.valueOf(vrUriNew.hashCode()) + "_" + this.req.getContentLength());
            vrNrdNew.setCreationDate(new Date());
            vrNrdNew.setLastModified(new Date());
            vrNrdNew.setProperty(new NodeProperty("version-name", (Object)vrUhNew.getVersionName()));
            vrNrdNew.setProperty(new NodeProperty("predecessor-set", predSetProp.getValue()));
            if (keepCheckedOut || !isWorkingResource) {
                this.content.store(this.sToken, rUri, rNrd, null);
                try {
                    this.content.remove(this.sToken, rUri, NodeRevisionNumber.HIDDEN_0_0);
                }
                catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {
                    Domain.info((Object)("Checkin: no backup descriptor found at " + rUri));
                }
                if (keepCheckedOut) {
                    this.backupSpecificLiveProperties(rNrds, rNrd);
                }
            } else {
                this.macro.delete(this.sToken, rUri);
            }
            this.content.store(this.sToken, vhrUri, vhrNrd, null);
            this.content.store(this.sToken, vhrUri, vrNrdNew, null);
            if (autoUpdNrd != null) {
                this.update(autoUpdNrds, autoUpdNrd, vhrNrds, vrNrdNew);
            }
            this.resp.setStatus(201);
            return vrUriNew;
        }
        Domain.warn((Object)("Do not know how to checkout a '" + rRk + "' resource"));
        this.resp.setStatus(409);
        return null;
    }

    public String checkout(String resourcePath, boolean forkOk, boolean applyToVersion) throws SlideException, JDOMException, IOException, PreconditionViolationException {
        return this.checkout(resourcePath, forkOk, applyToVersion, false);
    }

    public String checkout(String resourcePath, boolean forkOk, boolean applyToVersion, boolean isAutoVersionCheckout) throws SlideException, JDOMException, IOException, PreconditionViolationException {
        UriHandler rUh = UriHandler.getUriHandler(resourcePath);
        NodeRevisionDescriptors rNrds = this.content.retrieve(this.sToken, resourcePath);
        NodeRevisionDescriptor rNrd = this.content.retrieve(this.sToken, rNrds);
        if (rUh.isVersionUri()) {
            NodeRevisionContent rNrc = this.content.retrieve(this.sToken, rNrds, rNrd);
            return this.checkout(rNrds, rNrd, rNrc, forkOk, null);
        }
        return this.checkout(rNrds, rNrd, forkOk, applyToVersion, isAutoVersionCheckout);
    }

    public String checkout(NodeRevisionDescriptors rNrds, NodeRevisionDescriptor rNrd, NodeRevisionContent rNrc, boolean forkOk, String autoUpdateUri) throws SlideException, JDOMException, IOException, PreconditionViolationException {
        String rUri = this.getUri(rNrds, rNrd);
        ResourceKind rRk = AbstractResourceKind.determineResourceKind(this.nsaToken, rNrds, rNrd);
        if (!rRk.isSupportedMethod(this.req.getMethod())) {
            if (rRk instanceof CheckedOut) {
                throw new PreconditionViolationException(new ViolatedPrecondition("must-be-checked-in", 409), rNrds.getUri());
            }
            throw new MethodNotAllowedException(rRk);
        }
        if (rRk instanceof Version) {
            NodeProperty cinfProp;
            UriHandler rUh = UriHandler.getUriHandler(rUri);
            String vhUri = rUh.getAssociatedHistoryUri();
            ViolatedPrecondition violatedPrecondition = this.getCheckoutPreconditionViolation(rNrds, rNrd, forkOk);
            if (violatedPrecondition != null) {
                throw new PreconditionViolationException(violatedPrecondition, rNrds.getUri());
            }
            NodeRevisionDescriptors vhrNrds = this.content.retrieve(this.sToken, vhUri);
            UriHandler wrUh = UriHandler.createNextWorkingresourceUri(this.sToken, this.nsaToken, rUh);
            String wrUri = String.valueOf(wrUh);
            SubjectNode wrNode = new SubjectNode();
            this.structure.create(this.sToken, (ObjectNode)wrNode, String.valueOf(wrUh));
            NodeRevisionDescriptor wrNrd = new NodeRevisionDescriptor();
            Iterator i = this.pHelp.createInitialProperties(WorkingImpl.getInstance()).iterator();
            while (i.hasNext()) {
                wrNrd.setProperty((NodeProperty)i.next());
            }
            wrNrd.setProperty(new NodeProperty("checked-out", this.pHelp.createHrefValue(rUri)));
            wrNrd.setProperty(new NodeProperty("predecessor-set", this.pHelp.createHrefValue(rUri)));
            NodeProperty coutfProp = rNrd.getProperty("checkout-fork");
            if (coutfProp != null) {
                wrNrd.setProperty(coutfProp);
            }
            if ((cinfProp = rNrd.getProperty("checkin-fork")) != null) {
                wrNrd.setProperty(cinfProp);
            }
            wrNrd.setContentType(rNrd.getContentType());
            wrNrd.setContentLength(rNrd.getContentLength());
            wrNrd.setContentLanguage(rNrd.getContentLanguage());
            wrNrd.setETag(String.valueOf(wrUri.hashCode()) + "_" + rNrd.getContentLength());
            wrNrd.setLastModified(new Date());
            wrNrd.setCreationDate(new Date());
            if (autoUpdateUri != null && autoUpdateUri.length() > 0) {
                UriHandler autoUpdateUh = new UriHandler(autoUpdateUri);
                wrNrd.setProperty(new NodeProperty("auto-update", this.pHelp.createHrefValue(autoUpdateUri)));
                wrNrd.setName(autoUpdateUh.getName());
            } else {
                wrNrd.removeProperty("auto-update");
                wrNrd.setName(rNrd.getName());
            }
            Enumeration j = rNrd.enumerateProperties();
            while (j.hasMoreElements()) {
                NodeProperty p = (NodeProperty)j.nextElement();
                if (p.isLiveProperty()) continue;
                wrNrd.setProperty(p);
            }
            PropertyHelper.addHrefToProperty(rNrd, "checkout-set", wrUri);
            this.content.store(this.sToken, rNrds.getUri(), rNrd, null);
            this.content.create(this.sToken, wrUri, wrNrd, rNrc);
            this.content.store(this.sToken, wrUri, wrNrd, null);
            this.resp.setStatus(201);
            return wrUri;
        }
        Domain.warn((Object)("Do not know how to checkout a '" + rRk + "' resource"));
        this.resp.setStatus(409);
        throw new WebdavException(409);
    }

    public String checkout(NodeRevisionDescriptors rNrds, NodeRevisionDescriptor rNrd, boolean forkOk, boolean applyToVersion) throws SlideException, JDOMException, IOException, PreconditionViolationException {
        return this.checkout(rNrds, rNrd, forkOk, applyToVersion, false);
    }

    public String checkout(NodeRevisionDescriptors rNrds, NodeRevisionDescriptor rNrd, boolean forkOk, boolean applyToVersion, boolean isAutoVersionCheckout) throws SlideException, JDOMException, IOException, PreconditionViolationException {
        String rUri = this.getUri(rNrds, rNrd);
        ResourceKind rRk = AbstractResourceKind.determineResourceKind(this.nsaToken, rNrds, rNrd);
        if (!rRk.isSupportedMethod(this.req.getMethod())) {
            if (rRk instanceof CheckedOut) {
                throw new PreconditionViolationException(new ViolatedPrecondition("must-be-checked-in", 409), rNrds.getUri());
            }
            throw new MethodNotAllowedException(rRk);
        }
        if (rRk instanceof CheckedInVersionControlled) {
            NodeLock writeLock;
            NodeProperty cinProp = rNrd.getProperty("checked-in");
            String cinHref = VersioningHelper.getElementValue((String)cinProp.getValue());
            UriHandler cinUriHandler = UriHandler.getUriHandler(cinHref);
            String cinhUri = cinUriHandler.getAssociatedHistoryUri();
            NodeRevisionNumber cinNrn = new NodeRevisionNumber(cinUriHandler.getVersionName());
            NodeRevisionDescriptors cinNrds = this.content.retrieve(this.sToken, cinhUri);
            NodeRevisionDescriptor cinNrd = this.content.retrieve(this.sToken, cinNrds, cinNrn);
            if (applyToVersion) {
                NodeRevisionContent cinNrc = this.content.retrieve(this.sToken, cinNrds, cinNrd);
                return this.checkout(cinNrds, cinNrd, cinNrc, forkOk, rUri);
            }
            ViolatedPrecondition violatedPrecondition = this.getCheckoutPreconditionViolation(cinNrds, cinNrd, forkOk);
            if (violatedPrecondition != null) {
                throw new PreconditionViolationException(violatedPrecondition, rNrds.getUri());
            }
            NodeRevisionDescriptors vhrNrds = this.content.retrieve(this.sToken, cinhUri);
            this.backupSpecificLiveProperties(rNrds, rNrd);
            rNrd.removeProperty(cinProp);
            rNrd.setProperty(new NodeProperty("checked-out", cinProp.getValue()));
            rNrd.setProperty(new NodeProperty("predecessor-set", cinProp.getValue()));
            NodeProperty property = cinNrd.getProperty("checkout-fork");
            if (property != null) {
                rNrd.setProperty(property);
            }
            if ((property = cinNrd.getProperty("checkin-fork")) != null) {
                rNrd.setProperty(property);
            }
            if (isAutoVersionCheckout && (writeLock = this.getWriteLock(this.sToken, rNrds)) != null) {
                NodeProperty p = new NodeProperty("checkin-locktoken", (Object)writeLock.getLockId(), "http://jakarta.apache.org/slide/");
                p.setKind(NodeProperty.Kind.PROTECTED);
                rNrd.setProperty(p);
            }
            PropertyHelper.addHrefToProperty(cinNrd, "checkout-set", rUri);
            this.content.store(this.sToken, rNrds.getUri(), rNrd, null);
            this.content.store(this.sToken, cinNrds.getUri(), cinNrd, null);
            return null;
        }
        Domain.warn((Object)("Do not know how to checkout a '" + rRk + "' resource"));
        this.resp.setStatus(409);
        throw new WebdavException(409);
    }

    public String getAutoVersionElementName(NodeRevisionDescriptor revisionDescriptor) {
        String autoVersionValue = null;
        NodeProperty autoVersionProperty = revisionDescriptor.getProperty("auto-version");
        if (autoVersionProperty != null && autoVersionProperty.getValue() != null) {
            autoVersionValue = autoVersionProperty.getValue().toString().length() > 0 ? VersioningHelper.getElementName(autoVersionProperty.getValue().toString()) : "";
        }
        return autoVersionValue;
    }

    protected ViolatedPrecondition getCheckinPreconditionViolation(NodeProperty predSetProp, NodeRevisionDescriptors vhrNrds, boolean isForkOk, NodeRevisionDescriptor autoUpdNrd) throws LinkedObjectNotFoundException, ServiceAccessException, ObjectLockedException, RevisionDescriptorNotFoundException, JDOMException, IllegalArgumentException, ObjectNotFoundException, AccessDeniedException, IOException {
        ViolatedPrecondition violatedPrecondition = null;
        if (predSetProp != null && predSetProp.getValue() != null) {
            XMLValue predecessors = new XMLValue((String)predSetProp.getValue());
            Iterator iterator = predecessors.iterator();
            while (iterator.hasNext()) {
                NodeProperty cinProp;
                Enumeration predecessorSuccessors;
                String href = ((Element)iterator.next()).getTextTrim();
                if (href == null) continue;
                UriHandler predecessorUriHandler = UriHandler.getUriHandler(href);
                if (!predecessorUriHandler.isVersionUri() || !vhrNrds.getUri().equals(predecessorUriHandler.getAssociatedHistoryUri())) {
                    return new ViolatedPrecondition("version-history-is-tree", 403);
                }
                NodeRevisionNumber predecessorNrn = new NodeRevisionNumber(predecessorUriHandler.getVersionName());
                NodeRevisionDescriptor predecessorNrd = this.content.retrieve(this.sToken, vhrNrds, predecessorNrn);
                NodeProperty predecessorCheckinForkProperty = predecessorNrd.getProperty("checkin-fork");
                if (predecessorCheckinForkProperty != null && (predecessorSuccessors = vhrNrds.getSuccessors(predecessorNrn)) != null && predecessorSuccessors.hasMoreElements() && predecessorCheckinForkProperty.getValue() != null) {
                    String checkinFork = VersioningHelper.getElementName(predecessorCheckinForkProperty.getValue().toString());
                    if ("forbidden".equals(checkinFork)) {
                        return new ViolatedPrecondition("checkin-fork-forbidden", 403);
                    }
                    if ("discouraged".equals(checkinFork) && !isForkOk) {
                        return new ViolatedPrecondition("checkin-fork-discouraged", 409);
                    }
                }
                if (autoUpdNrd == null || (cinProp = autoUpdNrd.getProperty("checked-in")) == null) continue;
                Element cinHrefElm = this.pHelp.parsePropertyValue((String)cinProp.getValue());
                UriHandler cinUh = new UriHandler(cinHrefElm.getTextTrim());
                NodeRevisionNumber cinNrn = new NodeRevisionNumber(cinUh.getVersionName());
                if (!vhrNrds.getUri().equals(cinUh.getAssociatedHistoryUri())) {
                    return new ViolatedPrecondition("no-overwrite-by-auto-update", 409);
                }
                if (vhrNrds.isAncestorDescendant(cinNrn, predecessorNrn)) continue;
                return new ViolatedPrecondition("no-overwrite-by-auto-update", 409);
            }
        }
        return violatedPrecondition;
    }

    protected ViolatedPrecondition getCheckoutPreconditionViolation(NodeRevisionDescriptors cinNrds, NodeRevisionDescriptor cinNrd, boolean isForkOk) throws IllegalArgumentException, IOException, JDOMException, SlideException {
        Element checkoutForkElement;
        ViolatedPrecondition violatedPrecondition = null;
        NodeProperty checkoutForkProperty = cinNrd.getProperty("checkout-fork");
        if (checkoutForkProperty != null && (checkoutForkElement = this.pHelp.parsePropertyValue(checkoutForkProperty.getValue().toString())) != null) {
            XMLValue checkoutSetValue;
            PropertyHelper propertyHelper;
            NodeProperty checkoutSetProp;
            Enumeration successors = cinNrds.getSuccessors(cinNrd.getRevisionNumber());
            if (successors != null && successors.hasMoreElements()) {
                if ("forbidden".equals(checkoutForkElement.getName())) {
                    return new ViolatedPrecondition("checkout-of-version-with-descendant-is-forbidden", 403);
                }
                if ("discouraged".equals(checkoutForkElement.getName()) && !isForkOk) {
                    return new ViolatedPrecondition("checkout-of-version-with-descendant-is-discouraged", 409);
                }
            }
            if ((checkoutSetProp = (propertyHelper = PropertyHelper.getPropertyHelper(this.sToken, this.nsaToken, this.sConf)).getProperty("checkout-set", cinNrds, cinNrd, this.req.getContextPath(), null)) != null && checkoutSetProp.getValue() != null && (checkoutSetValue = new XMLValue(checkoutSetProp.getValue().toString())).iterator().hasNext()) {
                if ("forbidden".equals(checkoutForkElement.getName())) {
                    return new ViolatedPrecondition("checkout-of-checked-out-version-is-forbidden", 403);
                }
                if ("discouraged".equals(checkoutForkElement.getName()) && !isForkOk) {
                    return new ViolatedPrecondition("checkout-of-checked-out-version-is-discouraged", 409);
                }
            }
        }
        return violatedPrecondition;
    }

    public static Element getElement(String elementString) {
        Element element = null;
        try {
            Document document = VersioningHelper.getSAXBuilder().build((Reader)new StringReader(elementString));
            element = document.getRootElement();
        }
        catch (JDOMException jDOMException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return element;
    }

    public static String getElementName(String elementString) {
        String name = null;
        Element element = VersioningHelper.getElement(elementString);
        if (element != null) {
            name = element.getName();
        }
        return name;
    }

    public static String getElementValue(String elementString) {
        String text = null;
        Element element = VersioningHelper.getElement(elementString);
        if (element != null) {
            text = element.getText();
        }
        return text;
    }

    protected String getForkBranch(NodeProperty predSetProp, NodeRevisionDescriptors vhrNrds, boolean isForkOk) throws LinkedObjectNotFoundException, ServiceAccessException, ObjectLockedException, RevisionDescriptorNotFoundException, JDOMException, IllegalArgumentException, ObjectNotFoundException, AccessDeniedException, IOException {
        Enumeration predecessorSuccessors;
        UriHandler predecessorUriHandler;
        NodeRevisionNumber predecessorNrn;
        NodeRevisionDescriptor predecessorNrd;
        NodeProperty predecessorCheckinForkProperty;
        String href;
        XMLValue predecessors;
        Iterator iterator;
        String forkBranch = null;
        if (predSetProp != null && predSetProp.getValue() != null && (iterator = (predecessors = new XMLValue((String)predSetProp.getValue())).iterator()).hasNext() && (href = ((Element)iterator.next()).getTextTrim()) != null && (predecessorCheckinForkProperty = (predecessorNrd = this.content.retrieve(this.sToken, vhrNrds, predecessorNrn = new NodeRevisionNumber((predecessorUriHandler = UriHandler.getUriHandler(href)).getVersionName()))).getProperty("checkin-fork")) != null && (predecessorSuccessors = vhrNrds.getSuccessors(predecessorNrn)) != null && predecessorSuccessors.hasMoreElements()) {
            forkBranch = "branch_" + predecessorNrn.toString();
        }
        return forkBranch;
    }

    public String getLabeledResourceUri(String resourcePath, String label) throws SlideException, LabeledRevisionNotFoundException {
        return VersioningHelper.getLabeledResourceUri(this.nsaToken, this.sToken, this.content, resourcePath, label);
    }

    public static String getLabeledResourceUri(NamespaceAccessToken nsaToken, SlideToken sToken, Content content, String resourcePath, String label) throws SlideException, LabeledRevisionNotFoundException {
        NodeRevisionDescriptors revisionDescriptors = content.retrieve(sToken, resourcePath);
        NodeRevisionDescriptor revisionDescriptor = content.retrieve(sToken, revisionDescriptors);
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(nsaToken, resourcePath, revisionDescriptor);
        if (resourceKind instanceof VersionControlled && label != null) {
            String vrUri = VersioningHelper.getUriOfAssociatedVR(nsaToken, sToken, content, revisionDescriptors.getUri());
            UriHandler vrUriHandler = UriHandler.getUriHandler(vrUri);
            String historyUri = vrUriHandler.getAssociatedHistoryUri();
            revisionDescriptors = content.retrieve(sToken, historyUri);
            revisionDescriptor = VersioningHelper.retrieveLabeledRevision(nsaToken, sToken, content, historyUri, label);
        }
        return VersioningHelper.getUri(nsaToken, sToken, content, revisionDescriptors, revisionDescriptor);
    }

    protected Element getResourcesWithVersionHistoryQueryElement(String scope, String historyPath) {
        Element resourcesWithVersionHistoryQueryElement = new Element("basicsearch", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        Element select = new Element("select", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        resourcesWithVersionHistoryQueryElement.addContent(select);
        Element prop = new Element("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        select.addContent(prop);
        Element checkedIn = new Element("checked-in", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        prop.addContent(checkedIn);
        Element checkedOut = new Element("checked-out", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        prop.addContent(checkedOut);
        Element from = new Element("from", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        resourcesWithVersionHistoryQueryElement.addContent(from);
        Element scopeElement = new Element("scope", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        from.addContent(scopeElement);
        Element href = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        scopeElement.addContent(href);
        href.setText(scope);
        Element where = new Element("where", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        resourcesWithVersionHistoryQueryElement.addContent(where);
        Element or = new Element("or", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        where.addContent(or);
        Element propcontains = new Element("propcontains", NodeProperty.NamespaceCache.SLIDE_NAMESPACE);
        or.addContent(propcontains);
        prop = new Element("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        propcontains.addContent(prop);
        prop.addContent((Element)checkedIn.clone());
        Element literal = new Element("literal", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        propcontains.addContent(literal);
        literal.setText(historyPath);
        propcontains = new Element("propcontains", NodeProperty.NamespaceCache.SLIDE_NAMESPACE);
        or.addContent(propcontains);
        prop = new Element("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        propcontains.addContent(prop);
        prop.addContent((Element)checkedOut.clone());
        literal = new Element("literal", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        propcontains.addContent(literal);
        literal.setText(historyPath);
        return resourcesWithVersionHistoryQueryElement;
    }

    protected static SAXBuilder getSAXBuilder() {
        if (saxBuilder == null) {
            saxBuilder = new SAXBuilder();
        }
        return saxBuilder;
    }

    public static String getUri(NamespaceAccessToken nsaToken, SlideToken sToken, Content content, NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor) throws SlideException {
        StringBuffer uri = new StringBuffer();
        UriHandler uriHandler = UriHandler.getUriHandler(revisionDescriptors.getUri());
        if (!uriHandler.isHistoryUri()) {
            uri.append(revisionDescriptors.getUri());
        } else if (revisionDescriptor.getRevisionNumber().equals((Object)NodeRevisionNumber.HIDDEN_0_0)) {
            uri.append(revisionDescriptors.getUri());
        } else {
            uri.append(revisionDescriptors.getUri());
            if (!revisionDescriptors.getUri().endsWith("/")) {
                uri.append("/");
            }
            uri.append(revisionDescriptor.getRevisionNumber().toString());
        }
        return uri.toString();
    }

    public String getUri(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor) throws SlideException {
        return VersioningHelper.getUri(this.nsaToken, this.sToken, this.content, revisionDescriptors, revisionDescriptor);
    }

    public String getUriOfAssociatedVR(String resourceUri) throws SlideException {
        return VersioningHelper.getUriOfAssociatedVR(this.nsaToken, this.sToken, this.content, resourceUri);
    }

    public static String getUriOfAssociatedVR(NamespaceAccessToken nsaToken, SlideToken sToken, Content content, String resourceUri) throws SlideException {
        String vrUri;
        block6: {
            vrUri = null;
            NodeRevisionDescriptors revisionDescriptors = content.retrieve(sToken, resourceUri);
            if (revisionDescriptors.isVersioned()) break block6;
            NodeRevisionDescriptor revisionDescriptor = content.retrieve(sToken, revisionDescriptors);
            NodeProperty property = revisionDescriptor.getProperty("checked-out");
            if (property == null || property.getValue() == null) {
                property = revisionDescriptor.getProperty("checked-in");
            }
            if (property != null && property.getValue() != null) {
                try {
                    XMLValue xmlValue = new XMLValue(property.getValue().toString());
                    Iterator iterator = xmlValue.iterator();
                    if (iterator.hasNext()) {
                        Element element = (Element)iterator.next();
                        vrUri = element.getText();
                    }
                }
                catch (JDOMException jDOMException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return vrUri;
    }

    public ViolatedPrecondition getVersionControlPreconditionViolation(String resourcePath, NodeRevisionDescriptor resourceNrd, UriHandler resourceUrihandler, String existingVersionPath, NodeRevisionDescriptor existingVersionNrd, UriHandler existingVersionUrihandler) throws SlideException {
        ResourceKind rRk = AbstractResourceKind.determineResourceKind(this.nsaToken, resourcePath, resourceNrd);
        ResourceKind evRk = AbstractResourceKind.determineResourceKind(this.nsaToken, existingVersionPath, existingVersionNrd);
        if (!(rRk instanceof DeltavCompliantUnmappedUrl)) {
            return new ViolatedPrecondition("cannot-add-to-existing-history", 409);
        }
        if (!(evRk instanceof Version) || existingVersionNrd == null) {
            return new ViolatedPrecondition("must-be-version", 409);
        }
        String scope = resourceUrihandler.getAssociatedWorkspaceUri();
        String historyPath = existingVersionUrihandler.getAssociatedHistoryUri();
        SearchQueryResult queryResult = this.searchResourcesWithGivenHistory(historyPath, scope, Integer.MAX_VALUE);
        Iterator queryResultIterator = queryResult.iterator();
        if (queryResultIterator.hasNext()) {
            return new ViolatedPrecondition("one-version-controlled-resource-per-history-per-workspace", 409);
        }
        return null;
    }

    public static VersioningHelper getVersioningHelper(SlideToken sToken, NamespaceAccessToken nsaToken, HttpServletRequest req, HttpServletResponse resp, WebdavServletConfig sConf) {
        return new VersioningHelper(sToken, nsaToken, req, resp, sConf);
    }

    private NodeLock getWriteLock(SlideToken slideToken, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        NodeLock writeLock = null;
        try {
            Enumeration lockEnum = this.lock.enumerateLocks(slideToken, revisionDescriptors.getUri());
            if (lockEnum != null) {
                String typeUri = null;
                NodeLock lock = null;
                while (writeLock == null && lockEnum.hasMoreElements()) {
                    lock = (NodeLock)lockEnum.nextElement();
                    typeUri = lock.getTypeUri();
                    if (!this.modifyContentUri.equals(typeUri) && !this.modifyMetadataUri.equals(typeUri)) continue;
                    writeLock = lock;
                }
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
        }
        catch (LockTokenNotFoundException lockTokenNotFoundException) {}
        return writeLock;
    }

    public boolean isWriteLocked(SlideToken slideToken, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        return this.getWriteLock((SlideToken)new SlideTokenWrapper(slideToken, false), revisionDescriptors) != null;
    }

    public void mkworkspace(String resourcePath) throws SlideException {
        UriHandler rUh = UriHandler.getUriHandler(resourcePath);
        NodeRevisionDescriptor rNrd = null;
        try {
            NodeRevisionDescriptors rNrds = this.content.retrieve(this.sToken, resourcePath);
            rNrd = this.content.retrieve(this.sToken, rNrds);
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
        ResourceKind rRk = AbstractResourceKind.determineResourceKind(this.nsaToken, resourcePath, rNrd);
        if (!(rRk instanceof DeltavCompliantUnmappedUrl)) {
            throw new PreconditionViolationException(new ViolatedPrecondition("resource-must-be-null", 409), resourcePath);
        }
        if (!rUh.isWorkspaceUri()) {
            throw new PreconditionViolationException(new ViolatedPrecondition("workspace-location-ok", 403), resourcePath);
        }
        if (!rRk.isSupportedMethod(this.req.getMethod())) {
            throw new MethodNotAllowedException(rRk);
        }
        String wsUri = String.valueOf(rUh);
        NodeRevisionDescriptor wsNrd = new NodeRevisionDescriptor(0L);
        Iterator i = this.pHelp.createInitialProperties(WorkspaceImpl.getInstance()).iterator();
        while (i.hasNext()) {
            wsNrd.setProperty((NodeProperty)i.next());
        }
        wsNrd.setProperty(new NodeProperty("workspace", this.pHelp.createHrefValue(wsUri)));
        wsNrd.setETag(String.valueOf(wsUri.hashCode()) + "_");
        wsNrd.setLastModified(new Date());
        wsNrd.setContentLength(0L);
        wsNrd.setName(rUh.getWorkspaceName());
        wsNrd.setCreationDate(new Date());
        SubjectNode wsNode = new SubjectNode();
        this.structure.create(this.sToken, (ObjectNode)wsNode, wsUri);
        this.content.create(this.sToken, wsUri, wsNrd, null);
        this.resp.setStatus(201);
    }

    public boolean mustCheckinAutoVersionedVCR(SlideToken slideToken, String resourceUri) throws SlideException {
        NodeRevisionDescriptors vcrRevisionDescriptors = this.content.retrieve(this.sToken, resourceUri);
        NodeRevisionDescriptor vcrRevisionDescriptor = this.content.retrieve(this.sToken, vcrRevisionDescriptors);
        return this.mustCheckinAutoVersionedVCR(slideToken, vcrRevisionDescriptors, vcrRevisionDescriptor);
    }

    public boolean mustCheckinAutoVersionedVCR(SlideToken slideToken, NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        boolean checkin = false;
        String autoVersionValue = this.getAutoVersionElementName(revisionDescriptor);
        if (autoVersionValue != null && !(checkin = "checkout-checkin".equals(autoVersionValue)) && "checkout-unlocked-checkin".equals(autoVersionValue)) {
            checkin = this.isWriteLocked(slideToken, revisionDescriptors) ^ true;
        }
        return checkin;
    }

    public boolean mustCheckoutAutoVersionedVCR(String resourceUri) throws SlideException {
        NodeRevisionDescriptors vcrRevisionDescriptors = this.content.retrieve(this.sToken, resourceUri);
        NodeRevisionDescriptor vcrRevisionDescriptor = this.content.retrieve(this.sToken, vcrRevisionDescriptors);
        return this.mustCheckoutAutoVersionedVCR(vcrRevisionDescriptors, vcrRevisionDescriptor);
    }

    public boolean mustCheckoutAutoVersionedVCR(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor) {
        String autoVersionValue = this.getAutoVersionElementName(revisionDescriptor);
        return autoVersionValue != null && ("checkout-checkin".equals(autoVersionValue) || "checkout-unlocked-checkin".equals(autoVersionValue) || "checkout".equals(autoVersionValue) || "locked-checkout".equals(autoVersionValue));
    }

    protected void restoreSpecificLiveProperties(NodeRevisionDescriptors rNrds, NodeRevisionDescriptor rNrd) throws SlideException {
        NodeRevisionDescriptor backupNrd = this.content.retrieve(this.sToken, rNrds, NodeRevisionNumber.HIDDEN_0_0);
        NodeProperty p = backupNrd.getProperty("auto-version");
        if (p != null) {
            rNrd.setProperty(p);
        }
        if ((p = backupNrd.getProperty("comment")) != null) {
            rNrd.setProperty(p);
        }
        if ((p = backupNrd.getProperty("displayname")) != null) {
            rNrd.setProperty(p);
        }
        if ((p = backupNrd.getProperty("creator-displayname")) != null) {
            rNrd.setProperty(p);
        }
        this.content.store(this.sToken, rNrds.getUri(), rNrd, null);
    }

    public NodeRevisionDescriptor retrieveLabeledRevision(String resourcePath, String label) throws SlideException, LabeledRevisionNotFoundException {
        return VersioningHelper.retrieveLabeledRevision(this.nsaToken, this.sToken, this.content, resourcePath, label);
    }

    public static NodeRevisionDescriptor retrieveLabeledRevision(NamespaceAccessToken nsaToken, SlideToken sToken, Content content, String historyUri, String label) throws SlideException, LabeledRevisionNotFoundException {
        NodeRevisionDescriptor labeledRevision;
        block6: {
            labeledRevision = null;
            UriHandler historyUriHandler = UriHandler.getUriHandler(historyUri);
            if (!historyUriHandler.isHistoryUri()) break block6;
            NodeRevisionDescriptors historyNrds = content.retrieve(sToken, historyUri);
            NodeRevisionDescriptor historyNrd = content.retrieve(sToken, historyNrds, NodeRevisionNumber.HIDDEN_0_0);
            NodeProperty versionSet = historyNrd.getProperty("version-set");
            try {
                XMLValue versionSetValue = new XMLValue(versionSet.getValue().toString());
                NodeRevisionDescriptor vrNrd = null;
                NodeProperty labelNameSetProperty = null;
                String labelNameSetString = null;
                Iterator versionSetIterator = versionSetValue.iterator();
                String vrUri = null;
                UriHandler vrUriHandler = null;
                boolean found = false;
                while (!found && versionSetIterator.hasNext()) {
                    vrUri = ((Element)versionSetIterator.next()).getText();
                    vrUriHandler = UriHandler.getUriHandler(vrUri);
                    NodeRevisionNumber vrRevisionNumber = new NodeRevisionNumber(vrUriHandler.getVersionName());
                    vrNrd = content.retrieve(sToken, historyNrds, vrRevisionNumber);
                    labelNameSetProperty = vrNrd.getProperty("label-name-set");
                    if (labelNameSetProperty == null || labelNameSetProperty.getValue() == null || (labelNameSetString = labelNameSetProperty.getValue().toString()) == null) continue;
                    XMLValue labelNameSet = new XMLValue(labelNameSetString);
                    Iterator labelNameSetIterator = labelNameSet.iterator();
                    while (!found && labelNameSetIterator.hasNext()) {
                        found = label.equals(((Element)labelNameSetIterator.next()).getText());
                    }
                }
                if (found) {
                    labeledRevision = vrNrd;
                    break block6;
                }
                throw new LabeledRevisionNotFoundException(historyUri, label);
            }
            catch (JDOMException jDOMException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return labeledRevision;
    }

    protected SearchQueryResult searchResourcesWithGivenHistory(String historyPath, String scope, int maxDepth) throws ServiceAccessException, BadQueryException {
        SlideUri slideUri = new SlideUri(this.req.getRequestURI());
        String absPath = slideUri.getContextPath(scope);
        Element basicSearch = this.getResourcesWithVersionHistoryQueryElement(absPath, historyPath);
        String grammarNamespace = basicSearch.getNamespaceURI();
        Search searchHelper = this.nsaToken.getSearchHelper();
        SearchQuery searchQuery = searchHelper.createSearchQuery(grammarNamespace, basicSearch, this.sToken, maxDepth, this.req.getRequestURI());
        SearchQueryResult queryResult = searchHelper.search(this.sToken, searchQuery);
        return queryResult;
    }

    public void setWorkspaceProperty(String rUri, NodeRevisionDescriptor rNrd) {
        UriHandler rUh = UriHandler.getUriHandler(rUri);
        String wsUri = rUh.getAssociatedWorkspaceUri();
        if (wsUri != null) {
            rNrd.setProperty(new NodeProperty("workspace", this.pHelp.createHrefValue(wsUri)));
        } else {
            rNrd.removeProperty("workspace");
        }
    }

    public void uncheckout(String resourcePath) throws SlideException, JDOMException, IOException, PreconditionViolationException {
        NodeRevisionDescriptors rNrds = this.content.retrieve(this.sToken, resourcePath);
        NodeRevisionDescriptor rNrd = this.content.retrieve(this.sToken, rNrds);
        this.uncheckout(rNrds, rNrd);
    }

    public void uncheckout(NodeRevisionDescriptors rNrds, NodeRevisionDescriptor rNrd) throws SlideException, JDOMException, IOException, PreconditionViolationException {
        String rUri = this.getUri(rNrds, rNrd);
        ResourceKind rRk = AbstractResourceKind.determineResourceKind(this.nsaToken, rNrds, rNrd);
        if (!(rRk instanceof CheckedOutVersionControlled)) {
            throw new PreconditionViolationException(new ViolatedPrecondition("must-be-checked-out-version-controlled-resource", 409), rNrds.getUri());
        }
        if (!rRk.isSupportedMethod(this.req.getMethod())) {
            throw new MethodNotAllowedException(rRk);
        }
        NodeProperty coutProp = rNrd.getProperty("checked-out");
        String coutHref = VersioningHelper.getElementValue((String)coutProp.getValue());
        UriHandler coutUriHandler = UriHandler.getUriHandler(coutHref);
        String coutUri = coutUriHandler.getAssociatedHistoryUri();
        NodeRevisionNumber coutNrn = new NodeRevisionNumber(coutUriHandler.getVersionName());
        NodeRevisionDescriptors coutNrds = this.content.retrieve(this.sToken, coutUri);
        NodeRevisionDescriptor coutNrd = this.content.retrieve(this.sToken, coutNrds, coutNrn);
        NodeRevisionContent coutNrc = this.content.retrieve(this.sToken, coutNrds, coutNrd);
        PropertyHelper.removeHrefFromProperty(coutNrd, "checkout-set", rUri);
        this.content.store(this.sToken, coutNrds.getUri(), coutNrd, null);
        rNrd.removeProperty("checked-out");
        this.update(rNrds, rNrd, coutNrds, coutNrd);
        this.restoreSpecificLiveProperties(rNrds, rNrd);
        this.content.store(this.sToken, rNrds.getUri(), rNrd, null);
        this.content.remove(this.sToken, rNrds.getUri(), NodeRevisionNumber.HIDDEN_0_0);
    }

    public void update(String vcrUri, String vrUri) throws SlideException {
        NodeRevisionDescriptors vcrRevisionDescriptors = this.content.retrieve(this.sToken, vcrUri);
        NodeRevisionDescriptor vcrRevisionDescriptor = this.content.retrieve(this.sToken, vcrRevisionDescriptors);
        NodeRevisionDescriptors vrRevisionDescriptors = this.content.retrieve(this.sToken, vrUri);
        NodeRevisionDescriptor vrRevisionDescriptor = this.content.retrieve(this.sToken, vrRevisionDescriptors);
        this.update(vcrRevisionDescriptors, vcrRevisionDescriptor, vrRevisionDescriptors, vrRevisionDescriptor);
    }

    public void update(NodeRevisionDescriptors vcrRevisionDescriptors, NodeRevisionDescriptor vcrRevisionDescriptor, NodeRevisionDescriptors vrRevisionDescriptors, NodeRevisionDescriptor vrRevisionDescriptor) throws SlideException {
        NodeProperty p;
        ResourceKind vrResourceKind = VersionImpl.getInstance();
        ResourceKind cinvcrResourceKind = CheckedInVersionControlledImpl.getInstance();
        String vcrUri = this.getUri(vcrRevisionDescriptors, vcrRevisionDescriptor);
        Enumeration propertyEnum = vcrRevisionDescriptor.enumerateProperties();
        while (propertyEnum.hasMoreElements()) {
            p = (NodeProperty)propertyEnum.nextElement();
            if (p.isLiveProperty()) continue;
            vcrRevisionDescriptor.removeProperty(p);
        }
        propertyEnum = vrRevisionDescriptor.enumerateProperties();
        while (propertyEnum.hasMoreElements()) {
            p = (NodeProperty)propertyEnum.nextElement();
            if (p.isLiveProperty()) continue;
            vcrRevisionDescriptor.setProperty(p);
        }
        String vrUri = this.getUri(vrRevisionDescriptors, vrRevisionDescriptor);
        vcrRevisionDescriptor.setProperty(new NodeProperty("checked-in", this.pHelp.createHrefValue(vrUri)));
        vcrRevisionDescriptor.setLastModified(new Date());
        vcrRevisionDescriptor.setContentLength(vrRevisionDescriptor.getContentLength());
        vcrRevisionDescriptor.setContentType(vrRevisionDescriptor.getContentType());
        vcrRevisionDescriptor.setContentLanguage(vrRevisionDescriptor.getContentLanguage());
        vcrRevisionDescriptor.setETag(String.valueOf(vcrRevisionDescriptors.getUri().hashCode()) + "_" + vcrRevisionDescriptor.getContentLength());
        this.setWorkspaceProperty(vcrUri, vcrRevisionDescriptor);
        NodeRevisionContent vrContent = this.content.retrieve(this.sToken, vrRevisionDescriptors, vrRevisionDescriptor);
        this.content.store(this.sToken, vcrUri, vcrRevisionDescriptor, vrContent);
    }

    public void versionControl(String resourcePath) throws SlideException {
        UriHandler rUh = UriHandler.getUriHandler(resourcePath);
        NodeRevisionDescriptors rNrds = this.content.retrieve(this.sToken, resourcePath);
        NodeRevisionDescriptor rNrd = this.content.retrieve(this.sToken, rNrds);
        ResourceKind rRk = AbstractResourceKind.determineResourceKind(this.nsaToken, resourcePath, rNrd);
        if (!rRk.isSupportedMethod(this.req.getMethod())) {
            throw new MethodNotAllowedException(rRk);
        }
        if (rRk instanceof VersionControlled) {
            return;
        }
        NodeRevisionDescriptor vrNrd = new NodeRevisionDescriptor((long)this.req.getContentLength());
        Iterator i = this.pHelp.createInitialProperties(VersionImpl.getInstance()).iterator();
        while (i.hasNext()) {
            vrNrd.setProperty((NodeProperty)i.next());
        }
        Enumeration j = rNrd.enumerateProperties();
        while (j.hasMoreElements()) {
            NodeProperty p = (NodeProperty)j.nextElement();
            if (p.isLiveProperty() || vrNrd.exists(p.getName())) continue;
            vrNrd.setProperty(p);
        }
        NodeRevisionContent rNrc = this.content.retrieve(this.sToken, rNrds, rNrd);
        vrNrd.setContentType(rNrd.getContentType());
        vrNrd.setContentLength(rNrd.getContentLength());
        vrNrd.setContentLanguage(rNrd.getContentLanguage());
        String comment = "INITIAL VERSION. ";
        if (rNrd.exists("comment")) {
            comment = String.valueOf(comment) + (String)rNrd.getProperty("comment").getValue();
        }
        vrNrd.setProperty(new NodeProperty("comment", (Object)comment));
        Vector vhrLabels = new Vector();
        Hashtable vhrProps = new Hashtable();
        String vhrBranch = "main";
        NodeRevisionDescriptor vhrNrd = new NodeRevisionDescriptor(NodeRevisionNumber.HIDDEN_0_0, vhrBranch, vhrLabels, vhrProps);
        i = this.pHelp.createInitialProperties(VersionHistoryImpl.getInstance()).iterator();
        while (i.hasNext()) {
            vhrNrd.setProperty((NodeProperty)i.next());
        }
        i = this.pHelp.createInitialProperties(VersionControlledImpl.getInstance()).iterator();
        while (i.hasNext()) {
            NodeProperty p = (NodeProperty)i.next();
            if (rNrd.exists(p.getName())) continue;
            rNrd.setProperty(p);
        }
        UriHandler vhrUh = UriHandler.createNextHistoryUri(this.sToken, this.nsaToken, rUh);
        String vhrUri = String.valueOf(vhrUh);
        SubjectNode vhrNode = new SubjectNode();
        this.structure.create(this.sToken, (ObjectNode)vhrNode, String.valueOf(vhrUh));
        this.content.create(this.sToken, vhrUri, true);
        this.content.create(this.sToken, vhrUri, vrNrd, rNrc);
        NodeRevisionDescriptors vhrNrds = this.content.retrieve(this.sToken, vhrUri);
        this.content.create(this.sToken, vhrUri, null, vhrNrd, null);
        NodeRevisionNumber vrVersion = vrNrd.getRevisionNumber();
        SubjectNode vrNode = new SubjectNode();
        UriHandler vrUh = UriHandler.createVersionUri(vhrUh, String.valueOf(vrVersion));
        String vrUri = String.valueOf(vrUh);
        this.structure.create(this.sToken, (ObjectNode)vrNode, String.valueOf(vrUh));
        vrNrd.setName(rNrd.getName());
        rNrd.setProperty(new NodeProperty("checked-in", this.pHelp.createHrefValue(vrUri)));
        vhrNrd.setETag(String.valueOf(vhrUri.hashCode()) + "_");
        vhrNrd.setCreationDate(new Date());
        vhrNrd.setLastModified(new Date());
        vhrNrd.setContentLength(0L);
        vhrNrd.setName(vhrUh.getHistoryName());
        vhrNrd.setProperty(new NodeProperty("version-set", this.pHelp.createHrefValue(vrUri)));
        vrNrd.setETag(String.valueOf(vrUri.hashCode()) + "_" + this.req.getContentLength());
        vrNrd.setCreationDate(new Date());
        vrNrd.setLastModified(new Date());
        vrNrd.setProperty(new NodeProperty("version-name", (Object)vrUh.getVersionName()));
        this.content.store(this.sToken, resourcePath, rNrd, null);
        this.content.store(this.sToken, vhrUri, vhrNrd, null);
        this.content.store(this.sToken, vhrUri, vrNrd, null);
    }

    public void versionControl(String resourcePath, String existingVersionPath) throws SlideException {
        UriHandler rUh = UriHandler.getUriHandler(resourcePath);
        UriHandler evUh = UriHandler.getUriHandler(existingVersionPath);
        if (!evUh.isVersionUri()) {
            throw new PreconditionViolationException(new ViolatedPrecondition("must-be-version", 409), resourcePath);
        }
        NodeRevisionNumber evNrn = new NodeRevisionNumber(evUh.getVersionName());
        NodeRevisionDescriptors rNrds = null;
        NodeRevisionDescriptor rNrd = null;
        Object vcrNrds = null;
        NodeRevisionDescriptor vcrNrd = null;
        NodeRevisionDescriptors evNrds = null;
        NodeRevisionDescriptor evNrd = null;
        try {
            rNrds = this.content.retrieve(this.sToken, resourcePath);
            rNrd = this.content.retrieve(this.sToken, rNrds);
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
        try {
            evNrds = this.content.retrieve(this.sToken, existingVersionPath);
            evNrd = this.content.retrieve(this.sToken, evNrds);
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
        ViolatedPrecondition violatedPrecondition = this.getVersionControlPreconditionViolation(resourcePath, rNrd, rUh, existingVersionPath, evNrd, evUh);
        if (violatedPrecondition != null) {
            throw new PreconditionViolationException(violatedPrecondition, resourcePath);
        }
        String vcrUri = String.valueOf(rUh);
        String evUri = String.valueOf(evUh);
        UriHandler vcrUh = UriHandler.getUriHandler(vcrUri);
        vcrNrd = new NodeRevisionDescriptor(0L);
        Iterator i = this.pHelp.createInitialProperties(VersionControlledImpl.getInstance()).iterator();
        while (i.hasNext()) {
            vcrNrd.setProperty((NodeProperty)i.next());
        }
        vcrNrd.setETag(String.valueOf(vcrNrd.hashCode()) + "_" + evNrd.getContentLength());
        vcrNrd.setLastModified(new Date());
        vcrNrd.setContentLength(evNrd.getContentLength());
        vcrNrd.setContentType(evNrd.getContentType());
        vcrNrd.setContentLanguage(evNrd.getContentLanguage());
        String[] utok = vcrUh.getUriTokens();
        vcrNrd.setName(utok[utok.length - 1]);
        vcrNrd.setCreationDate(new Date());
        vcrNrd.setProperty(new NodeProperty("checked-in", this.pHelp.createHrefValue(evUri)));
        this.setWorkspaceProperty(vcrUri, vcrNrd);
        SubjectNode vcrNode = new SubjectNode();
        this.structure.create(this.sToken, (ObjectNode)vcrNode, vcrUri);
        NodeRevisionContent evContent = this.content.retrieve(this.sToken, evNrds, evNrd);
        this.content.create(this.sToken, vcrUri, vcrNrd, evContent);
        this.resp.setStatus(201);
    }
}

