/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.slide.common.Domain;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.DaslConstants;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.HistoryPathHandler;
import org.apache.slide.webdav.util.WorkingresourcePathHandler;
import org.apache.slide.webdav.util.WorkspacePathHandler;

public class UriHandler
implements DeltavConstants,
AclConstants,
DaslConstants {
    protected static Map registeredStores = new HashMap();
    protected static Set allScopes = new HashSet();
    protected static Set allStoreNames = new HashSet();
    private String uri;
    private String[] uriTokens = null;

    protected UriHandler(String uri) {
        this.uri = uri;
        StringTokenizer t = new StringTokenizer(uri, "/");
        int n = t.countTokens();
        this.uriTokens = new String[n];
        int i = 0;
        while (i < n) {
            this.uriTokens[i] = t.nextToken();
            ++i;
        }
    }

    protected UriHandler(UriHandler vhrUri, String versionName) {
        int n = vhrUri.length();
        this.uriTokens = new String[n + 1];
        int i = 0;
        while (i < n) {
            this.uriTokens[i] = vhrUri.getUriTokens()[i];
            ++i;
        }
        this.uriTokens[n] = versionName;
    }

    protected UriHandler(String[] uriTokens, int number) {
        String[] t = new String[number];
        int i = 0;
        while (i < number) {
            t[i] = uriTokens[i];
            ++i;
        }
        this.uriTokens = t;
    }

    protected static UriHandler bestMatchingScope(String namespaceName, UriHandler uh) {
        UriHandler result = null;
        Map storesInNamespace = (Map)registeredStores.get(namespaceName);
        Iterator i = storesInNamespace.keySet().iterator();
        int matchSize = 0;
        while (i.hasNext()) {
            UriHandler scopeUh = (UriHandler)i.next();
            if (!scopeUh.isAncestorOf(uh) || scopeUh.length() <= matchSize) continue;
            matchSize = scopeUh.length();
            result = scopeUh;
        }
        return result;
    }

    public static UriHandler createNextHistoryUri(SlideToken sToken, NamespaceAccessToken nsaToken, UriHandler uh) throws ObjectNotFoundException, AccessDeniedException, ObjectLockedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, RevisionNotFoundException {
        String hpath;
        NodeRevisionDescriptors hpathNrds;
        UriHandler result = null;
        String nsName = nsaToken.getName();
        UriHandler hpathHandler = HistoryPathHandler.getResolvedHistoryPathHandler(nsName, uh);
        Content content = nsaToken.getContentHelper();
        NodeRevisionDescriptor hpathNrd = content.retrieve(sToken, hpathNrds = content.retrieve(sToken, hpath = hpathHandler.toString()));
        NodeProperty nextHnProp = hpathNrd.getProperty("next-history-name", "http://jakarta.apache.org/slide/");
        if (nextHnProp == null && (nextHnProp = hpathNrd.getProperty("next-history-name")) != null) {
            hpathNrd.removeProperty(nextHnProp);
            nextHnProp = new NodeProperty("next-history-name", nextHnProp.getValue(), "http://jakarta.apache.org/slide/");
            nextHnProp.setKind(NodeProperty.Kind.PROTECTED);
            hpathNrd.setProperty(nextHnProp);
        }
        if (nextHnProp == null || nextHnProp.getValue() == null) {
            nextHnProp = new NodeProperty("next-history-name", (Object)"1", "http://jakarta.apache.org/slide/");
            nextHnProp.setKind(NodeProperty.Kind.PROTECTED);
            hpathNrd.setProperty(nextHnProp);
        }
        String nextHnStr = (String)nextHnProp.getValue();
        result = new UriHandler(String.valueOf(hpath) + "/" + nextHnStr);
        long nextHnLong = Long.parseLong(nextHnStr);
        nextHnProp = new NodeProperty("next-history-name", (Object)String.valueOf(nextHnLong + 1L), "http://jakarta.apache.org/slide/");
        hpathNrd.setProperty(nextHnProp);
        content.store(sToken, hpath, hpathNrd, null);
        return result;
    }

    public static UriHandler createNextWorkingresourceUri(SlideToken sToken, NamespaceAccessToken nsaToken, UriHandler uh) throws ObjectNotFoundException, AccessDeniedException, ObjectLockedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, RevisionNotFoundException {
        String wrpath;
        NodeRevisionDescriptors wrpathNrds;
        UriHandler result = null;
        String nsName = nsaToken.getName();
        UriHandler wrpathHandler = WorkingresourcePathHandler.getResolvedWorkingresourcePathHandler(nsName, uh);
        Content content = nsaToken.getContentHelper();
        NodeRevisionDescriptor wrpathNrd = content.retrieve(sToken, wrpathNrds = content.retrieve(sToken, wrpath = wrpathHandler.toString()));
        NodeProperty nextWrnProp = wrpathNrd.getProperty("next-workingresource-name", "http://jakarta.apache.org/slide/");
        if (nextWrnProp == null && (nextWrnProp = wrpathNrd.getProperty("next-workingresource-name")) != null) {
            wrpathNrd.removeProperty(nextWrnProp);
            nextWrnProp = new NodeProperty("next-workingresource-name", nextWrnProp.getValue(), "http://jakarta.apache.org/slide/");
            nextWrnProp.setKind(NodeProperty.Kind.PROTECTED);
            wrpathNrd.setProperty(nextWrnProp);
        }
        if (nextWrnProp == null || nextWrnProp.getValue() == null) {
            nextWrnProp = new NodeProperty("next-workingresource-name", (Object)"1", "http://jakarta.apache.org/slide/");
            nextWrnProp.setKind(NodeProperty.Kind.PROTECTED);
            wrpathNrd.setProperty(nextWrnProp);
        }
        String nextWrnStr = (String)nextWrnProp.getValue();
        result = new UriHandler(String.valueOf(wrpath) + "/" + nextWrnStr);
        long nextWrnLong = Long.parseLong(nextWrnStr);
        nextWrnProp = new NodeProperty("next-workingresource-name", (Object)String.valueOf(nextWrnLong + 1L), "http://jakarta.apache.org/slide/");
        wrpathNrd.setProperty(nextWrnProp);
        content.store(sToken, wrpath, wrpathNrd, null);
        return result;
    }

    public static UriHandler createVersionUri(UriHandler vhrUri, String version) {
        return new UriHandler(vhrUri, version);
    }

    public boolean equals(Object o) {
        if (!(o instanceof UriHandler)) {
            return false;
        }
        String[] oTokens = ((UriHandler)o).getUriTokens();
        if (oTokens.length != this.uriTokens.length) {
            return false;
        }
        int i = 0;
        while (i < this.uriTokens.length) {
            if (!oTokens[i].equals(this.uriTokens[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String extractStoreName(String prmStr, String srcStr) {
        String tail = null;
        int start = prmStr.indexOf("${store}");
        int endP = start + "${store}".length();
        int endS = -1;
        if (endP < prmStr.length()) {
            tail = prmStr.substring(endP);
            endS = srcStr.lastIndexOf(tail);
        } else {
            endS = srcStr.length();
        }
        return srcStr.substring(start, endS);
    }

    private String extractStoreName(UriHandler pUh) {
        String result = "";
        String[] pTokens = pUh.getUriTokens();
        int ptIndex = -1;
        int i = 0;
        while (i < pTokens.length) {
            if (pTokens[i].indexOf("${store}") >= 0) {
                ptIndex = i;
                break;
            }
            ++i;
        }
        if (ptIndex >= 0) {
            result = this.extractStoreName(pTokens[ptIndex], this.uriTokens[ptIndex]);
        }
        return result;
    }

    public String getAssociatedBaseStoreName(String namespaceName) {
        String result = "";
        if (this.isHistoryPathUri() || this.isHistoryUri() || this.isVersionUri()) {
            if (HistoryPathHandler.parameterized) {
                result = this.extractStoreName(HistoryPathHandler.historyPathHandler);
            } else {
                Domain.info((Object)("Cannot determine base store name for URI " + this));
            }
        } else if (this.isWorkspacePathUri() || this.isWorkspaceUri() || this.isResourceInWorkspaceUri()) {
            if (WorkspacePathHandler.parameterized) {
                result = this.extractStoreName(WorkspacePathHandler.workspacePathHandler);
            } else {
                Domain.info((Object)("Cannot determine base store name for URI " + this));
            }
        } else if (this.isWorkingresourcePathUri() || this.isWorkingresourceUri()) {
            if (WorkingresourcePathHandler.parameterized) {
                result = this.extractStoreName(WorkingresourcePathHandler.workingresourcePathHandler);
            } else {
                Domain.info((Object)("Cannot determine base store name for URI " + this));
            }
        } else {
            UriHandler scopeUh = UriHandler.bestMatchingScope(namespaceName, this);
            Map storesInNamespace = (Map)registeredStores.get(namespaceName);
            result = (String)storesInNamespace.get(scopeUh);
        }
        return result;
    }

    public String getAssociatedHistoryUri() {
        if (!this.isVersionUri()) {
            throw new IllegalStateException("URI " + this.uri + " is not a version URI");
        }
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < this.uriTokens.length - 1) {
            b.append("/");
            b.append(this.uriTokens[i]);
            ++i;
        }
        return b.toString();
    }

    public String getAssociatedWorkspaceUri() {
        if (!this.isWorkspaceUri() && !this.isResourceInWorkspaceUri()) {
            return null;
        }
        WorkspacePathHandler wspathHandler = WorkspacePathHandler.getWorkspacePathHandler();
        String[] wspathTokens = wspathHandler.getUriTokens();
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < wspathTokens.length + 1) {
            b.append("/");
            b.append(this.uriTokens[i]);
            ++i;
        }
        return b.toString();
    }

    public String getHistoryName() {
        HistoryPathHandler hpathHandler = HistoryPathHandler.getHistoryPathHandler();
        String[] hpathTokens = hpathHandler.getUriTokens();
        if (!this.isHistoryUri() && !this.isVersionUri()) {
            throw new IllegalStateException("URI " + this.uri + " is neither history nor version URI");
        }
        return this.uriTokens[hpathTokens.length];
    }

    public String getName() {
        if (this.uriTokens.length == 0) {
            return null;
        }
        return this.uriTokens[this.uriTokens.length - 1];
    }

    public UriHandler getParentUriHandler() {
        if (this.uriTokens.length == 0) {
            return null;
        }
        return new UriHandler(this.uriTokens, this.uriTokens.length - 1);
    }

    public String getUri() {
        if (this.uri == null) {
            this.uri = this.toString();
        }
        return this.uri;
    }

    public static UriHandler getUriHandler(String resourcePath) {
        return new UriHandler(resourcePath);
    }

    public static UriHandler getUriHandler(NodeRevisionDescriptors nrds, NodeRevisionDescriptor nrd) {
        StringBuffer b = new StringBuffer();
        String uri = nrds.getUri();
        UriHandler uriHandler = UriHandler.getUriHandler(uri);
        if (!uriHandler.isHistoryUri()) {
            b.append(uri);
        } else if (NodeRevisionNumber.HIDDEN_0_0.equals((Object)nrd.getRevisionNumber())) {
            b.append(uri);
        } else {
            b.append(uri);
            if (!uri.endsWith("/")) {
                b.append("/");
            }
            b.append(nrd.getRevisionNumber().toString());
        }
        return new UriHandler(b.toString());
    }

    public String[] getUriTokens() {
        return this.uriTokens;
    }

    public String getVersionName() {
        HistoryPathHandler hpathHandler = HistoryPathHandler.getHistoryPathHandler();
        String[] hpathTokens = hpathHandler.getUriTokens();
        if (!this.isVersionUri()) {
            throw new IllegalStateException("URI " + this.uri + " is not a version URI");
        }
        return this.uriTokens[hpathTokens.length + 1];
    }

    public String getWorkspaceName() {
        WorkspacePathHandler wspathHandler = WorkspacePathHandler.getWorkspacePathHandler();
        String[] wspathTokens = wspathHandler.getUriTokens();
        if (!this.isWorkspaceUri()) {
            throw new IllegalStateException("URI " + this.uri + " is not a workspace URI");
        }
        return this.uriTokens[wspathTokens.length];
    }

    public int hashCode() {
        return this.uriTokens.length;
    }

    public boolean isAncestorOf(UriHandler uh) {
        if (this.uriTokens.length > uh.length()) {
            return false;
        }
        int i = 0;
        while (i < this.uriTokens.length) {
            if (!this.uriTokens[i].equals(uh.getUriTokens()[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isHistoryPathUri() {
        HistoryPathHandler hpathHandler = HistoryPathHandler.getHistoryPathHandler();
        return hpathHandler.isHistoryPathUri(this);
    }

    public boolean isHistoryUri() {
        HistoryPathHandler hpathHandler = HistoryPathHandler.getHistoryPathHandler();
        String[] hpathTokens = hpathHandler.getUriTokens();
        if (hpathTokens.length + 1 == this.uriTokens.length && hpathHandler.isHistoryPathUri(this.getParentUriHandler())) {
            try {
                Integer.parseInt(this.uriTokens[this.uriTokens.length - 1]);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return false;
    }

    public boolean isResourceInWorkspaceUri() {
        UriHandler p;
        WorkspacePathHandler wspathHandler = WorkspacePathHandler.getWorkspacePathHandler();
        String[] wspathTokens = wspathHandler.getUriTokens();
        return wspathTokens.length + 1 < this.uriTokens.length && (p = new UriHandler(this.uriTokens, wspathTokens.length + 1)).isWorkspaceUri();
    }

    public boolean isRestrictedUri() {
        if (this.isRootUri()) {
            return true;
        }
        if (this.isVersionUri()) {
            return true;
        }
        if (this.isHistoryUri()) {
            return true;
        }
        if (this.isHistoryPathUri()) {
            return true;
        }
        if (this.isWorkspaceUri()) {
            return true;
        }
        if (this.isWorkspacePathUri()) {
            return true;
        }
        if (this.isWorkingresourceUri()) {
            return true;
        }
        if (this.isWorkingresourcePathUri()) {
            return true;
        }
        UriHandler p = this.getParentUriHandler();
        if (p != null) {
            if (p.isRootUri()) {
                return true;
            }
            if (p.isHistoryPathUri()) {
                return true;
            }
            if (p.isWorkingresourcePathUri()) {
                return true;
            }
        }
        return false;
    }

    public boolean isRootUri() {
        return this.uriTokens.length == 0;
    }

    public boolean isVersionUri() {
        HistoryPathHandler hpathHandler = HistoryPathHandler.getHistoryPathHandler();
        String[] hpathTokens = hpathHandler.getUriTokens();
        return hpathTokens.length + 2 == this.uriTokens.length && this.getParentUriHandler().isHistoryUri();
    }

    public boolean isWorkingresourcePathUri() {
        WorkingresourcePathHandler wrpathHandler = WorkingresourcePathHandler.getWorkingresourcePathHandler();
        return wrpathHandler.isWorkingresourcePathUri(this);
    }

    public boolean isWorkingresourceUri() {
        WorkingresourcePathHandler wrpathHandler = WorkingresourcePathHandler.getWorkingresourcePathHandler();
        String[] wrpathTokens = wrpathHandler.getUriTokens();
        if (wrpathTokens.length + 1 == this.uriTokens.length && wrpathHandler.isWorkingresourcePathUri(this.getParentUriHandler())) {
            try {
                Integer.parseInt(this.uriTokens[this.uriTokens.length - 1]);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return false;
    }

    public boolean isWorkspacePathUri() {
        WorkspacePathHandler wspathHandler = WorkspacePathHandler.getWorkspacePathHandler();
        return wspathHandler.isWorkspacePathUri(this);
    }

    public boolean isWorkspaceUri() {
        WorkspacePathHandler wspathHandler = WorkspacePathHandler.getWorkspacePathHandler();
        String[] wspathTokens = wspathHandler.getUriTokens();
        return wspathTokens.length + 1 == this.uriTokens.length && wspathHandler.isWorkspacePathUri(this.getParentUriHandler());
    }

    public int length() {
        return this.uriTokens.length;
    }

    public static void notifyStoreCreated(String namespaceName, String scope, String storeName) {
        HashMap<UriHandler, String> storesInNamespace = (HashMap<UriHandler, String>)registeredStores.get(namespaceName);
        if (storesInNamespace == null) {
            storesInNamespace = new HashMap<UriHandler, String>();
            registeredStores.put(namespaceName, storesInNamespace);
        }
        UriHandler scopeUh = new UriHandler(scope);
        storesInNamespace.put(scopeUh, storeName);
        allScopes.add(scopeUh);
        allStoreNames.add(storeName);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        if (this.uriTokens.length == 0) {
            b.append("/");
        } else {
            int i = 0;
            while (i < this.uriTokens.length) {
                b.append("/").append(this.uriTokens[i]);
                ++i;
            }
        }
        return b.toString();
    }
}

