/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.lock.UnlockListener;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.CheckedOutVersionControlled;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.jdom.JDOMException;

public class UnlockListenerImpl
implements UnlockListener {
    SlideToken slideToken;
    NamespaceAccessToken token;
    WebdavServletConfig config;
    HttpServletRequest req;
    HttpServletResponse resp;

    public UnlockListenerImpl(SlideToken slideToken, NamespaceAccessToken token, WebdavServletConfig config, HttpServletRequest req, HttpServletResponse resp) {
        this.slideToken = slideToken;
        this.token = token;
        this.config = config;
        this.req = req;
        this.resp = resp;
    }

    public void afterUnlock(String uri) throws SlideException {
        block5: {
            Content content = this.token.getContentHelper();
            NodeRevisionDescriptors revisionDescriptors = content.retrieve(this.slideToken, uri);
            NodeRevisionDescriptor revisionDescriptor = content.retrieve(this.slideToken, revisionDescriptors);
            ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.token, uri, revisionDescriptor);
            if (!Configuration.useVersionControl() || !(resourceKind instanceof CheckedOutVersionControlled)) break block5;
            NodeProperty checkinLocktokenProperty = revisionDescriptor.getProperty("checkin-locktoken", "http://jakarta.apache.org/slide/");
            if (checkinLocktokenProperty == null) {
                checkinLocktokenProperty = revisionDescriptor.getProperty("checkin-locktoken");
            }
            if (checkinLocktokenProperty != null && checkinLocktokenProperty.getValue() != null) {
                VersioningHelper versionHelper = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.config);
                try {
                    versionHelper.checkin(revisionDescriptors, revisionDescriptor, false, false, true);
                }
                catch (IOException iOException) {
                }
                catch (JDOMException jDOMException) {}
            }
        }
    }

    public void beforeUnlock(String uri) throws SlideException {
    }
}

