/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.RequestedResource;

public class ResourceWithProvidedProperties
implements RequestedResource {
    protected NodeRevisionDescriptors revisionDescriptors = null;
    protected NodeRevisionDescriptor revisionDescriptor = null;
    protected PropertyProvider propertyProvider = null;

    public ResourceWithProvidedProperties(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, PropertyProvider propertyProvider) {
        this.revisionDescriptors = revisionDescriptors;
        this.revisionDescriptor = revisionDescriptor;
        this.propertyProvider = propertyProvider;
    }

    public Iterator getAllProperties() throws SlideException {
        HashSet propertyList = new HashSet();
        Enumeration enumeration = this.revisionDescriptor.enumerateProperties();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                propertyList.add(enumeration.nextElement());
            }
        }
        if (this.propertyProvider != null) {
            Iterator iterator = this.propertyProvider.getSupportedProperties(this.getUri());
            while (iterator.hasNext()) {
                propertyList.add(iterator.next());
            }
        }
        return propertyList.iterator();
    }

    public Iterator getAllPropertiesNames() throws SlideException {
        HashSet<Object> propertyNamesList = new HashSet<Object>();
        Enumeration enumeration = this.revisionDescriptor.enumerateProperties();
        NodeProperty property = null;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                property = (NodeProperty)enumeration.nextElement();
                propertyNamesList.add(new PropertyName(property.getName(), property.getNamespace()));
            }
        }
        if (this.propertyProvider != null) {
            Iterator iterator = this.propertyProvider.getSupportedPropertiesNames(this.getUri());
            while (iterator.hasNext()) {
                propertyNamesList.add(iterator.next());
            }
        }
        return propertyNamesList.iterator();
    }

    public NodeProperty getProperty(String name, String namespace) throws SlideException {
        if (this.propertyProvider != null && this.propertyProvider.isSupportedProperty(this.getUri(), name, namespace)) {
            return this.propertyProvider.getProperty(this.getUri(), name, namespace);
        }
        return this.revisionDescriptor.getProperty(name, namespace);
    }

    public NodeProperty getProperty(PropertyName propertyName) throws SlideException {
        return this.getProperty(propertyName.getName(), propertyName.getNamespace());
    }

    public String getUri() {
        return this.revisionDescriptors.getOriginalUri();
    }
}

