/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class PropertySearchSetProperty {
    private static HashMap propertyMap = null;
    private String property = null;
    private String description = null;
    private String namespace = null;

    private PropertySearchSetProperty(String prop, String namesp, String desc) {
        this.property = prop;
        this.description = desc;
        this.namespace = namesp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPropertyName() {
        return this.property;
    }

    public static Iterator getPropertySetIterator() {
        if (propertyMap == null) {
            PropertySearchSetProperty.loadProperties();
        }
        Collection values = propertyMap.values();
        return values.iterator();
    }

    public static boolean inSearchPropertySet(String property, String namespace) {
        if (propertyMap == null) {
            PropertySearchSetProperty.loadProperties();
        }
        String space = namespace == null ? "DAV:" : namespace;
        return propertyMap.containsKey(String.valueOf(property) + space);
    }

    private static void loadProperties() {
        String propSet = "displayname,DAV:,Full name/";
        int index = 0;
        int doubleIndex = 0;
        int trippleIndex = 0;
        String currentProp = null;
        String currentTripple = null;
        String currentDesc = null;
        String namespace = null;
        propertyMap = new HashMap();
        int len = "displayname,DAV:,Full name/".length();
        while (index != -1 && index != len - 1) {
            index = propSet.indexOf("/");
            if (index == -1) {
                currentTripple = propSet;
            } else {
                currentTripple = propSet.substring(0, index);
                propSet = propSet.substring(index + 1);
            }
            if (len <= 0 || propSet.equals("/")) continue;
            trippleIndex = currentTripple.indexOf(",");
            if (trippleIndex == -1) {
                currentProp = currentTripple;
                namespace = "DAV:";
                currentDesc = "";
            } else {
                String currentDouble = currentTripple.substring(trippleIndex + 1);
                currentProp = currentTripple.substring(0, trippleIndex);
                doubleIndex = currentDouble.indexOf(",");
                if (doubleIndex == -1) {
                    namespace = currentDouble;
                    currentDesc = "";
                } else {
                    namespace = currentDouble.substring(0, doubleIndex);
                    currentDesc = currentDouble.substring(doubleIndex + 1);
                }
            }
            String key = new String(String.valueOf(currentProp) + namespace);
            propertyMap.put(key, new PropertySearchSetProperty(currentProp, namespace, currentDesc));
            len = propSet.length();
        }
    }
}

