/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.RequestedProperty;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.lock.Lock;
import org.apache.slide.search.RequestedResource;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.security.Security;
import org.apache.slide.structure.Structure;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.util.AbstractWebdavHelper;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.ComputedPropertyProvider;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PropertyHelper;
import org.apache.slide.webdav.util.PropertyRetriever;
import org.apache.slide.webdav.util.ResourceWithProvidedProperties;
import org.apache.slide.webdav.util.WebdavConstants;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.slide.webdav.util.XMLValue;
import org.apache.util.WebdavStatus;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class PropertyRetrieverImpl
extends AbstractWebdavHelper
implements PropertyRetriever,
WebdavConstants,
DeltavConstants,
AclConstants {
    protected Content content = null;
    protected Lock lock = null;
    protected Security security = null;
    protected Structure structure = null;
    protected PropertyHelper propertyHelper = null;

    public PropertyRetrieverImpl(NamespaceAccessToken token, SlideToken slideToken) {
        super(slideToken, token);
        this.structure = token.getStructureHelper();
        this.content = token.getContentHelper();
        this.security = token.getSecurityHelper();
        this.lock = token.getLockHelper();
        this.propertyHelper = PropertyHelper.getPropertyHelper(slideToken, token, null);
    }

    public PropertyRetrieverImpl(NamespaceAccessToken token, SlideToken slideToken, WebdavServletConfig sConf) {
        super(slideToken, token);
        this.structure = token.getStructureHelper();
        this.content = token.getContentHelper();
        this.security = token.getSecurityHelper();
        this.lock = token.getLockHelper();
        this.propertyHelper = PropertyHelper.getPropertyHelper(slideToken, token, sConf);
    }

    protected static void convertHrefValueToAbsoluteURL(XMLValue xmlValue, String contextPath, String serverURL) {
        if (xmlValue != null) {
            Iterator iterator = xmlValue.iterator();
            Element element = null;
            while (iterator.hasNext()) {
                element = (Element)iterator.next();
                if (!"href".equals(element.getName()) || element.getText() == null || PropertyHelper.isAbsoluteURL(serverURL, contextPath, element.getText())) continue;
                element.setText(PropertyHelper.getAbsoluteURL(serverURL, contextPath, element.getText()));
            }
        }
    }

    protected List getAllPropertiesOfObject(RequestedResource requestedResource, String contextPath, String serverURL, boolean allpropSupportsDeltaV) throws SlideException {
        ArrayList<Element> elementList = new ArrayList<Element>();
        Element propstat = new Element("propstat", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        elementList.add(propstat);
        Element prop = new Element("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        propstat.addContent(prop);
        Element propertyElement = null;
        HashMap<Integer, ArrayList<PropertyName>> erroneousPropertiesMap = new HashMap<Integer, ArrayList<PropertyName>>();
        String status = new String("HTTP/1.1 200 " + WebdavStatus.getStatusText((int)200));
        Iterator propertyNameIterator = requestedResource.getAllPropertiesNames();
        while (propertyNameIterator.hasNext()) {
            PropertyName currentPropertyName = (PropertyName)propertyNameIterator.next();
            if (currentPropertyName == null || !allpropSupportsDeltaV && DeltavConstants.DELTAV_PROPERTY_LIST.contains(currentPropertyName.getName()) || !Configuration.useIntegratedSecurity() && AclConstants.ACL_PROPERTY_LIST.contains(currentPropertyName.getName())) continue;
            NodeProperty currentProperty = null;
            Integer errorCode = null;
            try {
                currentProperty = requestedResource.getProperty(currentPropertyName);
                if (currentProperty == null) {
                    errorCode = new Integer(404);
                }
            }
            catch (AccessDeniedException accessDeniedException) {
                errorCode = new Integer(403);
            }
            if (errorCode != null) {
                ArrayList<PropertyName> erroneousPropertiesList = (ArrayList<PropertyName>)erroneousPropertiesMap.get(errorCode);
                if (erroneousPropertiesList == null) {
                    erroneousPropertiesList = new ArrayList<PropertyName>();
                    erroneousPropertiesMap.put(errorCode, erroneousPropertiesList);
                }
                erroneousPropertiesList.add(currentPropertyName);
                continue;
            }
            propertyElement = this.getPropertyElement(currentProperty, contextPath, serverURL);
            if (propertyElement == null) continue;
            prop.addContent(propertyElement);
        }
        Element statusElement = new Element("status", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        statusElement.setText(status);
        propstat.addContent(statusElement);
        elementList.addAll(this.getPropstatForErroneousProperties(erroneousPropertiesMap, contextPath, serverURL));
        return elementList;
    }

    public List getPropertiesOfObject(RequestedProperties requestedProperties, String uri, String contextPath, String serverURL, boolean allpropSupportsDeltaV) throws SlideException, JDOMException {
        NodeRevisionDescriptor revisionDescriptor;
        NodeRevisionDescriptors revisionDescriptors;
        block5: {
            revisionDescriptors = null;
            revisionDescriptor = null;
            boolean isCollection = false;
            try {
                revisionDescriptors = this.content.retrieve(this.sToken, uri);
                try {
                    revisionDescriptor = this.content.retrieve(this.sToken, revisionDescriptors);
                    isCollection = WebdavUtils.isCollection(revisionDescriptor);
                }
                catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {
                    isCollection = true;
                    revisionDescriptor = new NodeRevisionDescriptor(0L);
                    String resourceName = uri;
                    int lastSlash = resourceName.lastIndexOf(47);
                    if (lastSlash != -1) {
                        resourceName = resourceName.substring(lastSlash + 1);
                    }
                    revisionDescriptor.setName(resourceName);
                }
            }
            catch (AccessDeniedException accessDeniedException) {
                if (revisionDescriptor != null) break block5;
                revisionDescriptor = new NodeRevisionDescriptor(0L);
            }
        }
        return this.getPropertiesOfObject(requestedProperties, revisionDescriptors, revisionDescriptor, contextPath, serverURL, allpropSupportsDeltaV);
    }

    public List getPropertiesOfObject(RequestedProperties requestedProperties, String uri, NodeRevisionNumber revisionNumber, String contextPath, String serverURL, boolean allpropSupportsDeltaV) throws SlideException, JDOMException {
        NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.sToken, uri);
        NodeRevisionDescriptor revisionDescriptor = this.content.retrieve(this.sToken, revisionDescriptors, revisionNumber);
        return this.getPropertiesOfObject(requestedProperties, revisionDescriptors, revisionDescriptor, contextPath, serverURL, allpropSupportsDeltaV);
    }

    public List getPropertiesOfObject(RequestedProperties requestedProperties, NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL, boolean allpropSupportsDeltaV) throws SlideException, JDOMException {
        ComputedPropertyProvider propertyProvider = new ComputedPropertyProvider(this.nsaToken, this.sToken, this.propertyHelper, contextPath, serverURL);
        return this.getPropertiesOfObject(requestedProperties, new ResourceWithProvidedProperties(revisionDescriptors, revisionDescriptor, propertyProvider), contextPath, serverURL, allpropSupportsDeltaV);
    }

    public List getPropertiesOfObject(RequestedProperties requestedProperties, RequestedResource requestedResource, String contextPath, String serverURL, boolean allpropSupportsDeltaV) throws SlideException, JDOMException {
        List elementList = new ArrayList();
        String status = new String("HTTP/1.1 200 " + WebdavStatus.getStatusText((int)200));
        elementList = requestedProperties.isAllProp() ? this.getAllPropertiesOfObject(requestedResource, contextPath, serverURL, allpropSupportsDeltaV) : this.getRequestedPropertiesOfObject(requestedProperties, requestedResource, contextPath, serverURL);
        return elementList;
    }

    private Element getPropertyElement(String namespaceString, String propertyName, Object propertyValue, String contextPath, String serverURL) {
        Element property = null;
        Namespace namespace = Namespace.NO_NAMESPACE;
        Namespace valueDefaultNamespace = null;
        if (namespaceString != null && "DAV:".equals((namespace = NodeProperty.NamespaceCache.getNamespace((String)namespaceString)).getURI())) {
            valueDefaultNamespace = namespace;
        }
        property = new Element(propertyName, namespace);
        if (propertyValue != null && propertyValue.toString().length() > 0) {
            if (propertyValue.toString().startsWith("<")) {
                try {
                    XMLValue xmlValue = new XMLValue(propertyValue.toString(), valueDefaultNamespace);
                    PropertyRetrieverImpl.convertHrefValueToAbsoluteURL(xmlValue, contextPath, serverURL);
                    Iterator iterator = xmlValue.iterator();
                    while (iterator.hasNext()) {
                        property.addContent((Element)iterator.next());
                    }
                }
                catch (JDOMException jDOMException) {
                    property.setText(propertyValue.toString());
                }
            } else {
                property.setText(propertyValue.toString());
            }
        }
        return property;
    }

    private Element getPropertyElement(NodeProperty property, String contextPath, String serverURL) {
        if (property != null) {
            return this.getPropertyElement(property.getNamespace(), property.getName(), property.getValue(), contextPath, serverURL);
        }
        return null;
    }

    protected PropertyHelper getPropertyHelper() {
        return this.propertyHelper;
    }

    protected List getPropstatForErroneousProperties(Map erroneousPropertiesMap, String contextPath, String serverURL) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        Iterator iterator = erroneousPropertiesMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer errorCode = (Integer)iterator.next();
            List erroneousPropertiesList = (List)erroneousPropertiesMap.get(errorCode);
            Element propstat = new Element("propstat", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            elementList.add(propstat);
            Element prop = new Element("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            propstat.addContent(prop);
            String status = new String("HTTP/1.1 " + errorCode + " " + WebdavStatus.getStatusText((int)errorCode));
            Iterator propertyIterator = erroneousPropertiesList.iterator();
            while (propertyIterator.hasNext()) {
                PropertyName erroneousProperty = (PropertyName)propertyIterator.next();
                Element propertyElement = this.getPropertyElement(erroneousProperty.getNamespace(), erroneousProperty.getName(), null, contextPath, serverURL);
                if (propertyElement == null) continue;
                prop.addContent(propertyElement);
            }
            Element statusElement = new Element("status", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            statusElement.setText(status);
            propstat.addContent(statusElement);
        }
        return elementList;
    }

    protected List getRequestedPropertiesOfObject(RequestedProperties requestedProperties, RequestedResource requestedResource, String contextPath, String serverURL) throws SlideException {
        ArrayList<Element> elementList = new ArrayList<Element>();
        Iterator propertyIterator = requestedProperties.getRequestedProperties();
        Element propstat = new Element("propstat", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        Element prop = new Element("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        propstat.addContent(prop);
        Element propertyElement = null;
        boolean anyPropertyFound = false;
        HashMap<Integer, ArrayList<PropertyName>> erroneousPropertiesMap = new HashMap<Integer, ArrayList<PropertyName>>();
        String status = new String("HTTP/1.1 200 " + WebdavStatus.getStatusText((int)200));
        while (propertyIterator.hasNext()) {
            RequestedProperty property = (RequestedProperty)propertyIterator.next();
            NodeProperty currentProperty = null;
            Integer errorCode = null;
            try {
                currentProperty = requestedResource.getProperty(property.getName(), property.getNamespace());
                if (currentProperty == null) {
                    errorCode = new Integer(404);
                }
            }
            catch (AccessDeniedException accessDeniedException) {
                errorCode = new Integer(403);
            }
            if (errorCode != null) {
                ArrayList<PropertyName> erroneousPropertiesList = (ArrayList<PropertyName>)erroneousPropertiesMap.get(errorCode);
                if (erroneousPropertiesList == null) {
                    erroneousPropertiesList = new ArrayList<PropertyName>();
                    erroneousPropertiesMap.put(errorCode, erroneousPropertiesList);
                }
                erroneousPropertiesList.add(new PropertyName(property.getName(), property.getNamespace()));
                continue;
            }
            propertyElement = this.getPropertyElement(currentProperty, contextPath, serverURL);
            if (propertyElement == null) continue;
            anyPropertyFound = true;
            prop.addContent(propertyElement);
        }
        if (anyPropertyFound) {
            Element statusElement = new Element("status", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            statusElement.setText(status);
            propstat.addContent(statusElement);
            elementList.add(propstat);
        }
        elementList.addAll(this.getPropstatForErroneousProperties(erroneousPropertiesMap, contextPath, serverURL));
        return elementList;
    }
}

