/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.common.Domain;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.SlideTokenWrapper;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.lock.Lock;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.search.RequestedResource;
import org.apache.slide.search.Search;
import org.apache.slide.search.SearchQuery;
import org.apache.slide.search.SearchQueryResult;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.security.NodePermission;
import org.apache.slide.security.Security;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.Structure;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.util.AbstractWebdavHelper;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.DaslConstants;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.HistoryPathHandler;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.WebdavConstants;
import org.apache.slide.webdav.util.XMLValue;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.Activity;
import org.apache.slide.webdav.util.resourcekind.CheckedInVersionControlled;
import org.apache.slide.webdav.util.resourcekind.CheckedOutVersionControlled;
import org.apache.slide.webdav.util.resourcekind.DeltavCompliantCollection;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.apache.slide.webdav.util.resourcekind.Version;
import org.apache.slide.webdav.util.resourcekind.VersionHistory;
import org.apache.slide.webdav.util.resourcekind.Workspace;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class PropertyHelper
extends AbstractWebdavHelper
implements WebdavConstants,
DeltavConstants,
AclConstants,
DaslConstants {
    public static final String DEFAULT_AUTO_VERSION = Domain.getParameter((String)"auto-version", (String)"checkout-checkin");
    public static final String DEFAULT_CHECKOUT_FORK = Domain.getParameter((String)"checkout-fork", (String)"forbidden");
    public static final String DEFAULT_CHECKIN_FORK = Domain.getParameter((String)"checkin-fork", (String)"forbidden");
    public static final String LOCKDISCOVERY_INCL_PRINCIPAL = "lockdiscoveryIncludesPrincipalURL";
    private boolean lockdiscoveryIncludesPrincipalURL = true;
    protected Element checkoutSetQueryElement = null;
    protected Element checkoutSetQueryLiteralElement = null;
    protected Element workspaceCheckoutSetQueryElement = null;
    protected Element workspaceCheckoutSetQueryHrefElement = null;
    private WebdavServletConfig sConf = null;

    protected PropertyHelper(SlideToken sToken, NamespaceAccessToken nsaToken, WebdavServletConfig sConf) {
        super(sToken, nsaToken);
        this.sConf = sConf;
        if (sConf != null) {
            this.lockdiscoveryIncludesPrincipalURL = "false".equalsIgnoreCase(sConf.getInitParameter(LOCKDISCOVERY_INCL_PRINCIPAL)) ^ true;
        }
    }

    public static void addElementToProperty(NodeRevisionDescriptor revisionDescriptor, String propertyName, String elementName, String elementValue) throws JDOMException {
        NodeProperty property = revisionDescriptor.getProperty(propertyName);
        if (property == null) {
            property = new NodeProperty(propertyName, null);
        }
        XMLValue xmlValue = new XMLValue((String)property.getValue());
        Iterator iterator = xmlValue.iterator();
        boolean alreadyContained = false;
        Element element = null;
        while (iterator.hasNext() && !alreadyContained) {
            element = (Element)iterator.next();
            if (!element.getName().equals(elementName) || !element.getText().equals(elementValue)) continue;
            alreadyContained = true;
        }
        if (!alreadyContained) {
            element = new Element(elementName);
            element.setText(elementValue);
            xmlValue.add(element);
        }
        revisionDescriptor.setProperty(propertyName, (Object)xmlValue.toString());
    }

    public static void addHrefToProperty(NodeRevisionDescriptor revisionDescriptor, String propertyName, String uri) throws JDOMException {
        PropertyHelper.addElementToProperty(revisionDescriptor, propertyName, "href", uri);
    }

    public XMLValue computeAcl(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        XMLValue xmlValue = new XMLValue();
        NamespaceConfig config = this.nsaToken.getNamespaceConfig();
        Structure structure = this.nsaToken.getStructureHelper();
        ObjectNode object = structure.retrieve(this.sToken, revisionDescriptors.getUri());
        Security security = this.nsaToken.getSecurityHelper();
        security.checkCredentials(this.sToken, object, config.getReadPermissionsAction());
        String readObjectUri = config.getReadObjectAction().getUri();
        String readRevisionMetadataUri = config.getReadRevisionMetadataAction().getUri();
        String readRevisionContentUri = config.getReadRevisionContentAction().getUri();
        String createObjectUri = config.getCreateObjectAction().getUri();
        String removeObjectUri = config.getRemoveObjectAction().getUri();
        String lockObjectUri = config.getLockObjectAction().getUri();
        String readLocksUri = config.getReadLocksAction().getUri();
        String createRevisionMetadataUri = config.getCreateRevisionMetadataAction().getUri();
        String modifyRevisionMetadataUri = config.getModifyRevisionMetadataAction().getUri();
        String removeRevisionMetadataUri = config.getRemoveRevisionMetadataAction().getUri();
        String createRevisionContentUri = config.getCreateRevisionContentAction().getUri();
        String modifyRevisionContentUri = config.getModifyRevisionContentAction().getUri();
        String removeRevisionContentUri = config.getRemoveRevisionContentAction().getUri();
        String readPermissionsUri = config.getReadPermissionsAction().getUri();
        String grantPermissionUri = config.getGrantPermissionAction().getUri();
        String revokePermissionUri = config.getRevokePermissionAction().getUri();
        ObjectNode current = object;
        boolean inheritedPermissions = false;
        Vector<NodePermission> permissions = new Vector<NodePermission>();
        while (current != null) {
            try {
                NodePermission permission;
                permissions.clear();
                Enumeration aclList = security.enumeratePermissions(this.sToken, current);
                while (aclList.hasMoreElements()) {
                    permission = (NodePermission)aclList.nextElement();
                    if (inheritedPermissions && !permission.isInheritable()) continue;
                    permissions.add(permission);
                }
                while (permissions.size() > 0) {
                    permission = (NodePermission)permissions.get(0);
                    permissions.remove(0);
                    String principal = permission.getSubjectUri();
                    boolean negative = permission.isNegative();
                    String action = permission.getActionUri();
                    boolean isReadObject = readObjectUri.startsWith(action);
                    boolean isReadLocks = readLocksUri.startsWith(action);
                    boolean isReadRevisionMetadata = readRevisionMetadataUri.startsWith(action);
                    boolean isReadRevisionContent = readRevisionContentUri.startsWith(action);
                    boolean isCreateObject = createObjectUri.startsWith(action);
                    boolean isRemoveObject = removeObjectUri.startsWith(action);
                    boolean isLockObject = lockObjectUri.startsWith(action);
                    boolean isCreateRevisionMetadata = createRevisionMetadataUri.startsWith(action);
                    boolean isModifyRevisionMetadata = modifyRevisionMetadataUri.startsWith(action);
                    boolean isRemoveRevisionMetadata = removeRevisionMetadataUri.startsWith(action);
                    boolean isCreateRevisionContent = createRevisionContentUri.startsWith(action);
                    boolean isModifyRevisionContent = modifyRevisionContentUri.startsWith(action);
                    boolean isRemoveRevisionContent = removeRevisionContentUri.startsWith(action);
                    boolean isReadPermissions = readPermissionsUri.startsWith(action);
                    boolean isGrantPermission = grantPermissionUri.startsWith(action);
                    boolean isRevokePermission = revokePermissionUri.startsWith(action);
                    int i = 0;
                    while (i < permissions.size()) {
                        NodePermission otherPermission = (NodePermission)permissions.get(i);
                        if (principal.equals(otherPermission.getSubjectUri()) && negative == otherPermission.isNegative()) {
                            permissions.remove(i);
                            --i;
                            action = otherPermission.getActionUri();
                            isReadObject |= readObjectUri.startsWith(action);
                            isReadLocks |= readLocksUri.startsWith(action);
                            isReadRevisionMetadata |= readRevisionMetadataUri.startsWith(action);
                            isReadRevisionContent |= readRevisionContentUri.startsWith(action);
                            isCreateObject |= createObjectUri.startsWith(action);
                            isRemoveObject |= removeObjectUri.startsWith(action);
                            isLockObject |= lockObjectUri.startsWith(action);
                            isCreateRevisionMetadata |= createRevisionMetadataUri.startsWith(action);
                            isModifyRevisionMetadata |= modifyRevisionMetadataUri.startsWith(action);
                            isRemoveRevisionMetadata |= removeRevisionMetadataUri.startsWith(action);
                            isCreateRevisionContent |= createRevisionContentUri.startsWith(action);
                            isModifyRevisionContent |= modifyRevisionContentUri.startsWith(action);
                            isRemoveRevisionContent |= removeRevisionContentUri.startsWith(action);
                            isReadPermissions |= readPermissionsUri.startsWith(action);
                            isGrantPermission |= grantPermissionUri.startsWith(action);
                            isRevokePermission |= revokePermissionUri.startsWith(action);
                        }
                        ++i;
                    }
                    boolean isRead = isReadObject && isReadLocks && isReadRevisionMetadata && isReadRevisionContent;
                    boolean isWrite = isCreateObject && isRemoveObject && isLockObject && isCreateRevisionMetadata && isModifyRevisionMetadata && isRemoveRevisionMetadata && isCreateRevisionContent && isModifyRevisionContent && isRemoveRevisionContent;
                    boolean isReadAcl = isReadPermissions;
                    boolean isWriteAcl = isGrantPermission && isRevokePermission;
                    boolean isAll = isRead && isWrite && isReadAcl && isWriteAcl;
                    Element ace = new Element("ace", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                    xmlValue.add(ace);
                    ace.addContent(this.createPrincipal(principal, contextPath));
                    Element permissionElement = null;
                    permissionElement = permission.isNegative() ? new Element("deny", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE) : new Element("grant", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                    ace.addContent(permissionElement);
                    if (isAll) {
                        permissionElement.addContent(this.createPrivilege("all", true));
                    } else {
                        if (isRead) {
                            permissionElement.addContent(this.createPrivilege("read", true));
                        } else {
                            if (isReadObject) {
                                permissionElement.addContent(this.createPrivilege("read-object", false));
                            }
                            if (isReadLocks) {
                                permissionElement.addContent(this.createPrivilege("read-locks", false));
                            }
                            if (isReadRevisionMetadata) {
                                permissionElement.addContent(this.createPrivilege("read-revision-metadata", false));
                            }
                            if (isReadRevisionContent) {
                                permissionElement.addContent(this.createPrivilege("read-revision-content", false));
                            }
                        }
                        if (isWrite) {
                            permissionElement.addContent(this.createPrivilege("write", true));
                        } else {
                            if (isCreateObject) {
                                permissionElement.addContent(this.createPrivilege("create-object", false));
                            }
                            if (isRemoveObject) {
                                permissionElement.addContent(this.createPrivilege("remove-object", false));
                            }
                            if (isLockObject) {
                                permissionElement.addContent(this.createPrivilege("lock-object", false));
                            }
                            if (isCreateRevisionMetadata) {
                                permissionElement.addContent(this.createPrivilege("create-revision-metadata", false));
                            }
                            if (isModifyRevisionMetadata) {
                                permissionElement.addContent(this.createPrivilege("modify-revision-metadata", false));
                            }
                            if (isRemoveRevisionMetadata) {
                                permissionElement.addContent(this.createPrivilege("remove-revision-metadata", false));
                            }
                            if (isCreateRevisionContent) {
                                permissionElement.addContent(this.createPrivilege("create-revision-content", false));
                            }
                            if (isModifyRevisionContent) {
                                permissionElement.addContent(this.createPrivilege("modify-revision-content", false));
                            }
                            if (isRemoveRevisionContent) {
                                permissionElement.addContent(this.createPrivilege("remove-revision-content", false));
                            }
                        }
                        if (isReadAcl) {
                            permissionElement.addContent(this.createPrivilege("read-acl", true));
                        }
                        if (isWriteAcl) {
                            permissionElement.addContent(this.createPrivilege("write-acl", true));
                        } else {
                            if (isGrantPermission) {
                                permissionElement.addContent(this.createPrivilege("grant-premission", false));
                            }
                            if (isRevokePermission) {
                                permissionElement.addContent(this.createPrivilege("revoke-premission", false));
                            }
                        }
                    }
                    if (!inheritedPermissions) continue;
                    ace.addContent(new Element("protected", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE));
                    Element inherited = new Element("inherited", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                    ace.addContent(inherited);
                    Element href = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                    inherited.addContent(href);
                    href.setText(PropertyHelper.getAbsoluteURL(null, contextPath, current.getUri()));
                }
            }
            catch (SlideException slideException) {}
            inheritedPermissions = true;
            try {
                current = structure.getParent(this.sToken, current);
            }
            catch (SlideException slideException) {
                break;
            }
        }
        return xmlValue;
    }

    public XMLValue computeAclSemantics(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        XMLValue xmlValue = new XMLValue();
        Element aceCombination = new Element("ace-combination", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        xmlValue.add(aceCombination);
        Element allGrantBeforeDeny = new Element("all-grant-before-any-deny", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        aceCombination.addContent(allGrantBeforeDeny);
        Element requiredPrincipal = new Element("required-principal", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        xmlValue.add(requiredPrincipal);
        Element all = new Element("all", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        requiredPrincipal.addContent(all);
        return xmlValue;
    }

    public XMLValue computeCheckoutSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor) throws SlideException, JDOMException {
        return this.computeCheckoutSet(revisionDescriptors, revisionDescriptor, null, null);
    }

    public XMLValue computeCheckoutSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws SlideException, JDOMException {
        XMLValue xmlValue = new XMLValue();
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, revisionDescriptors, revisionDescriptor);
        if (resourceKind instanceof Version) {
            String resourcePath = VersioningHelper.getUri(this.nsaToken, (SlideToken)new SlideTokenWrapper(this.sToken, false), this.nsaToken.getContentHelper(), revisionDescriptors, revisionDescriptor);
            Element basicSearch = this.getCheckoutSetQueryElement(resourcePath);
            String grammarNamespace = basicSearch.getNamespaceURI();
            Search searchHelper = this.nsaToken.getSearchHelper();
            SearchQuery searchQuery = searchHelper.createSearchQuery(grammarNamespace, basicSearch, (SlideToken)new SlideTokenWrapper(this.sToken, false), Integer.MAX_VALUE, contextPath);
            SearchQueryResult queryResult = searchHelper.search((SlideToken)new SlideTokenWrapper(this.sToken, false), searchQuery);
            Iterator queryResultIterator = queryResult.iterator();
            RequestedResource requestedResource = null;
            Element href = null;
            while (queryResultIterator.hasNext()) {
                requestedResource = (RequestedResource)queryResultIterator.next();
                href = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                href.setText(PropertyHelper.getAbsoluteURL(serverURL, contextPath, requestedResource.getUri()));
                xmlValue.add(href);
            }
        }
        return xmlValue;
    }

    public XMLValue computeCurrentuserPrivilegeSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        XMLValue xmlValue = new XMLValue();
        NamespaceConfig config = this.nsaToken.getNamespaceConfig();
        Security security = this.nsaToken.getSecurityHelper();
        Structure structure = this.nsaToken.getStructureHelper();
        SubjectNode principalNode = null;
        ObjectNode object = structure.retrieve(this.sToken, revisionDescriptors.getUri());
        try {
            principalNode = (SubjectNode)security.getPrincipal(this.sToken);
        }
        catch (SlideException slideException) {
            return xmlValue;
        }
        catch (ClassCastException classCastException) {
            return xmlValue;
        }
        try {
            boolean canAll;
            boolean readObject = security.hasPermission(object, principalNode, config.getReadObjectAction());
            boolean createObject = security.hasPermission(object, principalNode, config.getCreateObjectAction());
            boolean removeObject = security.hasPermission(object, principalNode, config.getRemoveObjectAction());
            boolean grantPermission = security.hasPermission(object, principalNode, config.getGrantPermissionAction());
            boolean revokePermission = security.hasPermission(object, principalNode, config.getRevokePermissionAction());
            boolean readPermissions = security.hasPermission(object, principalNode, config.getReadPermissionsAction());
            boolean lockObject = security.hasPermission(object, principalNode, config.getLockObjectAction());
            boolean killLock = security.hasPermission(object, principalNode, config.getKillLockAction());
            boolean readLocks = security.hasPermission(object, principalNode, config.getReadLocksAction());
            boolean readRevisionMetadata = security.hasPermission(object, principalNode, config.getReadRevisionMetadataAction());
            boolean createRevisionMetadata = security.hasPermission(object, principalNode, config.getCreateRevisionMetadataAction());
            boolean modifyRevisionMetadata = security.hasPermission(object, principalNode, config.getModifyRevisionMetadataAction());
            boolean removeRevisionMetadata = security.hasPermission(object, principalNode, config.getRemoveRevisionMetadataAction());
            boolean readRevisionContent = security.hasPermission(object, principalNode, config.getReadRevisionContentAction());
            boolean createRevisionContent = security.hasPermission(object, principalNode, config.getCreateRevisionContentAction());
            boolean modifyRevisionContent = security.hasPermission(object, principalNode, config.getModifyRevisionContentAction());
            boolean removeRevisionContent = security.hasPermission(object, principalNode, config.getRemoveRevisionContentAction());
            boolean canRead = readObject && readRevisionMetadata && readRevisionContent;
            boolean canWrite = createObject && removeObject && lockObject && readLocks && createRevisionMetadata && modifyRevisionMetadata && removeRevisionMetadata && createRevisionContent && modifyRevisionContent && removeRevisionContent;
            boolean canReadAcl = readPermissions;
            boolean canWriteAcl = grantPermission && revokePermission;
            boolean bl = canAll = canRead && canWrite && canReadAcl && canWriteAcl && killLock;
            if (canRead) {
                xmlValue.add(this.createPrivilege("read"));
            }
            if (canWrite) {
                xmlValue.add(this.createPrivilege("write"));
            }
            if (canReadAcl) {
                xmlValue.add(this.createPrivilege("read-acl"));
            }
            if (canWriteAcl) {
                xmlValue.add(this.createPrivilege("write-acl"));
            }
            if (canAll) {
                xmlValue.add(this.createPrivilege("all"));
            }
        }
        catch (SlideException slideException) {
            return xmlValue;
        }
        return xmlValue;
    }

    public XMLValue computeLockDiscovery(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws ServiceAccessException, LinkedObjectNotFoundException, ObjectNotFoundException, LockTokenNotFoundException {
        XMLValue xmlValue = new XMLValue();
        Lock lock = this.nsaToken.getLockHelper();
        NodeLock objectLockToken = null;
        Enumeration lockTokens = lock.enumerateLocks((SlideToken)new SlideTokenWrapper(this.sToken, false), revisionDescriptors.getUri(), true);
        while (lockTokens.hasMoreElements()) {
            objectLockToken = (NodeLock)lockTokens.nextElement();
            Element activelock = this.createActiveLockElement(objectLockToken, serverURL, contextPath);
            if (activelock == null) continue;
            xmlValue.add(activelock);
        }
        return xmlValue;
    }

    public XMLValue computeLockDiscovery(NodeLock objectLockToken, String serverURL, String contextPath) {
        XMLValue xmlValue = new XMLValue();
        Element activelock = this.createActiveLockElement(objectLockToken, serverURL, contextPath);
        if (activelock != null) {
            xmlValue.add(activelock);
        }
        return xmlValue;
    }

    public XMLValue computeOwner(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        XMLValue xmlValue = new XMLValue();
        NodeProperty ownerProperty = revisionDescriptor.getProperty("owner", "DAV:");
        NamespaceConfig config = this.nsaToken.getNamespaceConfig();
        String ownerHref = ownerProperty != null && ownerProperty.getValue() != null && !"".equals(ownerProperty.getValue().toString()) ? String.valueOf(contextPath) + config.getUsersPath() + "/" + ownerProperty.getValue().toString() : String.valueOf(contextPath) + config.getUsersPath() + "/" + config.getGuestPath();
        Element href = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        href.setText(ownerHref);
        xmlValue.add(href);
        return xmlValue;
    }

    public XMLValue computePrincipalCollectionSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        XMLValue xmlValue = new XMLValue();
        NamespaceConfig config = this.nsaToken.getNamespaceConfig();
        Element href = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        href.setText(PropertyHelper.getAbsoluteURL(null, contextPath, config.getUsersPath()));
        xmlValue.add(href);
        return xmlValue;
    }

    public NodeProperty computeProperty(String propertyName, NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws SlideException, JDOMException {
        NodeProperty property = null;
        if ("successor-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeSuccessorSet(revisionDescriptors, revisionDescriptor, contextPath, serverURL));
        } else if ("version-history".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeVersionHistory(revisionDescriptors, revisionDescriptor, contextPath, serverURL));
        } else if ("root-version".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeRootVersion(revisionDescriptors, revisionDescriptor, contextPath, serverURL));
        } else if ("supported-method-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeSupportedMethodSet(revisionDescriptors, revisionDescriptor, contextPath, serverURL));
        } else if ("supported-live-property-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeSupportedLivePropertySet(revisionDescriptors, revisionDescriptor, contextPath, serverURL));
        } else if ("supported-report-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeSupportedReportSet(revisionDescriptors, revisionDescriptor, contextPath, serverURL));
        } else if ("checkout-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeCheckoutSet(revisionDescriptors, revisionDescriptor, contextPath, serverURL));
        } else if ("workspace-checkout-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeWorkspaceCheckoutSet(revisionDescriptors, revisionDescriptor, contextPath, serverURL));
        } else if ("lockdiscovery".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeLockDiscovery(revisionDescriptors, revisionDescriptor, contextPath, serverURL));
        } else if ("supportedlock".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeSupportedlock(revisionDescriptors, revisionDescriptor, contextPath, serverURL));
        } else if ("supported-privilege-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeSupportedPrivilegeSet(revisionDescriptors, revisionDescriptor, contextPath, serverURL));
        } else if ("current-user-privilege-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeCurrentuserPrivilegeSet(revisionDescriptors, revisionDescriptor, contextPath, serverURL));
        } else if ("acl".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeAcl(revisionDescriptors, revisionDescriptor, contextPath, serverURL));
        } else if ("acl-semantics".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeAclSemantics(revisionDescriptors, revisionDescriptor, contextPath, serverURL));
        } else if ("principal-collection-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computePrincipalCollectionSet(revisionDescriptors, revisionDescriptor, contextPath, serverURL));
        } else if ("owner".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeOwner(revisionDescriptors, revisionDescriptor, contextPath, serverURL));
        }
        return property;
    }

    public XMLValue computeRootVersion(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException {
        XMLValue xmlValue = new XMLValue();
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, revisionDescriptors, revisionDescriptor);
        if (resourceKind instanceof VersionHistory) {
            Element element = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            StringBuffer buffer = new StringBuffer(revisionDescriptors.getUri());
            if (!revisionDescriptors.getUri().endsWith("/")) {
                buffer.append("/");
            }
            buffer.append(revisionDescriptors.getInitialRevision().toString());
            element.setText(PropertyHelper.getAbsoluteURL(serverURL, contextPath, buffer.toString()));
            xmlValue.add(element);
        }
        return xmlValue;
    }

    public XMLValue computeSuccessorSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException {
        XMLValue xmlValue = new XMLValue();
        Element hrefElement = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        Object successorRevisionDescriptor = null;
        NodeRevisionNumber successorRevisionNumber = null;
        Enumeration successorEnum = revisionDescriptors.getSuccessors(revisionDescriptor.getRevisionNumber());
        if (successorEnum != null) {
            while (successorEnum.hasMoreElements()) {
                successorRevisionNumber = (NodeRevisionNumber)successorEnum.nextElement();
                hrefElement = (Element)hrefElement.clone();
                StringBuffer buffer = new StringBuffer(revisionDescriptors.getUri());
                if (!revisionDescriptors.getUri().endsWith("/")) {
                    buffer.append("/");
                }
                buffer.append(successorRevisionNumber.toString());
                hrefElement.setText(PropertyHelper.getAbsoluteURL(serverURL, contextPath, buffer.toString()));
                xmlValue.add(hrefElement);
            }
        }
        return xmlValue;
    }

    public XMLValue computeSupportedLivePropertySet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException {
        XMLValue xmlValue = new XMLValue();
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, revisionDescriptors, revisionDescriptor);
        Set supportedLivePropertyNames = resourceKind.getSupportedLiveProperties();
        Iterator iterator = supportedLivePropertyNames.iterator();
        Element supportedLivePropertyElement = null;
        Element propElement = null;
        Element propertyElement = null;
        while (iterator.hasNext()) {
            supportedLivePropertyElement = new Element("supported-live-property", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            propElement = new Element("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            supportedLivePropertyElement.addContent(propElement);
            propertyElement = new Element((String)iterator.next(), NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            propElement.addContent(propertyElement);
            xmlValue.add(supportedLivePropertyElement);
        }
        return xmlValue;
    }

    public XMLValue computeSupportedMethodSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException {
        XMLValue xmlValue = new XMLValue();
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, revisionDescriptors, revisionDescriptor);
        Set supportedMethodNames = resourceKind.getSupportedMethods();
        Iterator iterator = supportedMethodNames.iterator();
        Element supportedMethod = null;
        while (iterator.hasNext()) {
            supportedMethod = new Element("supported-method", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            supportedMethod.setAttribute(new Attribute("name", (String)iterator.next()));
            xmlValue.add(supportedMethod);
        }
        return xmlValue;
    }

    public XMLValue computeSupportedPrivilegeSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        XMLValue xmlValue = new XMLValue();
        Element supportedPrivilege = new Element("supported-privilege", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        supportedPrivilege.addContent(this.createPrivilege("all"));
        supportedPrivilege.addContent(this.createDescription("Any operation"));
        supportedPrivilege.addContent(this.createPrivilege("read"));
        supportedPrivilege.addContent(this.createDescription("Read any object"));
        xmlValue.add(supportedPrivilege);
        supportedPrivilege = new Element("supported-privilege", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        supportedPrivilege.addContent(this.createPrivilege("write"));
        supportedPrivilege.addContent(this.createDescription("Write any object"));
        supportedPrivilege.addContent(this.createPrivilege("read-acl"));
        supportedPrivilege.addContent(this.createDescription("Read the ACL"));
        xmlValue.add(supportedPrivilege);
        supportedPrivilege = new Element("supported-privilege", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        supportedPrivilege.addContent(this.createPrivilege("write-acl"));
        supportedPrivilege.addContent(this.createDescription("Write the ACL"));
        xmlValue.add(supportedPrivilege);
        return xmlValue;
    }

    public XMLValue computeSupportedReportSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException {
        XMLValue xmlValue = new XMLValue();
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, revisionDescriptors, revisionDescriptor);
        Set supportedReportNames = resourceKind.getSupportedReports();
        Iterator iterator = supportedReportNames.iterator();
        Element supportedReportElement = null;
        Element reportElement = null;
        Element propertyElement = null;
        while (iterator.hasNext()) {
            supportedReportElement = new Element("supported-report", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            reportElement = new Element("report", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            supportedReportElement.addContent(reportElement);
            propertyElement = new Element((String)iterator.next(), NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            reportElement.addContent(propertyElement);
            xmlValue.add(supportedReportElement);
        }
        return xmlValue;
    }

    public XMLValue computeSupportedlock(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        XMLValue xmlValue = new XMLValue();
        Element lockentry = new Element("lockentry", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        Element lockscope = new Element("lockscope", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        lockentry.addContent(lockscope);
        Element exclusive = new Element("exclusive", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        lockscope.addContent(exclusive);
        Element locktype = new Element("locktype", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        lockentry.addContent(locktype);
        Element write = new Element("write", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        locktype.addContent(write);
        xmlValue.add(lockentry);
        lockentry = new Element("lockentry", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        lockscope = new Element("lockscope", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        lockentry.addContent(lockscope);
        Element shared = new Element("shared", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        lockscope.addContent(shared);
        locktype = new Element("locktype", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        lockentry.addContent(locktype);
        write = new Element("write", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        locktype.addContent(write);
        xmlValue.add(lockentry);
        return xmlValue;
    }

    public XMLValue computeVersionHistory(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, JDOMException {
        XMLValue xmlValue = new XMLValue();
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, revisionDescriptors, revisionDescriptor);
        if (resourceKind instanceof Version) {
            Element element = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            element.setText(PropertyHelper.getAbsoluteURL(serverURL, contextPath, revisionDescriptors.getUri()));
            xmlValue.add(element);
        } else if (resourceKind instanceof CheckedInVersionControlled) {
            Element element = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            String checkedInHref = revisionDescriptor.getProperty("checked-in").getValue().toString();
            String checkedInUri = ((Element)new XMLValue(checkedInHref).iterator().next()).getText();
            UriHandler uriHandler = UriHandler.getUriHandler(checkedInUri);
            element.setText(PropertyHelper.getAbsoluteURL(serverURL, contextPath, uriHandler.getAssociatedHistoryUri()));
            xmlValue.add(element);
        } else if (resourceKind instanceof CheckedOutVersionControlled) {
            Element element = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            String checkedOutHref = revisionDescriptor.getProperty("checked-out").getValue().toString();
            String checkedOutUri = ((Element)new XMLValue(checkedOutHref).iterator().next()).getText();
            UriHandler uriHandler = UriHandler.getUriHandler(checkedOutUri);
            element.setText(PropertyHelper.getAbsoluteURL(serverURL, contextPath, uriHandler.getAssociatedHistoryUri()));
            xmlValue.add(element);
        }
        return xmlValue;
    }

    public XMLValue computeWorkspaceCheckoutSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws SlideException, JDOMException {
        XMLValue xmlValue = new XMLValue();
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, revisionDescriptors, revisionDescriptor);
        if (resourceKind instanceof Workspace) {
            Element basicSearch = this.getWorkspaceCheckoutSetQueryElement(revisionDescriptors.getUri());
            String grammarNamespace = basicSearch.getNamespaceURI();
            Search searchHelper = this.nsaToken.getSearchHelper();
            SearchQuery searchQuery = searchHelper.createSearchQuery(grammarNamespace, basicSearch, (SlideToken)new SlideTokenWrapper(this.sToken, false), Integer.MAX_VALUE, contextPath);
            SearchQueryResult queryResult = searchHelper.search((SlideToken)new SlideTokenWrapper(this.sToken, false), searchQuery);
            Iterator queryResultIterator = queryResult.iterator();
            RequestedResource requestedResource = null;
            Element hrefElement = null;
            while (queryResultIterator.hasNext()) {
                requestedResource = (RequestedResource)queryResultIterator.next();
                hrefElement = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                hrefElement.setText(PropertyHelper.getAbsoluteURL(serverURL, contextPath, requestedResource.getUri()));
                xmlValue.add(hrefElement);
            }
        }
        return xmlValue;
    }

    private Element createActiveLockElement(NodeLock objectLockToken, String serverURL, String contextPath) {
        Element activelock = null;
        Security security = this.nsaToken.getSecurityHelper();
        if (objectLockToken != null) {
            activelock = new Element("activelock", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            Element locktype = new Element("locktype", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            activelock.addContent(locktype);
            Element write = new Element("write", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            locktype.addContent(write);
            Element lockscope = new Element("lockscope", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            activelock.addContent(lockscope);
            Element lockscopeValue = null;
            lockscopeValue = objectLockToken.isExclusive() ? new Element("exclusive", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE) : new Element("shared", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            lockscope.addContent(lockscopeValue);
            Element depth = new Element("depth", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            activelock.addContent(depth);
            if (objectLockToken.isInheritable()) {
                depth.setText("infinity");
            } else {
                depth.setText("0");
            }
            Element owner = new Element("owner", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            activelock.addContent(owner);
            if (objectLockToken.getOwnerInfo() != null && !objectLockToken.getOwnerInfo().equals("")) {
                try {
                    Document d = new SAXBuilder().build((Reader)new StringReader(objectLockToken.getOwnerInfo()));
                    owner.addContent(d.getRootElement());
                }
                catch (Throwable throwable) {
                    owner.addContent(new CDATA(objectLockToken.getOwnerInfo()));
                }
            }
            Element timeout = new Element("timeout", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            activelock.addContent(timeout);
            timeout.setText("Second-" + new Long((objectLockToken.getExpirationDate().getTime() - new Date().getTime()) / 1000L).toString());
            Element locktoken = new Element("locktoken", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            activelock.addContent(locktoken);
            Element href = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            locktoken.addContent(href);
            href.setText("opaquelocktoken:" + objectLockToken.getLockId());
            if (this.lockdiscoveryIncludesPrincipalURL) {
                Element principalUrl = new Element("principal-URL", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                activelock.addContent(principalUrl);
                Element puhref = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                principalUrl.addContent(puhref);
                puhref.setText(PropertyHelper.getAbsoluteURL(serverURL, contextPath, objectLockToken.getSubjectUri()));
            }
        }
        return activelock;
    }

    public Object createCdataValue(String text) {
        StringBuffer b = new StringBuffer();
        if (text == null) {
            text = "";
        }
        b.append("![CDATA[").append(text).append("]]");
        return b.toString();
    }

    Object createDefaultValue(String propName, ResourceKind resourceKind) {
        Principal p;
        CredentialsToken credToken;
        String result = "";
        if ("resourcetype".equals(propName)) {
            StringBuffer rtvv = new StringBuffer();
            try {
                if (resourceKind instanceof VersionHistory) {
                    rtvv.append(AbstractWebdavHelper.xmlOut.outputString(new Element("version-history", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE)));
                    rtvv.append(AbstractWebdavHelper.xmlOut.outputString(new Element("collection", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE)));
                }
                if (resourceKind instanceof DeltavCompliantCollection) {
                    rtvv.append(AbstractWebdavHelper.xmlOut.outputString(new Element("collection", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE)));
                }
                if (resourceKind instanceof Activity) {
                    rtvv.append(AbstractWebdavHelper.xmlOut.outputString(new Element("activity", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE)));
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            result = rtvv.toString();
        } else if ("supported-method-set".equals(propName)) {
            Iterator i = resourceKind.getSupportedMethods().iterator();
            StringBuffer smsv = new StringBuffer();
            while (i.hasNext()) {
                String m = (String)i.next();
                Element sm = new Element("supported-method", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                Attribute na = new Attribute("name", m, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                sm.setAttribute(na);
                try {
                    smsv.append(AbstractWebdavHelper.xmlOut.outputString(sm));
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            result = smsv.toString();
        } else if ("supported-live-property-set".equals(propName)) {
            Iterator i = resourceKind.getSupportedLiveProperties().iterator();
            StringBuffer spsv = new StringBuffer();
            while (i.hasNext()) {
                String p2 = (String)i.next();
                Element sp = new Element("supported-live-property", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                Element na = new Element("name", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                na.addContent(p2);
                sp.addContent(na);
                try {
                    spsv.append(AbstractWebdavHelper.xmlOut.outputString(sp));
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            result = spsv.toString();
        } else if ("supported-report-set".equals(propName)) {
            Iterator i = resourceKind.getSupportedReports().iterator();
            StringBuffer srsv = new StringBuffer();
            while (i.hasNext()) {
                String r = (String)i.next();
                Element sr = new Element("supported-report", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                Element na = new Element("name", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                na.addContent(r);
                sr.addContent(na);
                try {
                    srsv.append(AbstractWebdavHelper.xmlOut.outputString(sr));
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            result = srsv.toString();
        } else if ("auto-version".equals(propName)) {
            XMLValue xmlValue = new XMLValue();
            if (DEFAULT_AUTO_VERSION.length() > 0) {
                xmlValue.add(new Element(DEFAULT_AUTO_VERSION, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE));
            }
            if (!resourceKind.isSupportedPropertyValue("auto-version", xmlValue)) {
                Domain.warn((Object)"Auto-version not configured properly; using checkout-checkin");
                xmlValue = new XMLValue(new Element("checkout-checkin", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE));
            }
            result = xmlValue.toString();
        } else if ("checkout-fork".equals(propName)) {
            XMLValue xmlValue = new XMLValue();
            if (DEFAULT_CHECKOUT_FORK.length() > 0) {
                xmlValue.add(new Element(DEFAULT_CHECKOUT_FORK, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE));
            }
            if (!resourceKind.isSupportedPropertyValue("checkout-fork", xmlValue)) {
                Domain.warn((Object)"Checkout-fork not configured properly; using forbidden");
                xmlValue = new XMLValue(new Element("forbidden", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE));
            }
            result = xmlValue.toString();
        } else if ("checkin-fork".equals(propName)) {
            XMLValue xmlValue = new XMLValue();
            if (DEFAULT_CHECKIN_FORK.length() > 0) {
                xmlValue.add(new Element(DEFAULT_CHECKIN_FORK, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE));
            }
            if (!resourceKind.isSupportedPropertyValue("checkin-fork", xmlValue)) {
                Domain.warn((Object)"Checkin-fork not configured properly; using forbidden");
                xmlValue = new XMLValue(new Element("forbidden", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE));
            }
            result = xmlValue.toString();
        } else if ("getcontentlanguage".equals(propName)) {
            result = "en";
        } else if ("creator-displayname".equals(propName) && this.sToken != null && (credToken = this.sToken.getCredentialsToken()) != null && (p = credToken.getPrincipal()) != null) {
            result = p.getName();
        }
        return result;
    }

    private Element createDescription(String text) {
        Element description = new Element("description", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        description.setText(text);
        return description;
    }

    public Object createHrefSetValue(String rootElement, List uriList) {
        String result = "";
        Element root = new Element(rootElement, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        Iterator i = uriList.iterator();
        while (i.hasNext()) {
            Element href = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            href.addContent((String)i.next());
            root.addContent(href);
        }
        try {
            result = AbstractWebdavHelper.xmlOut.outputString(root);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return result;
    }

    public Object createHrefSetValue(List uriList) {
        StringBuffer b = new StringBuffer();
        Iterator i = uriList.iterator();
        while (i.hasNext()) {
            b.append(this.createHrefValue((String)i.next()));
        }
        return b.toString();
    }

    public Object createHrefValue(String uri) {
        String result = "";
        Element href = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        href.addContent(uri);
        try {
            result = AbstractWebdavHelper.xmlOut.outputString(href);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return result;
    }

    public List createInitialProperties(ResourceKind resourceKind) {
        Set sp = resourceKind.getSupportedLiveProperties();
        ArrayList<NodeProperty> result = null;
        if (sp == null) {
            result = Collections.EMPTY_LIST;
        } else {
            result = new ArrayList<NodeProperty>();
            Iterator i = sp.iterator();
            while (i.hasNext()) {
                String propName = (String)i.next();
                if (AbstractResourceKind.isComputedProperty(propName)) continue;
                Object pvalue = this.createDefaultValue(propName, resourceKind);
                result.add(new NodeProperty(propName, pvalue));
            }
        }
        return result;
    }

    private Element createPrincipal(String principalName, String contextPath) {
        Element principal = new Element("principal", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        if (principalName.equals("~")) {
            principal.addContent(new Element("self", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE));
        } else if (principalName.equals("nobody")) {
            principal.addContent(new Element("all", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE));
        } else {
            Element href = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            href.setText(PropertyHelper.getAbsoluteURL(null, contextPath, principalName));
            principal.addContent(href);
        }
        return principal;
    }

    private Element createPrivilege(String privilegeName) {
        return this.createPrivilege(privilegeName, true);
    }

    private Element createPrivilege(String privilegeName, boolean useDavNamespace) {
        Element privilege = new Element("privilege", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        Namespace namespace = NodeProperty.NamespaceCache.DEFAULT_NAMESPACE;
        if (!useDavNamespace) {
            namespace = NodeProperty.NamespaceCache.SLIDE_NAMESPACE;
        }
        Element privilegeNameElement = new Element(privilegeName, namespace);
        privilege.addContent(privilegeNameElement);
        return privilege;
    }

    public static String getAbsoluteURL(String serverURL, String contextPath, String uri) {
        StringBuffer buffer = new StringBuffer();
        String lastAppended = null;
        if (contextPath != null) {
            if (lastAppended != null && !lastAppended.endsWith("/") && !contextPath.startsWith("/")) {
                buffer.append("/");
            }
            buffer.append(contextPath);
            lastAppended = buffer.toString();
        }
        if (uri != null) {
            if (lastAppended != null && !lastAppended.endsWith("/") && !uri.startsWith("/")) {
                buffer.append("/");
            }
            buffer.append(uri);
        }
        return buffer.toString();
    }

    protected Element getCheckoutSetQueryElement(String resourcePath) throws SlideException {
        if (this.checkoutSetQueryElement == null) {
            this.checkoutSetQueryElement = new Element("basicsearch", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            Element select = new Element("select", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            this.checkoutSetQueryElement.addContent(select);
            Element prop = new Element("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            select.addContent(prop);
            Element checkedOut = new Element("checked-out", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            prop.addContent(checkedOut);
            Element from = new Element("from", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            this.checkoutSetQueryElement.addContent(from);
            Element scope = new Element("scope", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            from.addContent(scope);
            Element href = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            scope.addContent(href);
            href.setText("");
            Iterator excludeIterator = this.getNonVcrPathExcludeList().iterator();
            while (excludeIterator.hasNext()) {
                scope.addContent((Element)excludeIterator.next());
            }
            Element where = new Element("where", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            this.checkoutSetQueryElement.addContent(where);
            Element propcontains = new Element("propcontains", NodeProperty.NamespaceCache.SLIDE_NAMESPACE);
            where.addContent(propcontains);
            propcontains.addContent((Element)prop.clone());
            this.checkoutSetQueryLiteralElement = new Element("literal", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            propcontains.addContent(this.checkoutSetQueryLiteralElement);
        }
        this.checkoutSetQueryLiteralElement.setText(resourcePath);
        return this.checkoutSetQueryElement;
    }

    public List getNonVcrPathExcludeList() {
        ArrayList<Element> excludeList = new ArrayList<Element>();
        String usersPath = PropertyHelper.truncateLeadingSlash(this.nsaToken.getNamespaceConfig().getUsersPath());
        Element excludeElement = new Element("exclude", NodeProperty.NamespaceCache.SLIDE_NAMESPACE);
        excludeElement.setText(usersPath);
        excludeList.add(excludeElement);
        Iterator historyPathIterator = HistoryPathHandler.getHistoryPathHandler().getResolvedHistoryPaths().iterator();
        while (historyPathIterator.hasNext()) {
            excludeElement = new Element("exclude", NodeProperty.NamespaceCache.SLIDE_NAMESPACE);
            excludeElement.setText(PropertyHelper.truncateLeadingSlash(historyPathIterator.next().toString()));
            excludeList.add(excludeElement);
        }
        return excludeList;
    }

    public NodeProperty getProperty(String propertyName, String resourcePath) throws SlideException, JDOMException {
        return this.getProperty(propertyName, resourcePath, null, null);
    }

    public NodeProperty getProperty(String propertyName, String resourcePath, String contextPath, String serverURL) throws SlideException, JDOMException {
        UriHandler uriHandler = UriHandler.getUriHandler(resourcePath);
        String uri = null;
        NodeRevisionDescriptors revisionDescriptors = null;
        NodeRevisionDescriptor revisionDescriptor = null;
        Content contentHelper = this.nsaToken.getContentHelper();
        if (uriHandler.isVersionUri()) {
            uri = uriHandler.getAssociatedHistoryUri();
            NodeRevisionNumber revisionNumber = new NodeRevisionNumber(uriHandler.getVersionName());
            revisionDescriptors = contentHelper.retrieve(this.sToken, uri);
            revisionDescriptor = contentHelper.retrieve(this.sToken, revisionDescriptors, revisionNumber);
        } else if (uriHandler.isHistoryUri()) {
            uri = uriHandler.getAssociatedHistoryUri();
            NodeRevisionNumber revisionNumber = new NodeRevisionNumber("0.0");
            revisionDescriptors = contentHelper.retrieve(this.sToken, uri);
            revisionDescriptor = contentHelper.retrieve(this.sToken, revisionDescriptors, revisionNumber);
        } else {
            uri = resourcePath;
            revisionDescriptors = contentHelper.retrieve(this.sToken, uri);
            revisionDescriptor = contentHelper.retrieve(this.sToken, revisionDescriptors);
        }
        return this.getProperty(propertyName, revisionDescriptors, revisionDescriptor, contextPath, serverURL);
    }

    public NodeProperty getProperty(String propertyName, NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor) throws SlideException, JDOMException {
        return this.getProperty(propertyName, revisionDescriptors, revisionDescriptor, null, null);
    }

    public NodeProperty getProperty(String propertyName, NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String contextPath, String serverURL) throws SlideException, JDOMException {
        NodeProperty property = revisionDescriptor.getProperty(propertyName);
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, revisionDescriptors, revisionDescriptor);
        if (resourceKind.isSupportedLiveProperty(propertyName) && AbstractResourceKind.isComputedProperty(propertyName)) {
            property = this.computeProperty(propertyName, revisionDescriptors, revisionDescriptor, contextPath, serverURL);
        }
        return property;
    }

    public static PropertyHelper getPropertyHelper(SlideToken sToken, NamespaceAccessToken nsaToken) {
        return new PropertyHelper(sToken, nsaToken, null);
    }

    public static PropertyHelper getPropertyHelper(SlideToken sToken, NamespaceAccessToken nsaToken, WebdavServletConfig sConf) {
        return new PropertyHelper(sToken, nsaToken, sConf);
    }

    protected Element getWorkspaceCheckoutSetQueryElement(String scopePath) {
        if (this.workspaceCheckoutSetQueryElement == null) {
            this.workspaceCheckoutSetQueryElement = new Element("basicsearch", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            Element select = new Element("select", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            this.workspaceCheckoutSetQueryElement.addContent(select);
            Element prop = new Element("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            select.addContent(prop);
            Element checkedOut = new Element("checked-out", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            prop.addContent(checkedOut);
            Element from = new Element("from", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            this.workspaceCheckoutSetQueryElement.addContent(from);
            Element scope = new Element("scope", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            from.addContent(scope);
            this.workspaceCheckoutSetQueryHrefElement = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            scope.addContent(this.workspaceCheckoutSetQueryHrefElement);
            Element where = new Element("where", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            this.workspaceCheckoutSetQueryElement.addContent(where);
            Element isdefined = new Element("isdefined", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            where.addContent(isdefined);
            isdefined.addContent((Element)prop.clone());
        }
        this.workspaceCheckoutSetQueryHrefElement.setText(PropertyHelper.truncateLeadingSlash(scopePath));
        return this.workspaceCheckoutSetQueryElement;
    }

    public static boolean isAbsoluteURL(String serverURL, String contextPath, String uri) {
        if (!uri.startsWith("/")) {
            uri = "/" + uri;
        }
        return uri.startsWith(contextPath);
    }

    public Element parsePropertyValue(String propValue) throws JDOMException, IOException {
        Document d = AbstractWebdavHelper.xmlBuilder.build((Reader)new StringReader(propValue));
        return d.getRootElement();
    }

    public static void removeElementFromProperty(NodeRevisionDescriptor revisionDescriptor, String propertyName, String elementName, String elementValue) throws JDOMException {
        NodeProperty property = revisionDescriptor.getProperty(propertyName);
        if (property != null) {
            XMLValue xmlValue = new XMLValue((String)property.getValue());
            Iterator iterator = xmlValue.iterator();
            boolean found = false;
            Element element = null;
            while (iterator.hasNext() && !found) {
                element = (Element)iterator.next();
                if (!element.getName().equals(elementName) || !element.getText().equals(elementValue)) continue;
                found = true;
                iterator.remove();
            }
            if (found) {
                revisionDescriptor.setProperty(propertyName, (Object)xmlValue.toString());
            }
        }
    }

    public static void removeHrefFromProperty(NodeRevisionDescriptor revisionDescriptor, String propertyName, String uri) throws JDOMException {
        PropertyHelper.removeElementFromProperty(revisionDescriptor, propertyName, "href", uri);
    }

    /*
     * Unable to fully structure code
     */
    public static String truncateLeadingSlash(String uri) {
        if (uri != null) ** GOTO lbl4
        return uri;
lbl-1000:
        // 1 sources

        {
            uri = uri.substring(1);
lbl4:
            // 2 sources

            ** while (uri.startsWith((String)"/"))
        }
lbl5:
        // 1 sources

        return uri;
    }
}

