/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.lock.Lock;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.security.Security;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.Structure;
import org.apache.slide.util.Configuration;
import org.apache.slide.util.Messages;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.util.WebdavUtils;

public class DirectoryIndexGenerator {
    public static final String DATE_FORMAT = "EEE, d MMM yyyy kk:mm:ss z";
    private static final DateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy kk:mm:ss z");
    protected NamespaceAccessToken nat;
    protected WebdavServletConfig config;

    public DirectoryIndexGenerator(NamespaceAccessToken nat, WebdavServletConfig config) {
        if (nat == null) {
            throw new IllegalArgumentException("NamespaceAccessToken must not be null");
        }
        this.nat = nat;
        if (config == null) {
            throw new IllegalArgumentException("WebdavServletConfig must not be null");
        }
        this.config = config;
    }

    private String charToCharacterRef(char val) {
        StringBuffer result = new StringBuffer(8);
        result.append("&#x").append(Integer.toHexString(val).toUpperCase()).append(";");
        return result.toString();
    }

    protected void displayLocks(Enumeration locksList, PrintWriter writer, boolean shade) throws IOException {
        boolean hideLocks = false;
        String hideLocksStr = this.config.getInitParameter("directory-browsing-hide-locks");
        if ("true".equalsIgnoreCase(hideLocksStr)) {
            hideLocks = true;
        }
        if (!hideLocks && locksList != null && locksList.hasMoreElements()) {
            writer.print("<tr" + (shade ? " bgcolor=\"eeeeee\"" : " bgcolor=\"dddddd\"") + ">\r\n");
            writer.print("<td align=\"left\" colspan=\"5\"><tt><b>");
            writer.print(Messages.message((String)"org.apache.slide.webdav.GetMethod.locksinfo"));
            writer.print("</b></tt></td>\r\n");
            writer.print("</tr>\r\n");
            writer.print("<tr");
            if (!shade) {
                writer.print(" bgcolor=\"dddddd\"");
            } else {
                writer.print(" bgcolor=\"eeeeee\"");
            }
            writer.print(">\r\n");
            writer.print("<td align=\"left\"><tt><b>");
            writer.print(Messages.message((String)"org.apache.slide.webdav.GetMethod.subject"));
            writer.print("</b></tt></td>\r\n");
            writer.print("<td align=\"left\"><tt><b>");
            writer.print(Messages.message((String)"org.apache.slide.webdav.GetMethod.type"));
            writer.print("</b></tt></td>\r\n");
            writer.print("<td align=\"right\"><tt><b>");
            writer.print(Messages.message((String)"org.apache.slide.webdav.GetMethod.expiration"));
            writer.print("</b></tt></td>\r\n");
            writer.print("<td align=\"right\"><tt><b>");
            writer.print(Messages.message((String)"org.apache.slide.webdav.GetMethod.inheritable"));
            writer.print("</b></tt></td>\r\n");
            writer.print("<td align=\"right\"><tt><b>");
            writer.print(Messages.message((String)"org.apache.slide.webdav.GetMethod.exclusive"));
            writer.print("</b></tt></td>\r\n");
            writer.print("</tr>\r\n");
            while (locksList.hasMoreElements()) {
                writer.print("<tr" + (shade ? " bgcolor=\"eeeeee\"" : " bgcolor=\"dddddd\"") + ">\r\n");
                NodeLock currentLock = (NodeLock)locksList.nextElement();
                writer.print("<td align=\"left\"><tt>");
                writer.print(currentLock.getSubjectUri());
                writer.print("</tt></td>\r\n");
                writer.print("<td align=\"left\"><tt>");
                writer.print(currentLock.getTypeUri());
                writer.print("</tt></td>\r\n");
                writer.print("<td align=\"right\"><tt>");
                writer.print(formatter.format(currentLock.getExpirationDate()));
                writer.print("</tt></td>\r\n");
                writer.print("<td align=\"right\"><tt>");
                writer.print(currentLock.isInheritable());
                writer.print("</tt></td>\r\n");
                writer.print("<td align=\"right\"><tt>");
                writer.print(currentLock.isExclusive());
                writer.print("</tt></td>\r\n");
            }
        }
    }

    protected void displayPermissions(Enumeration permissionsList, PrintWriter writer, boolean shade) throws IOException {
        boolean hideAcl = false;
        String hideAclStr = this.config.getInitParameter("directory-browsing-hide-acl");
        if ("true".equalsIgnoreCase(hideAclStr)) {
            hideAcl = true;
        }
        if (!hideAcl && permissionsList != null && permissionsList.hasMoreElements()) {
            writer.print("<tr" + (shade ? " bgcolor=\"eeeeee\"" : " bgcolor=\"dddddd\"") + ">\r\n");
            writer.print("<td align=\"left\" colspan=\"5\"><tt><b>");
            writer.print(Messages.message((String)"org.apache.slide.webdav.GetMethod.aclinfo"));
            writer.print("</b></tt></td>\r\n");
            writer.print("</tr>\r\n");
            writer.print("<tr");
            if (!shade) {
                writer.print(" bgcolor=\"dddddd\"");
            } else {
                writer.print(" bgcolor=\"eeeeee\"");
            }
            writer.print(">\r\n");
            writer.print("<td align=\"left\" colspan=\"2\"><tt><b>");
            writer.print(Messages.message((String)"org.apache.slide.webdav.GetMethod.subject"));
            writer.print("</b></tt></td>\r\n");
            writer.print("<td align=\"left\"><tt><b>");
            writer.print(Messages.message((String)"org.apache.slide.webdav.GetMethod.action"));
            writer.print("</b></tt></td>\r\n");
            writer.print("<td align=\"right\"><tt><b>");
            writer.print(Messages.message((String)"org.apache.slide.webdav.GetMethod.inheritable"));
            writer.print("</b></tt></td>\r\n");
            writer.print("<td align=\"right\"><tt><b>");
            writer.print(Messages.message((String)"org.apache.slide.webdav.GetMethod.deny"));
            writer.print("</b></tt></td>\r\n");
            writer.print("</tr>\r\n");
            while (permissionsList.hasMoreElements()) {
                writer.print("<tr" + (shade ? " bgcolor=\"eeeeee\"" : " bgcolor=\"dddddd\"") + ">\r\n");
                NodePermission currentPermission = (NodePermission)permissionsList.nextElement();
                writer.print("<td align=\"left\" colspan=\"2\"><tt>");
                writer.print(currentPermission.getSubjectUri());
                writer.print("</tt></td>\r\n");
                writer.print("<td align=\"left\"><tt>");
                writer.print(currentPermission.getActionUri());
                writer.print("</tt></td>\r\n");
                writer.print("<td align=\"right\"><tt>");
                writer.print(currentPermission.isInheritable());
                writer.print("</tt></td>\r\n");
                writer.print("<td align=\"right\"><tt>");
                writer.print(currentPermission.isNegative());
                writer.print("</tt></td>\r\n");
                writer.print("</tr>\r\n");
            }
        }
    }

    public void generate(HttpServletRequest req, HttpServletResponse res) throws IOException, SlideException {
        String scope;
        res.setContentType("text/html; charset=\"UTF-8\"");
        String contextPath = req.getContextPath();
        if (contextPath == null) {
            contextPath = "";
        }
        Content content = this.nat.getContentHelper();
        Lock lock = this.nat.getLockHelper();
        Security security = this.nat.getSecurityHelper();
        Structure structure = this.nat.getStructureHelper();
        SlideToken slideToken = WebdavUtils.getSlideToken(req);
        String resourcePath = WebdavUtils.getRelativePath(req, this.config);
        ObjectNode object = structure.retrieve(slideToken, resourcePath);
        String name = object.getUri();
        int trim = name.length();
        if (!name.endsWith("/")) {
            ++trim;
        }
        if (name.equals("/")) {
            trim = 1;
        }
        PrintWriter writer = new PrintWriter(res.getWriter());
        writer.print("<html>\r\n");
        writer.print("<head>\r\n");
        writer.print("<meta http-equiv=\"Content-type\" content=\"text/html; charset=UTF-8\" >\r\n");
        writer.print("</meta>\r\n");
        writer.print("<title>");
        writer.print(Messages.format((String)"org.apache.slide.webdav.GetMethod.directorylistingfor", (Object)name));
        writer.print("</title>\r\n</head>\r\n");
        writer.print("<body bgcolor=\"white\">\r\n");
        writer.print("<table width=\"90%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">\r\n");
        writer.print("<tr><td colspan=\"3\"><font size=\"+2\">\r\n<strong>");
        writer.print(Messages.format((String)"org.apache.slide.webdav.GetMethod.directorylistingfor", (Object)name));
        writer.print("</strong>\r\n</font></td></tr>\r\n");
        String parentDirectory = name;
        if (parentDirectory.endsWith("/")) {
            parentDirectory = parentDirectory.substring(0, parentDirectory.length() - 1);
        }
        if ((parentDirectory = parentDirectory.substring((scope = this.config.getScope()).length())).lastIndexOf("/") >= 0) {
            parentDirectory = parentDirectory.substring(0, parentDirectory.lastIndexOf("/"));
            writer.print("<tr><td colspan=\"5\" bgcolor=\"#ffffff\">\r\n");
            writer.print("<a href=\"");
            writer.print(WebdavUtils.encodeURL(contextPath, "UTF-8"));
            if (parentDirectory.equals("")) {
                parentDirectory = "/";
            }
            writer.print(parentDirectory);
            writer.print("\">");
            writer.print(Messages.format((String)"org.apache.slide.webdav.GetMethod.parent", (Object)parentDirectory));
            writer.print("</a>\r\n");
            writer.print("</td></tr>\r\n");
        }
        Enumeration permissionsList = null;
        Enumeration locksList = null;
        try {
            permissionsList = security.enumeratePermissions(slideToken, object.getUri());
            locksList = lock.enumerateLocks(slideToken, object.getUri(), false);
        }
        catch (SlideException slideException) {}
        if (Configuration.useIntegratedSecurity()) {
            this.displayPermissions(permissionsList, writer, false);
        }
        this.displayLocks(locksList, writer, false);
        writer.print("<tr><td colspan=\"5\" bgcolor=\"#ffffff\">");
        writer.print("&nbsp;");
        writer.print("</td></tr>\r\n");
        writer.print("<tr bgcolor=\"#cccccc\">\r\n");
        writer.print("<td align=\"left\" colspan=\"3\">");
        writer.print("<font size=\"+1\"><strong>");
        writer.print(Messages.message((String)"org.apache.slide.webdav.GetMethod.filename"));
        writer.print("</strong></font></td>\r\n");
        writer.print("<td align=\"center\"><font size=\"+1\"><strong>");
        writer.print(Messages.message((String)"org.apache.slide.webdav.GetMethod.size"));
        writer.print("</strong></font></td>\r\n");
        writer.print("<td align=\"right\"><font size=\"+1\"><strong>");
        writer.print(Messages.message((String)"org.apache.slide.webdav.GetMethod.lastModified"));
        writer.print("</strong></font></td>\r\n");
        writer.print("</tr>\r\n");
        Enumeration resources = object.enumerateChildren();
        boolean shade = false;
        while (resources.hasMoreElements()) {
            String currentResource = (String)resources.nextElement();
            NodeRevisionDescriptor currentDescriptor = null;
            permissionsList = null;
            locksList = null;
            try {
                NodeRevisionDescriptors revisionDescriptors = content.retrieve(slideToken, currentResource);
                currentDescriptor = content.retrieve(slideToken, revisionDescriptors);
            }
            catch (SlideException slideException) {}
            try {
                permissionsList = security.enumeratePermissions(slideToken, currentResource);
                locksList = lock.enumerateLocks(slideToken, currentResource, false);
            }
            catch (SlideException slideException) {}
            String trimmed = currentResource.substring(trim);
            if (trimmed.equalsIgnoreCase("WEB-INF") || trimmed.equalsIgnoreCase("META-INF")) continue;
            writer.print("<tr");
            if (shade) {
                writer.print(" bgcolor=\"dddddd\"");
            } else {
                writer.print(" bgcolor=\"eeeeee\"");
            }
            writer.print(">\r\n");
            shade ^= true;
            writer.print("<td align=\"left\" colspan=\"3\">&nbsp;&nbsp;\r\n");
            writer.print("<a href=\"");
            writer.print(WebdavUtils.encodeURL(String.valueOf(contextPath) + currentResource.substring(scope.length())));
            writer.print("\"><tt>");
            writer.print(this.stringToCharacterRef(trimmed));
            if (WebdavUtils.isCollection(currentDescriptor)) {
                writer.print("/");
            }
            writer.print("</tt></a></td>\r\n");
            writer.print("<td align=\"right\"><tt>");
            if (WebdavUtils.isCollection(currentDescriptor)) {
                writer.print("&nbsp;");
            } else {
                writer.print(this.renderSize(currentDescriptor.getContentLength()));
            }
            writer.print("</tt></td>\r\n");
            writer.print("<td align=\"right\"><tt>");
            if (currentDescriptor != null) {
                writer.print(currentDescriptor.getLastModified());
            } else {
                writer.print("&nbsp;");
            }
            writer.print("</tt></td>\r\n");
            writer.print("</tr>\r\n");
            if (Configuration.useIntegratedSecurity()) {
                this.displayPermissions(permissionsList, writer, shade);
            }
            this.displayLocks(locksList, writer, shade);
        }
        writer.print("<tr><td colspan=\"5\">&nbsp;</td></tr>\r\n");
        writer.print("<tr><td colspan=\"3\" bgcolor=\"#cccccc\">");
        writer.print("<font size=\"-1\">");
        writer.print(Messages.message((String)"org.apache.slide.webdav.GetMethod.version"));
        writer.print("</font></td>\r\n");
        writer.print("<td colspan=\"2\" align=\"right\" bgcolor=\"#cccccc\">");
        writer.print("<font size=\"-1\">");
        writer.print(formatter.format(new Date()));
        writer.print("</font></td></tr>\r\n");
        writer.print("</table>\r\n");
        writer.print("</body>\r\n");
        writer.print("</html>\r\n");
        writer.flush();
    }

    protected String renderSize(long size) {
        long leftSide = size / 1024L;
        long rightSide = size % 1024L / 103L;
        if (leftSide == 0L && rightSide == 0L && size > 0L) {
            rightSide = 1L;
        }
        return leftSide + "." + rightSide + " kb";
    }

    private String stringToCharacterRef(String val) {
        StringBuffer result = new StringBuffer(val.length() * 8);
        int i = 0;
        while (i < val.length()) {
            result.append(this.charToCharacterRef(val.charAt(i)));
            ++i;
        }
        return result.toString();
    }
}

