/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.util.Iterator;
import org.apache.slide.common.Domain;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.macro.ForbiddenException;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.VersioningHelper;
import org.jdom.Element;
import org.jdom.JDOMException;

public class VersionControlMethod
extends AbstractWebdavMethod
implements DeltavConstants {
    static final String VERSIONCONTROL_EXCLUDEPATH = Domain.getParameter((String)"versioncontrol-exclude", (String)"");
    private String resourcePath;
    private String existingVersionPath;

    public VersionControlMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void executeRequest() throws WebdavException, IOException {
        this.slideToken.setForceStoreEnlistment(true);
        try {
            UriHandler exUh;
            UriHandler rUh = UriHandler.getUriHandler(this.resourcePath);
            if (VERSIONCONTROL_EXCLUDEPATH != null && VERSIONCONTROL_EXCLUDEPATH.length() > 0 && (exUh = UriHandler.getUriHandler(VERSIONCONTROL_EXCLUDEPATH)).isAncestorOf(rUh)) {
                throw new ForbiddenException(this.resourcePath, (Throwable)new Exception("The resource path has been excluded from version-control"));
            }
            VersioningHelper vh = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.getConfig());
            if (this.existingVersionPath == null) {
                vh.versionControl(this.resourcePath);
            } else {
                vh.versionControl(this.resourcePath, this.existingVersionPath);
            }
        }
        catch (PreconditionViolationException e) {
            this.sendPreconditionViolation(e);
            throw e;
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    protected void parseRequest() throws WebdavException {
        this.readRequestContent();
        this.resourcePath = this.requestUri;
        if (this.resourcePath == null) {
            this.resourcePath = "/";
        }
        if (this.req.getContentLength() > 0) {
            try {
                Element vce = this.parseRequestContent().getRootElement();
                Element ve = null;
                if (vce == null || !vce.getName().equals("version-control")) {
                    Domain.warn((Object)"Root element must be version-control");
                    throw new JDOMException("Root element must be <version-control>");
                }
                Iterator i = vce.getChildren().iterator();
                while (i.hasNext()) {
                    Element e = (Element)i.next();
                    if (!e.getName().equals("version")) continue;
                    ve = e;
                    try {
                        Element hre = (Element)ve.getChildren().get(0);
                        if (hre == null || !hre.getName().equals("href")) {
                            throw new Exception();
                        }
                        this.existingVersionPath = this.getSlidePath(hre.getText());
                        break;
                    }
                    catch (Exception exception) {
                        Domain.warn((Object)"version element must contain href element");
                        throw new JDOMException("<version> element must contain <href> element");
                    }
                }
            }
            catch (JDOMException e) {
                int statusCode = 400;
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
            catch (IOException e) {
                int statusCode = 500;
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
        }
    }
}

