/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.util.Enumeration;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.CheckedOutVersionControlled;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;

public class UnlockMethod
extends AbstractWebdavMethod {
    public static final String LOCK_TOKEN_HEADER_MISSING = "Lock-Token header missing";
    public static final String INVALID_LOCK_TOKEN = "Lock-Token is invalid";
    private String toUnlock;
    private String lockId;

    public UnlockMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected boolean canUnlock(SlideToken slideToken, String objectUri, String lockID) throws ServiceAccessException, LockTokenNotFoundException, ObjectNotFoundException {
        Enumeration locksList = this.lock.enumerateLocks(slideToken, objectUri, false);
        boolean foundLock = locksList.hasMoreElements() ^ true;
        while (!foundLock && locksList.hasMoreElements()) {
            NodeLock currentLock = (NodeLock)locksList.nextElement();
            if (!currentLock.getLockId().equals(this.lockId)) continue;
            foundLock = true;
        }
        return foundLock;
    }

    protected void executeRequest() throws WebdavException {
        this.slideToken.setForceStoreEnlistment(true);
        String errorMessage = null;
        try {
            if (!this.canUnlock(this.slideToken, this.requestUri, this.lockId)) {
                errorMessage = INVALID_LOCK_TOKEN;
                throw new WebdavException(412);
            }
            this.lock.unlock(this.slideToken, this.requestUri, this.lockId);
            NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.slideToken, this.requestUri);
            NodeRevisionDescriptor revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors);
            ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.token, this.requestUri, revisionDescriptor);
            if (Configuration.useVersionControl() && resourceKind instanceof CheckedOutVersionControlled) {
                NodeProperty checkinLocktokenProperty = revisionDescriptor.getProperty("checkin-locktoken", "http://jakarta.apache.org/slide/");
                if (checkinLocktokenProperty == null) {
                    checkinLocktokenProperty = revisionDescriptor.getProperty("checkin-locktoken");
                }
                if (checkinLocktokenProperty != null && checkinLocktokenProperty.getValue() != null && this.lockId.equals(checkinLocktokenProperty.getValue().toString())) {
                    VersioningHelper versionHelper = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.config);
                    versionHelper.checkin(revisionDescriptors, revisionDescriptor, false, false, true);
                }
            }
            ObjectNode node = this.structure.retrieve(this.slideToken, this.requestUri);
            if (revisionDescriptor.propertyValueContains("resourcetype", "lock-null")) {
                this.content.remove(this.slideToken, this.requestUri, revisionDescriptor);
                this.content.remove(this.slideToken, revisionDescriptors);
                this.structure.remove(this.slideToken, node);
            }
            this.resp.setStatus(204);
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            if (errorMessage != null) {
                this.sendError(statusCode, errorMessage);
            } else {
                this.sendError(statusCode, e);
            }
            throw new WebdavException(statusCode);
        }
    }

    protected int getErrorCode(Exception ex) {
        try {
            throw ex;
        }
        catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {
            return 200;
        }
        catch (LinkedObjectNotFoundException linkedObjectNotFoundException) {
            return 404;
        }
        catch (Exception e) {
            return super.getErrorCode(e);
        }
    }

    protected boolean methodNeedsTransactionSupport() {
        return true;
    }

    protected void parseRequest() throws WebdavException {
        String lockTokenHeader;
        this.toUnlock = this.requestUri;
        if (this.toUnlock == null) {
            this.toUnlock = "/";
        }
        if ((lockTokenHeader = this.req.getHeader("Lock-Token")) == null) {
            this.sendError(412, LOCK_TOKEN_HEADER_MISSING);
            throw new WebdavException(412);
        }
        this.lockId = this.parseLockToken(lockTokenHeader);
    }
}

