/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.VersioningHelper;
import org.jdom.JDOMException;

public class UncheckoutMethod
extends AbstractWebdavMethod
implements DeltavConstants {
    protected static final String NO_CACHE = "no-cache";
    private String resourcePath;

    public UncheckoutMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void executeRequest() throws WebdavException, IOException {
        this.slideToken.setForceStoreEnlistment(true);
        try {
            try {
                VersioningHelper vh = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.getConfig());
                vh.uncheckout(this.resourcePath);
            }
            catch (PreconditionViolationException e) {
                this.sendPreconditionViolation(e);
                throw e;
            }
            catch (Exception e) {
                int statusCode = this.getErrorCode(e);
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
            Object var2_5 = null;
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            this.resp.setHeader("Cache-Control", NO_CACHE);
            throw throwable;
        }
        this.resp.setHeader("Cache-Control", NO_CACHE);
    }

    protected void parseRequest() throws WebdavException {
        this.readRequestContent();
        this.resourcePath = this.requestUri;
        if (this.resourcePath == null) {
            this.resourcePath = "/";
        }
        try {
            this.parseRequestContent();
        }
        catch (JDOMException e) {
            int statusCode = 400;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (IOException e) {
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }
}

