/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.search.BadGatewayException;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.InvalidQueryException;
import org.apache.slide.search.InvalidScopeException;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.QueryScope;
import org.apache.slide.search.RequestedResource;
import org.apache.slide.search.Search;
import org.apache.slide.search.SearchQuery;
import org.apache.slide.search.SearchQueryResult;
import org.apache.slide.search.basic.IBasicQuery;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.StructureException;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.util.ComputedPropertyProvider;
import org.apache.slide.webdav.util.PropertyHelper;
import org.apache.slide.webdav.util.PropertyRetriever;
import org.apache.slide.webdav.util.PropertyRetrieverImpl;
import org.apache.slide.webdav.util.WebdavConstants;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.util.WebdavStatus;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;

public class SearchMethod
extends AbstractWebdavMethod
implements WebdavConstants {
    private SearchQuery searchQuery = null;
    private Search searchHelper = null;
    private RequestedProperties requestedProperties = null;
    private PropertyRetriever retriever;
    protected boolean allpropIncludesDeltav = false;

    public SearchMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    private void createErrorResult(int queryStatus, String message) {
        SearchQueryResult result = new SearchQueryResult();
        result.setStatus(queryStatus);
        result.setDescription(message);
        result.setHref(this.req.getContextPath());
        try {
            WebdavResult webdavResult = new WebdavResult(result, this.retriever);
            Document responseDoc = webdavResult.getWebdavResultDocument();
            this.sendResult(responseDoc);
        }
        catch (Exception exception) {}
    }

    protected void executeRequest() throws WebdavException {
        SearchQueryResult result = null;
        try {
            this.resp.setContentType("text/xml; charset=\"UTF-8\"");
            result = this.searchHelper.search(this.slideToken, this.searchQuery);
            WebdavResult webdavResult = new WebdavResult(result, this.retriever);
            this.resp.setStatus(webdavResult.getWebdavStatus());
            Document responseDoc = webdavResult.getWebdavResultDocument();
            this.sendResult(responseDoc);
        }
        catch (StructureException structureException) {
            try {
                this.resp.sendError(404, WebdavStatus.getStatusText((int)404));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            throw new WebdavException(404);
        }
        catch (Exception e) {
            this.resp.setStatus(this.getErrorCode(e));
            throw new WebdavException(202, false);
        }
    }

    private Element getQueryElement() throws WebdavException, JDOMException {
        Element queryElement = null;
        try {
            Document document = this.parseRequestContent();
            Element rootElement = document.getRootElement();
            List children = rootElement.getChildren();
            if (children.size() > 0) {
                queryElement = (Element)children.get(0);
            }
            return queryElement;
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.resp.setStatus(500);
            throw new WebdavException(500);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseRequest() throws WebdavException {
        this.searchHelper = this.token.getSearchHelper();
        this.retriever = new PropertyRetrieverImpl(this.token, this.slideToken, this.getConfig());
        String slidePath = null;
        this.allpropIncludesDeltav = this.getBooleanInitParameter("allpropIncludesDeltav");
        if (Configuration.useSearch()) {
            try {
                Element queryElement = this.getQueryElement();
                String grammarNamespace = queryElement.getNamespaceURI();
                int maxDepth = this.getConfig().getDepthLimit();
                String serverURL = "http://" + this.req.getServerName() + ":" + this.req.getServerPort();
                this.searchQuery = this.searchHelper.createSearchQuery(grammarNamespace, queryElement, this.slideToken, maxDepth, (PropertyProvider)new ComputedPropertyProvider(this.token, this.slideToken, this.req.getContextPath(), serverURL, this.getConfig()), this.req.getRequestURI());
                this.requestedProperties = this.searchQuery.requestedProperties();
                if (!(this.searchQuery instanceof IBasicQuery)) return;
                QueryScope scope = ((IBasicQuery)this.searchQuery).getScope();
                slidePath = ((IBasicQuery)this.searchQuery).getSlidePath();
                this.token.getContentHelper().retrieve(this.slideToken, slidePath);
                scope.setIsCollection(WebdavUtils.isCollection(this.token, this.slideToken, slidePath));
                return;
            }
            catch (JDOMException e) {
                this.resp.setStatus(400);
                this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                this.createErrorResult(1, e.getMessage());
                throw new WebdavException(400);
            }
            catch (InvalidQueryException e) {
                this.resp.setStatus(422);
                this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                this.createErrorResult(4, e.getMessage());
                throw new WebdavException(422);
            }
            catch (BadGatewayException e) {
                this.resp.setStatus(502);
                this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                this.createErrorResult(5, e.getMessage());
                throw new WebdavException(502);
            }
            catch (InvalidScopeException e) {
                this.resp.setStatus(400);
                this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                this.createErrorResult(2, e.getMessage());
                throw new WebdavException(400);
            }
            catch (BadQueryException e) {
                this.resp.setStatus(400);
                this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                this.createErrorResult(1, e.getMessage());
                throw new WebdavException(400);
            }
            catch (AccessDeniedException e) {
                String contextPath = this.req.getContextPath();
                AccessDeniedException ade = new AccessDeniedException(String.valueOf(contextPath) + e.getObjectUri(), String.valueOf(contextPath) + e.getSubjectUri(), String.valueOf(contextPath) + e.getActionUri());
                String msg = ade.getMessage();
                this.resp.setStatus(403);
                this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                this.createErrorResult(6, msg);
                throw new WebdavException(403);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                this.resp.setStatus(400);
                this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                this.createErrorResult(2, "scope " + slidePath + " is invalid");
                throw new WebdavException(400);
            }
            catch (SlideException e) {
                e.printStackTrace();
                return;
            }
        } else {
            this.resp.setStatus(400);
            this.resp.setContentType("text/xml; charset=\"UTF-8\"");
            this.createErrorResult(1, "SEARCH not implemented on this server");
            throw new WebdavException(400);
        }
    }

    private void sendResult(Document responseDoc) throws JDOMException, IOException {
        XMLOutputter xmlWriter = new XMLOutputter("    ", true);
        xmlWriter.output(responseDoc, (Writer)this.resp.getWriter());
    }

    class WebdavResult {
        private SearchQueryResult queryResult;
        private Document responseDoc;
        private PropertyRetriever retriever;
        private int webdavStatus = 207;

        WebdavResult(SearchQueryResult queryResult, PropertyRetriever retriever) throws JDOMException, SlideException {
            this.queryResult = queryResult;
            this.retriever = retriever;
            this.init();
        }

        private String getStatusText(int status) {
            return "HTTP/1.1 " + status + " " + WebdavStatus.getStatusText((int)status);
        }

        Document getWebdavResultDocument() {
            return this.responseDoc;
        }

        int getWebdavStatus() {
            return this.webdavStatus;
        }

        private void init() throws JDOMException, SlideException {
            String href = null;
            int errorStatus = this.webdavStatus;
            Element rootElement = new Element("multistatus", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            this.responseDoc = new Document(rootElement);
            Iterator it = this.queryResult.iterator();
            String serverURL = "http://" + SearchMethod.this.req.getServerName() + ":" + SearchMethod.this.req.getServerPort();
            while (it.hasNext()) {
                Element responseElement = new Element("response", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                rootElement.addContent(responseElement);
                Element hrefElement = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                RequestedResource resource = (RequestedResource)it.next();
                String internalUri = resource.getUri();
                String absUri = PropertyHelper.getAbsoluteURL(serverURL, SearchMethod.this.req.getContextPath(), internalUri);
                hrefElement.addContent(absUri);
                responseElement.addContent(hrefElement);
                List propstatList = this.retriever.getPropertiesOfObject(SearchMethod.this.requestedProperties, resource, SearchMethod.this.req.getContextPath(), serverURL, SearchMethod.this.allpropIncludesDeltav);
                Iterator iterator = propstatList.iterator();
                while (iterator.hasNext()) {
                    responseElement.addContent((Element)iterator.next());
                }
            }
            int status = this.queryResult.getStatus();
            if (status != 0) {
                Object webdavStatusText = null;
                switch (status) {
                    case 1: {
                        this.webdavStatus = 400;
                        errorStatus = 400;
                        href = this.queryResult.getHref();
                        break;
                    }
                    case 2: {
                        this.webdavStatus = 400;
                        errorStatus = 404;
                        href = this.queryResult.getHref();
                        break;
                    }
                    case 3: {
                        errorStatus = 507;
                        href = SearchMethod.this.req.getContextPath();
                        break;
                    }
                    case 4: {
                        errorStatus = 422;
                        href = SearchMethod.this.req.getContextPath();
                        break;
                    }
                    case 5: {
                        errorStatus = 502;
                        href = this.queryResult.getHref();
                        break;
                    }
                    case 6: {
                        errorStatus = 403;
                        href = this.queryResult.getHref();
                        break;
                    }
                    default: {
                        throw new WebdavException(500);
                    }
                }
                Element responseElement = new Element("response", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                Element hrefElement = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                hrefElement.addContent(href);
                Element statusElement = new Element("status", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                statusElement.addContent(this.getStatusText(errorStatus));
                responseElement.addContent(hrefElement);
                responseElement.addContent(statusElement);
                String description = this.queryResult.getDescription();
                if (description != null) {
                    Element responseDescriptionElement = new Element("responsedescription", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                    responseDescriptionElement.addContent(description);
                    responseElement.addContent(responseDescriptionElement);
                }
                if (status == 2) {
                    responseElement.addContent(new Element("scopeerror", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE));
                }
                rootElement.addContent(responseElement);
            }
        }
    }
}

