/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyParseException;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.RequestedPropertiesImpl;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.RequestedResource;
import org.apache.slide.search.Search;
import org.apache.slide.search.SearchQuery;
import org.apache.slide.search.SearchQueryResult;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.PropertyHelper;
import org.apache.slide.webdav.util.PropertyRetrieverImpl;
import org.apache.slide.webdav.util.PropertySearchSetProperty;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.slide.webdav.util.XMLValue;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.apache.slide.webdav.util.resourcekind.Version;
import org.apache.slide.webdav.util.resourcekind.VersionControlled;
import org.apache.util.WebdavStatus;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class ReportMethod
extends AbstractWebdavMethod
implements DeltavConstants,
AclConstants {
    public static final String HTTP_PROTOCOL = "http://";
    public static final String HTTP_VERSION = "HTTP/1.1";
    public static final String PROPERTY_LIST = "propertylist";
    public static final String PARAM_NAME = "name";
    protected static SAXBuilder saxBuilder = null;
    protected static final int INFINITY = Integer.MAX_VALUE;
    protected Set propertySearchSet = null;
    protected String resourcePath = null;
    protected int depth = 0;
    protected RequestedProperties requestedProperties = null;
    protected Document requestContentDocument = null;
    protected String requestedReport = null;
    protected Element principalProperty = null;
    protected Element expandPropertyElement = null;
    protected XMLValue versionHistorySet = null;
    protected VersioningHelper versioningHelper = null;
    protected String serverUri = null;

    public ReportMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    private RequestedProperties createRequestedProperties(List propertyElements) throws PropertyParseException {
        Element propertyListElement = new Element(PROPERTY_LIST);
        Iterator iterator = propertyElements.iterator();
        while (iterator.hasNext()) {
            propertyListElement.addContent((Element)((Element)iterator.next()).clone());
        }
        return new RequestedPropertiesImpl(propertyListElement);
    }

    protected void executeAclMatchReport(Element parentElement, int depth) throws WebdavException, SlideException, JDOMException, IOException {
        CredentialsToken crdToken;
        String currentUri = null;
        String userID = null;
        String userpath = this.token.getNamespaceConfig().getUsersPath();
        String searchDocument = null;
        int maxDepth = 0;
        SearchQueryResult queryResult = null;
        char seperator = '/';
        boolean self = false;
        currentUri = this.req.getRequestURI();
        if (this.principalProperty.getName().equalsIgnoreCase("self")) {
            self = true;
        }
        if ((crdToken = this.slideToken.getCredentialsToken()) != null) {
            userID = crdToken.getPublicCredentials();
        }
        if (userID != null && !userpath.endsWith("/")) {
            userpath = String.valueOf(userpath) + "/";
        }
        String currentUser = new String(String.valueOf(userpath) + userID);
        if (self) {
            int i = 0;
            while (i < currentUser.length()) {
                if (currentUser.charAt(i) == seperator) {
                    ++maxDepth;
                }
                ++i;
            }
        } else {
            maxDepth = depth;
        }
        searchDocument = self ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?><searchrequest xmlns:D=\"DAV:\"><D:basicsearch><D:select><D:prop><D:displayname/></D:prop></D:select><D:from><D:scope><D:href>" + currentUri + "</D:href></D:scope></D:from>" + "<D:where><is-principal xmlns=\"http://jakarta.apache.org/slide/\"/></D:where>" + "</D:basicsearch></searchrequest>" : "<?xml version=\"1.0\" encoding=\"UTF-8\"?><searchrequest xmlns:D=\"DAV:\"><D:basicsearch><D:select><D:prop><D:displayname/></D:prop></D:select><D:from><D:scope><D:href>" + currentUri + "</D:href></D:scope></D:from>" + "</D:basicsearch></searchrequest>";
        queryResult = this.searchPrincipal(searchDocument, maxDepth);
        Iterator it = queryResult.iterator();
        if (!it.hasNext()) {
            this.resp.setStatus(404);
            WebdavException we = new WebdavException(404);
        }
        while (it.hasNext()) {
            String uri = null;
            RequestedResource resource = (RequestedResource)it.next();
            String currentIntUrl = resource.getUri();
            uri = resource.getUri();
            if (!self) {
                try {
                    if (this.principalProperty.getName().equalsIgnoreCase("owner")) {
                        NodeProperty owner = resource.getProperty("owner", "DAV:");
                        uri = owner != null ? (String)owner.getValue() : null;
                        if (uri != null) {
                            if (!userpath.endsWith("/")) {
                                userpath = String.valueOf(userpath) + "/";
                            }
                            if (uri.startsWith("/")) {
                                uri = uri.substring(1);
                            }
                            uri = new String(String.valueOf(userpath) + uri);
                        } else {
                            uri = new String(userpath);
                        }
                    } else {
                        NodeProperty prop = resource.getProperty(this.principalProperty.getName(), this.principalProperty.getNamespaceURI());
                        uri = prop != null ? (String)prop.getValue() : null;
                    }
                }
                catch (Exception exception) {}
            }
            if (uri == null || !currentUser.startsWith(uri) || !currentUser.startsWith(uri)) continue;
            this.getPropertiesForResponse(currentIntUrl, parentElement);
        }
    }

    protected void executeAclPrincipalReport(String requestUri, Element parentElement) throws WebdavException, ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, JDOMException {
        NodeRevisionDescriptors revisionDescriptors = null;
        NodeRevisionDescriptor revisionDescriptor = null;
        NodeRevisionNumber revisionNumber = null;
        PropertyRetrieverImpl retriever = new PropertyRetrieverImpl(this.token, this.slideToken, this.getConfig());
        String serverURL = HTTP_PROTOCOL + this.req.getServerName() + ":" + this.req.getServerPort();
        List propstatList = null;
        Element aclprops = null;
        Element aclpropstat = null;
        Element acl = null;
        List aces = null;
        HashSet<String> principals = new HashSet<String>();
        Element aclproperty = new Element("property", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        aclproperty.setAttribute(PARAM_NAME, "acl");
        Element prop = new Element("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        prop.addContent(aclproperty);
        RequestedPropertiesImpl reqProperties = null;
        try {
            reqProperties = new RequestedPropertiesImpl(prop);
        }
        catch (PropertyParseException e) {
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        try {
            revisionDescriptors = this.content.retrieve(this.slideToken, this.resourcePath);
            try {
                revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors);
            }
            catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {
                revisionDescriptor = new NodeRevisionDescriptor(0L);
                String resourceName = requestUri;
                int lastSlash = resourceName.lastIndexOf(47);
                if (lastSlash != -1) {
                    resourceName = resourceName.substring(lastSlash + 1);
                }
                revisionDescriptor.setName(resourceName);
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            if (revisionDescriptor == null) {
                revisionDescriptor = new NodeRevisionDescriptor(0L);
            }
        }
        catch (ObjectNotFoundException e) {
            int statusCode = 404;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (Exception e) {
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        try {
            propstatList = retriever.getPropertiesOfObject((RequestedProperties)reqProperties, revisionDescriptors, revisionDescriptor, this.req.getContextPath(), serverURL, true);
        }
        catch (SlideException e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        if (propstatList.size() != 1) {
            int statusCode = 400;
            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".invalidNumberOfElements", new Object[]{propstatList, "2"});
            throw new WebdavException(statusCode);
        }
        Iterator iterator = propstatList.iterator();
        aclpropstat = (Element)iterator.next();
        aclprops = aclpropstat.getChild("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        if (aclprops == null) {
            return;
        }
        acl = aclprops.getChild("acl", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        if (aclprops == null) {
            return;
        }
        acl = aclprops.getChild("acl", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        aces = acl.getChildren("ace", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        Iterator aceIter = aces.iterator();
        Element current = null;
        while (aceIter.hasNext()) {
            current = ((Element)aceIter.next()).getChild("principal", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE).getChild("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            if (current == null) continue;
            principals.add(current.getText());
        }
        Iterator principalIter = principals.iterator();
        while (principalIter.hasNext()) {
            String principalUrl = ((String)principalIter.next()).substring(this.token.getNamespaceConfig().toString().length() + 1);
            Element response = this.getResponseElement(principalUrl, revisionDescriptors, revisionNumber, this.slideToken, principalUrl, this.requestedProperties);
            parentElement.addContent(response);
        }
    }

    protected void executeAclPrincipalReport(String requestUri, Element parentElement, int depth) throws WebdavException, ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, JDOMException {
        if (depth < 0) {
            return;
        }
        this.executeAclPrincipalReport(requestUri, parentElement);
        ObjectNode onode = this.structure.retrieve(this.slideToken, requestUri);
        Enumeration childrenEnum = this.structure.getChildren(this.slideToken, onode);
        while (childrenEnum.hasMoreElements()) {
            ObjectNode cnode = (ObjectNode)childrenEnum.nextElement();
            this.executeAclPrincipalReport(cnode.getUri(), parentElement, depth - 1);
        }
    }

    protected void executeExpandPropertyReport(String requestUri, Element parentElement, int depth) throws WebdavException, ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, JDOMException {
        List requestedPropertyElementList = this.expandPropertyElement.getChildren("property", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        this.writeExpandPropertyReport(requestUri, parentElement, requestedPropertyElementList, depth);
    }

    protected void executeLocateByHistoryReport(String requestUri, Element parentElement, int depth) throws WebdavException, ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, JDOMException, PreconditionViolationException, SlideException {
        if (!WebdavUtils.isCollection(this.token, this.slideToken, requestUri)) {
            int statusCode = 400;
            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".mustBeCollection");
            throw new WebdavException(statusCode);
        }
        Iterator iterator = this.versionHistorySet.iterator();
        UriHandler uriHandler = null;
        String href = null;
        boolean isVersionHistory = true;
        while (iterator.hasNext()) {
            href = ((Element)iterator.next()).getText();
            if (href == null) {
                isVersionHistory = false;
            } else {
                uriHandler = UriHandler.getUriHandler(this.getSlidePath(href));
                isVersionHistory = uriHandler.isHistoryUri();
            }
            if (isVersionHistory) continue;
            throw new PreconditionViolationException(new ViolatedPrecondition("must-be-version-history", 409), requestUri);
        }
        this.writeLocateByHistoryReport(requestUri, parentElement, depth);
    }

    protected Element executePrincipalSearchPropertyReport(int depth) throws WebdavException, SlideException, JDOMException, IOException {
        Element parentElement = new Element("multistatus", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        SearchQueryResult queryResult = null;
        Iterator searchPropIter = null;
        Element currentSearchProperty = null;
        String currentUri = this.req.getRequestURI();
        searchPropIter = this.propertySearchSet.iterator();
        HashSet<String> principalCollectionSet = new HashSet<String>();
        Object searchReq = null;
        String whereElement = null;
        Element principalCollectionSetElement = new Element("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        principalCollectionSetElement.addContent(new Element("principal-collection-set", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE));
        RequestedPropertiesImpl collectionSetProp = new RequestedPropertiesImpl(principalCollectionSetElement);
        List collectionSets = this.retrieveProperties(this.requestUri, (RequestedProperties)collectionSetProp);
        Iterator collectionSetsIter = collectionSets.iterator();
        while (collectionSetsIter.hasNext()) {
            Element currentPrincipalCollection = (Element)collectionSetsIter.next();
            List currentProps = currentPrincipalCollection.getChildren();
            Iterator currentPropsIter = currentProps.iterator();
            while (currentPropsIter.hasNext()) {
                Element currentProp = (Element)currentPropsIter.next();
                if (currentProp.getName() != "prop") continue;
                List currentCollectioSets = currentProp.getChildren();
                if (currentCollectioSets.size() == 1) {
                    Element currentCollectioSet = (Element)currentCollectioSets.get(0);
                    List currentHrefs = currentCollectioSet.getChildren();
                    Iterator currentHrefsIter = currentHrefs.iterator();
                    while (currentHrefsIter.hasNext()) {
                        Element currentHref = (Element)currentHrefsIter.next();
                        principalCollectionSet.add("<D:from><D:scope><D:href>" + currentHref.getText() + "</D:href></D:scope></D:from>");
                    }
                    continue;
                }
                int statusCode = 400;
                this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".invalidNumberOfElements", new Object[]{currentCollectioSets, "1"});
                throw new WebdavException(statusCode);
            }
        }
        whereElement = "<D:where><D:and>";
        while (searchPropIter.hasNext()) {
            String currentSearchPropertyName = null;
            String currentSearchPropertyNamespace = null;
            String currentSearchLiteral = null;
            currentSearchProperty = (Element)searchPropIter.next();
            List currentPropertyChildren = currentSearchProperty.getChildren();
            Iterator currentChildListIter = currentPropertyChildren.iterator();
            while (currentChildListIter.hasNext()) {
                Element element = (Element)currentChildListIter.next();
                if ("prop".equals(element.getName()) && currentSearchPropertyName == null) {
                    List props = element.getChildren();
                    if (props.size() != 1) {
                        int statusCode = 400;
                        this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".invalidNumberOfChildren", new Object[]{String.valueOf(String.valueOf(element.getNamespace())) + ":" + element.getName(), "1"});
                        throw new WebdavException(statusCode);
                    }
                    Element currentPropertyElement = (Element)props.get(0);
                    currentSearchPropertyNamespace = currentPropertyElement.getNamespace().getURI();
                    currentSearchPropertyName = currentSearchPropertyNamespace.equals("DAV:") ? "<D:prop><D:" + currentPropertyElement.getName() + "/>" + "</D:prop>" : "<D:prop xmlns:Y=\"" + currentSearchPropertyNamespace + "\">" + "<" + "Y:" + currentPropertyElement.getName() + "/>" + "</D:prop>";
                    if (PropertySearchSetProperty.inSearchPropertySet(currentPropertyElement.getName(), currentSearchPropertyNamespace)) continue;
                    parentElement = new Element("non-searchable-property", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                    parentElement.addContent((Element)element.clone());
                    this.resp.setStatus(403);
                    return parentElement;
                }
                if ("allprop".equals(element.getName())) {
                    parentElement = new Element("non-searchable-property", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                    parentElement.addContent((Element)element.clone());
                    this.resp.setStatus(403);
                    return parentElement;
                }
                if ("caseless-substring".equals(element.getName())) {
                    currentSearchLiteral = "<D:literal>" + element.getText() + "</D:literal>";
                    continue;
                }
                if ("substring".equals(element.getName())) {
                    int statusCode = 501;
                    this.sendError(statusCode);
                    throw new WebdavException(statusCode);
                }
                int statusCode = 400;
                this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".invalidChildOfElement", new Object[]{String.valueOf(String.valueOf(element.getNamespace())) + ":" + element.getName(), String.valueOf(String.valueOf(currentSearchProperty.getNamespace())) + ":" + currentSearchProperty.getName()});
                throw new WebdavException(statusCode);
            }
            if (currentSearchLiteral == null || currentSearchPropertyName == null) {
                int statusCode = 400;
                this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".searchRequirementsIncomplete", new Object[]{currentSearchProperty});
                throw new WebdavException(statusCode);
            }
            whereElement = String.valueOf(whereElement) + "<X:propcontains xmlns:X=\"http://jakarta.apache.org/slide/\">" + currentSearchPropertyName + currentSearchLiteral + "</X:propcontains>";
        }
        whereElement = String.valueOf(whereElement) + "</D:and></D:where>";
        Iterator principalCollectionSetIter = principalCollectionSet.iterator();
        while (principalCollectionSetIter.hasNext()) {
            String searchDocument = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><searchrequest xmlns:D=\"DAV:\"><D:basicsearch><D:select><D:prop><D:displayname/></D:prop></D:select>" + (String)principalCollectionSetIter.next() + whereElement + "</D:basicsearch></searchrequest>";
            queryResult = this.searchPrincipal(searchDocument, depth);
            Iterator it = queryResult.iterator();
            while (it.hasNext()) {
                String uri = null;
                RequestedResource resource = (RequestedResource)it.next();
                String currentIntUrl = resource.getUri();
                uri = resource.getUri();
                if (uri == null) continue;
                this.getPropertiesForResponse(currentIntUrl, parentElement);
            }
        }
        return parentElement;
    }

    protected void executePrincipalSearchPropertySetReport(String requestUri, Element parentElement) throws WebdavException, ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, JDOMException {
        Iterator propertiesIter = PropertySearchSetProperty.getPropertySetIterator();
        PropertySearchSetProperty currentProperty = null;
        while (propertiesIter.hasNext()) {
            currentProperty = (PropertySearchSetProperty)propertiesIter.next();
            Element searchProp = new Element("principal-search-property", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            Element prop = new Element("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            Element propContent = new Element(currentProperty.getPropertyName(), currentProperty.getNamespace());
            Element description = new Element("description", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            Attribute lang = new Attribute("xml:lang", "en");
            description.setAttribute(lang);
            description.addContent(currentProperty.getDescription());
            prop.addContent(propContent);
            searchProp.addContent(prop);
            searchProp.addContent(description);
            parentElement.addContent(searchProp);
        }
    }

    protected void executeRequest() throws WebdavException, IOException {
        this.getResponse().setContentType("text/xml; charset=\"UTF-8\"");
        Element resultElement = null;
        try {
            if ("version-tree".equals(this.requestedReport)) {
                resultElement = new Element("multistatus", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                this.getResponse().setStatus(207);
                this.executeVersionTreeReport(this.requestUri, resultElement, this.getDepth());
            } else if ("expand-property".equals(this.requestedReport)) {
                resultElement = new Element("multistatus", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                this.getResponse().setStatus(207);
                this.executeExpandPropertyReport(this.requestUri, resultElement, this.getDepth());
            } else if ("acl-principal-prop-set".equals(this.requestedReport)) {
                resultElement = new Element("multistatus", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                this.getResponse().setStatus(207);
                this.executeAclPrincipalReport(this.requestUri, resultElement, this.getDepth());
            } else if ("principal-match".equals(this.requestedReport)) {
                resultElement = new Element("multistatus", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                this.getResponse().setStatus(207);
                this.executeAclMatchReport(resultElement, this.getDepth());
            } else if ("principal-search-property-set".equals(this.requestedReport)) {
                resultElement = new Element("principal-search-property-set", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                this.getResponse().setStatus(200);
                this.executePrincipalSearchPropertySetReport(this.requestUri, resultElement);
            } else if ("principal-property-search".equals(this.requestedReport)) {
                this.getResponse().setStatus(200);
                resultElement = this.executePrincipalSearchPropertyReport(this.getDepth());
            } else if ("locate-by-history".equals(this.requestedReport)) {
                resultElement = new Element("multistatus", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                this.getResponse().setStatus(207);
                this.executeLocateByHistoryReport(this.requestUri, resultElement, this.getDepth());
            }
            new XMLOutputter("    ", true).output(new Document(resultElement), (Writer)this.getResponse().getWriter());
        }
        catch (PreconditionViolationException e) {
            this.sendPreconditionViolation(e);
            throw e;
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    protected void executeVersionTreeReport(String requestUri, Element parentElement) throws WebdavException, SlideException, JDOMException {
        NodeRevisionDescriptor revisionDescriptor;
        NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.slideToken, requestUri);
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.token, revisionDescriptors, revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors));
        if (resourceKind instanceof VersionControlled) {
            requestUri = this.versioningHelper.getUriOfAssociatedVR(requestUri);
            revisionDescriptors = this.content.retrieve(this.slideToken, requestUri);
            revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors);
            resourceKind = AbstractResourceKind.determineResourceKind(this.token, revisionDescriptors, revisionDescriptor);
        }
        try {
            if (Configuration.useVersionControl() && resourceKind instanceof Version) {
                this.writeVersionTreeReport(revisionDescriptors, revisionDescriptor, this.slideToken, requestUri, parentElement);
            } else {
                parentElement.addContent(this.getErrorResponse(requestUri, 403, "supported-report"));
            }
        }
        catch (SlideException e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    protected void executeVersionTreeReport(String requestUri, Element parentElement, int depth) throws WebdavException, SlideException, JDOMException {
        if (depth < 0) {
            return;
        }
        this.executeVersionTreeReport(requestUri, parentElement);
        ObjectNode onode = this.structure.retrieve(this.slideToken, requestUri);
        Enumeration childrenEnum = this.structure.getChildren(this.slideToken, onode);
        while (childrenEnum.hasMoreElements()) {
            ObjectNode cnode = (ObjectNode)childrenEnum.nextElement();
            this.executeVersionTreeReport(cnode.getUri(), parentElement, depth - 1);
        }
    }

    protected int getDepth() {
        return this.depth;
    }

    public static String getElementValue(String elementString) {
        String text = null;
        try {
            Document document = ReportMethod.getSAXBuilder().build((Reader)new StringReader(elementString));
            text = document.getRootElement().getText();
        }
        catch (JDOMException jDOMException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return text;
    }

    private Element getErrorResponse(String requestUri, int errorCode, String condition) {
        Element response = new Element("response", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        Element href = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        href.setText(PropertyHelper.getAbsoluteURL(this.serverUri, this.getRequest().getContextPath(), requestUri));
        response.addContent(href);
        Element propStat = new Element("propstat", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        response.addContent(propStat);
        Element status = new Element("status", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        status.setText("HTTP/1.1 " + errorCode + " " + WebdavStatus.getStatusText((int)errorCode));
        propStat.addContent(status);
        if (condition != null) {
            Element responseDescriptiont = new Element("responsedescription", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            Element errorElement = new Element("error", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            responseDescriptiont.addContent(errorElement);
            Element conditionElement = new Element(condition, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            errorElement.addContent(conditionElement);
            propStat.addContent(responseDescriptiont);
        }
        return response;
    }

    private String getHistoryUriOfVCR(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor) {
        String historyUri;
        block4: {
            historyUri = null;
            NodeProperty property = revisionDescriptor.getProperty("checked-in");
            if (property == null) {
                property = revisionDescriptor.getProperty("checked-out");
            }
            if (property == null || property.getValue() == null) break block4;
            try {
                String vrUri;
                UriHandler uriHandler;
                XMLValue xmlValue = new XMLValue(property.getValue().toString());
                Iterator iterator = xmlValue.iterator();
                if (iterator.hasNext() && (uriHandler = UriHandler.getUriHandler(vrUri = ((Element)iterator.next()).getText())).isVersionUri()) {
                    historyUri = uriHandler.getAssociatedHistoryUri();
                }
            }
            catch (JDOMException jDOMException) {}
        }
        return historyUri;
    }

    public NamespaceAccessToken getNamespaceAccessToken() {
        return this.token;
    }

    protected void getPropertiesForResponse(String currentIntUrl, Element parentElement) throws WebdavException, SlideException, JDOMException {
        List propList = null;
        String serverURL = HTTP_PROTOCOL + this.req.getServerName() + ":" + this.req.getServerPort();
        PropertyRetrieverImpl retriever = new PropertyRetrieverImpl(this.token, this.slideToken, this.getConfig());
        Element responseElement = new Element("response", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        parentElement.addContent(responseElement);
        Element hrefElement = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        hrefElement.addContent(PropertyHelper.getAbsoluteURL(serverURL, this.req.getContextPath(), currentIntUrl));
        responseElement.addContent(hrefElement);
        if (this.requestedProperties != null) {
            propList = this.retrieveProperties(currentIntUrl, this.requestedProperties);
            Iterator iterator = propList.iterator();
            while (iterator.hasNext()) {
                responseElement.addContent((Element)iterator.next());
            }
        } else {
            Element statusElement = new Element("status", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            statusElement.addContent("HTTP/1.1 200 " + WebdavStatus.getStatusText((int)200));
            responseElement.addContent(statusElement);
        }
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    protected RequestedProperties getRequestedVersionTreeProperties() {
        if (this.requestedProperties == null) {
            this.requestedProperties = new RequestedPropertiesImpl();
        }
        return this.requestedProperties;
    }

    protected String getResourcePath() {
        return this.resourcePath;
    }

    public HttpServletResponse getResponse() {
        return this.resp;
    }

    private Element getResponseElement(String slideUri, NodeRevisionDescriptors revisionDescriptors, NodeRevisionNumber revisionNumber, SlideToken slideToken, String requestUri, RequestedProperties requestedProperties) throws JDOMException {
        Element response = new Element("response", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        Element href = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        String serverURL = HTTP_PROTOCOL + this.req.getServerName() + ":" + this.req.getServerPort();
        href.setText(PropertyHelper.getAbsoluteURL(this.serverUri, this.req.getContextPath(), requestUri));
        response.addContent(href);
        PropertyRetrieverImpl retriever = new PropertyRetrieverImpl(this.token, slideToken, this.getConfig());
        try {
            List propstatList = retriever.getPropertiesOfObject(requestedProperties, slideUri, revisionNumber, this.req.getContextPath(), serverURL, true);
            Iterator iterator = propstatList.iterator();
            while (iterator.hasNext()) {
                response.addContent((Element)iterator.next());
            }
        }
        catch (Exception e) {
            response = this.getErrorResponse(requestUri, this.getErrorCode(e), null);
        }
        return response;
    }

    private Element getResponseElement(String slideUri, RequestedResource requestedResource, SlideToken slideToken, String requestUri, RequestedProperties requestedProperties) throws JDOMException {
        Element response = new Element("response", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        Element href = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        String serverURL = HTTP_PROTOCOL + this.req.getServerName() + ":" + this.req.getServerPort();
        href.setText(PropertyHelper.getAbsoluteURL(this.serverUri, this.req.getContextPath(), requestUri));
        response.addContent(href);
        PropertyRetrieverImpl retriever = new PropertyRetrieverImpl(this.token, slideToken, this.getConfig());
        try {
            List propstatList = retriever.getPropertiesOfObject(requestedProperties, requestedResource, this.req.getContextPath(), serverURL, true);
            Iterator iterator = propstatList.iterator();
            while (iterator.hasNext()) {
                response.addContent((Element)iterator.next());
            }
        }
        catch (Exception e) {
            response = this.getErrorResponse(requestUri, this.getErrorCode(e), null);
        }
        return response;
    }

    protected static SAXBuilder getSAXBuilder() {
        if (saxBuilder == null) {
            saxBuilder = new SAXBuilder();
        }
        return saxBuilder;
    }

    protected String getStatusText(Exception exception) {
        String status = null;
        if (exception instanceof WebdavException) {
            status = WebdavStatus.getStatusText((int)((WebdavException)((Object)exception)).getStatusCode());
        }
        return status;
    }

    protected void parseACLRequest(Element aclElement) throws WebdavException, PropertyParseException {
        List childrenList = aclElement.getChildren();
        if (childrenList.size() == 0) {
            int statusCode = 400;
            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".missingRootElementChildren", new Object[]{String.valueOf(String.valueOf(aclElement.getNamespace())) + ":" + aclElement.getName()});
            throw new WebdavException(statusCode);
        }
        Element element = (Element)childrenList.get(0);
        if (!"allprop".equals(element.getName()) && !"prop".equals(element.getName())) {
            int statusCode = 400;
            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".invalidChildOfRootElement", new Object[]{String.valueOf(String.valueOf(aclElement.getNamespace())) + ":" + aclElement.getName(), String.valueOf(String.valueOf(element.getNamespace())) + ":" + element.getName()});
            throw new WebdavException(statusCode);
        }
        this.requestedProperties = new RequestedPropertiesImpl(element);
    }

    protected void parseExpandPropertyRequest(Element expandPropertyElement) throws WebdavException, PropertyParseException {
        this.expandPropertyElement = expandPropertyElement;
    }

    protected void parseLocateByHistoryRequest(Element locateByHistoryElement) throws WebdavException, PropertyParseException {
        List childrenList = locateByHistoryElement.getChildren();
        if (childrenList.size() != 2) {
            int statusCode = 400;
            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".invalidNumberOfChildren", new Object[]{String.valueOf(String.valueOf(locateByHistoryElement.getNamespace())) + ":" + locateByHistoryElement.getName(), "2"});
            throw new WebdavException(statusCode);
        }
        Element versionHistorySetElement = null;
        Element propElement = null;
        if ("version-history-set".equals(((Element)childrenList.get(0)).getName()) && "prop".equals(((Element)childrenList.get(1)).getName())) {
            versionHistorySetElement = (Element)childrenList.get(0);
            propElement = (Element)childrenList.get(1);
        } else if ("prop".equals(((Element)childrenList.get(0)).getName()) && "version-history-set".equals(((Element)childrenList.get(1)).getName())) {
            propElement = (Element)childrenList.get(0);
            versionHistorySetElement = (Element)childrenList.get(1);
        } else {
            int statusCode = 400;
            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".invalidChildOfRootElement", new Object[]{childrenList, String.valueOf(String.valueOf(locateByHistoryElement.getNamespace())) + ":" + locateByHistoryElement.getName()});
            throw new WebdavException(statusCode);
        }
        childrenList = versionHistorySetElement.getChildren();
        this.versionHistorySet = new XMLValue(childrenList);
        Iterator iterator = this.versionHistorySet.iterator();
        while (iterator.hasNext()) {
            if ("href".equals(((Element)iterator.next()).getName())) continue;
            int statusCode = 400;
            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".invalidChildOfElement", new Object[]{childrenList, String.valueOf(String.valueOf(versionHistorySetElement.getNamespace())) + ":" + versionHistorySetElement.getName()});
            throw new WebdavException(statusCode);
        }
        this.requestedProperties = new RequestedPropertiesImpl(propElement);
    }

    protected void parsePrincipalMatchRequest(Element aclElement) throws WebdavException, PropertyParseException {
        List childrenList = aclElement.getChildren();
        Iterator childListIter = null;
        if (childrenList.size() == 0) {
            int statusCode = 400;
            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".missingRootElementChildren", new Object[]{String.valueOf(String.valueOf(aclElement.getNamespace())) + ":" + aclElement.getName()});
            throw new WebdavException(statusCode);
        }
        childListIter = childrenList.iterator();
        while (childListIter.hasNext()) {
            Element element = (Element)childListIter.next();
            if ("principal-property".equals(element.getName()) && this.principalProperty == null) {
                List props = element.getChildren();
                if (props.size() != 1) {
                    int statusCode = 400;
                    this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".invalidNumberOfChildren", new Object[]{String.valueOf(String.valueOf(element.getNamespace())) + ":" + element.getName(), "1"});
                    throw new WebdavException(statusCode);
                }
                this.principalProperty = (Element)props.get(0);
                continue;
            }
            if ("self".equals(element.getName()) && this.principalProperty == null) {
                this.principalProperty = element;
                continue;
            }
            if (("allprop".equals(element.getName()) || "prop".equals(element.getName())) && this.requestedProperties == null) {
                this.requestedProperties = new RequestedPropertiesImpl(element);
                continue;
            }
            int statusCode = 400;
            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".invalidChildOfRootElement", new Object[]{String.valueOf(String.valueOf(aclElement.getNamespace())) + ":" + aclElement.getName(), String.valueOf(String.valueOf(element.getNamespace())) + ":" + element.getName()});
            throw new WebdavException(statusCode);
        }
        if (this.principalProperty == null) {
            int statusCode = 400;
            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".missingPrincipalProperty");
            throw new WebdavException(statusCode);
        }
    }

    protected void parsePrincipalSearchRequest(Element aclElement) throws WebdavException, PropertyParseException {
        List childrenList = aclElement.getChildren();
        Iterator childListIter = null;
        if (childrenList.size() == 0) {
            int statusCode = 400;
            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".missingRootElementChildren", new Object[]{String.valueOf(String.valueOf(aclElement.getNamespace())) + ":" + aclElement.getName()});
            throw new WebdavException(statusCode);
        }
        childListIter = childrenList.iterator();
        while (childListIter.hasNext()) {
            Element element = (Element)childListIter.next();
            if ("property-search".equals(element.getName()) && this.principalProperty == null) {
                if (this.propertySearchSet == null) {
                    this.propertySearchSet = new HashSet();
                }
                this.propertySearchSet.add(element);
                continue;
            }
            if (("allprop".equals(element.getName()) || "prop".equals(element.getName())) && this.requestedProperties == null) {
                this.requestedProperties = new RequestedPropertiesImpl(element);
                continue;
            }
            int statusCode = 400;
            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".invalidChildOfRootElement", new Object[]{String.valueOf(String.valueOf(aclElement.getNamespace())) + ":" + aclElement.getName(), String.valueOf(String.valueOf(element.getNamespace())) + ":" + element.getName()});
            throw new WebdavException(statusCode);
        }
        if (this.propertySearchSet == null) {
            int statusCode = 400;
            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".missingPropertySearchSet");
            throw new WebdavException(statusCode);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void parseRequest() throws WebdavException {
        block17: {
            this.versioningHelper = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.config);
            this.retrieveResourcePath();
            this.retrieveDepth();
            this.serverUri = HTTP_PROTOCOL + this.req.getServerName() + ":" + this.req.getServerPort();
            try {
                Document content = this.parseRequestContent();
                Element element = content.getRootElement();
                if (element == null) {
                    int statusCode = 400;
                    this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".missingRootElement");
                    throw new WebdavException(statusCode);
                }
                if (element.getName().equalsIgnoreCase("version-tree")) {
                    this.requestedReport = "version-tree";
                    this.parseVersionTreeRequest(element);
                    break block17;
                }
                if (element.getName().equalsIgnoreCase("expand-property")) {
                    this.requestedReport = "expand-property";
                    this.parseExpandPropertyRequest(element);
                    break block17;
                }
                if (element.getName().equalsIgnoreCase("acl-principal-prop-set")) {
                    this.requestedReport = "acl-principal-prop-set";
                    this.parseACLRequest(element);
                    break block17;
                }
                if (element.getName().equalsIgnoreCase("principal-match")) {
                    this.requestedReport = "principal-match";
                    this.parsePrincipalMatchRequest(element);
                    break block17;
                }
                if (element.getName().equalsIgnoreCase("principal-property-search")) {
                    this.requestedReport = "principal-property-search";
                    this.parsePrincipalSearchRequest(element);
                    break block17;
                }
                if (element.getName().equalsIgnoreCase("principal-search-property-set")) {
                    this.requestedReport = "principal-search-property-set";
                    break block17;
                }
                if (element.getName().equalsIgnoreCase("locate-by-history")) {
                    this.requestedReport = "locate-by-history";
                    this.parseLocateByHistoryRequest(element);
                    break block17;
                }
                int statusCode = 400;
                this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".invalidRootElement", new Object[]{element});
                throw new WebdavException(statusCode);
            }
            catch (JDOMException e) {
                int statusCode = 400;
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
            catch (PropertyParseException e) {
                int statusCode = 400;
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
            catch (IOException e) {
                int statusCode = 500;
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
            catch (WebdavException e) {
                void content;
                ((Throwable)((Object)e)).printStackTrace();
                String statusText = this.getStatusText((Exception)((Object)e));
                try {
                    if (statusText != null) {
                        this.resp.sendError(e.getStatusCode(), statusText);
                    } else {
                        this.resp.sendError(e.getStatusCode());
                    }
                }
                catch (IOException iOException) {}
                throw content;
            }
        }
    }

    protected void parseVersionTreeRequest(Element versionTreeElement) throws WebdavException, PropertyParseException {
        List childrenList = versionTreeElement.getChildren();
        if (childrenList.size() == 0) {
            int statusCode = 400;
            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".missingRootElementChildren", new Object[]{String.valueOf(String.valueOf(versionTreeElement.getNamespace())) + ":" + versionTreeElement.getName()});
            throw new WebdavException(statusCode);
        }
        Element element = (Element)childrenList.get(0);
        if (!"allprop".equals(element.getName()) && !"prop".equals(element.getName())) {
            int statusCode = 400;
            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".invalidChildOfRootElement", new Object[]{String.valueOf(String.valueOf(element.getNamespace())) + ":" + element.getName(), String.valueOf(String.valueOf(versionTreeElement.getNamespace())) + ":" + versionTreeElement.getName()});
            throw new WebdavException(statusCode);
        }
        this.requestedProperties = new RequestedPropertiesImpl(element);
    }

    protected void retrieveDepth() {
        String depthStr = this.req.getHeader("Depth");
        this.depth = depthStr == null ? 0 : (depthStr.equals("1") ? 1 : (depthStr.equalsIgnoreCase("infinity") ? Integer.MAX_VALUE : 0));
        if (this.depth > this.getConfig().getDepthLimit()) {
            this.depth = this.getConfig().getDepthLimit();
        }
    }

    protected List retrieveProperties(String currentIntUrl, RequestedProperties reqProperties) throws WebdavException, SlideException, JDOMException {
        List propList = null;
        String serverURL = HTTP_PROTOCOL + this.req.getServerName() + ":" + this.req.getServerPort();
        PropertyRetrieverImpl retriever = new PropertyRetrieverImpl(this.token, this.slideToken, this.getConfig());
        try {
            propList = retriever.getPropertiesOfObject(reqProperties, currentIntUrl, this.req.getContextPath(), serverURL, true);
        }
        catch (LockTokenNotFoundException e) {
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        return propList;
    }

    protected void retrieveResourcePath() {
        this.resourcePath = this.requestUri;
        if (this.resourcePath == null) {
            this.resourcePath = "/";
        }
    }

    protected SearchQueryResult searchPrincipal(String searchDocument, int depth) throws WebdavException, SlideException, JDOMException, IOException {
        Element rootElement = null;
        Document parseDoc = null;
        Element queryElement = null;
        Search searchHelper = null;
        String grammarNamespace = null;
        SearchQuery searchQuery = null;
        SearchQueryResult queryResult = null;
        parseDoc = ReportMethod.getSAXBuilder().build((Reader)new StringReader(searchDocument));
        rootElement = parseDoc.getRootElement();
        List childrenList = rootElement.getChildren();
        if (childrenList.size() > 0) {
            queryElement = (Element)childrenList.get(0);
        }
        grammarNamespace = queryElement.getNamespaceURI();
        searchHelper = this.token.getSearchHelper();
        try {
            searchQuery = searchHelper.createSearchQuery(grammarNamespace, queryElement, this.slideToken, depth, this.req.getRequestURI());
        }
        catch (BadQueryException e) {
            int statusCode = 400;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        queryResult = searchHelper.search(this.slideToken, searchQuery);
        return queryResult;
    }

    protected void writeExpandPropertyReport(String requestUri, Element parentElement, List requestedPropertyElementList) throws WebdavException, ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, JDOMException {
        try {
            NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.slideToken, requestUri);
            NodeRevisionDescriptor revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors);
            ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.token, revisionDescriptors, revisionDescriptor);
            PropertyRetrieverImpl retriever = new PropertyRetrieverImpl(this.token, this.slideToken, this.getConfig());
            Element response = this.getResponseElement(requestUri, revisionDescriptors, revisionDescriptor.getRevisionNumber(), this.slideToken, requestUri, this.createRequestedProperties(requestedPropertyElementList));
            parentElement.addContent(response);
            Iterator iterator = requestedPropertyElementList.iterator();
            while (iterator.hasNext()) {
                Element propertyElement = (Element)iterator.next();
                List childPropertyList = propertyElement.getChildren();
                if (childPropertyList.size() <= 0) continue;
                try {
                    Element hrefElement = response.getChild("propstat", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE).getChild("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE).getChild(propertyElement.getAttribute(PARAM_NAME).getValue(), NodeProperty.NamespaceCache.DEFAULT_NAMESPACE).getChild("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                    if (hrefElement.getText() == null) continue;
                    this.writeExpandPropertyReport(this.getSlidePath(hrefElement.getText()), hrefElement.getParent(), childPropertyList);
                    hrefElement.getParent().removeContent(hrefElement);
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        catch (Exception e) {
            parentElement.addContent(this.getErrorResponse(requestUri, this.getErrorCode(e), null));
        }
    }

    protected void writeExpandPropertyReport(String requestUri, Element parentElement, List requestedPropertyElementList, int depth) throws WebdavException, ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, JDOMException {
        if (depth < 0) {
            return;
        }
        this.writeExpandPropertyReport(requestUri, parentElement, requestedPropertyElementList);
        ObjectNode onode = this.structure.retrieve(this.slideToken, requestUri);
        Enumeration childrenEnum = this.structure.getChildren(this.slideToken, onode);
        while (childrenEnum.hasMoreElements()) {
            ObjectNode cnode = (ObjectNode)childrenEnum.nextElement();
            this.writeExpandPropertyReport(cnode.getUri(), parentElement, requestedPropertyElementList, depth - 1);
        }
    }

    protected void writeLocateByHistoryReport(String collectionUri, Element parentElement, int depth) throws WebdavException, ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, JDOMException, SlideException {
        if (depth < 0) {
            return;
        }
        NodeRevisionDescriptor revisionDescriptor = null;
        NodeRevisionDescriptors revisionDescriptors = null;
        ResourceKind resourceKind = null;
        String versionHistoryUri = null;
        ObjectNode collectionNode = this.structure.retrieve(this.slideToken, collectionUri);
        Enumeration childrenEnum = this.structure.getChildren(this.slideToken, collectionNode);
        while (childrenEnum.hasMoreElements()) {
            ObjectNode child = (ObjectNode)childrenEnum.nextElement();
            if (child.hasChildren()) {
                this.writeLocateByHistoryReport(child.getUri(), parentElement, depth - 1);
                continue;
            }
            revisionDescriptors = this.content.retrieve(this.slideToken, child.getUri());
            revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors);
            resourceKind = AbstractResourceKind.determineResourceKind(this.token, child.getUri(), revisionDescriptor);
            versionHistoryUri = null;
            if (resourceKind instanceof VersionControlled) {
                versionHistoryUri = this.getHistoryUriOfVCR(revisionDescriptors, revisionDescriptor);
            }
            if (versionHistoryUri == null) continue;
            boolean found = false;
            Iterator iterator = this.versionHistorySet.iterator();
            String currentHistoryUri = null;
            while (!found && iterator.hasNext()) {
                currentHistoryUri = ((Element)iterator.next()).getText();
                if (currentHistoryUri != null) {
                    currentHistoryUri = this.getSlidePath(currentHistoryUri);
                }
                found = versionHistoryUri.equals(currentHistoryUri);
            }
            if (!found) continue;
            parentElement.addContent(this.getResponseElement(child.getUri(), revisionDescriptors, revisionDescriptor.getRevisionNumber(), this.slideToken, child.getUri(), this.requestedProperties));
        }
    }

    private void writeVersionTreeReport(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, SlideToken slideToken, String requestUri, Element parentElement) throws ObjectLockedException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, RevisionDescriptorNotFoundException, LockTokenNotFoundException, JDOMException {
        PropertyRetrieverImpl retriever = new PropertyRetrieverImpl(this.token, slideToken, this.getConfig());
        NodeRevisionNumber revisionNumber = revisionDescriptor.getRevisionNumber();
        NodeRevisionDescriptor historyDescriptor = this.content.retrieve(slideToken, revisionDescriptors, NodeRevisionNumber.HIDDEN_0_0);
        NodeProperty versionSetProperty = historyDescriptor.getProperty("version-set");
        if (versionSetProperty != null && versionSetProperty.getValue() != null) {
            XMLValue xmlValue = new XMLValue(versionSetProperty.getValue().toString());
            Iterator hrefIterator = xmlValue.iterator();
            Object currentRevisionDescriptor = null;
            NodeRevisionDescriptors currentRevisionDescriptors = null;
            NodeRevisionNumber currentRevisionNumber = null;
            UriHandler currentUriHandler = null;
            String currentRequestUri = null;
            while (hrefIterator.hasNext()) {
                currentRequestUri = ((Element)hrefIterator.next()).getText();
                currentUriHandler = UriHandler.getUriHandler(currentRequestUri);
                currentRevisionNumber = new NodeRevisionNumber(currentUriHandler.getVersionName());
                currentRevisionDescriptors = this.content.retrieve(slideToken, currentRequestUri);
                parentElement.addContent(this.getResponseElement(currentRequestUri, currentRevisionDescriptors, currentRevisionNumber, slideToken, currentRequestUri, this.getRequestedVersionTreeProperties()));
            }
        }
    }
}

