/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.slide.common.Domain;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.VersionControlMethod;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.CheckedInVersionControlled;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;

public class PutMethod
extends AbstractWebdavMethod
implements DeltavConstants {
    public static final boolean AUTO_VERSION_CONTROL = new Boolean(Domain.getParameter((String)"auto-version-control", (String)"false"));
    protected VersioningHelper versioningHelper = null;
    protected String resourcePath;
    private boolean isInVersioncontrolExcludePath = false;

    public PutMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void executeRequest() throws WebdavException, IOException {
        UriHandler exUh;
        this.slideToken.setForceStoreEnlistment(true);
        UriHandler destUh = UriHandler.getUriHandler(this.resourcePath);
        if (VersionControlMethod.VERSIONCONTROL_EXCLUDEPATH != null && VersionControlMethod.VERSIONCONTROL_EXCLUDEPATH.length() > 0 && (exUh = UriHandler.getUriHandler(VersionControlMethod.VERSIONCONTROL_EXCLUDEPATH)).isAncestorOf(destUh)) {
            this.isInVersioncontrolExcludePath = true;
        }
        if (destUh.isRestrictedUri()) {
            boolean sendError = true;
            if (destUh.isWorkingresourceUri()) {
                try {
                    this.content.retrieve(this.slideToken, this.resourcePath);
                    sendError = false;
                }
                catch (Exception exception) {}
            }
            if (sendError) {
                int statusCode = 403;
                this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".restrictedDestinationUri", new Object[]{this.resourcePath});
                throw new WebdavException(statusCode);
            }
        }
        try {
            try {
                boolean isLockedNullResource = false;
                NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.slideToken, this.resourcePath);
                NodeRevisionNumber revisionNumber = revisionDescriptors.getLatestRevision();
                NodeRevisionDescriptor oldRevisionDescriptor = null;
                if (revisionNumber != null) {
                    try {
                        oldRevisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors);
                    }
                    catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {}
                }
                if (WebdavUtils.isCollection(oldRevisionDescriptor)) {
                    int statusCode = 405;
                    this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".mustNotBeCollection");
                    throw new WebdavException(statusCode);
                }
                NodeRevisionDescriptor revisionDescriptor = null;
                if (oldRevisionDescriptor == null) {
                    revisionDescriptor = new NodeRevisionDescriptor();
                } else {
                    revisionDescriptor = oldRevisionDescriptor;
                    revisionDescriptor.setContentLength(-1L);
                }
                ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.token, this.resourcePath, revisionDescriptor);
                this.versioningHelper.isWriteLocked(this.slideToken, revisionDescriptors);
                ViolatedPrecondition violatedPrecondition = this.getPreconditionViolation(revisionDescriptors, revisionDescriptor, resourceKind);
                if (violatedPrecondition != null) {
                    throw new PreconditionViolationException(violatedPrecondition, this.resourcePath);
                }
                boolean mustCheckIn = false;
                if (Configuration.useVersionControl() && resourceKind instanceof CheckedInVersionControlled && this.versioningHelper.mustCheckoutAutoVersionedVCR(revisionDescriptors, revisionDescriptor)) {
                    this.versioningHelper.checkout(revisionDescriptors, revisionDescriptor, false, false, true);
                    mustCheckIn = this.versioningHelper.mustCheckinAutoVersionedVCR(this.slideToken, revisionDescriptors, revisionDescriptor);
                }
                NodeRevisionContent revisionContent = new NodeRevisionContent();
                revisionContent.setContent((InputStream)this.req.getInputStream());
                revisionDescriptor.setContentLength((long)this.req.getContentLength());
                revisionDescriptor.setLastModified(new Date());
                revisionDescriptor.setETag(String.valueOf(this.resourcePath.hashCode()) + "_" + revisionNumber.hashCode() + "_" + revisionDescriptor.getContentLength());
                if (revisionDescriptor.propertyValueContains("resourcetype", "lock-null")) {
                    isLockedNullResource = true;
                    revisionDescriptor.setContentLanguage("en");
                    String contentType = this.req.getContentType();
                    if (contentType == null) {
                        contentType = this.getConfig().getServletContext().getMimeType(this.resourcePath);
                    }
                    if (contentType == null) {
                        contentType = this.getConfig().getDefaultMimeType();
                    }
                    revisionDescriptor.setContentType(contentType);
                    if (Configuration.useVersionControl()) {
                        this.versioningHelper.setWorkspaceProperty(this.resourcePath, revisionDescriptor);
                    }
                }
                revisionDescriptor.setResourceType("");
                if (isLockedNullResource) {
                    revisionDescriptor.setOwner(this.slideToken.getCredentialsToken().getPublicCredentials());
                }
                this.content.store(this.slideToken, this.resourcePath, revisionDescriptor, revisionContent);
                if (isLockedNullResource && Configuration.useVersionControl() && AUTO_VERSION_CONTROL && !this.isInVersioncontrolExcludePath) {
                    this.versioningHelper.versionControl(this.resourcePath);
                }
                if (Configuration.useVersionControl() && mustCheckIn) {
                    this.versioningHelper.checkin(revisionDescriptors, revisionDescriptor, false, false, true);
                }
                this.resp.setStatus(204);
            }
            catch (LinkedObjectNotFoundException e) {
                int statusCode = this.getErrorCode((SlideException)((Object)e));
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                SubjectNode subject = new SubjectNode();
                this.structure.create(this.slideToken, (ObjectNode)subject, this.resourcePath);
                NodeRevisionDescriptor revisionDescriptor = new NodeRevisionDescriptor((long)this.req.getContentLength());
                revisionDescriptor.setResourceType("");
                revisionDescriptor.setSource("");
                revisionDescriptor.setContentLanguage("en");
                revisionDescriptor.setContentLength((long)this.req.getContentLength());
                String contentType = this.req.getContentType();
                if (contentType == null) {
                    contentType = this.getConfig().getServletContext().getMimeType(this.resourcePath);
                }
                if (contentType == null) {
                    contentType = this.getConfig().getDefaultMimeType();
                }
                revisionDescriptor.setContentType(contentType);
                revisionDescriptor.setLastModified(new Date());
                revisionDescriptor.setETag(String.valueOf(this.resourcePath.hashCode()) + "_" + new NodeRevisionNumber().hashCode() + "_" + this.req.getContentLength());
                revisionDescriptor.setOwner(this.slideToken.getCredentialsToken().getPublicCredentials());
                if (Configuration.useVersionControl()) {
                    this.versioningHelper.setWorkspaceProperty(this.resourcePath, revisionDescriptor);
                }
                if (this.isMsProprietarySupport()) {
                    NodeProperty property = null;
                    property = new NodeProperty("ishidden", (Object)"0", "MICROSOFT");
                    revisionDescriptor.setProperty(property);
                    property = new NodeProperty("iscollection", (Object)"0", "MICROSOFT");
                    revisionDescriptor.setProperty(property);
                    property = new NodeProperty("isreadonly", (Object)"0", "MICROSOFT");
                    revisionDescriptor.setProperty(property);
                    property = new NodeProperty("lastaccessed", (Object)new Date().toString(), "MICROSOFT");
                    revisionDescriptor.setProperty(property);
                }
                NodeRevisionContent revisionContent = new NodeRevisionContent();
                revisionContent.setContent((InputStream)this.req.getInputStream());
                this.content.create(this.slideToken, this.resourcePath, revisionDescriptor, revisionContent);
                if (Configuration.useVersionControl() && AUTO_VERSION_CONTROL && !this.isInVersioncontrolExcludePath) {
                    this.versioningHelper.versionControl(this.resourcePath);
                }
                this.resp.setStatus(201);
            }
        }
        catch (PreconditionViolationException e) {
            this.sendPreconditionViolation(e);
            throw e;
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    protected int getErrorCode(SlideException ex) {
        try {
            throw ex;
        }
        catch (RevisionAlreadyExistException revisionAlreadyExistException) {
            return 409;
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            return 409;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return 409;
        }
        catch (LinkedObjectNotFoundException linkedObjectNotFoundException) {
            return 404;
        }
        catch (SlideException e) {
            return super.getErrorCode(e);
        }
        catch (Exception e) {
            return super.getErrorCode(e);
        }
    }

    private ViolatedPrecondition getPreconditionViolation(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, ResourceKind resourceKind) throws ServiceAccessException {
        if (Configuration.useVersionControl()) {
            UriHandler uriHandler;
            if (resourceKind instanceof CheckedInVersionControlled) {
                String autoVersion = this.versioningHelper.getAutoVersionElementName(revisionDescriptor);
                if (autoVersion == null) {
                    autoVersion = "";
                }
                if (!("checkout-checkin".equals(autoVersion) || "checkout-unlocked-checkin".equals(autoVersion) || "checkout".equals(autoVersion) || "locked-checkout".equals(autoVersion))) {
                    return new ViolatedPrecondition("cannot-modify-version-controlled-content", 403);
                }
                if ("locked-checkout".equals(autoVersion) && !this.versioningHelper.isWriteLocked(this.slideToken, revisionDescriptors)) {
                    return new ViolatedPrecondition("cannot-modify-version-controlled-content", 403);
                }
            }
            if ((uriHandler = UriHandler.getUriHandler(this.resourcePath)).isVersionUri()) {
                return new ViolatedPrecondition("cannot-modify-version", 403);
            }
        }
        return null;
    }

    protected boolean methodNeedsTransactionSupport() {
        return true;
    }

    protected void parseRequest() throws WebdavException {
        this.versioningHelper = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.config);
        this.resourcePath = this.requestUri;
        if (this.resourcePath == null) {
            this.resourcePath = "/";
        }
    }
}

