/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyParseException;
import org.apache.slide.common.RequestedPropertiesImpl;
import org.apache.slide.common.RequestedProperty;
import org.apache.slide.common.RequestedPropertyImpl;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.PropertyHelper;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.XMLValue;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.CheckedInVersionControlled;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.apache.util.PropertyWriter;
import org.apache.util.WebdavStatus;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;

public class PropPatchMethod
extends AbstractWebdavMethod
implements DeltavConstants {
    private static final int SET = 0;
    private static final int REMOVE = 1;
    protected VersioningHelper versioningHelper = null;
    protected PropertyHelper propertyHelper = null;
    private PropPatchProperties propertiesToSet;
    private PropPatchProperties propertiesToRemove;
    private PropertyWriter propertyWriter;
    private String resourcePath;

    public PropPatchMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    private void addPropstatElements(PropPatchProperties properties, Element response) {
        Iterator propertyIterator = properties.iterator();
        while (propertyIterator.hasNext()) {
            Element responseDescription;
            PropPatchProperty property = (PropPatchProperty)((Object)propertyIterator.next());
            Element propstat = this.createPropstatElement(property);
            response.addContent(propstat);
            if (property.getViolatedPrecondition() != null) {
                responseDescription = new Element("responsedescription", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                responseDescription.addContent(this.getPreconditionViolationError(property.getViolatedPrecondition()));
                propstat.addContent(responseDescription);
                continue;
            }
            if (property.getErrorMessage() == null) continue;
            responseDescription = new Element("responsedescription", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            responseDescription.addContent(property.getErrorMessage());
            propstat.addContent(responseDescription);
        }
    }

    private boolean checkPropertyModification(PropPatchProperty property, NodeRevisionDescriptor rd, ResourceKind resourceKind) {
        boolean result = false;
        ViolatedPrecondition violatedPrecondition = this.getPropertySpecificPreconditionViolation(property);
        if (violatedPrecondition != null) {
            property.setViolatedPrecondition(violatedPrecondition);
        } else {
            NodeProperty originalProperty = rd.getProperty(property.getName(), property.getNamespace());
            result = originalProperty == null ? AbstractResourceKind.isComputedProperty(property.getName()) ^ true : originalProperty.isProtected() ^ true;
            if (!result) {
                property.setErrorMessage("Property " + property.getQualifiedNameAsElementString() + " is protected");
            }
            if (result && !this.isSupportedPropertyValue(property, resourceKind)) {
                property.setErrorMessage("Value " + property.getValue() + " is not supported by property " + property.getQualifiedNameAsElementString());
                result = false;
            }
            if (!result) {
                property.setStatusCode(409);
            }
        }
        return result;
    }

    private Element createPropstatElement(PropPatchProperty property) {
        Element propstat = new Element("propstat", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        Element prop = new Element("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        propstat.addContent(prop);
        Namespace namespace = Namespace.NO_NAMESPACE;
        if (property.getNamespace() != null) {
            namespace = NodeProperty.NamespaceCache.getNamespace((String)property.getNamespace());
        }
        Element propertyElement = new Element(property.getName(), namespace);
        prop.addContent(propertyElement);
        Element status = new Element("status", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        status.setText("HTTP/1.1 " + property.statusCode + " " + WebdavStatus.getStatusText((int)property.statusCode));
        propstat.addContent(status);
        return propstat;
    }

    protected void executeRequest() throws WebdavException, IOException {
        boolean allOperationsExcecuted = true;
        this.slideToken.setForceStoreEnlistment(true);
        try {
            ResourceKind resourceKind;
            ViolatedPrecondition violatedPrecondition;
            VersioningHelper vHelp = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.getConfig());
            NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.slideToken, this.resourcePath);
            NodeRevisionNumber revisionNumber = revisionDescriptors.getLatestRevision();
            NodeRevisionDescriptor revisionDescriptor = null;
            if (revisionNumber != null) {
                try {
                    revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors);
                }
                catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {}
            }
            if (revisionDescriptor == null) {
                revisionDescriptor = new NodeRevisionDescriptor(0L);
            }
            if ((violatedPrecondition = this.getPreconditionViolation(revisionDescriptors, revisionDescriptor, resourceKind = AbstractResourceKind.determineResourceKind(this.token, this.resourcePath, revisionDescriptor))) != null) {
                throw new PreconditionViolationException(violatedPrecondition, this.resourcePath);
            }
            boolean mustCheckIn = false;
            if (Configuration.useVersionControl() && resourceKind instanceof CheckedInVersionControlled && this.versioningHelper.mustCheckoutAutoVersionedVCR(revisionDescriptors, revisionDescriptor)) {
                vHelp.checkout(revisionDescriptors, revisionDescriptor, false, false, true);
                mustCheckIn = this.versioningHelper.mustCheckinAutoVersionedVCR(this.slideToken, revisionDescriptors, revisionDescriptor);
            }
            Iterator propertyIterator = null;
            propertyIterator = this.propertiesToSet.iterator();
            PropPatchProperty currentProperty = null;
            while (propertyIterator.hasNext()) {
                currentProperty = (PropPatchProperty)((Object)propertyIterator.next());
                if (this.checkPropertyModification(currentProperty, revisionDescriptor, resourceKind)) {
                    NodeProperty newProperty = new NodeProperty(currentProperty.getName(), (Object)currentProperty.getValue(), currentProperty.getNamespace());
                    revisionDescriptor.setProperty(newProperty);
                    continue;
                }
                allOperationsExcecuted = false;
            }
            propertyIterator = this.propertiesToRemove.iterator();
            while (propertyIterator.hasNext()) {
                currentProperty = (PropPatchProperty)((Object)propertyIterator.next());
                if (this.checkPropertyModification(currentProperty, revisionDescriptor, resourceKind)) {
                    revisionDescriptor.removeProperty(currentProperty.getName(), currentProperty.getNamespace());
                    continue;
                }
                allOperationsExcecuted = false;
            }
            if (allOperationsExcecuted) {
                this.content.store(this.slideToken, this.resourcePath, revisionDescriptor, null);
            }
            if (Configuration.useVersionControl() && mustCheckIn) {
                vHelp.checkin(revisionDescriptors, revisionDescriptor, false, false, true);
            }
            this.resp.setContentType("text/xml; charset=\"UTF-8\"");
            this.resp.setStatus(207);
        }
        catch (PreconditionViolationException e) {
            this.sendPreconditionViolation(e);
            throw e;
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        this.writeReport();
        if (!allOperationsExcecuted) {
            throw new WebdavException(202);
        }
    }

    protected int getErrorCode(Exception ex) {
        try {
            throw ex;
        }
        catch (LinkedObjectNotFoundException linkedObjectNotFoundException) {
            return 404;
        }
        catch (PropertyParseException propertyParseException) {
            return 400;
        }
        catch (JDOMException jDOMException) {
            return 400;
        }
        catch (Exception e) {
            return super.getErrorCode(e);
        }
    }

    private ViolatedPrecondition getPreconditionViolation(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, ResourceKind resourceKind) throws ServiceAccessException {
        if (Configuration.useVersionControl()) {
            UriHandler uriHandler;
            if (resourceKind instanceof CheckedInVersionControlled) {
                String autoVersion = this.versioningHelper.getAutoVersionElementName(revisionDescriptor);
                if (autoVersion == null) {
                    autoVersion = "";
                }
                if (!("checkout-checkin".equals(autoVersion) || "checkout-unlocked-checkin".equals(autoVersion) || "checkout".equals(autoVersion) || "locked-checkout".equals(autoVersion))) {
                    return new ViolatedPrecondition("cannot-modify-version-controlled-property", 403);
                }
                if ("locked-checkout".equals(autoVersion) && !this.versioningHelper.isWriteLocked(this.slideToken, revisionDescriptors)) {
                    return new ViolatedPrecondition("cannot-modify-version-controlled-property", 403);
                }
            }
            if ((uriHandler = UriHandler.getUriHandler(this.resourcePath)).isVersionUri()) {
                return new ViolatedPrecondition("cannot-modify-version", 403);
            }
        }
        return null;
    }

    private Element getPropElement(Element parent) throws JDOMException {
        List childrenList = parent.getChildren();
        if (childrenList.size() != 1 || !"prop".equals(((Element)childrenList.get(0)).getName())) {
            throw new JDOMException("Expected &lt;prop&gt; element");
        }
        return (Element)childrenList.get(0);
    }

    private ViolatedPrecondition getPropertySpecificPreconditionViolation(PropPatchProperty property) {
        if (AbstractResourceKind.isProtectedProperty(property.getName()) && DeltavConstants.DELTAV_PROPERTY_LIST.contains(property.getName())) {
            return new ViolatedPrecondition("cannot-modify-protected-property", 409);
        }
        return null;
    }

    private boolean isSupportedPropertyValue(PropPatchProperty property, ResourceKind resourceKind) {
        boolean isSupportedValue = true;
        if (property.getValue() != null) {
            if (!resourceKind.isSupportedPropertyValue(property.getName(), property.getValue())) {
                isSupportedValue = false;
            }
            if ("getcontentlanguage".equals(property.getName())) {
                StringTokenizer tokenizer = new StringTokenizer(property.getValue(), "-");
                String token = null;
                while (isSupportedValue && tokenizer.hasMoreTokens()) {
                    token = tokenizer.nextToken();
                    isSupportedValue = token.length() >= 1 && token.length() <= 8;
                    int i = 0;
                    while (isSupportedValue && i < token.length()) {
                        char character = token.charAt(i);
                        isSupportedValue = character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z';
                        ++i;
                    }
                }
            }
        }
        return isSupportedValue;
    }

    protected boolean methodNeedsTransactionSupport() {
        return true;
    }

    protected void parseRequest() throws WebdavException {
        this.versioningHelper = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.config);
        this.propertyHelper = PropertyHelper.getPropertyHelper(this.slideToken, this.token, this.getConfig());
        this.readRequestContent();
        this.resourcePath = this.requestUri;
        if (this.resourcePath == null) {
            this.resourcePath = "/";
        }
        this.propertiesToSet = new PropPatchProperties();
        this.propertiesToRemove = new PropPatchProperties();
        if (this.requestBody.length() != 0) {
            try {
                Object setNode = null;
                Object removeNode = null;
                Document document = this.parseRequestContent();
                Element rootElement = document.getRootElement();
                if (rootElement == null || !"propertyupdate".equals(rootElement.getName())) {
                    throw new JDOMException("<propertyupdate> element missing");
                }
                Iterator childrenIterator = rootElement.getChildren().iterator();
                Element child = null;
                while (childrenIterator.hasNext()) {
                    child = (Element)childrenIterator.next();
                    if ("set".equals(child.getName())) {
                        this.propertiesToSet.add(this.getPropElement(child));
                        continue;
                    }
                    if ("remove".equals(child.getName())) {
                        this.propertiesToRemove.add(this.getPropElement(child));
                        continue;
                    }
                    throw new JDOMException("Expected <set> or <remove> element");
                }
            }
            catch (Exception e) {
                int statusCode = this.getErrorCode(e);
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
        } else {
            int statusCode = 400;
            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".missingRequestBody");
            throw new WebdavException(statusCode);
        }
    }

    private void writeReport() throws WebdavException {
        Element multistatus = new Element("multistatus", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        Element response = new Element("response", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        multistatus.addContent(response);
        Element href = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        href.setText(this.getFullPath(this.requestUri));
        response.addContent(href);
        this.addPropstatElements(this.propertiesToSet, response);
        this.addPropstatElements(this.propertiesToRemove, response);
        try {
            this.resp.setContentType("text/xml; charset=\"UTF-8\"");
            PrintWriter writer = this.resp.getWriter();
            new XMLOutputter("    ", true).output(new Document(multistatus), (Writer)writer);
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    public static class PropPatchProperties
    extends RequestedPropertiesImpl {
        public PropPatchProperties() {
        }

        public PropPatchProperties(Element propElement) throws PropertyParseException {
            super(propElement);
        }

        protected RequestedProperty createRequestedProperty(String name, String namespacePrefix, String namespaceUri, String text, List children) {
            String value = text;
            if (children.size() > 0) {
                value = new XMLValue(children).toString();
            }
            NodeProperty.NamespaceCache.getNamespace((String)namespacePrefix, (String)namespaceUri);
            return new PropPatchProperty(name, namespaceUri, value);
        }
    }

    public static class PropPatchProperty
    extends RequestedPropertyImpl {
        protected String value = null;
        protected int statusCode = 200;
        protected ViolatedPrecondition violatedPrecondition = null;
        protected String errorMessage = null;
        protected String qualifiedNameAsElement = null;

        public PropPatchProperty(String propertyName) {
            super(propertyName);
        }

        public PropPatchProperty(String propertyName, String namespace) {
            super(propertyName, namespace);
        }

        public PropPatchProperty(String propertyName, String namespace, String value) {
            super(propertyName, namespace);
            this.value = value;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getQualifiedNameAsElementString() {
            if (this.qualifiedNameAsElement == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("<");
                buffer.append(this.getName());
                if (this.getNamespace() != null && this.getNamespace().length() > 0) {
                    buffer.append(" xmlns=\"");
                    buffer.append(this.getNamespace());
                    buffer.append("\"");
                    buffer.append(" />");
                }
                this.qualifiedNameAsElement = buffer.toString();
            }
            return this.qualifiedNameAsElement;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getValue() {
            return this.value;
        }

        public ViolatedPrecondition getViolatedPrecondition() {
            return this.violatedPrecondition;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public void setViolatedPrecondition(ViolatedPrecondition violatedPrecondition) {
            this.violatedPrecondition = violatedPrecondition;
            if (violatedPrecondition != null) {
                this.setStatusCode(violatedPrecondition.getStatusCode());
            }
        }

        public String toString() {
            return String.valueOf(this.getNamespace()) + ":" + this.getName() + "[" + this.getValue() + "]";
        }
    }
}

