/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyParseException;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.RequestedPropertiesImpl;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.StructureException;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.LabeledRevisionNotFoundException;
import org.apache.slide.webdav.util.PropertyRetrieverImpl;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.apache.util.WebdavStatus;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class PropFindMethod
extends AbstractWebdavMethod
implements DeltavConstants,
AclConstants {
    protected static final int INFINITY = Integer.MAX_VALUE;
    protected static final int FIND_BY_PROPERTY = 0;
    protected static final int FIND_ALL_PROP = 1;
    protected static final int FIND_PROPERTY_NAMES = 2;
    protected int depth;
    protected int propFindType;
    protected boolean allpropIncludesDeltav = false;
    protected static SAXBuilder saxBuilder = null;
    protected RequestedProperties requestedProperties = null;
    protected String resourcePath;
    protected VersioningHelper versioningHelper = null;
    protected String labelHeader = null;
    protected boolean outputOptimized = true;

    public PropFindMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    /*
     * Unable to fully structure code
     */
    protected void executeRequest() throws IOException, WebdavException {
        block16: {
            block17: {
                this.resp.setStatus(207);
                resource = null;
                try {
                    resource = this.structure.retrieve(this.slideToken, this.resourcePath);
                }
                catch (StructureException e) {
                    statusCode = 404;
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
                catch (Exception e) {
                    statusCode = this.getErrorCode(e);
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
                this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                multistatusElement = new Element("multistatus", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                xmlOutputter = new XMLOutputter("    ", true);
                if (resource == null) break block16;
                if (this.depth != 0) break block17;
                multistatusElement.addContent(this.getPropertiesOfObject(resource.getUri()));
                xmlOutputter.output(new Document(multistatusElement), (Writer)this.resp.getWriter());
                break block16;
            }
            stack = new Stack<ObjectNode>();
            stack.push(resource);
            stackBelow = new Stack<E>();
            buffer = new StringBuffer();
            if (this.outputOptimized) {
                this.resp.getWriter().write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                this.resp.getWriter().write("\n");
                namespacePrefix = multistatusElement.getNamespacePrefix();
                if (namespacePrefix != null && namespacePrefix.length() == 0) {
                    namespacePrefix = null;
                }
                if ((namespaceUri = multistatusElement.getNamespaceURI()) != null && namespaceUri.length() == 0) {
                    namespaceUri = null;
                }
                buffer.append("<");
                buffer.append(multistatusElement.getQualifiedName());
                if (namespaceUri != null) {
                    buffer.append(" xmlns");
                    if (namespacePrefix != null) {
                        buffer.append(":");
                        buffer.append(namespacePrefix);
                    }
                    buffer.append("=\"");
                    buffer.append(namespaceUri);
                    buffer.append("\"");
                }
                buffer.append(">");
                this.resp.getWriter().write(buffer.toString());
                this.resp.getWriter().write("\n");
            }
            while (!stack.isEmpty() && this.depth >= 0) {
                block18: {
                    cur = (ObjectNode)stack.pop();
                    response = this.getPropertiesOfObject(cur.getUri());
                    if (this.outputOptimized) {
                        xmlOutputter.output(response, (Writer)this.resp.getWriter());
                    } else {
                        multistatusElement.addContent(response);
                    }
                    if (this.depth <= 0) break block18;
                    enum = null;
                    try {
                        enum = this.structure.getChildren(this.slideToken, cur);
                        if (true) ** GOTO lbl79
                    }
                    catch (Exception e) {
                        statusCode = this.getErrorCode(e);
                        this.sendError(statusCode, e);
                        throw new WebdavException(statusCode);
                    }
                    do {
                        stackBelow.push(enum.nextElement());
lbl79:
                        // 2 sources

                    } while (enum.hasMoreElements());
                }
                if (!stack.isEmpty()) continue;
                --this.depth;
                stack = stackBelow;
                stackBelow = new Stack<E>();
            }
            if (this.outputOptimized) {
                this.resp.getWriter().write("\n");
                buffer.setLength(0);
                buffer.append("</");
                buffer.append(multistatusElement.getQualifiedName());
                buffer.append(">");
                this.resp.getWriter().write(buffer.toString());
                this.resp.getWriter().write("\n");
            } else {
                xmlOutputter.output(new Document(multistatusElement), (Writer)this.resp.getWriter());
            }
        }
    }

    private Element getErrorResponse(String resourcePath, int errorCode, String condition) {
        Element response = new Element("response", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        Element href = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        href.setText("http://" + this.req.getServerName() + ":" + this.req.getServerPort() + this.req.getContextPath() + resourcePath);
        response.addContent(href);
        Element propStat = new Element("propstat", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        response.addContent(propStat);
        Element status = new Element("status", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        status.setText("HTTP/1.1 " + errorCode + " " + WebdavStatus.getStatusText((int)errorCode));
        propStat.addContent(status);
        if (condition != null) {
            Element responseDescriptiont = new Element("responsedescription", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            Element errorElement = new Element("error", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            responseDescriptiont.addContent(errorElement);
            Element conditionElement = new Element(condition, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            errorElement.addContent(conditionElement);
            propStat.addContent(responseDescriptiont);
        }
        return response;
    }

    protected Element getPropertiesOfObject(String resourceUri) throws WebdavException {
        if (Configuration.useVersionControl()) {
            try {
                resourceUri = this.versioningHelper.getLabeledResourceUri(resourceUri, this.labelHeader);
            }
            catch (LabeledRevisionNotFoundException labeledRevisionNotFoundException) {
                return this.getErrorResponse(resourceUri, 409, "must-select-version-in-history");
            }
            catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {
            }
            catch (SlideException e) {
                return this.getErrorResponse(resourceUri, this.getErrorCode(e), null);
            }
        }
        ObjectNode object = null;
        try {
            object = this.structure.retrieve(this.slideToken, resourceUri);
        }
        catch (SlideException e) {
            return this.getErrorResponse(resourceUri, this.getErrorCode(e), null);
        }
        Element responseElement = new Element("response", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        String status = new String("HTTP/1.1200 " + WebdavStatus.getStatusText((int)200));
        NodeRevisionDescriptors revisionDescriptors = null;
        NodeRevisionDescriptor revisionDescriptor = null;
        boolean isCollection = false;
        NodeLock objectLockToken = null;
        String serverURL = "http://" + this.req.getServerName() + ":" + this.req.getServerPort();
        try {
            Element hrefElement = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            VersioningHelper vHelp = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.getConfig());
            String resourcePath = object.getUri();
            revisionDescriptors = this.content.retrieve(this.slideToken, resourcePath);
            try {
                revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors);
                isCollection = WebdavUtils.isCollection(revisionDescriptor);
                hrefElement.setText(WebdavUtils.getAbsolutePath(object.getUri(), this.req, this.getConfig()));
            }
            catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {
                isCollection = true;
                revisionDescriptor = new NodeRevisionDescriptor(0L);
                String resourceName = object.getUri();
                int lastSlash = resourceName.lastIndexOf(47);
                if (lastSlash != -1) {
                    resourceName = resourceName.substring(lastSlash + 1);
                }
                revisionDescriptor.setName(resourceName);
                hrefElement.setText(WebdavUtils.getAbsolutePath(object.getUri(), this.req, this.getConfig()));
            }
            responseElement.addContent(hrefElement);
            Enumeration lockTokens = this.lock.enumerateLocks(this.slideToken, object.getUri(), true);
            if (lockTokens.hasMoreElements()) {
                objectLockToken = (NodeLock)lockTokens.nextElement();
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            if (revisionDescriptor == null) {
                revisionDescriptor = new NodeRevisionDescriptor(0L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            responseElement = this.getErrorResponse(object.getUri(), this.getErrorCode(e), null);
        }
        Object propertiesParser = null;
        switch (this.propFindType) {
            case 0: 
            case 1: {
                try {
                    PropertyRetrieverImpl propertyRetriever = new PropertyRetrieverImpl(this.token, this.slideToken, this.getConfig());
                    List propstatList = propertyRetriever.getPropertiesOfObject(this.requestedProperties, revisionDescriptors, revisionDescriptor, this.req.getContextPath(), serverURL, this.allpropIncludesDeltav);
                    Iterator iterator = propstatList.iterator();
                    while (iterator.hasNext()) {
                        responseElement.addContent((Element)iterator.next());
                    }
                    break;
                }
                catch (ServiceAccessException e) {
                    int statusCode = 403;
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
                catch (Exception e) {
                    int statusCode = this.getErrorCode(e);
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
            }
            case 2: {
                status = new String("HTTP/1.1 200 " + WebdavStatus.getStatusText((int)200));
                Element propstatElement = new Element("propstat", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                responseElement.addContent(propstatElement);
                ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.token, object.getUri(), revisionDescriptor);
                String[] excludedFeatures = new String[]{};
                if (!Configuration.useIntegratedSecurity()) {
                    excludedFeatures = new String[]{"access-control"};
                }
                Set propertySet = resourceKind.getSupportedLiveProperties(null, excludedFeatures);
                Iterator iterator = propertySet.iterator();
                while (iterator.hasNext()) {
                    Element propertyElement = new Element(iterator.next().toString(), NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                    propstatElement.addContent(propertyElement);
                }
                Enumeration propertyList = revisionDescriptor.enumerateProperties();
                while (propertyList.hasMoreElements()) {
                    NodeProperty currentProperty = (NodeProperty)propertyList.nextElement();
                    Element propertyElement = new Element(currentProperty.getName(), NodeProperty.NamespaceCache.getNamespace((String)currentProperty.getNamespace()));
                    propstatElement.addContent(propertyElement);
                }
                Element statusElement = new Element("status", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                propstatElement.addContent(statusElement);
                break;
            }
        }
        return responseElement;
    }

    protected void parseRequest() throws WebdavException {
        block13: {
            this.versioningHelper = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.getConfig());
            this.readRequestContent();
            this.depth = Integer.MAX_VALUE;
            this.propFindType = 1;
            this.allpropIncludesDeltav = this.getBooleanInitParameter("allpropIncludesDeltav");
            this.outputOptimized = this.getBooleanInitParameter("optimizePropfindOutput");
            this.resourcePath = this.requestUri;
            if (this.resourcePath == null) {
                this.resourcePath = "/";
            }
            this.labelHeader = WebdavUtils.fixTomcatHeader(this.req.getHeader("Label"), "UTF-8");
            this.retrieveDepth();
            if (this.req.getContentLength() == 0) {
                this.requestedProperties = new RequestedPropertiesImpl();
                this.requestedProperties.setIsAllProp(true);
                this.propFindType = 1;
            } else {
                try {
                    Element element = this.parseRequestContent().getRootElement();
                    if (element == null || !element.getName().equalsIgnoreCase("propfind")) {
                        int statusCode = 400;
                        this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".missingRootElement", new Object[]{"DAV:propfind"});
                        throw new WebdavException(statusCode);
                    }
                    try {
                        element = (Element)element.getChildren().get(0);
                    }
                    catch (Exception exception) {
                        int statusCode = 400;
                        this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".missingRootElementChildren", new Object[]{"DAV:propfind"});
                        throw new WebdavException(statusCode);
                    }
                    if (element.getName().equalsIgnoreCase("propname")) {
                        this.propFindType = 2;
                        break block13;
                    }
                    if (element.getName().equalsIgnoreCase("prop")) {
                        this.requestedProperties = new RequestedPropertiesImpl(element);
                        this.propFindType = 0;
                        break block13;
                    }
                    if (element.getName().equalsIgnoreCase("allprop")) {
                        this.requestedProperties = new RequestedPropertiesImpl(element);
                        this.propFindType = 1;
                        break block13;
                    }
                    int statusCode = 400;
                    this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".invalidChildOfRootElement", new Object[]{String.valueOf(String.valueOf(element.getNamespace())) + ":" + element.getName(), "DAV:propfind"});
                    throw new WebdavException(statusCode);
                }
                catch (JDOMException e) {
                    int statusCode = 400;
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
                catch (PropertyParseException e) {
                    int statusCode = 400;
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
                catch (IOException e) {
                    int statusCode = 500;
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
            }
        }
    }

    private void retrieveDepth() {
        String depthStr = this.req.getHeader("Depth");
        if (depthStr == null) {
            this.depth = Integer.MAX_VALUE;
        } else if (depthStr.equals("0")) {
            this.depth = 0;
        } else if (depthStr.equals("1")) {
            this.depth = 1;
        } else if (depthStr.equalsIgnoreCase("infinity")) {
            this.depth = Integer.MAX_VALUE;
        } else {
            try {
                this.depth = Integer.parseInt(depthStr);
                if (this.depth < 0) {
                    this.depth = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.depth = Integer.MAX_VALUE;
            }
        }
        if (this.depth > this.getConfig().getDepthLimit()) {
            this.depth = this.getConfig().getDepthLimit();
        }
    }
}

