/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.search.SearchLanguage;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.HistoryPathHandler;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.slide.webdav.util.WorkspacePathHandler;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;

public class OptionsMethod
extends AbstractWebdavMethod
implements DeltavConstants,
AclConstants {
    private XMLOutputter xmlOut = new XMLOutputter("    ", true, "UTF-8");
    private Namespace xmlNs = NodeProperty.NamespaceCache.DEFAULT_NAMESPACE;
    private boolean versionHistoryCollectionSetRequested = false;
    private boolean workspaceCollectionSetRequested = false;
    private boolean responseBodyNeeded = false;

    public OptionsMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void executeRequest() throws WebdavException {
        StringBuffer davHeader = new StringBuffer();
        davHeader.append("1");
        if (Configuration.useIntegratedLocking()) {
            davHeader.append(", ").append("2");
        }
        davHeader.append(", ").append("slide");
        if (Configuration.useIntegratedSecurity()) {
            davHeader.append(", ").append("access-control");
        }
        this.resp.addHeader("DAV", davHeader.toString());
        davHeader = new StringBuffer();
        if (Configuration.useVersionControl()) {
            davHeader.append("version-control");
            davHeader.append(", ").append("version-history");
            davHeader.append(", ").append("checkout-in-place");
        }
        this.resp.addHeader("DAV", davHeader.toString());
        davHeader = new StringBuffer();
        if (Configuration.useVersionControl()) {
            davHeader.append("workspace");
            davHeader.append(", ").append("working-resource");
            davHeader.append(", ").append("update");
            davHeader.append(", ").append("label");
        }
        this.resp.addHeader("DAV", davHeader.toString());
        String resourceUri = this.requestUri;
        if (resourceUri == null) {
            resourceUri = "/";
        }
        boolean resourceExists = false;
        boolean resourceIsCollection = false;
        SearchLanguage[] languages = this.token.getSearchHelper().getSupportedLanguages();
        ResourceKind resourceKind = null;
        try {
            NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.slideToken, resourceUri);
            NodeRevisionDescriptor revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors);
            resourceKind = AbstractResourceKind.determineResourceKind(this.token, revisionDescriptors, revisionDescriptor);
            resourceExists = true;
            if (WebdavUtils.isCollection(revisionDescriptor)) {
                resourceIsCollection = true;
            }
        }
        catch (SlideException slideException) {
            if (resourceUri.equals("/")) {
                resourceExists = true;
                resourceIsCollection = true;
            }
            resourceExists = false;
        }
        StringBuffer methodsAllowed = new StringBuffer();
        if (resourceKind != null) {
            Iterator methodIterator = resourceKind.getSupportedMethods().iterator();
            while (methodIterator.hasNext()) {
                methodsAllowed.append((String)methodIterator.next());
                methodsAllowed.append(", ");
            }
            if (methodsAllowed.length() > 1) {
                methodsAllowed.setLength(methodsAllowed.length() - 2);
            }
        } else {
            methodsAllowed.append("OPTIONS, MKCOL, PUT");
            if (Configuration.useIntegratedLocking()) {
                methodsAllowed.append(", LOCK");
            }
        }
        this.resp.addHeader("Allow", methodsAllowed.toString());
        if (Configuration.useSearch() && languages != null && resourceExists) {
            int i = 0;
            while (i < languages.length) {
                this.resp.addHeader("DASL", "<" + languages[i].getGrammarUri() + languages[i].getName() + ">");
                ++i;
            }
        }
        this.resp.addHeader("MS-Author-Via", "DAV");
        if (this.responseBodyNeeded) {
            Element hre;
            Iterator i;
            this.resp.setContentType("text/xml; charset=\"UTF-8\"");
            UriHandler uh = UriHandler.getUriHandler(resourceUri);
            String storeName = uh.getAssociatedBaseStoreName(this.token.getName());
            HistoryPathHandler hpath = HistoryPathHandler.getHistoryPathHandler();
            WorkspacePathHandler wspath = WorkspacePathHandler.getWorkspacePathHandler();
            Element ore = new Element("options-response", this.xmlNs);
            if (this.versionHistoryCollectionSetRequested) {
                Element vhcse = new Element("version-history-collection-set", this.xmlNs);
                i = hpath.getResolvedHistoryPaths(storeName).iterator();
                while (i.hasNext()) {
                    hre = new Element("href", this.xmlNs);
                    hre.addContent(this.getFullPath(String.valueOf(i.next())));
                    vhcse.addContent(hre);
                }
                ore.addContent(vhcse);
            }
            if (this.workspaceCollectionSetRequested) {
                Element wscse = new Element("workspace-collection-set", this.xmlNs);
                i = wspath.getResolvedWorkspacePaths(storeName).iterator();
                while (i.hasNext()) {
                    hre = new Element("href", this.xmlNs);
                    hre.addContent(this.getFullPath(String.valueOf(i.next())));
                    wscse.addContent(hre);
                }
                ore.addContent(wscse);
            }
            try {
                this.xmlOut.output(new Document(ore), (Writer)this.resp.getWriter());
            }
            catch (IOException e) {
                int statusCode = 500;
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
        }
    }

    protected void parseRequest() throws WebdavException {
        if (this.req.getContentLength() > 0) {
            try {
                Element oe = this.parseRequestContent().getRootElement();
                if (oe == null || !oe.getName().equals("options")) {
                    int statusCode = 400;
                    this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".missingRootElement", new Object[]{"DAV:options"});
                    throw new WebdavException(statusCode);
                }
                Iterator i = oe.getChildren().iterator();
                while (i.hasNext()) {
                    Element e = (Element)i.next();
                    if (e.getName().equals("version-history-collection-set")) {
                        this.versionHistoryCollectionSetRequested = true;
                    }
                    if (!e.getName().equals("workspace-collection-set")) continue;
                    this.workspaceCollectionSetRequested = true;
                }
                if (this.versionHistoryCollectionSetRequested || this.workspaceCollectionSetRequested) {
                    this.responseBodyNeeded = true;
                }
            }
            catch (JDOMException e) {
                int statusCode = 400;
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
            catch (IOException e) {
                int statusCode = 500;
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
        }
    }
}

