/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.NestedSlideException;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.lock.ObjectIsAlreadyLockedException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractMultistatusResponseMethod;
import org.apache.slide.webdav.util.PropertyHelper;
import org.apache.slide.webdav.util.XMLValue;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;

public class LockMethod
extends AbstractMultistatusResponseMethod {
    private static final int INFINITY = -1;
    private static final int LOCK_CREATION = 0;
    private static final int LOCK_REFRESH = 1;
    private static final int DEFAULT_TIMEOUT = 3600;
    private static final int MAX_TIMEOUT = 604800;
    public static final String DEFAULT_LOCK_OWNER = "";
    private int depth;
    private int lockType;
    private int lockDuration = 3600;
    private boolean davNative;
    private String lockInfo_lockScope;
    private String lockInfo_lockType;
    private String lockInfo_lockOwner;
    private String lockInfo_lockSubject;
    protected PropertyHelper propertyHelper = null;
    protected String serverURL = null;

    public LockMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void executeRequest() throws WebdavException {
        this.slideToken.setForceStoreEnlistment(true);
        SubjectNode toLockSubject = null;
        boolean isCollection = this.isCollection(this.lockInfo_lockSubject);
        boolean inheritance = false;
        Date lockDate = null;
        switch (this.lockType) {
            case 0: {
                try {
                    NamespaceConfig namespaceConfig = this.token.getNamespaceConfig();
                    try {
                        toLockSubject = (SubjectNode)this.structure.retrieve(this.slideToken, this.lockInfo_lockSubject);
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {
                        toLockSubject = new SubjectNode();
                        this.structure.create(this.slideToken, (ObjectNode)toLockSubject, this.lockInfo_lockSubject);
                        NodeRevisionDescriptor revisionDescriptor = new NodeRevisionDescriptor(0L);
                        revisionDescriptor.setResourceType("<lock-null/>");
                        this.content.create(this.slideToken, this.lockInfo_lockSubject, revisionDescriptor, null);
                        lockDate = new Date(new Date().getTime() + 604800000L);
                    }
                    SubjectNode credentialsSubject = (SubjectNode)this.structure.retrieve(this.slideToken, String.valueOf(namespaceConfig.getUsersPath()) + "/" + this.slideToken.getCredentialsToken().getPublicCredentials());
                    NodeLock lockToken = null;
                    inheritance = this.depth != 0;
                    boolean exclusive = this.lockInfo_lockScope.equals("shared") ^ true;
                    if (lockDate == null) {
                        lockDate = new Date(new Date().getTime() + (long)(this.lockDuration * 1000));
                    }
                    lockToken = new NodeLock((ObjectNode)toLockSubject, credentialsSubject, namespaceConfig.getCreateObjectAction(), lockDate, inheritance, exclusive, this.lockInfo_lockOwner);
                    this.lock.lock(this.slideToken, lockToken);
                    try {
                        lockToken = new NodeLock(lockToken, namespaceConfig.getCreateRevisionMetadataAction().getUri());
                        this.lock.lock(this.slideToken, lockToken);
                    }
                    catch (ObjectIsAlreadyLockedException objectIsAlreadyLockedException) {}
                    try {
                        lockToken = new NodeLock(lockToken, namespaceConfig.getModifyRevisionMetadataAction().getUri());
                        this.lock.lock(this.slideToken, lockToken);
                    }
                    catch (ObjectIsAlreadyLockedException objectIsAlreadyLockedException) {}
                    try {
                        lockToken = new NodeLock(lockToken, namespaceConfig.getRemoveRevisionMetadataAction().getUri());
                        this.lock.lock(this.slideToken, lockToken);
                    }
                    catch (ObjectIsAlreadyLockedException objectIsAlreadyLockedException) {}
                    try {
                        lockToken = new NodeLock(lockToken, namespaceConfig.getModifyRevisionContentAction().getUri());
                        this.lock.lock(this.slideToken, lockToken);
                    }
                    catch (ObjectIsAlreadyLockedException objectIsAlreadyLockedException) {}
                    try {
                        lockToken = new NodeLock(lockToken, namespaceConfig.getRemoveRevisionContentAction().getUri());
                        this.lock.lock(this.slideToken, lockToken);
                    }
                    catch (ObjectIsAlreadyLockedException objectIsAlreadyLockedException) {}
                    try {
                        lockToken = new NodeLock(lockToken, namespaceConfig.getRemoveObjectAction().getUri());
                        this.lock.lock(this.slideToken, lockToken);
                    }
                    catch (ObjectIsAlreadyLockedException objectIsAlreadyLockedException) {}
                    this.resp.setHeader("Lock-Token", "opaquelocktoken:" + lockToken.getLockId());
                    this.resp.setStatus(200);
                    this.showLockDiscoveryInfo(lockToken);
                    break;
                }
                catch (ObjectIsAlreadyLockedException e) {
                    if (inheritance && this.generate207Response(isCollection, (NestedSlideException)((Object)e), this.requestUri)) {
                        String errorMessage = this.generateErrorMessage((NestedSlideException)((Object)e));
                        this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                        this.resp.setStatus(207);
                        try {
                            this.resp.getWriter().write(errorMessage);
                        }
                        catch (IOException iOException) {
                            int statusCode = 500;
                            this.sendError(statusCode, e);
                            throw new WebdavException(statusCode);
                        }
                    } else {
                        this.resp.setStatus(423);
                    }
                    throw new WebdavException(202, false);
                }
                catch (Exception e) {
                    int statusCode = this.getErrorCode(e);
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
            }
            case 1: {
                try {
                    Enumeration lockTokens = this.lock.enumerateLocks(this.slideToken, this.lockInfo_lockSubject, false);
                    NodeLock currentLockToken = null;
                    Date newExpirationDate = new Date(new Date().getTime() + (long)(this.lockDuration * 1000));
                    while (lockTokens.hasMoreElements()) {
                        currentLockToken = (NodeLock)lockTokens.nextElement();
                        this.lock.renew(this.slideToken, currentLockToken, newExpirationDate);
                    }
                    this.showLockDiscoveryInfo(currentLockToken);
                    break;
                }
                catch (SlideException e) {
                    int statusCode = 412;
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
            }
        }
    }

    protected int getErrorCode(Exception ex) {
        try {
            throw ex;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return 412;
        }
        catch (Exception e) {
            return super.getErrorCode(e);
        }
    }

    protected boolean methodNeedsTransactionSupport() {
        return true;
    }

    private void parseLockInfo() throws WebdavException {
        this.lockType = 0;
        try {
            Document document = this.parseRequestContent();
            if (document == null) {
                throw new JDOMException("Request content missing");
            }
            Element lockInfoElement = document.getRootElement();
            if (lockInfoElement == null || !"lockinfo".equals(lockInfoElement.getName())) {
                throw new JDOMException("Request must start with <lockinfo> element");
            }
            Object strWriter = null;
            Object propertyWriter = null;
            Element lockScopeElement = null;
            Element lockTypeElement = null;
            Element lockOwnerElement = null;
            Iterator childrenIterator = lockInfoElement.getChildren().iterator();
            Element currentElement = null;
            while (childrenIterator.hasNext()) {
                currentElement = (Element)childrenIterator.next();
                if ("lockscope".equals(currentElement.getName())) {
                    lockScopeElement = currentElement;
                    continue;
                }
                if ("locktype".equals(currentElement.getName())) {
                    lockTypeElement = currentElement;
                    continue;
                }
                if (!"owner".equals(currentElement.getName())) continue;
                lockOwnerElement = currentElement;
            }
            this.parseLockScope(lockScopeElement);
            this.parseLockType(lockTypeElement);
            this.parseOwner(lockOwnerElement);
        }
        catch (JDOMException e) {
            int statusCode = 400;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (IOException e) {
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    private void parseLockScope(Element lockScopeElement) throws JDOMException {
        if (lockScopeElement == null) {
            throw new JDOMException("Expected <lockscope> element");
        }
        List children = lockScopeElement.getChildren();
        if (children.size() != 1) {
            throw new JDOMException("<lockscope> must have exactly one child element");
        }
        this.lockInfo_lockScope = ((Element)children.get(0)).getName();
    }

    private void parseLockType(Element lockTypeElement) throws JDOMException {
        if (lockTypeElement == null) {
            throw new JDOMException("Expected <locktype> element");
        }
        List children = lockTypeElement.getChildren();
        if (children.size() != 1) {
            throw new JDOMException("<locktype> must have exactly one child element");
        }
        this.lockInfo_lockType = ((Element)children.get(0)).getName();
    }

    private void parseOwner(Element ownerElement) throws JDOMException {
        if (ownerElement == null) {
            this.lockInfo_lockOwner = DEFAULT_LOCK_OWNER;
            return;
        }
        StringWriter stringWriter = new StringWriter();
        XMLOutputter xmlOutputter = new XMLOutputter();
        try {
            xmlOutputter.outputElementContent(ownerElement, (Writer)stringWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.lockInfo_lockOwner = stringWriter.toString();
        if (this.lockInfo_lockOwner.length() == 0) {
            this.lockInfo_lockOwner = DEFAULT_LOCK_OWNER;
        }
    }

    protected void parseRequest() throws WebdavException {
        String depthStr;
        this.propertyHelper = PropertyHelper.getPropertyHelper(this.slideToken, this.token, this.getConfig());
        this.readRequestContent();
        this.serverURL = "http://" + this.req.getServerName() + ":" + this.req.getServerPort();
        this.lockInfo_lockSubject = this.requestUri;
        if (this.lockInfo_lockSubject == null) {
            this.lockInfo_lockSubject = "/";
        }
        this.depth = (depthStr = this.req.getHeader("Depth")) == null ? -1 : (depthStr.equals("0") ? 0 : -1);
        String lockDurationStr = this.req.getHeader("Timeout");
        if (lockDurationStr != null) {
            int firstCommaPos = lockDurationStr.indexOf(44);
            if (firstCommaPos != -1) {
                lockDurationStr = lockDurationStr.substring(0, firstCommaPos);
            }
            if (lockDurationStr.startsWith("Second-")) {
                try {
                    this.lockDuration = new Integer(lockDurationStr.substring(7));
                }
                catch (NumberFormatException numberFormatException) {
                    this.lockDuration = 604800;
                }
            } else if (lockDurationStr.equalsIgnoreCase("Infinite")) {
                this.lockDuration = 604800;
            } else {
                try {
                    this.lockDuration = new Integer(lockDurationStr);
                }
                catch (NumberFormatException numberFormatException) {
                    this.lockDuration = 604800;
                }
            }
            if (this.lockDuration > 604800) {
                this.lockDuration = 604800;
            }
        }
        if (this.req.getContentLength() > 0) {
            this.parseLockInfo();
        } else {
            this.lockType = 1;
        }
    }

    protected void showLockDiscoveryInfo(NodeLock token) throws WebdavException {
        Element prop = new Element("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        Element lockdiscovery = new Element("lockdiscovery", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        prop.addContent(lockdiscovery);
        XMLValue xmlValue = this.propertyHelper.computeLockDiscovery(token, this.serverURL, this.req.getContextPath());
        Iterator iterator = xmlValue.iterator();
        while (iterator.hasNext()) {
            lockdiscovery.addContent((Element)iterator.next());
        }
        try {
            this.resp.setContentType("text/xml; charset=\"UTF-8\"");
            PrintWriter writer = this.resp.getWriter();
            new XMLOutputter("    ", true).output(new Document(prop), (Writer)writer);
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }
}

