/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.RevisionContentNotFoundException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.util.LabeledRevisionNotFoundException;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.WebdavUtils;

public class GetMethod
extends AbstractWebdavMethod {
    protected final int BUFFER_SIZE = 2048;
    protected static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    protected static final String mimeSeparation = "SLIDE_MIME_BOUNDARY";
    protected int input = 2048;
    protected int output = 2048;
    protected boolean printContent = true;
    protected VersioningHelper vHelp = null;
    protected String resourcePath;

    public GetMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    private boolean checkIfHeaders(HttpServletRequest request, HttpServletResponse response, ResourceInfo resourceInfo) throws IOException {
        SimpleDateFormat simpleDateFormat;
        String currentToken;
        StringTokenizer commaTokenizer;
        String eTag = this.getETag(resourceInfo, true);
        long fileLength = resourceInfo.length;
        long lastModified = resourceInfo.date;
        String headerValue = request.getHeader("If-Match");
        if (headerValue != null && headerValue.indexOf("*") == -1) {
            commaTokenizer = new StringTokenizer(headerValue, ",");
            boolean conditionSatisfied = false;
            while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                currentToken = commaTokenizer.nextToken();
                if (!currentToken.trim().equals(eTag)) continue;
                conditionSatisfied = true;
            }
            if (!conditionSatisfied) {
                response.sendError(412);
                return false;
            }
        }
        if ((headerValue = request.getHeader("If-Modified-Since")) != null && request.getHeader("If-None-Match") == null) {
            Date date = null;
            int i = 0;
            while (date == null && i < formats.length) {
                try {
                    simpleDateFormat = formats[i];
                    synchronized (simpleDateFormat) {
                        date = formats[i].parse(headerValue);
                    }
                }
                catch (ParseException parseException) {}
                ++i;
            }
            if (date != null && lastModified <= date.getTime() + 1000L) {
                response.sendError(304);
                return false;
            }
        }
        if ((headerValue = request.getHeader("If-None-Match")) != null) {
            if (headerValue.indexOf("*") == -1) {
                commaTokenizer = new StringTokenizer(headerValue, ",");
                boolean conditionSatisfied = false;
                while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                    currentToken = commaTokenizer.nextToken();
                    if (!currentToken.trim().equals(eTag)) continue;
                    conditionSatisfied = true;
                }
                if (conditionSatisfied) {
                    if ("GET".equals(request.getMethod()) || "HEAD".equals(request.getMethod())) {
                        response.sendError(304);
                        return false;
                    }
                    response.sendError(412);
                    return false;
                }
            } else {
                resourceInfo.exists();
            }
        }
        if ((headerValue = request.getHeader("If-Unmodified-Since")) != null) {
            Date date = null;
            int i = 0;
            while (date == null && i < formats.length) {
                try {
                    simpleDateFormat = formats[i];
                    synchronized (simpleDateFormat) {
                        date = formats[i].parse(headerValue);
                    }
                }
                catch (ParseException parseException) {}
                ++i;
            }
            if (date != null && lastModified > date.getTime()) {
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    private void copy(ResourceInfo resourceInfo, InputStream resourceInputStream, ServletOutputStream ostream) throws IOException {
        IOException exception = null;
        BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
        exception = this.copyRange(istream, ostream);
        try {
            ((InputStream)istream).close();
        }
        catch (Throwable throwable) {}
        try {
            ostream.flush();
        }
        catch (Throwable throwable) {}
        try {
            ostream.close();
        }
        catch (Throwable throwable) {}
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(ResourceInfo resourceInfo, InputStream resourceInputStream, ServletOutputStream ostream, Enumeration ranges, String contentType) throws IOException {
        IOException exception = null;
        while (exception == null && ranges.hasMoreElements()) {
            BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
            Range currentRange = (Range)ranges.nextElement();
            ostream.println("--SLIDE_MIME_BOUNDARY");
            if (contentType != null) {
                ostream.println("Content-Type: " + contentType);
            }
            ostream.println("Content-Range: bytes " + currentRange.start + "-" + currentRange.end + "/" + currentRange.length);
            ostream.println();
            exception = this.copyRange(istream, ostream, currentRange.start, currentRange.end);
            try {
                ((InputStream)istream).close();
            }
            catch (Throwable throwable) {}
        }
        ostream.print("--SLIDE_MIME_BOUNDARY--");
        try {
            ostream.flush();
        }
        catch (Throwable throwable) {}
        try {
            ostream.close();
        }
        catch (Throwable throwable) {}
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(ResourceInfo resourceInfo, InputStream resourceInputStream, ServletOutputStream ostream, Range range) throws IOException {
        IOException exception = null;
        BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
        exception = this.copyRange(istream, ostream, range.start, range.end);
        try {
            ((InputStream)istream).close();
        }
        catch (Throwable throwable) {}
        try {
            ostream.flush();
        }
        catch (Throwable throwable) {}
        try {
            ostream.close();
        }
        catch (Throwable throwable) {}
        if (exception != null) {
            throw exception;
        }
    }

    private IOException copyRange(InputStream istream, ServletOutputStream ostream) {
        IOException exception = null;
        byte[] buffer = new byte[this.input];
        int len = buffer.length;
        try {
            while ((len = istream.read(buffer)) != -1) {
                ostream.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    private IOException copyRange(InputStream istream, ServletOutputStream ostream, long start, long end) {
        try {
            istream.skip(start);
        }
        catch (IOException e) {
            return e;
        }
        IOException exception = null;
        long bytesToRead = end - start + 1L;
        byte[] buffer = new byte[this.input];
        int len = buffer.length;
        while (bytesToRead > 0L && len >= buffer.length) {
            try {
                len = istream.read(buffer);
                if (bytesToRead >= (long)len) {
                    ostream.write(buffer, 0, len);
                    bytesToRead -= (long)len;
                } else {
                    ostream.write(buffer, 0, (int)bytesToRead);
                    bytesToRead = 0L;
                }
            }
            catch (IOException e) {
                exception = e;
                len = -1;
            }
            if (len < buffer.length) break;
        }
        return exception;
    }

    protected void executeRequest() throws WebdavException {
        try {
            ObjectNode object = this.structure.retrieve(this.slideToken, this.resourcePath);
            NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.slideToken, this.resourcePath);
            if (revisionDescriptors.hasRevisions()) {
                NodeRevisionDescriptor revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors);
                if (revisionDescriptor != null) {
                    ResourceInfo resourceInfo = new ResourceInfo(this.resourcePath, revisionDescriptor);
                    if (!this.checkIfHeaders(this.req, this.resp, resourceInfo)) {
                        return;
                    }
                    ServletOutputStream os = this.resp.getOutputStream();
                    InputStream is = null;
                    if (this.printContent) {
                        is = this.content.retrieve(this.slideToken, revisionDescriptors, revisionDescriptor).streamContent();
                    }
                    Vector ranges = this.parseRange(this.req, this.resp, resourceInfo);
                    this.resp.setHeader("ETag", this.getETag(resourceInfo, true));
                    this.resp.setHeader("Content-Language", revisionDescriptor.getContentLanguage());
                    this.resp.addHeader("Last-Modified", revisionDescriptor.getLastModified().toString());
                    if ((ranges == null || ranges.isEmpty()) && this.req.getHeader("Range") == null) {
                        this.resp.setContentType(revisionDescriptor.getContentType());
                        this.resp.setContentLength((int)revisionDescriptor.getContentLength());
                        if (this.printContent) {
                            this.resp.setBufferSize(this.output);
                            this.copy(resourceInfo, is, os);
                        }
                    } else {
                        if (ranges == null || ranges.isEmpty()) {
                            return;
                        }
                        this.resp.setStatus(206);
                        if (ranges.size() == 1) {
                            Range range = (Range)ranges.elementAt(0);
                            this.resp.addHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + range.length);
                            this.resp.setContentLength((int)range.length);
                            this.resp.setContentType(revisionDescriptor.getContentType());
                            if (this.printContent) {
                                this.resp.setBufferSize(this.output);
                                this.copy(resourceInfo, is, os, range);
                            }
                        } else {
                            this.resp.setContentType("multipart/byteranges; boundary=SLIDE_MIME_BOUNDARY");
                            if (this.printContent) {
                                this.resp.setBufferSize(this.output);
                                this.copy(resourceInfo, is, os, ranges.elements(), revisionDescriptor.getContentType());
                            }
                        }
                    }
                } else {
                    this.resp.setStatus(204);
                }
            } else {
                this.resp.setStatus(204);
            }
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    private String getETag(ResourceInfo resourceInfo, boolean strong) {
        if (strong) {
            return "\"" + this.getETagValue(resourceInfo, strong) + "\"";
        }
        return "W/\"" + this.getETagValue(resourceInfo, strong) + "\"";
    }

    private String getETagValue(ResourceInfo resourceInfo, boolean strong) {
        return String.valueOf(resourceInfo.length) + "-" + resourceInfo.date;
    }

    protected int getErrorCode(Exception ex) {
        try {
            throw ex;
        }
        catch (RevisionNotFoundException revisionNotFoundException) {
            return 404;
        }
        catch (RevisionContentNotFoundException revisionContentNotFoundException) {
            return 404;
        }
        catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {
            return 404;
        }
        catch (LinkedObjectNotFoundException linkedObjectNotFoundException) {
            return 404;
        }
        catch (Exception e) {
            return super.getErrorCode(e);
        }
    }

    private Vector parseRange(HttpServletRequest request, HttpServletResponse response, ResourceInfo resourceInfo) throws IOException {
        long fileLength;
        String headerValue = request.getHeader("If-Range");
        if (headerValue != null) {
            String eTag = this.getETag(resourceInfo, true);
            long lastModified = resourceInfo.date;
            Date date = null;
            int i = 0;
            while (date == null && i < formats.length) {
                try {
                    SimpleDateFormat simpleDateFormat = formats[i];
                    synchronized (simpleDateFormat) {
                        date = formats[i].parse(headerValue);
                    }
                }
                catch (ParseException parseException) {}
                ++i;
            }
            if (date == null ? !eTag.equals(headerValue.trim()) : lastModified > date.getTime() + 1000L) {
                return null;
            }
        }
        if ((fileLength = resourceInfo.length) == 0L) {
            return null;
        }
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            response.sendError(416);
            return null;
        }
        rangeHeader = rangeHeader.substring(6);
        Vector<Range> result = new Vector<Range>();
        StringTokenizer commaTokenizer = new StringTokenizer(rangeHeader, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String rangeDefinition = commaTokenizer.nextToken();
            Range currentRange = new Range();
            currentRange.length = fileLength;
            int dashPos = rangeDefinition.indexOf(45);
            if (dashPos == -1) {
                response.sendError(416);
                return null;
            }
            if (dashPos == 0) {
                try {
                    long offset = Long.parseLong(rangeDefinition);
                    currentRange.start = fileLength + offset;
                    currentRange.end = fileLength - 1L;
                }
                catch (NumberFormatException numberFormatException) {
                    response.sendError(416);
                    return null;
                }
            }
            try {
                currentRange.start = Long.parseLong(rangeDefinition.substring(0, dashPos));
                currentRange.end = dashPos < rangeDefinition.length() - 1 ? Long.parseLong(rangeDefinition.substring(dashPos + 1, rangeDefinition.length())) : fileLength - 1L;
            }
            catch (NumberFormatException numberFormatException) {
                response.sendError(416);
                return null;
            }
            if (!currentRange.validate()) {
                response.sendError(416);
                return null;
            }
            result.addElement(currentRange);
        }
        return result;
    }

    protected void parseRequest() throws WebdavException {
        this.vHelp = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.getConfig());
        this.resourcePath = this.requestUri;
        if (this.resourcePath == null) {
            this.resourcePath = "/";
        }
        if (Configuration.useVersionControl()) {
            try {
                String labelHeader = WebdavUtils.fixTomcatHeader(this.req.getHeader("Label"), "UTF-8");
                this.resourcePath = this.vHelp.getLabeledResourceUri(this.resourcePath, labelHeader);
            }
            catch (LabeledRevisionNotFoundException labeledRevisionNotFoundException) {
                ViolatedPrecondition violatedPrecondition = new ViolatedPrecondition("must-select-version-in-history", 409);
                try {
                    this.sendPreconditionViolation(new PreconditionViolationException(violatedPrecondition, this.resourcePath));
                }
                catch (IOException iOException) {}
                throw new WebdavException(409);
            }
            catch (SlideException e) {
                int statusCode = this.getErrorCode((Exception)((Object)e));
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
        }
    }

    private class Range {
        public long start;
        public long end;
        public long length;

        Range() {
        }

        public boolean validate() {
            return this.start >= 0L && this.end >= 0L && this.length > 0L && this.start <= this.end && this.end < this.length;
        }
    }

    private class ResourceInfo {
        public String path;
        public long creationDate;
        public String httpDate;
        public long date;
        public long length;
        public boolean exists;

        public ResourceInfo(String path, NodeRevisionDescriptor properties) {
            this.path = path;
            this.exists = true;
            this.creationDate = properties.getCreationDateAsDate().getTime();
            this.date = properties.getLastModifiedAsDate().getTime();
            this.httpDate = properties.getLastModified();
            this.length = properties.getContentLength();
        }

        public boolean exists() {
            return this.exists;
        }

        public String toString() {
            return this.path;
        }
    }
}

