/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NestedSlideException;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.macro.DeleteListener;
import org.apache.slide.macro.DeleteMacroException;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractMultistatusResponseMethod;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.PropertyHelper;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.CheckedOutVersionControlled;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.apache.slide.webdav.util.resourcekind.Working;
import org.jdom.JDOMException;

public class DeleteMethod
extends AbstractMultistatusResponseMethod
implements DeltavConstants,
DeleteListener {
    private String toDelete;
    protected NodeRevisionDescriptors historyNrds = null;
    protected boolean isCollection = false;
    protected UriHandler uriHandler = null;
    protected VersioningHelper versioningHelper = null;

    public DeleteMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    public void afterDelete(String targetUri) throws SlideException {
    }

    public void beforeDelete(String targetUri) throws SlideException {
        if (Configuration.useVersionControl()) {
            NodeRevisionDescriptor nrd;
            this.uriHandler = UriHandler.getUriHandler(targetUri);
            if (this.uriHandler.isVersionUri() && !this.isCollection) {
                throw new PreconditionViolationException(new ViolatedPrecondition("no-version-delete", 403), targetUri);
            }
            NodeRevisionDescriptors nrds = this.content.retrieve(this.slideToken, targetUri);
            ResourceKind rk = AbstractResourceKind.determineResourceKind(this.token, nrds, nrd = this.content.retrieve(this.slideToken, nrds));
            if (rk instanceof CheckedOutVersionControlled || rk instanceof Working) {
                String vrUri = VersioningHelper.getUriOfAssociatedVR(this.token, this.slideToken, this.content, targetUri);
                try {
                    NodeRevisionDescriptors vrNrds = this.content.retrieve(this.slideToken, vrUri);
                    NodeRevisionDescriptor vrNrd = this.content.retrieve(this.slideToken, vrNrds);
                    PropertyHelper.removeHrefFromProperty(vrNrd, "checkout-set", targetUri);
                    this.content.store(this.slideToken, vrNrds.getUri(), vrNrd, null);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                }
                catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {
                }
                catch (JDOMException e) {
                    throw new SlideException("Unable to update DAV:checkout-set of " + vrUri + ": " + e.getMessage());
                }
            }
        }
    }

    protected void executeRequest() throws WebdavException {
        this.slideToken.setForceStoreEnlistment(true);
        this.isCollection = this.isCollection(this.toDelete);
        try {
            this.macro.delete(this.slideToken, this.toDelete, null, (DeleteListener)this);
            this.resp.setStatus(204);
        }
        catch (DeleteMacroException dme) {
            if (this.generate207Response(this.isCollection, (NestedSlideException)((Object)dme), this.requestUri)) {
                String errorMessage = this.generateErrorMessage((NestedSlideException)((Object)dme));
                this.resp.setStatus(207);
                try {
                    this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                    this.resp.getWriter().write(errorMessage);
                }
                catch (IOException ex) {
                    int statusCode = 500;
                    this.sendError(statusCode, ex);
                    throw new WebdavException(statusCode);
                }
            } else {
                SlideException exception = (SlideException)((Object)dme.enumerateExceptions().nextElement());
                if (exception instanceof PreconditionViolationException) {
                    try {
                        this.sendPreconditionViolation((PreconditionViolationException)exception);
                    }
                    catch (IOException ex) {
                        int statusCode = 500;
                        this.sendError(statusCode, ex);
                        throw new WebdavException(statusCode);
                    }
                } else {
                    int statusCode = this.getErrorCode(exception);
                    this.sendError(statusCode, exception);
                    throw new WebdavException(statusCode);
                }
            }
            throw new WebdavException(202, false);
        }
    }

    protected void parseRequest() throws WebdavException {
        this.versioningHelper = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.config);
        this.toDelete = this.requestUri;
        if (this.toDelete == null) {
            this.toDelete = "/";
        }
    }
}

