/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NestedSlideException;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.BranchNotFoundException;
import org.apache.slide.content.NodeNotVersionedException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.macro.CopyListener;
import org.apache.slide.macro.CopyRouteRedirector;
import org.apache.slide.macro.DeleteListener;
import org.apache.slide.macro.Macro;
import org.apache.slide.macro.MacroException;
import org.apache.slide.macro.MacroParameters;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractMultistatusResponseMethod;
import org.apache.slide.webdav.method.PutMethod;
import org.apache.slide.webdav.method.VersionControlMethod;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.LabeledRevisionNotFoundException;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.PropertyHelper;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.CheckedInVersionControlled;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.apache.slide.webdav.util.resourcekind.VersionableImpl;
import org.jdom.JDOMException;

public class CopyMethod
extends AbstractMultistatusResponseMethod
implements DeltavConstants,
CopyListener,
DeleteListener,
CopyRouteRedirector {
    protected VersioningHelper versioningHelper = null;
    protected Map destinationDescriptorMap = new HashMap();
    protected Map destinationBackupDescriptorMap = new HashMap();
    protected String labelHeader = null;
    private boolean isInVersioncontrolExcludePath = false;

    public CopyMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    public void afterCopy(String sourceUri, String destinationUri) throws SlideException {
        if (Configuration.useVersionControl()) {
            NodeRevisionDescriptors destinationRevisionDescriptors = this.content.retrieve(this.slideToken, destinationUri);
            NodeRevisionDescriptor destinationRevisionDescriptor = this.content.retrieve(this.slideToken, destinationRevisionDescriptors);
            this.restoreBackupRevisionDescriptor(destinationUri, destinationRevisionDescriptors);
            NodeRevisionDescriptor existingDestinationRevisionDescriptor = (NodeRevisionDescriptor)this.destinationDescriptorMap.get(destinationUri);
            if (existingDestinationRevisionDescriptor != null) {
                this.restoreLiveProperties(destinationRevisionDescriptor, existingDestinationRevisionDescriptor);
            } else {
                this.resetDeltavProperties(destinationRevisionDescriptor);
            }
            this.versioningHelper.setWorkspaceProperty(destinationUri, destinationRevisionDescriptor);
            this.content.store(this.slideToken, destinationRevisionDescriptors.getUri(), destinationRevisionDescriptor, null);
            boolean mustCheckin = this.versioningHelper.mustCheckinAutoVersionedVCR(this.slideToken, destinationRevisionDescriptors, destinationRevisionDescriptor);
            if (mustCheckin) {
                try {
                    this.versioningHelper.checkin(destinationUri, false, false, true);
                }
                catch (IOException e) {
                    throw new SlideException("Checkin failed: " + e.getMessage());
                }
                catch (JDOMException e) {
                    throw new SlideException("Checkin failed: " + e.getMessage());
                }
            }
            if (PutMethod.AUTO_VERSION_CONTROL && !this.isCollection(destinationUri) && !this.isInVersioncontrolExcludePath) {
                this.versioningHelper.versionControl(destinationUri);
            }
        }
    }

    public void afterDelete(String targetUri) throws SlideException {
    }

    public void beforeCopy(String sourceUri, String destinationUri) throws SlideException {
        UriHandler uriHandler;
        if (Configuration.useVersionControl() && (uriHandler = UriHandler.getUriHandler(sourceUri)).isHistoryUri()) {
            throw new PreconditionViolationException(new ViolatedPrecondition("cannot-copy-history", 403), sourceUri);
        }
    }

    public void beforeDelete(String targetUri) throws SlideException {
        if (Configuration.useVersionControl()) {
            boolean destinationExists = false;
            NodeRevisionDescriptors revisionDescriptors = null;
            NodeRevisionDescriptor revisionDescriptor = null;
            try {
                revisionDescriptors = this.content.retrieve(this.slideToken, targetUri);
                revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors);
                destinationExists = true;
            }
            catch (ObjectNotFoundException objectNotFoundException) {}
            if (destinationExists) {
                UriHandler uriHandler;
                ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.token, targetUri, revisionDescriptor);
                if (resourceKind instanceof CheckedInVersionControlled) {
                    String autoVersion = this.versioningHelper.getAutoVersionElementName(revisionDescriptor);
                    if (autoVersion == null) {
                        autoVersion = "";
                    }
                    if (!("checkout-checkin".equals(autoVersion) || "checkout-unlocked-checkin".equals(autoVersion) || "checkout".equals(autoVersion) || "locked-checkout".equals(autoVersion))) {
                        throw new PreconditionViolationException(new ViolatedPrecondition("cannot-modify-version-controlled-content", 403), targetUri);
                    }
                    if ("locked-checkout".equals(autoVersion) && !this.versioningHelper.isWriteLocked(this.slideToken, revisionDescriptors)) {
                        throw new PreconditionViolationException(new ViolatedPrecondition("cannot-modify-version-controlled-content", 403), targetUri);
                    }
                }
                if ((uriHandler = UriHandler.getUriHandler(targetUri)).isVersionUri()) {
                    throw new PreconditionViolationException(new ViolatedPrecondition("cannot-modify-version", 403), targetUri);
                }
                if (Configuration.useVersionControl() && resourceKind instanceof CheckedInVersionControlled && this.versioningHelper.mustCheckoutAutoVersionedVCR(revisionDescriptors, revisionDescriptor)) {
                    try {
                        this.versioningHelper.checkout(revisionDescriptors, revisionDescriptor, false, false, true);
                    }
                    catch (IOException e) {
                        throw new SlideException("Checkout failed: " + e.getMessage());
                    }
                    catch (JDOMException e) {
                        throw new SlideException("Checkout failed: " + e.getMessage());
                    }
                }
                try {
                    NodeRevisionDescriptor backupDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors, NodeRevisionNumber.HIDDEN_0_0);
                    this.destinationBackupDescriptorMap.put(targetUri, backupDescriptor);
                }
                catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {}
                this.destinationDescriptorMap.put(targetUri, revisionDescriptor);
            }
        }
    }

    protected void executeRequest() throws WebdavException, IOException {
        UriHandler exUh;
        this.slideToken.setForceStoreEnlistment(true);
        MacroParameters macroParameters = null;
        Object status = null;
        boolean isCollection = this.isCollection(this.sourceUri);
        macroParameters = this.overwrite ? Macro.RECURSIVE_OVERWRITE_PARAMETERS : Macro.DEFAULT_PARAMETERS;
        UriHandler destUh = UriHandler.getUriHandler(this.destinationUri);
        if (VersionControlMethod.VERSIONCONTROL_EXCLUDEPATH != null && VersionControlMethod.VERSIONCONTROL_EXCLUDEPATH.length() > 0 && (exUh = UriHandler.getUriHandler(VersionControlMethod.VERSIONCONTROL_EXCLUDEPATH)).isAncestorOf(destUh)) {
            this.isInVersioncontrolExcludePath = true;
        }
        if (destUh.isRestrictedUri()) {
            boolean sendError = true;
            if (destUh.isWorkspaceUri() || destUh.isWorkingresourceUri()) {
                try {
                    this.content.retrieve(this.slideToken, this.destinationUri);
                    sendError = false;
                }
                catch (Exception exception) {}
            }
            if (sendError) {
                int statusCode = 403;
                this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".restrictedDestinationUri", new Object[]{this.destinationUri});
                throw new WebdavException(statusCode);
            }
        }
        try {
            this.macro.copy(this.slideToken, this.sourceUri, this.destinationUri, macroParameters, (CopyRouteRedirector)this, (CopyListener)this, null, (DeleteListener)this);
            if (this.overwrite) {
                this.resp.setStatus(204);
            } else {
                this.resp.setStatus(201);
            }
        }
        catch (MacroException e) {
            if (this.generate207Response(isCollection, (NestedSlideException)((Object)e), this.requestUri)) {
                String errorMessage = this.generateErrorMessage((NestedSlideException)((Object)e));
                this.resp.setStatus(207);
                try {
                    this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                    this.resp.getWriter().write(errorMessage);
                }
                catch (IOException iOException) {
                    int statusCode = 500;
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
            } else {
                SlideException exception = (SlideException)((Object)e.enumerateExceptions().nextElement());
                if (exception instanceof PreconditionViolationException) {
                    try {
                        this.sendPreconditionViolation((PreconditionViolationException)exception);
                    }
                    catch (IOException iOException) {
                        int statusCode = 500;
                        this.sendError(statusCode, e);
                        throw new WebdavException(statusCode);
                    }
                } else {
                    int statusCode = this.getErrorCode(exception);
                    this.sendError(statusCode, exception);
                    throw new WebdavException(statusCode);
                }
            }
            throw new WebdavException(202, false);
        }
    }

    protected int getErrorCode(SlideException ex) {
        try {
            throw ex;
        }
        catch (RevisionNotFoundException revisionNotFoundException) {
            return 404;
        }
        catch (SlideException e) {
            return super.getErrorCode(e);
        }
    }

    public CopyRouteRedirector.CopyRoute getRedirectedCopyRoute(CopyRouteRedirector.CopyRoute copyRoute) throws SlideException {
        if (Configuration.useVersionControl()) {
            String sourceUri = copyRoute.getSourceUri();
            String destinationUri = copyRoute.getDestinationUri();
            try {
                sourceUri = this.versioningHelper.getLabeledResourceUri(sourceUri, this.labelHeader);
            }
            catch (LabeledRevisionNotFoundException labeledRevisionNotFoundException) {
                ViolatedPrecondition violatedPrecondition = new ViolatedPrecondition("must-select-version-in-history", 409);
                throw new PreconditionViolationException(violatedPrecondition, sourceUri);
            }
            copyRoute = new CopyRouteRedirector.CopyRoute(sourceUri, destinationUri);
        }
        return copyRoute;
    }

    private boolean isLivePropertyToRestore(NodeProperty property) {
        return property.isLiveProperty() && DeltavConstants.DELTAV_PROPERTY_LIST.contains(property.getName());
    }

    protected void parseRequest() throws WebdavException {
        super.parseRequest();
        this.versioningHelper = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.config);
        this.labelHeader = WebdavUtils.fixTomcatHeader(this.req.getHeader("Label"), "UTF-8");
    }

    private void resetDeltavProperties(NodeRevisionDescriptor revisionDescriptor) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this.slideToken, this.token, this.getConfig());
        ResourceKind resourceKind = VersionableImpl.getInstance();
        Iterator initialPropertyIterator = propertyHelper.createInitialProperties(resourceKind).iterator();
        NodeProperty property = null;
        ArrayList<NodeProperty> initialDeltavProperties = new ArrayList<NodeProperty>();
        while (initialPropertyIterator.hasNext()) {
            property = (NodeProperty)initialPropertyIterator.next();
            if (!DeltavConstants.DELTAV_PROPERTY_LIST.contains(property.getName())) continue;
            initialDeltavProperties.add(property);
        }
        Enumeration propertyEnum = revisionDescriptor.enumerateProperties();
        property = null;
        int index = 0;
        while (propertyEnum.hasMoreElements()) {
            property = (NodeProperty)propertyEnum.nextElement();
            if (!DeltavConstants.DELTAV_PROPERTY_LIST.contains(property.getName())) continue;
            index = initialDeltavProperties.indexOf(property);
            if (index >= 0) {
                revisionDescriptor.setProperty((NodeProperty)initialDeltavProperties.get(index));
                continue;
            }
            revisionDescriptor.removeProperty(property);
        }
    }

    private void restoreBackupRevisionDescriptor(String destinationUri, NodeRevisionDescriptors destinationRevisionDescriptors) throws RevisionNotFoundException, ServiceAccessException, RevisionAlreadyExistException, ObjectNotFoundException, LinkedObjectNotFoundException, ObjectLockedException, AccessDeniedException, RevisionDescriptorNotFoundException, BranchNotFoundException, NodeNotVersionedException {
        block2: {
            NodeRevisionDescriptor destinationBackupDescriptor = (NodeRevisionDescriptor)this.destinationBackupDescriptorMap.get(destinationUri);
            if (destinationBackupDescriptor == null) break block2;
            try {
                this.content.retrieve(this.slideToken, destinationRevisionDescriptors, NodeRevisionNumber.HIDDEN_0_0);
                this.content.store(this.slideToken, destinationRevisionDescriptors.getUri(), destinationBackupDescriptor, null);
            }
            catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {
                this.content.create(this.slideToken, destinationRevisionDescriptors.getUri(), null, destinationBackupDescriptor, null);
            }
        }
    }

    private void restoreLiveProperties(NodeRevisionDescriptor destinationRevisionDescriptor, NodeRevisionDescriptor existingDestinationRevisionDescriptor) {
        Enumeration propertyEnum = destinationRevisionDescriptor.enumerateProperties();
        NodeProperty property = null;
        while (propertyEnum.hasMoreElements()) {
            property = (NodeProperty)propertyEnum.nextElement();
            if (!this.isLivePropertyToRestore(property)) continue;
            destinationRevisionDescriptor.removeProperty(property);
        }
        propertyEnum = existingDestinationRevisionDescriptor.enumerateProperties();
        property = null;
        while (propertyEnum.hasMoreElements()) {
            property = (NodeProperty)propertyEnum.nextElement();
            if (!this.isLivePropertyToRestore(property)) continue;
            destinationRevisionDescriptor.setProperty(property);
        }
    }
}

