/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.security.NodePermission;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.util.AclConstants;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class AclMethod
extends AbstractWebdavMethod
implements AclConstants {
    protected static final int PRIVILEGE_ALL = 0;
    protected static final int PRIVILEGE_READ = 1;
    protected static final int PRIVILEGE_READ_OBJECT = 2;
    protected static final int PRIVILEGE_READ_REVISION_METADATA = 3;
    protected static final int PRIVILEGE_READ_REVISION_CONTENT = 4;
    protected static final int PRIVILEGE_WRITE = 5;
    protected static final int PRIVILEGE_CREATE_OBJECT = 6;
    protected static final int PRIVILEGE_REMOVE_OBJECT = 7;
    protected static final int PRIVILEGE_LOCK_OBJECT = 8;
    protected static final int PRIVILEGE_READ_LOCKS = 9;
    protected static final int PRIVILEGE_CREATE_REVISION_METADATA = 10;
    protected static final int PRIVILEGE_MODIFY_REVISION_METADATA = 11;
    protected static final int PRIVILEGE_REMOVE_REVISION_METADATA = 12;
    protected static final int PRIVILEGE_CREATE_REVISION_CONTENT = 13;
    protected static final int PRIVILEGE_MODIFY_REVISION_CONTENT = 14;
    protected static final int PRIVILEGE_REMOVE_REVISION_CONTENT = 15;
    protected static final int PRIVILEGE_READ_ACL = 16;
    protected static final int PRIVILEGE_WRITE_ACL = 17;
    protected static final int PRIVILEGE_GRANT_PERMISSION = 18;
    protected static final int PRIVILEGE_REVOKE_PERMISSION = 19;
    protected String resourcePath;
    protected Vector permissions = new Vector();
    protected NamespaceConfig config;

    public AclMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void addPermission(String principal, String action, boolean negative, boolean inheritable) {
        NodePermission permission = new NodePermission(this.resourcePath, principal, action, inheritable, negative);
        if (!this.permissions.contains(permission)) {
            this.permissions.addElement(permission);
        }
    }

    protected void executeRequest() throws WebdavException, IOException {
        this.slideToken.setForceStoreEnlistment(true);
        try {
            this.security.setPermissions(this.slideToken, this.resourcePath, this.permissions.elements());
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    protected Element getChild(Element parent, Namespace namespace, String name) {
        List childrenList = parent.getChildren(name, namespace);
        if (childrenList.size() > 0) {
            return (Element)childrenList.get(0);
        }
        return null;
    }

    protected boolean hasChild(Element parent, Namespace namespace, String name) {
        return parent.getChildren(name, namespace).size() == 1;
    }

    protected boolean methodNeedsTransactionSupport() {
        return true;
    }

    protected String parseInheritence(Element inheritence) throws JDOMException {
        Element href = this.getChild(inheritence, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE, "href");
        if (href != null) {
            String text = href.getText();
            if (text.length() == 0) {
                throw new JDOMException("&lt;href&gt; element of &lt;" + inheritence.getName() + "&gt; must not be emtpy");
            }
            return this.getSlidePath(text);
        }
        throw new JDOMException("&lt;" + inheritence.getName() + "&gt; element must contain a &lt;" + "href" + "&gt; element");
    }

    protected String parsePrincipal(Element principal) throws JDOMException {
        Element href = this.getChild(principal, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE, "href");
        if (href != null) {
            String text = href.getText();
            if (text.length() == 0) {
                throw new JDOMException("&lt;href&gt; element of &lt;" + principal.getName() + "&gt; must not be emtpy");
            }
            return this.getSlidePath(text);
        }
        if (this.hasChild(principal, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE, "all")) {
            return "nobody";
        }
        if (this.hasChild(principal, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE, "self")) {
            return "~";
        }
        if (this.hasChild(principal, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE, "unauthenticated")) {
            return String.valueOf(this.token.getNamespaceConfig().getUsersPath()) + "/" + this.token.getNamespaceConfig().getGuestPath();
        }
        throw new JDOMException("&lt;" + principal.getName() + "&gt; element must contain either a " + "&lt;" + "href" + "&gt;, " + "&lt;" + "all" + "&gt;, " + "&lt;" + "self" + "&gt; or " + "&lt;" + "unauthenticated" + "&gt; element.");
    }

    protected int parsePrivilege(Element privilege) throws JDOMException {
        if (this.hasChild(privilege, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE, "all")) {
            return 0;
        }
        if (this.hasChild(privilege, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE, "read")) {
            return 1;
        }
        if (this.hasChild(privilege, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE, "write")) {
            return 5;
        }
        if (this.hasChild(privilege, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE, "read-acl")) {
            return 16;
        }
        if (this.hasChild(privilege, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE, "write-acl")) {
            return 17;
        }
        System.err.println("Error: Unknown privilege !!!");
        throw new JDOMException("Unknown privilege &lt;" + privilege.getName() + "&gt;");
    }

    protected void parseRequest() throws WebdavException {
        this.resourcePath = this.requestUri;
        if (this.resourcePath == null) {
            this.resourcePath = "/";
        }
        this.readRequestContent();
        this.config = this.token.getNamespaceConfig();
        try {
            if (this.requestBody.length() == 0) {
                throw new JDOMException("Request content must not be empty");
            }
            Document document = this.parseRequestContent();
            Element acl = document.getRootElement();
            if (acl == null || !"acl".equals(acl.getName())) {
                throw new JDOMException("Request content document must start with an <acl> element");
            }
            List aceList = acl.getChildren("ace", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            Iterator aceIterator = aceList.iterator();
            while (aceIterator.hasNext()) {
                boolean inheritable = true;
                Element ace = (Element)aceIterator.next();
                int protectedCount = ace.getChildren("protected", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE).size();
                if (protectedCount == 1) continue;
                if (protectedCount > 1) {
                    throw new JDOMException("Element <ace> must contain at most one <protected> element");
                }
                List principalList = ace.getChildren("principal", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                if (principalList.size() != 1) {
                    throw new JDOMException("Element <ace> must contain a <principal> element");
                }
                Element principalElement = (Element)principalList.get(0);
                String principal = this.parsePrincipal(principalElement);
                List grantList = ace.getChildren("grant", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                List denyList = ace.getChildren("deny", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                if (grantList.size() + denyList.size() != 1) {
                    throw new JDOMException("Element <ace> must contain either a <grant> or a <deny> element");
                }
                boolean negative = denyList.size() > 0;
                List privilegeList = null;
                if (negative) {
                    Element denyElement = (Element)denyList.get(0);
                    privilegeList = denyElement.getChildren("privilege", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                } else {
                    Element grantElement = (Element)grantList.get(0);
                    privilegeList = grantElement.getChildren("privilege", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
                }
                int j = 0;
                while (j < privilegeList.size()) {
                    Element privilegeElement = (Element)privilegeList.get(j);
                    int privilege = this.parsePrivilege(privilegeElement);
                    switch (privilege) {
                        case 0: {
                            this.addPermission(principal, "/", negative, inheritable);
                            break;
                        }
                        case 1: {
                            this.addPermission(principal, this.config.getReadObjectAction().getUri(), negative, inheritable);
                            this.addPermission(principal, this.config.getReadLocksAction().getUri(), negative, inheritable);
                            this.addPermission(principal, this.config.getReadRevisionMetadataAction().getUri(), negative, inheritable);
                            this.addPermission(principal, this.config.getReadRevisionContentAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 2: {
                            this.addPermission(principal, this.config.getReadObjectAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 9: {
                            this.addPermission(principal, this.config.getReadLocksAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 3: {
                            this.addPermission(principal, this.config.getReadRevisionMetadataAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 4: {
                            this.addPermission(principal, this.config.getReadRevisionContentAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 5: {
                            this.addPermission(principal, this.config.getCreateObjectAction().getUri(), negative, inheritable);
                            this.addPermission(principal, this.config.getRemoveObjectAction().getUri(), negative, inheritable);
                            this.addPermission(principal, this.config.getLockObjectAction().getUri(), negative, inheritable);
                            this.addPermission(principal, this.config.getCreateRevisionMetadataAction().getUri(), negative, inheritable);
                            this.addPermission(principal, this.config.getModifyRevisionMetadataAction().getUri(), negative, inheritable);
                            this.addPermission(principal, this.config.getRemoveRevisionMetadataAction().getUri(), negative, inheritable);
                            this.addPermission(principal, this.config.getCreateRevisionContentAction().getUri(), negative, inheritable);
                            this.addPermission(principal, this.config.getModifyRevisionContentAction().getUri(), negative, inheritable);
                            this.addPermission(principal, this.config.getRemoveRevisionContentAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 6: {
                            this.addPermission(principal, this.config.getCreateObjectAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 7: {
                            this.addPermission(principal, this.config.getRemoveObjectAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 8: {
                            this.addPermission(principal, this.config.getLockObjectAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 10: {
                            this.addPermission(principal, this.config.getCreateRevisionMetadataAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 11: {
                            this.addPermission(principal, this.config.getModifyRevisionMetadataAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 12: {
                            this.addPermission(principal, this.config.getRemoveRevisionMetadataAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 13: {
                            this.addPermission(principal, this.config.getCreateRevisionContentAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 14: {
                            this.addPermission(principal, this.config.getModifyRevisionContentAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 15: {
                            this.addPermission(principal, this.config.getRemoveRevisionContentAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 16: {
                            this.addPermission(principal, this.config.getReadPermissionsAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 17: {
                            this.addPermission(principal, this.config.getGrantPermissionAction().getUri(), negative, inheritable);
                            this.addPermission(principal, this.config.getRevokePermissionAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 18: {
                            this.addPermission(principal, this.config.getGrantPermissionAction().getUri(), negative, inheritable);
                            break;
                        }
                        case 19: {
                            this.addPermission(principal, this.config.getRevokePermissionAction().getUri(), negative, inheritable);
                            break;
                        }
                        default: {
                            int statusCode = 500;
                            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".invalidPrivilegeElement", new Object[]{String.valueOf(String.valueOf(privilegeElement.getNamespace())) + ":" + privilegeElement.getName()});
                            throw new WebdavException(statusCode);
                        }
                    }
                    ++j;
                }
            }
        }
        catch (AbstractMethodError e) {
            System.err.println("You are using using an incorrect older parser");
            System.err.println("that doesn't provide Element::getElementsByTagNameNS");
            System.err.println("consult the documentation for a list of valid parsers.");
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (JDOMException e) {
            System.err.println("Error parsing requestBody:");
            System.err.println(this.requestBody);
            int statusCode = 400;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (IOException e) {
            int statusCode = 400;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }
}

