/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.lock.Lock;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.lock.UnlockListener;
import org.apache.slide.macro.ConflictException;
import org.apache.slide.macro.ForbiddenException;
import org.apache.slide.macro.Macro;
import org.apache.slide.search.Search;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.security.Security;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.Structure;
import org.apache.slide.util.Messages;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavMethod;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.MethodNotAllowedException;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.UnlockListenerImpl;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.util.MD5Encoder;
import org.apache.util.WebdavStatus;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public abstract class AbstractWebdavMethod
implements WebdavMethod {
    protected static final String NO_CACHE = "no-cache";
    public static final String HTTP_PROTOCOL = "http://";
    public static final String HTTP_VERSION = "HTTP/1.1";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_XML_UTF_8 = "text/xml; charset=\"UTF-8\"";
    public static final String XML_REPONSE_INDENT = "    ";
    private static final String LOG_CHANNEL = (class$org$apache$slide$webdav$method$AbstractWebdavMethod != null ? class$org$apache$slide$webdav$method$AbstractWebdavMethod : (class$org$apache$slide$webdav$method$AbstractWebdavMethod = AbstractWebdavMethod.class$("org.apache.slide.webdav.method.AbstractWebdavMethod"))).getName();
    public static final String LOCK_TOKEN = "opaquelocktoken:";
    protected String requestUri;
    protected HttpServletRequest req;
    protected HttpServletResponse resp;
    protected WebdavServletConfig config;
    protected String requestBody;
    protected NamespaceAccessToken token;
    protected Structure structure;
    protected Content content;
    protected Security security;
    protected Lock lock;
    protected Search search;
    protected Macro macro;
    protected SlideToken slideToken;
    protected static MessageDigest md5Helper;
    protected static final MD5Encoder md5Encoder;
    private Document requestContentDocument = null;
    private boolean isRequestContentParsed = false;
    static /* synthetic */ Class class$org$apache$slide$webdav$method$AbstractWebdavMethod;

    static {
        md5Encoder = new MD5Encoder();
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(e.toString());
            throw new IllegalStateException();
        }
    }

    public AbstractWebdavMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        this.config = config;
        this.token = token;
        this.structure = token.getStructureHelper();
        this.content = token.getContentHelper();
        this.security = token.getSecurityHelper();
        this.lock = token.getLockHelper();
        this.macro = token.getMacroHelper();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected abstract void executeRequest() throws WebdavException, IOException;

    protected String getAbsoluteURL(String uri) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(HTTP_PROTOCOL);
        buffer.append(this.req.getServerName());
        buffer.append(":");
        buffer.append(this.req.getServerPort());
        if (!this.req.getContextPath().startsWith("/")) {
            buffer.append("/");
        }
        buffer.append(this.req.getContextPath());
        if (uri != null) {
            if (!this.req.getContextPath().endsWith("/") && !uri.startsWith("/")) {
                buffer.append("/");
            }
            buffer.append(uri);
        }
        return buffer.toString();
    }

    protected boolean getBooleanInitParameter(String name) {
        return "true".equalsIgnoreCase(this.getConfig().getInitParameter(name));
    }

    public WebdavServletConfig getConfig() {
        return this.config;
    }

    public static String getEncodingString(String httpEncoding) {
        String result = httpEncoding;
        if (result == null) {
            result = System.getProperty("file.encoding");
        }
        if (result.startsWith("\"")) {
            result = result.substring(1, result.length());
        }
        if (result.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    protected int getErrorCode(Throwable ex) {
        if (!(ex instanceof SlideException)) {
            return 500;
        }
        return this.getErrorCode((SlideException)ex);
    }

    protected int getErrorCode(ServiceAccessException ex) {
        Throwable cause = ex.getCauseException();
        if (cause == null || !(cause instanceof SlideException)) {
            if (cause != null) {
                cause.printStackTrace();
            }
            return 500;
        }
        return this.getErrorCode((SlideException)cause);
    }

    protected int getErrorCode(SlideException ex) {
        try {
            throw ex;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return 404;
        }
        catch (ConflictException conflictException) {
            return 409;
        }
        catch (ForbiddenException forbiddenException) {
            return 403;
        }
        catch (AccessDeniedException accessDeniedException) {
            return 403;
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            return 412;
        }
        catch (ServiceAccessException serviceAccessException) {
            return this.getErrorCode((ServiceAccessException)((Object)ex));
        }
        catch (ObjectLockedException objectLockedException) {
            return 423;
        }
        catch (WebdavException e) {
            return e.getStatusCode();
        }
        catch (MethodNotAllowedException methodNotAllowedException) {
            return 405;
        }
        catch (SlideException slideException) {
            return 500;
        }
    }

    public String getFullPath(String path) {
        if (path.startsWith("/")) {
            return WebdavUtils.encodeURL(String.valueOf(this.req.getContextPath()) + path);
        }
        return WebdavUtils.encodeURL(String.valueOf(this.req.getContextPath()) + "/" + path);
    }

    protected int getIntInitParameter(String name) {
        int result = -1;
        try {
            result = Integer.parseInt(this.getConfig().getInitParameter(name));
        }
        catch (NumberFormatException numberFormatException) {}
        return result;
    }

    protected Element getPreconditionViolationError(ViolatedPrecondition violatedPrecondition) {
        return this.getPreconditionViolationError(violatedPrecondition, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
    }

    protected Element getPreconditionViolationError(ViolatedPrecondition violatedPrecondition, Namespace namespace) {
        Element error = new Element("error", namespace);
        Element violatedPreconditionElement = new Element(violatedPrecondition.getPrecondition(), namespace);
        error.addContent(violatedPreconditionElement);
        return error;
    }

    protected Document getRequestContent() {
        return this.requestContentDocument;
    }

    public String getSlidePath(String fullpath) {
        String contextPath;
        if (fullpath.indexOf("://") >= 0) {
            fullpath = fullpath.substring(fullpath.indexOf("://") + 3);
            fullpath = fullpath.substring(fullpath.indexOf("/"));
        }
        if (fullpath.startsWith(contextPath = this.req.getContextPath())) {
            fullpath = fullpath.substring(contextPath.length());
        }
        return fullpath;
    }

    protected boolean isCollection(String path) {
        return WebdavUtils.isCollection(this.token, this.slideToken, path);
    }

    protected boolean isMsProprietarySupport() {
        return this.token.getNamespaceConfig().getParameter("ms") != null;
    }

    protected boolean methodNeedsTransactionSupport() {
        return true;
    }

    protected void parseHeaders() {
        String ifHeader = this.req.getHeader("If");
        if (ifHeader == null) {
            return;
        }
        int pos = ifHeader.indexOf(LOCK_TOKEN);
        int endPos = -1;
        int offset = LOCK_TOKEN.length();
        String lockToken = null;
        while (pos != -1) {
            endPos = ifHeader.indexOf(62, pos + offset);
            if (endPos == -1) {
                lockToken = ifHeader;
                endPos = ifHeader.length();
            } else {
                lockToken = ifHeader.substring(pos + offset, endPos);
            }
            this.slideToken.addLockToken(lockToken);
            pos = ifHeader.indexOf(LOCK_TOKEN, endPos);
        }
    }

    protected String parseLockToken(String lockTokenValue) {
        int semi = lockTokenValue.indexOf(":");
        String result = null;
        try {
            result = lockTokenValue.substring(semi + 1, lockTokenValue.length() - 1);
        }
        catch (Exception e) {
            this.token.getLogger().log((Object)e, LOG_CHANNEL, 2);
        }
        return result;
    }

    protected abstract void parseRequest() throws WebdavException;

    protected Document parseRequestContent() throws JDOMException, IOException {
        if (this.isRequestContentParsed) {
            return this.requestContentDocument;
        }
        if (this.requestBody == null) {
            this.readRequestContent();
            if (this.requestBody == null) {
                return this.requestContentDocument;
            }
        }
        try {
            this.requestContentDocument = new SAXBuilder().build((Reader)new StringReader(this.requestBody));
            this.isRequestContentParsed = true;
        }
        catch (JDOMException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
        return this.requestContentDocument;
    }

    protected void printStackTrace(Throwable x, int statusCode) {
        int printStackTraceFrom = this.getIntInitParameter("printStackTrace");
        if (printStackTraceFrom < 0) {
            printStackTraceFrom = 500;
        }
        if (statusCode >= printStackTraceFrom) {
            x.printStackTrace();
        }
    }

    protected void readRequestContent() {
        if (this.req.getContentLength() == 0) {
            return;
        }
        try {
            this.requestBody = new String(NodeRevisionContent.readFromStream((InputStream)this.req.getInputStream()), AbstractWebdavMethod.getEncodingString(this.req.getCharacterEncoding()));
        }
        catch (Exception e) {
            this.token.getLogger().log((Object)e, LOG_CHANNEL, 2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(HttpServletRequest req, HttpServletResponse resp) throws WebdavException {
        this.req = req;
        this.resp = resp;
        this.slideToken = WebdavUtils.getSlideToken(req);
        this.requestUri = WebdavUtils.getRelativePath(req, this.config);
        this.parseHeaders();
        boolean transactionIsStarted = false;
        try {
            try {
                this.parseRequest();
                if (this.methodNeedsTransactionSupport()) {
                    this.token.begin();
                    transactionIsStarted = true;
                }
                try {
                    UnlockListenerImpl listener = new UnlockListenerImpl(this.slideToken, this.token, this.config, req, resp);
                    this.lock.clearExpiredLocks(this.slideToken, this.requestUri, (UnlockListener)listener);
                }
                catch (SlideException slideException) {}
                this.executeRequest();
                if (this.methodNeedsTransactionSupport()) {
                    this.token.commit();
                    return;
                }
            }
            catch (WebdavException webdavException) {
            }
            catch (Exception ex) {
                this.token.getLogger().log((Object)ex, LOG_CHANNEL, 2);
                int statusCode = 500;
                this.sendError(statusCode, ex);
                throw new WebdavException(statusCode);
            }
            Object var5_7 = null;
            if (!transactionIsStarted) return;
            if (!this.methodNeedsTransactionSupport()) return;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (!transactionIsStarted) throw throwable;
            if (!this.methodNeedsTransactionSupport()) throw throwable;
            try {
                this.token.rollback();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            this.token.rollback();
            return;
        }
        catch (Exception exception) {}
    }

    protected void sendError(int statusCode) {
        try {
            this.resp.sendError(statusCode);
        }
        catch (Throwable throwable) {}
    }

    protected void sendError(int statusCode, String message) {
        String statusText = String.valueOf(WebdavStatus.getStatusText((int)statusCode)) + ": " + Messages.format((String)message, null);
        try {
            this.resp.sendError(statusCode, statusText);
        }
        catch (Throwable throwable) {}
    }

    protected void sendError(int statusCode, String message, Object[] args) {
        String statusText = String.valueOf(WebdavStatus.getStatusText((int)statusCode)) + ": " + Messages.format((String)message, (Object[])args);
        try {
            this.resp.sendError(statusCode, statusText);
        }
        catch (Throwable throwable) {}
    }

    protected void sendError(int statusCode, Throwable t) {
        this.printStackTrace(t, statusCode);
        String explanation = t == null || t.getMessage() == null || "".equals(t.getMessage()) ? Messages.format((String)t.getClass().getName(), null) : t.getMessage();
        String statusText = String.valueOf(WebdavStatus.getStatusText((int)statusCode)) + ": " + explanation;
        try {
            this.resp.sendError(statusCode, statusText);
        }
        catch (Throwable throwable) {}
    }

    protected void sendPreconditionViolation(PreconditionViolationException pve) throws IOException {
        if (pve != null) {
            ViolatedPrecondition violatedPrecondition = pve.getViolatedPrecondition();
            int statusCode = violatedPrecondition.getStatusCode();
            this.printStackTrace((Throwable)((Object)pve), statusCode);
            this.resp.setStatus(statusCode);
            this.resp.setContentType(TEXT_XML_UTF_8);
            new XMLOutputter(XML_REPONSE_INDENT, true).output(new Document(this.getPreconditionViolationError(pve.getViolatedPrecondition())), (Writer)this.resp.getWriter());
        }
    }
}

