/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import org.apache.slide.common.Domain;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NestedSlideException;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.macro.ConflictException;
import org.apache.slide.macro.ForbiddenException;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.WebdavConstants;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.util.WebdavStatus;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public abstract class AbstractMultistatusResponseMethod
extends AbstractWebdavMethod
implements WebdavConstants {
    protected String sourceUri;
    protected String destinationUri;
    protected boolean overwrite;

    public AbstractMultistatusResponseMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected boolean generate207Response(boolean isCollection, NestedSlideException causeException, String resourceURI) {
        boolean is207 = false;
        if (isCollection) {
            if (causeException.getExceptionsCount() > 1) {
                is207 = true;
            } else if (causeException.getExceptionsCount() == 1) {
                SlideException unpackedException = causeException.unpackSingleException();
                is207 = resourceURI.equals(this.getURI(unpackedException)) ^ true;
            }
        }
        return is207;
    }

    protected String generateErrorMessage(NestedSlideException nestedException) {
        Element multistatus = new Element("multistatus", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        Enumeration nestedExceptionsList = nestedException.enumerateExceptions();
        while (nestedExceptionsList.hasMoreElements()) {
            Element response = new Element("response", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            multistatus.addContent(response);
            SlideException ex = (SlideException)((Object)nestedExceptionsList.nextElement());
            this.generateStatusText(response, this.getErrorMessage(ex), this.getErrorCode(ex));
            if (!(ex instanceof PreconditionViolationException)) continue;
            response.addContent(this.getPreconditionViolationResponseDescription((PreconditionViolationException)ex));
        }
        StringWriter stringWriter = new StringWriter();
        try {
            new XMLOutputter().output(multistatus, (Writer)stringWriter);
        }
        catch (IOException e) {
            Domain.log((Object)e);
        }
        return stringWriter.toString();
    }

    protected void generateStatusText(Element parentElement, String href, int statusCode) {
        Element hrefElement = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        parentElement.addContent(hrefElement);
        hrefElement.setText(this.getFullPath(href));
        Element statusElement = new Element("status", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        parentElement.addContent(statusElement);
        statusElement.setText("HTTP/1.1 " + statusCode + " " + WebdavStatus.getStatusText((int)statusCode));
    }

    protected String getErrorMessage(Throwable ex) {
        if (!(ex instanceof SlideException)) {
            return "";
        }
        return this.getErrorMessage((SlideException)ex);
    }

    private String getErrorMessage(ServiceAccessException ex) {
        Throwable cause = ex.getCauseException();
        if (cause == null || !(cause instanceof SlideException)) {
            return "";
        }
        return this.getErrorMessage((SlideException)cause);
    }

    private String getErrorMessage(SlideException ex) {
        try {
            throw ex;
        }
        catch (ObjectNotFoundException e) {
            return e.getObjectUri();
        }
        catch (ConflictException e) {
            return e.getObjectUri();
        }
        catch (ForbiddenException e) {
            return e.getObjectUri();
        }
        catch (AccessDeniedException e) {
            return e.getObjectUri();
        }
        catch (ObjectAlreadyExistsException e) {
            return e.getObjectUri();
        }
        catch (ServiceAccessException e) {
            return this.getErrorMessage(e);
        }
        catch (LinkedObjectNotFoundException e) {
            return e.getTargetUri();
        }
        catch (RevisionNotFoundException e) {
            return e.getObjectUri();
        }
        catch (ObjectLockedException e) {
            return e.getObjectUri();
        }
        catch (PreconditionViolationException e) {
            return e.getObjectUri();
        }
        catch (SlideException e) {
            return e.getMessage();
        }
    }

    protected Element getPreconditionViolationResponseDescription(PreconditionViolationException pve) {
        Element responseDescription = new Element("responsedescription", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        responseDescription.addContent(this.getPreconditionViolationError(pve.getViolatedPrecondition()));
        return responseDescription;
    }

    private String getURI(Throwable ex) {
        if (!(ex instanceof SlideException)) {
            return "";
        }
        return this.getURI((SlideException)ex);
    }

    private String getURI(ServiceAccessException ex) {
        Throwable cause = ex.getCauseException();
        if (cause == null || !(cause instanceof SlideException)) {
            return "";
        }
        return this.getURI((SlideException)cause);
    }

    private String getURI(SlideException ex) {
        try {
            throw ex;
        }
        catch (ObjectNotFoundException e) {
            return e.getObjectUri();
        }
        catch (ConflictException e) {
            return e.getObjectUri();
        }
        catch (ForbiddenException e) {
            return e.getObjectUri();
        }
        catch (AccessDeniedException e) {
            return e.getObjectUri();
        }
        catch (ObjectAlreadyExistsException e) {
            return e.getObjectUri();
        }
        catch (ServiceAccessException serviceAccessException) {
            return this.getURI((ServiceAccessException)((Object)ex));
        }
        catch (LinkedObjectNotFoundException e) {
            return e.getTargetUri();
        }
        catch (RevisionNotFoundException e) {
            return e.getObjectUri();
        }
        catch (ObjectLockedException e) {
            return e.getObjectUri();
        }
        catch (SlideException slideException) {
            return "";
        }
    }

    protected boolean methodNeedsTransactionSupport() {
        return true;
    }

    protected void parseRequest() throws WebdavException {
        String servletPath;
        String pathInfo;
        this.sourceUri = this.requestUri;
        if (this.sourceUri == null) {
            this.sourceUri = "/";
        }
        this.destinationUri = this.req.getHeader("Destination");
        if (this.destinationUri == null) {
            int statusCode = 400;
            this.sendError(statusCode, String.valueOf(this.getClass().getName()) + ".missingDestinationHeader");
            throw new WebdavException(statusCode);
        }
        int protocolIndex = this.destinationUri.indexOf("://");
        if (protocolIndex >= 0) {
            int firstSeparator = this.destinationUri.indexOf("/", protocolIndex + 4);
            this.destinationUri = firstSeparator < 0 ? "/" : this.destinationUri.substring(firstSeparator);
        } else {
            int portIndex;
            String hostName = this.req.getServerName();
            if (hostName != null && this.destinationUri.startsWith(hostName)) {
                this.destinationUri = this.destinationUri.substring(hostName.length());
            }
            if ((portIndex = this.destinationUri.indexOf(":")) >= 0) {
                this.destinationUri = this.destinationUri.substring(portIndex);
            }
            if (this.destinationUri.startsWith(":")) {
                int firstSeparator = this.destinationUri.indexOf("/");
                this.destinationUri = firstSeparator < 0 ? "/" : this.destinationUri.substring(firstSeparator);
            }
        }
        this.destinationUri = WebdavUtils.decodeURL(WebdavUtils.fixTomcatURL(this.destinationUri, "ISO-8859-1"));
        String contextPath = this.req.getContextPath();
        if (contextPath != null && this.destinationUri.startsWith(contextPath)) {
            this.destinationUri = this.destinationUri.substring(contextPath.length());
        }
        if ((pathInfo = this.req.getPathInfo()) != null && (servletPath = this.req.getServletPath()) != null && this.destinationUri.startsWith(servletPath)) {
            this.destinationUri = this.destinationUri.substring(servletPath.length());
        }
        this.destinationUri = String.valueOf(this.getConfig().getScope()) + this.destinationUri;
        String overwriteHeader = this.req.getHeader("Overwrite");
        this.overwrite = overwriteHeader != null ? overwriteHeader.equalsIgnoreCase("T") : true;
    }
}

