/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.logger;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import org.apache.slide.common.Domain;
import org.apache.slide.webdav.logger.XByteBuffer;

public class XServletOutputStreamFacade
extends ServletOutputStream {
    public static final String DEFAULT_CHAR_ENCODING = "8859_1";
    public static final byte[] bCRLF = System.getProperty("line.separator").getBytes();
    ServletOutputStream prStream;
    XByteBuffer bb;
    String enc;

    protected XServletOutputStreamFacade(ServletOutputStream soStream, String enc) {
        Domain.debug((Object)"Create XServletOutputStreamFacade");
        this.prStream = soStream;
        this.bb = new XByteBuffer();
    }

    public void close() throws IOException {
        Domain.debug((Object)"XServletOutputStreamFacade:close()");
        this.prStream.close();
    }

    public void flush() throws IOException {
        Domain.debug((Object)"XServletOutputStreamFacade:flush()");
        this.prStream.flush();
    }

    public String getOutputBuffer() throws IOException {
        return this.bb.getBufferContent();
    }

    public void print(String s) throws IOException {
        Domain.debug((Object)("XServletOutputStreamFacade:print(" + s + " )"));
        if (s == null) {
            s = "null";
        }
        byte[] b = null;
        if (this.enc == null) {
            b = s.getBytes();
        } else {
            try {
                b = s.getBytes(this.enc);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                b = s.getBytes();
                this.enc = null;
            }
        }
        this.write(b);
        this.prStream.print(s);
    }

    public void println() throws IOException {
        Domain.debug((Object)"XServletOutputStreamFacade:println()");
        this.write(bCRLF);
        this.prStream.println();
    }

    public void println(String s) throws IOException {
        Domain.debug((Object)("XServletOutputStreamFacade:println(" + s + " )"));
        if (s == null) {
            s = "null";
        }
        byte[] b = null;
        if (this.enc == null) {
            b = s.getBytes();
        } else {
            try {
                b = s.getBytes(this.enc);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                b = s.getBytes();
                this.enc = null;
            }
        }
        this.write(b);
        this.write(bCRLF);
        this.prStream.println(s);
    }

    public void write(int i) throws IOException {
        Domain.debug((Object)"XServletOutputStreamFacade:write(int)");
        this.bb.write(i);
        this.prStream.write(i);
    }

    public void write(byte[] b) throws IOException {
        Domain.debug((Object)"XServletOutputStreamFacade:write(byte[])");
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        Domain.debug((Object)"XServletOutputStreamFacade:write(byte[] b, int off, int len)");
        this.bb.write(b, off, len);
        this.prStream.write(b, off, len);
    }
}

