/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.logger;

import java.io.IOException;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.slide.webdav.logger.XHttpServletRequestFacade;
import org.apache.slide.webdav.logger.XHttpServletResponseFacade;
import org.apache.slide.webdav.logger.XResponseHeader;
import org.apache.util.WebdavStatus;
import org.jdom.CDATA;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class XMLTestCaseGenerator {
    private XMLOutputter xmlOut = new XMLOutputter("  ", true, "UTF-8");
    private XHttpServletRequestFacade request;
    private XHttpServletResponseFacade response;
    private Element root = new Element("test");
    private Document doc = new Document(this.root);
    private String threadName;

    public XMLTestCaseGenerator(XHttpServletRequestFacade request, XHttpServletResponseFacade response) {
        this.request = request;
        this.response = response;
    }

    private String getProtocol() {
        String result = this.request.getProtocol();
        while (result.endsWith("\n")) {
            result = result.substring(0, result.length() - "\n".length() - 1);
        }
        return result;
    }

    public String getThreadName() {
        return this.threadName;
    }

    private Element printXMLrequest() {
        Element stepElem = new Element("request");
        stepElem.addContent(this.printXMLrequestCommand());
        Iterator it = this.printXMLrequestHeaders();
        while (it.hasNext()) {
            stepElem.addContent((Element)it.next());
        }
        stepElem.addContent(this.printXMLrequestBody());
        return stepElem;
    }

    private Element printXMLrequestBody() {
        Element bodyElem = new Element("body");
        try {
            bodyElem.addContent(new CDATA(this.request.getRequestBody()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bodyElem;
    }

    private Element printXMLrequestCommand() {
        Element reqComElem = new Element("command");
        reqComElem.addContent(String.valueOf(this.request.getMethod()) + " " + this.request.getRequestURI() + " " + this.getProtocol());
        return reqComElem;
    }

    private Iterator printXMLrequestHeaders() {
        Vector<Element> vector = new Vector<Element>();
        Enumeration e = this.request.getHeaderNames();
        if (e != null) {
            while (e.hasMoreElements()) {
                String headerName = (String)e.nextElement();
                String headerValue = this.request.getHeader(headerName);
                Element elem = new Element("header");
                elem.addContent(String.valueOf(headerName) + ": " + headerValue);
                vector.add(elem);
            }
        }
        return ((AbstractList)vector).iterator();
    }

    private Element printXMLresponse() {
        Element respElem = new Element("response");
        respElem.addContent(this.printXMLresponseCommand());
        Iterator it = this.printXMLresponseHeaders();
        while (it.hasNext()) {
            respElem.addContent((Element)it.next());
        }
        respElem.addContent(this.printXMLresponseBody());
        return respElem;
    }

    private Element printXMLresponseBody() {
        Element bodyElem = new Element("body");
        try {
            bodyElem.addContent(new CDATA(this.response.getResponseBody()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bodyElem;
    }

    private Element printXMLresponseCommand() {
        Element respComElem = new Element("command");
        respComElem.addContent(String.valueOf(this.getProtocol()) + " " + this.response.getStatus() + " " + WebdavStatus.getStatusText((int)this.response.getStatus()));
        return respComElem;
    }

    private Iterator printXMLresponseHeaders() {
        Vector<Element> vector = new Vector<Element>();
        Enumeration e = this.response.getResponseHeaders();
        if (e != null) {
            while (e.hasMoreElements()) {
                Element elem = new Element("header");
                elem.addContent(((XResponseHeader)e.nextElement()).toString());
                vector.add(elem);
            }
        }
        return ((AbstractList)vector).iterator();
    }

    private Element printXMLstep() {
        Element stepElem = new Element("step");
        stepElem.addContent(this.printXMLrequest());
        stepElem.addContent(this.printXMLresponse());
        return stepElem;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public String toString() {
        String result = "";
        this.root.addContent(this.printXMLstep());
        try {
            result = this.xmlOut.outputString(this.doc.getRootElement().getChild("step"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

