/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.logger;

import java.io.IOException;
import org.apache.slide.common.Domain;

public class XByteBuffer {
    protected static final int DEFAULT_BUFFER_SIZE = 8192;
    int defaultBufferSize = 8192;
    int bytesWritten = 0;
    private byte[] buf = new byte[this.defaultBufferSize];
    private byte[] buf2;
    public int count = 0;

    public byte[] getBuffer() {
        return this.buf;
    }

    public String getBufferContent() {
        return new String(this.buf).substring(0, this.bytesWritten);
    }

    public int getBufferSize() {
        return this.buf.length;
    }

    public int getNumberOfBytesWritten() {
        return this.bytesWritten;
    }

    public boolean isContentWritten() {
        return this.bytesWritten != 0;
    }

    private void resize() {
        this.resize(this.buf.length + this.buf.length / 2);
    }

    private void resize(int neededSize) {
        Domain.debug((Object)("XByteBuffer:resize( neededSize=" + neededSize + ")"));
        this.buf2 = new byte[neededSize];
        System.arraycopy(this.buf, 0, this.buf2, 0, this.buf.length);
        this.buf = this.buf2;
        this.buf2 = null;
    }

    public void setBufferSize(int size) {
        if (size > this.buf.length) {
            this.buf = new byte[size];
        }
    }

    public void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.resize();
        }
        this.buf[this.count++] = (byte)b;
        ++this.bytesWritten;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int avail = this.buf.length - this.count;
        Domain.debug((Object)("ENTER: XByteBuffer:write(len=" + len + ") avail=" + avail));
        if (len > avail) {
            int newLength = this.buf.length;
            while ((newLength += newLength / 2) <= this.count + len) {
            }
            this.resize(newLength);
        }
        if (len > 0) {
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
            this.bytesWritten += len;
        }
        Domain.debug((Object)("LEAVE: XByteBuffer:write(len=" + len + ") bytesWritten=" + this.bytesWritten));
    }
}

