/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.filter;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Principal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.slide.webdav.logger.XHttpServletRequestFacade;
import org.apache.slide.webdav.logger.XHttpServletResponseFacade;
import org.apache.util.WebdavStatus;

public class LogFilter
implements Filter {
    FilterConfig config;
    ServletContext context;
    String logFormat = "%t, %p, %m, %s \"%l\", %i, %u";
    boolean outputToConsole = true;
    boolean outputToServletLog = false;
    boolean outputToFile = false;
    String outputFilePath = null;
    File outputFile = null;
    BufferedOutputStream fout = null;
    DateFormat df;
    String dateTimePattern = "dd-MMM-yyyy HH:mm:ss";
    String thread;
    String datetime;
    String method;
    String uri;
    String path;
    int status;
    String message;
    String principal;
    String detail;
    String contentlength;

    public void destroy() {
        try {
            if (this.outputToFile) {
                this.fout.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Principal p;
        XHttpServletRequestFacade req = new XHttpServletRequestFacade((HttpServletRequest)request);
        XHttpServletResponseFacade resp = new XHttpServletResponseFacade((HttpServletResponse)response);
        long b = System.currentTimeMillis();
        this.thread = Thread.currentThread().getName();
        this.datetime = this.df.format(new Date());
        this.method = req.getMethod();
        this.uri = req.getRequestURI();
        this.path = req.getServletPath();
        if ("".equals(this.path)) {
            this.path = "/";
        }
        this.principal = (p = req.getUserPrincipal()) != null ? p.getName() : "";
        this.contentlength = req.getHeader("Content-Length");
        if (this.contentlength == null) {
            this.contentlength = "-";
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        this.status = resp.getStatus();
        this.message = WebdavStatus.getStatusText((int)this.status);
        this.detail = resp.getStatusText();
        if (this.detail == null || "".equals(this.detail)) {
            this.detail = this.message;
        }
        long a = System.currentTimeMillis();
        this.logLine(req, resp, a - b);
    }

    public void init(FilterConfig config) throws ServletException {
        block6: {
            this.config = config;
            this.context = config.getServletContext();
            this.df = new SimpleDateFormat(this.dateTimePattern);
            String p = config.getInitParameter("logFormat");
            if (p != null && !"".equals(p)) {
                this.logFormat = p;
            }
            if ("false".equalsIgnoreCase(p = config.getInitParameter("outputToConsole"))) {
                this.outputToConsole = false;
            }
            if ("true".equalsIgnoreCase(p = config.getInitParameter("outputToServletLog"))) {
                this.outputToServletLog = true;
            }
            if ((p = config.getInitParameter("outputToFile")) == null || "".equals(p)) break block6;
            this.outputFilePath = p;
            this.outputFile = new File(this.outputFilePath);
            try {
                if (this.outputFile.canWrite() || this.outputFile.createNewFile()) {
                    this.fout = new BufferedOutputStream(new FileOutputStream(this.outputFilePath, true));
                    this.outputToFile = true;
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void logLine(XHttpServletRequestFacade req, XHttpServletResponseFacade resp, long elapsed) throws IOException {
        StringBuffer b = new StringBuffer(this.logFormat);
        int i = b.toString().indexOf("%T");
        if (i >= 0) {
            b.replace(i, i + 2, this.thread);
        }
        if ((i = b.toString().indexOf("%t")) >= 0) {
            b.replace(i, i + 2, this.datetime);
        }
        if ((i = b.toString().indexOf("%P")) >= 0) {
            b.replace(i, i + 2, this.principal);
        }
        if ((i = b.toString().indexOf("%m")) >= 0) {
            b.replace(i, i + 2, this.method);
        }
        if ((i = b.toString().indexOf("%s")) >= 0) {
            b.replace(i, i + 2, String.valueOf(this.status));
        }
        if ((i = b.toString().indexOf("%l")) >= 0) {
            b.replace(i, i + 2, this.message);
        }
        if ((i = b.toString().indexOf("%L")) >= 0) {
            b.replace(i, i + 2, this.detail);
        }
        if ((i = b.toString().indexOf("%i")) >= 0) {
            b.replace(i, i + 2, String.valueOf(String.valueOf(elapsed)) + " ms");
        }
        if ((i = b.toString().indexOf("%p")) >= 0) {
            b.replace(i, i + 2, this.path);
        }
        if ((i = b.toString().indexOf("%u")) >= 0) {
            b.replace(i, i + 2, this.uri);
        }
        if ((i = b.toString().indexOf("%x")) >= 0) {
            b.replace(i, i + 2, this.contentlength);
        }
        if (this.outputToConsole) {
            System.out.println(b.toString());
        }
        if (this.outputToServletLog) {
            this.context.log(b.toString());
        }
        if (this.outputToFile) {
            b.append("\n");
            this.fout.write(b.toString().getBytes("UTF-8"));
            this.fout.flush();
        }
    }
}

