/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav;

import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class WebdavServletConfig
implements ServletConfig {
    static final String DEFAULT_SERVLET_PARAMETER = "default-servlet";
    static final String DEPTH_LIMIT_PARAMETER = "depth-limit";
    static final String DEFAULT_MIME_TYPE_PARAMETER = "default-mime-type";
    static final String METHOD_FACTORY_PARAMETER = "method-factory";
    static final String SCOPE_PARAMETER = "scope";
    private ServletConfig config;
    private boolean isDefaultServlet = true;
    private String defaultMimeType = "text/plain";
    private int depthLimit = 3;
    private String scope = "";
    private String methodFactory;

    WebdavServletConfig(ServletConfig config) {
        this.config = config;
        ServletContext context = this.getServletContext();
        String value = null;
        value = this.getInitParameter(SCOPE_PARAMETER);
        if (value == null) {
            value = context.getInitParameter(SCOPE_PARAMETER);
        }
        if (value != null) {
            this.scope = value;
        }
        if ((value = this.getInitParameter(DEPTH_LIMIT_PARAMETER)) == null) {
            value = context.getInitParameter(DEPTH_LIMIT_PARAMETER);
        }
        if (value != null) {
            this.depthLimit = Integer.parseInt(value);
        }
        if ((value = this.getInitParameter(DEFAULT_MIME_TYPE_PARAMETER)) == null) {
            value = context.getInitParameter(DEFAULT_MIME_TYPE_PARAMETER);
        }
        if (value != null) {
            this.defaultMimeType = value;
        }
        if ((value = this.getInitParameter(DEFAULT_SERVLET_PARAMETER)) != null) {
            this.isDefaultServlet = Boolean.valueOf(value);
        }
        if ((value = this.getInitParameter(METHOD_FACTORY_PARAMETER)) == null) {
            value = context.getInitParameter(METHOD_FACTORY_PARAMETER);
        }
        if (value != null) {
            this.methodFactory = value;
        }
    }

    public String getDefaultMimeType() {
        return this.defaultMimeType;
    }

    public int getDepthLimit() {
        return this.depthLimit;
    }

    public String getInitParameter(String name) {
        return this.config.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.config.getInitParameterNames();
    }

    public String getMethodFactory() {
        return this.methodFactory;
    }

    public String getScope() {
        return this.scope;
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public String getServletName() {
        return this.config.getServletName();
    }

    public boolean isDefaultServlet() {
        return this.isDefaultServlet;
    }
}

