/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav;

import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.slide.authenticate.SecurityToken;
import org.apache.slide.common.Domain;
import org.apache.slide.common.DomainInitializationFailedError;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.SlideException;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavMethod;
import org.apache.slide.webdav.WebdavMethodFactory;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.util.DirectoryIndexGenerator;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.util.DOMUtils;

public class WebdavServlet
extends HttpServlet {
    private static final String LOG_CHANNEL = (class$org$apache$slide$webdav$WebdavServlet != null ? class$org$apache$slide$webdav$WebdavServlet : (class$org$apache$slide$webdav$WebdavServlet = WebdavServlet.class$("org.apache.slide.webdav.WebdavServlet"))).getName();
    public static final String ATTRIBUTE_NAME = "org.apache.slide.NamespaceAccessToken";
    protected NamespaceAccessToken token;
    protected boolean directoryBrowsing = true;
    protected RequestDispatcher directoryBrowsingTemplate;
    protected DirectoryIndexGenerator directoryIndexGenerator;
    protected boolean handleLifecycle = true;
    protected WebdavMethodFactory methodFactory;
    static /* synthetic */ Class class$org$apache$slide$webdav$WebdavServlet;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void destroy() {
        if (this.handleLifecycle) {
            Domain.closeNamespace((NamespaceAccessToken)this.token);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (this.directoryBrowsing) {
            if (this.directoryBrowsingTemplate != null) {
                req.setAttribute("org.apache.slide.NamespaceName", (Object)this.token.getName());
                req.setAttribute("slide_namespace", (Object)this.token.getName());
                req.setAttribute("slide_uri", (Object)WebdavUtils.getRelativePath(req, (WebdavServletConfig)this.getServletConfig()));
                this.directoryBrowsingTemplate.forward((ServletRequest)req, (ServletResponse)res);
            } else {
                try {
                    this.directoryIndexGenerator.generate(req, res);
                }
                catch (AccessDeniedException accessDeniedException) {
                    res.sendError(403);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    res.sendError(404);
                }
                catch (LinkedObjectNotFoundException linkedObjectNotFoundException) {
                    res.sendError(404);
                }
                catch (SlideException slideException) {
                    res.setStatus(500);
                }
            }
        } else {
            res.sendError(403);
        }
    }

    public void init() throws ServletException {
        if (!DOMUtils.isDocumentBuilderDOM2Compliant()) {
            System.out.println("======================================================");
            System.out.println("!!! Unable to start Slide Servlet !!!");
            System.out.println("------------------------------------------------------");
            System.out.println("You are using using an incorrect older XML parser");
            System.out.println("that doesn't provide Element::getElementsByTagNameNS");
            System.out.println("consult the documentation for a list of valid XML parsers.");
            System.out.println("======================================================");
            this.log("======================================================");
            this.log("!!! Unable to start Slide Servlet !!!");
            this.log("------------------------------------------------------");
            this.log("======================================================");
            this.log("You are using using an incorrect older XML parser");
            this.log("that doesn't provide Element::getElementsByTagNameNS");
            this.log("consult the documentation for a list of valid XML parsers.");
            this.log("======================================================");
            throw new ServletException("Invalid XML parser");
        }
        String value = null;
        this.token = (NamespaceAccessToken)this.getServletContext().getAttribute(ATTRIBUTE_NAME);
        if (this.token == null) {
            String namespaceName = null;
            String domainConfigFile = null;
            value = this.getInitParameter("namespace");
            if (value != null) {
                namespaceName = value;
            }
            if ((value = this.getInitParameter("domain")) != null) {
                domainConfigFile = value;
            }
            try {
                URL domainConfigFileURL;
                if (domainConfigFile != null && (domainConfigFileURL = this.getServletContext().getResource(domainConfigFile)) != null) {
                    Domain.init((URL)domainConfigFileURL);
                }
                if (namespaceName == null) {
                    namespaceName = Domain.getDefaultNamespace();
                    this.log("No namespace specified, will use default namespace: " + namespaceName);
                }
                this.token = Domain.accessNamespace((SecurityToken)new SecurityToken((Object)this), (String)namespaceName);
                if (this.token == null) {
                    this.log("Could not access namespace " + namespaceName + ".");
                    throw new UnavailableException("Namespace " + namespaceName + " not accessible");
                }
                this.getServletContext().setAttribute(ATTRIBUTE_NAME, (Object)this.token);
            }
            catch (DomainInitializationFailedError e) {
                this.log("Could not initialize domain", e);
                throw new UnavailableException(e.toString());
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new ServletException(t.toString());
            }
        } else {
            this.handleLifecycle = false;
        }
        this.methodFactory = WebdavMethodFactory.newInstance((WebdavServletConfig)this.getServletConfig());
        value = this.getInitParameter("directory-browsing");
        if (value != null) {
            if (value.startsWith("/")) {
                this.directoryBrowsingTemplate = this.getServletContext().getRequestDispatcher(value);
                if (this.directoryBrowsingTemplate == null) {
                    this.directoryBrowsing = false;
                }
            } else {
                this.directoryBrowsing = Boolean.valueOf(value);
            }
        }
        if (this.directoryBrowsing) {
            this.directoryIndexGenerator = new DirectoryIndexGenerator(this.token, (WebdavServletConfig)this.getServletConfig());
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init((ServletConfig)new WebdavServletConfig(config));
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        SimpleDateFormat sdf = new SimpleDateFormat();
        if (this.token.getLogger().isEnabled(LOG_CHANNEL, 7)) {
            this.token.getLogger().log((Object)("==> " + req.getMethod() + " start: " + sdf.format(new Date(System.currentTimeMillis())) + " [" + Thread.currentThread().getName() + "]"), LOG_CHANNEL, 7);
        }
        WebdavServletConfig config = (WebdavServletConfig)this.getServletConfig();
        try {
            try {
                long startTime = System.currentTimeMillis();
                if (this.token == null) {
                    String namespaceName = req.getContextPath();
                    if (namespaceName == null || namespaceName.equals("")) {
                        namespaceName = Domain.getDefaultNamespace();
                    }
                    while (namespaceName.startsWith("/")) {
                        namespaceName = namespaceName.substring(1);
                    }
                    this.token = Domain.accessNamespace((SecurityToken)new SecurityToken((Object)this), (String)namespaceName);
                }
                resp.setStatus(200);
                String methodName = req.getMethod();
                if ((methodName.equalsIgnoreCase("GET") || methodName.equalsIgnoreCase("POST")) && WebdavUtils.isCollection(this.token, req, config)) {
                    super.service(req, resp);
                } else {
                    WebdavMethod method = this.methodFactory.createMethod(methodName);
                    if (method == null) {
                        throw new WebdavException(405);
                    }
                    method.run(req, resp);
                }
            }
            catch (WebdavException e) {
                this.token.getLogger().log((Object)e, LOG_CHANNEL, 2);
                try {
                    resp.sendError(e.getStatusCode());
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable e) {
                this.token.getLogger().log((Object)e, LOG_CHANNEL, 2);
                try {
                    resp.sendError(500);
                }
                catch (Throwable throwable) {
                }
            }
            Object var6_10 = null;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            if (this.token.getLogger().isEnabled(LOG_CHANNEL, 7)) {
                this.token.getLogger().log((Object)("<== " + req.getMethod() + " end: " + sdf.format(new Date(System.currentTimeMillis())) + " [" + Thread.currentThread().getName() + "]"), LOG_CHANNEL, 7);
            }
            throw throwable;
        }
        if (this.token.getLogger().isEnabled(LOG_CHANNEL, 7)) {
            this.token.getLogger().log((Object)("<== " + req.getMethod() + " end: " + sdf.format(new Date(System.currentTimeMillis())) + " [" + Thread.currentThread().getName() + "]"), LOG_CHANNEL, 7);
        }
    }
}

