/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.trax;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class DOMDriver
implements Locator,
XMLReader {
    protected ContentHandler contentHandler = new DefaultHandler();
    private LexicalHandler lexicalHandler = null;
    private NamespaceSupport nsSupport = new NamespaceSupport();
    private AttributesImpl attlist = new AttributesImpl();
    private String[] parts = new String[3];
    private String[] elparts = new String[3];
    private Hashtable nsDeclarations = new Hashtable();
    protected Node root = null;
    protected String systemId;
    static final String FEATURE = "http://xml.org/sax/features/";
    static final String HANDLER = "http://xml.org/sax/properties/";

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        if (contentHandler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setLocale(Locale locale) throws SAXException {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setDocument(Document document) {
        this.root = document;
    }

    public void parse(InputSource inputSource) throws SAXException {
        this.parse();
    }

    public void parse(String string) throws SAXException {
        this.parse();
    }

    public void parse() throws SAXException {
        if (this.root == null) {
            throw new SAXException("DOMDriver: no start node defined");
        }
        if (this.contentHandler == null) {
            throw new SAXException("DOMDriver: no content handler defined");
        }
        this.contentHandler.setDocumentLocator(this);
        this.contentHandler.startDocument();
        this.walkNode(this.root);
        this.contentHandler.endDocument();
    }

    private void walkNode(Node node) throws SAXException {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                switch (node2.getNodeType()) {
                    case 9: {
                        break;
                    }
                    case 1: {
                        String string;
                        String[] stringArray;
                        String string2;
                        Object object;
                        Object object2;
                        Element element = (Element)node2;
                        this.nsSupport.pushContext();
                        this.attlist.clear();
                        this.nsDeclarations.clear();
                        String string3 = element.getTagName();
                        try {
                            object2 = element.getPrefix();
                            String string4 = element.getNamespaceURI();
                            if (this.nsDeclarations.get(object2) == null) {
                                this.nsSupport.declarePrefix((String)object2, string4);
                                this.contentHandler.startPrefixMapping((String)object2, string4);
                                this.nsDeclarations.put(object2, string4);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        object2 = element.getAttributes();
                        int n2 = 0;
                        while (n2 < object2.getLength()) {
                            Attr attr = (Attr)object2.item(n2);
                            object = attr.getName();
                            if (object.equals("xmlns")) {
                                if (this.nsDeclarations.get("") == null) {
                                    string2 = attr.getValue();
                                    this.nsSupport.declarePrefix("", string2);
                                    this.contentHandler.startPrefixMapping("", string2);
                                    this.nsDeclarations.put("", string2);
                                }
                            } else if (object.startsWith("xmlns:")) {
                                string2 = object.substring(6);
                                if (this.nsDeclarations.get(string2) == null) {
                                    stringArray = attr.getValue();
                                    this.nsSupport.declarePrefix(string2, (String)stringArray);
                                    this.contentHandler.startPrefixMapping(string2, (String)stringArray);
                                    this.nsDeclarations.put(string2, stringArray);
                                }
                            } else if (object.indexOf(58) >= 0) {
                                try {
                                    string2 = attr.getPrefix();
                                    stringArray = attr.getNamespaceURI();
                                    if (this.nsDeclarations.get(string2) == null) {
                                        this.nsSupport.declarePrefix(string2, (String)stringArray);
                                        this.contentHandler.startPrefixMapping(string2, (String)stringArray);
                                        this.nsDeclarations.put(string2, stringArray);
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            ++n2;
                        }
                        int n3 = 0;
                        while (n3 < object2.getLength()) {
                            object = (Attr)object2.item(n3);
                            string2 = object.getName();
                            if (!string2.equals("xmlns") && !string2.startsWith("xmlns:")) {
                                stringArray = this.nsSupport.processName(string2, this.parts, true);
                                if (stringArray == null) {
                                    throw new SAXException("Undeclared namespace in " + string2);
                                }
                                this.attlist.addAttribute(stringArray[0], stringArray[1], stringArray[2], "CDATA", object.getValue());
                            }
                            ++n3;
                        }
                        object = this.nsSupport.processName(element.getTagName(), this.elparts, false);
                        if (object == null) {
                            throw new SAXException("Undeclared namespace in " + element.getTagName());
                        }
                        string2 = object[0];
                        stringArray = object[1];
                        String string5 = object[2];
                        this.contentHandler.startElement(string2, (String)stringArray, string5, this.attlist);
                        this.walkNode(element);
                        this.contentHandler.endElement(string2, (String)stringArray, string5);
                        Enumeration<String> enumeration = this.nsSupport.getDeclaredPrefixes();
                        while (enumeration.hasMoreElements()) {
                            string = enumeration.nextElement();
                            this.contentHandler.endPrefixMapping(string);
                        }
                        this.nsSupport.popContext();
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 7: {
                        this.contentHandler.processingInstruction(((ProcessingInstruction)node2).getTarget(), ((ProcessingInstruction)node2).getData());
                        break;
                    }
                    case 8: {
                        String string;
                        if (this.lexicalHandler == null || (string = ((Comment)node2).getData()) == null) break;
                        this.lexicalHandler.comment(string.toCharArray(), 0, string.length());
                        break;
                    }
                    case 3: 
                    case 4: {
                        String string = ((CharacterData)node2).getData();
                        if (string == null) break;
                        this.contentHandler.characters(string.toCharArray(), 0, string.length());
                        break;
                    }
                    case 5: {
                        this.walkNode(node2);
                        break;
                    }
                }
                ++n;
            }
        }
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/features/validation".equals(string)) {
            return false;
        }
        if ("http://xml.org/sax/features/external-general-entities".equals(string) || "http://xml.org/sax/features/external-parameter-entities".equals(string)) {
            return false;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            return false;
        }
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            return true;
        }
        if ("http://xml.org/sax/features/string-interning".equals(string)) {
            return false;
        }
        throw new SAXNotRecognizedException(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException {
        if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.lexicalHandler;
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/validation".equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException(string + " feature cannot be switched on");
            }
            return;
        }
        if ("http://xml.org/sax/features/external-general-entities".equals(string) || "http://xml.org/sax/features/external-parameter-entities".equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException(string + " feature cannot be switched on");
            }
            return;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException(string + " feature cannot be switched on");
            }
            return;
        }
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            if (!bl) {
                throw new SAXNotSupportedException(string + " feature cannot be switched off");
            }
            return;
        }
        if ("http://xml.org/sax/features/string-interning".equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException(string + " feature cannot be switched on");
            }
            return;
        }
        throw new SAXNotRecognizedException("Feature not recognized: " + string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            if (!(object instanceof LexicalHandler)) {
                throw new SAXNotSupportedException("Lexical Handler must be instance of org.xml.sax.ext.LexicalHandler");
            }
        } else {
            throw new SAXNotRecognizedException(string);
        }
        this.lexicalHandler = (LexicalHandler)object;
    }
}

