/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.trace;

import java.util.Hashtable;
import java.util.TooManyListenersException;
import java.util.Vector;
import net.sf.joost.trace.TraceListener;
import net.sf.joost.trace.TraceMetaInfo;
import net.sf.joost.trax.TransformerImpl;
import org.xml.sax.Attributes;

public class TraceManager {
    private TransformerImpl transformer;
    private Vector traceListeners = null;

    public TraceManager(TransformerImpl transformerImpl) {
        this.transformer = transformerImpl;
    }

    public boolean hasTraceListeners() {
        return this.traceListeners != null;
    }

    public void addTraceListener(TraceListener traceListener) throws TooManyListenersException {
        TransformerImpl.DEBUG_MODE = true;
        if (this.traceListeners == null) {
            this.traceListeners = new Vector();
        }
        this.traceListeners.addElement(traceListener);
    }

    public void removeTraceListener(TraceListener traceListener) {
        if (this.traceListeners != null) {
            this.traceListeners.removeElement(traceListener);
        }
    }

    public void fireStartProcessingEvent(TraceMetaInfo traceMetaInfo) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.open(traceMetaInfo);
                ++n2;
            }
        }
    }

    public void fireEndProcessingEvent(TraceMetaInfo traceMetaInfo) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.close(traceMetaInfo);
                ++n2;
            }
        }
    }

    public void fireStartElementEvent(TraceMetaInfo traceMetaInfo) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.startElementEvent(traceMetaInfo);
                ++n2;
            }
        }
    }

    public void fireEndElementEvent(TraceMetaInfo traceMetaInfo) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.endElementEvent(traceMetaInfo);
                ++n2;
            }
        }
    }

    public void fireTextEvent(TraceMetaInfo traceMetaInfo) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.textEvent(traceMetaInfo);
                ++n2;
            }
        }
    }

    public void firePIEvent(TraceMetaInfo traceMetaInfo) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.PIEvent(traceMetaInfo);
                ++n2;
            }
        }
    }

    public void fireMappingEvent(TraceMetaInfo traceMetaInfo) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.mappingEvent(traceMetaInfo);
                ++n2;
            }
        }
    }

    public void fireCommentEvent(TraceMetaInfo traceMetaInfo) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.commentEvent(traceMetaInfo);
                ++n2;
            }
        }
    }

    public void fireStartInnerProcessing() {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.startInnerProcessingEvent();
                ++n2;
            }
        }
    }

    public void fireEndInnerProcessing() {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.endInnerProcessingEvent();
                ++n2;
            }
        }
    }

    public void fireEnterStylesheetNode(TraceMetaInfo traceMetaInfo) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.enterStxNode(traceMetaInfo);
                ++n2;
            }
        }
    }

    public void fireLeaveStylesheetNode(TraceMetaInfo traceMetaInfo) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.leaveStxNode(traceMetaInfo);
                ++n2;
            }
        }
    }

    public void fireStartDocumentEmitterEvent() {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.startDocumentEmitterEvent();
                ++n2;
            }
        }
    }

    public void fireEndDocumentEmitterEvent(String string, String string2, int n, int n2) {
        if (this.hasTraceListeners()) {
            int n3 = this.traceListeners.size();
            int n4 = 0;
            while (n4 < n3) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n4);
                traceListener.endDocumentEmitterEvent(string, string2, n, n2);
                ++n4;
            }
        }
    }

    public void fireStartElementEmitterEvent(String string, String string2, String string3, Attributes attributes, Hashtable hashtable, String string4, String string5, int n, int n2) {
        if (this.hasTraceListeners()) {
            int n3 = this.traceListeners.size();
            int n4 = 0;
            while (n4 < n3) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n4);
                traceListener.startElementEmitterEvent(string, string2, string3, attributes, hashtable, string4, string5, n, n2);
                ++n4;
            }
        }
    }

    public void fireEndElementEmitterEvent(String string, String string2, String string3, String string4, String string5, int n, int n2) {
        if (this.hasTraceListeners()) {
            int n3 = this.traceListeners.size();
            int n4 = 0;
            while (n4 < n3) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n4);
                traceListener.endElementEmitterEvent(string, string2, string3, string4, string5, n, n2);
                ++n4;
            }
        }
    }

    public void fireTextEmitterEvent(String string) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.textEmitterEvent(string);
                ++n2;
            }
        }
    }

    public void firePIEmitterEvent(String string, String string2, String string3, String string4, int n, int n2) {
        if (this.hasTraceListeners()) {
            int n3 = this.traceListeners.size();
            int n4 = 0;
            while (n4 < n3) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n4);
                traceListener.PIEmitterEvent(string, string2, string3, string4, n, n2);
                ++n4;
            }
        }
    }

    public void fireCommentEmitterEvent(String string, String string2, String string3, int n, int n2) {
        if (this.hasTraceListeners()) {
            int n3 = this.traceListeners.size();
            int n4 = 0;
            while (n4 < n3) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n4);
                traceListener.commentEmitterEvent(string, string2, string3, n, n2);
                ++n4;
            }
        }
    }

    public void fireStartCDATAEmitterEvent(String string, String string2, int n, int n2) {
        if (this.hasTraceListeners()) {
            int n3 = this.traceListeners.size();
            int n4 = 0;
            while (n4 < n3) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n4);
                traceListener.startCDATAEmitterEvent(string, string2, n, n2);
                ++n4;
            }
        }
    }

    public void fireEndCDATAEmitterEvent() {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.endCDATAEmitterEvent();
                ++n2;
            }
        }
    }
}

