/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.trace;

import java.io.IOException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import net.sf.joost.stx.Parser;
import net.sf.joost.stx.Processor;
import net.sf.joost.stx.SAXEvent;
import net.sf.joost.trace.TraceManager;
import net.sf.joost.trace.TraceMetaInfo;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DebugProcessor
extends Processor {
    private TraceManager tmgr;
    public Parser stxparser;

    public DebugProcessor(XMLReader xMLReader, InputSource inputSource, ErrorListener errorListener, URIResolver uRIResolver) throws IOException, SAXException {
        super(xMLReader, inputSource, errorListener, uRIResolver);
    }

    public DebugProcessor(InputSource inputSource, ErrorListener errorListener, URIResolver uRIResolver) throws IOException, SAXException {
        super(inputSource, errorListener, uRIResolver);
    }

    public DebugProcessor(InputSource inputSource) throws IOException, SAXException {
        super(inputSource);
    }

    public DebugProcessor(Parser parser) throws SAXException {
        super(parser);
    }

    public DebugProcessor(Processor processor) {
        super(processor);
    }

    public void setTraceManager(TraceManager traceManager) {
        this.tmgr = traceManager;
    }

    public TraceManager getTraceManager() {
        return this.tmgr;
    }

    public void startDocument() throws SAXException {
        TraceMetaInfo traceMetaInfo = new TraceMetaInfo();
        traceMetaInfo.eventStack = this.getEventStack();
        traceMetaInfo.dataStack = this.getDataStack();
        traceMetaInfo.innerProcessStack = this.getInnerProcessStack();
        traceMetaInfo.context = this.getContext();
        this.tmgr.fireStartProcessingEvent(traceMetaInfo);
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        TraceMetaInfo traceMetaInfo = new TraceMetaInfo();
        traceMetaInfo.eventStack = this.getEventStack();
        traceMetaInfo.dataStack = this.getDataStack();
        traceMetaInfo.innerProcessStack = this.getInnerProcessStack();
        traceMetaInfo.context = this.getContext();
        this.tmgr.fireEndProcessingEvent(traceMetaInfo);
        super.endDocument();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        SAXEvent sAXEvent = SAXEvent.newElement(string, string2, string3, attributes, null);
        TraceMetaInfo traceMetaInfo = new TraceMetaInfo();
        traceMetaInfo.saxEvent = sAXEvent;
        traceMetaInfo.eventStack = this.getEventStack();
        traceMetaInfo.dataStack = this.getDataStack();
        traceMetaInfo.innerProcessStack = this.getInnerProcessStack();
        traceMetaInfo.context = this.getContext();
        traceMetaInfo.lastElement = this.getLastElement();
        this.tmgr.fireStartElementEvent(traceMetaInfo);
        super.startElement(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        SAXEvent sAXEvent = SAXEvent.newElement(string, string2, string3, null, null);
        TraceMetaInfo traceMetaInfo = new TraceMetaInfo();
        traceMetaInfo.saxEvent = sAXEvent;
        traceMetaInfo.eventStack = this.getEventStack();
        traceMetaInfo.dataStack = this.getDataStack();
        traceMetaInfo.innerProcessStack = this.getInnerProcessStack();
        traceMetaInfo.context = this.getContext();
        traceMetaInfo.lastElement = this.getLastElement();
        this.tmgr.fireEndElementEvent(traceMetaInfo);
        super.endElement(string, string2, string3);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        SAXEvent sAXEvent = SAXEvent.newText(string);
        TraceMetaInfo traceMetaInfo = new TraceMetaInfo();
        traceMetaInfo.saxEvent = sAXEvent;
        traceMetaInfo.context = this.getContext();
        this.tmgr.fireTextEvent(traceMetaInfo);
        super.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        SAXEvent sAXEvent = SAXEvent.newPI(string, string2);
        TraceMetaInfo traceMetaInfo = new TraceMetaInfo();
        traceMetaInfo.saxEvent = sAXEvent;
        traceMetaInfo.context = this.getContext();
        this.tmgr.firePIEvent(traceMetaInfo);
        super.processingInstruction(string, string2);
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        SAXEvent sAXEvent = SAXEvent.newMapping(string, string2);
        TraceMetaInfo traceMetaInfo = new TraceMetaInfo();
        traceMetaInfo.saxEvent = sAXEvent;
        traceMetaInfo.context = this.getContext();
        this.tmgr.fireMappingEvent(traceMetaInfo);
        super.startPrefixMapping(string, string2);
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        SAXEvent sAXEvent = SAXEvent.newComment(string);
        TraceMetaInfo traceMetaInfo = new TraceMetaInfo();
        traceMetaInfo.saxEvent = sAXEvent;
        traceMetaInfo.context = this.getContext();
        this.tmgr.fireCommentEvent(traceMetaInfo);
        super.comment(cArray, n, n2);
    }

    public void startInnerProcessing() throws SAXException {
        this.tmgr.fireStartInnerProcessing();
        super.startInnerProcessing();
    }

    public void endInnerProcessing() throws SAXException {
        this.tmgr.fireEndInnerProcessing();
        super.endInnerProcessing();
    }
}

