/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx;

import java.util.ArrayList;
import net.sf.joost.grammar.EvalException;
import net.sf.joost.stx.SAXEvent;

public class Value
implements Cloneable {
    public static final int EMPTY = 0;
    public static final int NODE = 1;
    public static final int BOOLEAN = 2;
    public static final int NUMBER = 3;
    public static final int STRING = 4;
    public static final int OBJECT = 5;
    public int type;
    public SAXEvent event;
    public boolean bool;
    public double number;
    public String string;
    public Object object;
    public Value next;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public Value() {
        this.type = 0;
    }

    public Value(double d) {
        this.type = 3;
        this.number = d;
    }

    public Value(boolean bl) {
        this.type = 2;
        this.bool = bl;
    }

    public Value(String string) {
        this.type = 4;
        this.string = string;
    }

    public Value(SAXEvent sAXEvent) {
        this.type = 1;
        this.event = sAXEvent;
    }

    public Value(Object object) {
        if (object == null) {
            this.type = 5;
            return;
        }
        if (object instanceof Void) {
            this.type = 0;
            return;
        }
        if (object instanceof String || object instanceof Character) {
            this.type = 4;
            this.string = object.toString();
            return;
        }
        if (object instanceof Boolean) {
            this.type = 2;
            this.bool = (Boolean)object;
            return;
        }
        if (object instanceof Double) {
            this.type = 3;
            this.number = (Double)object;
            return;
        }
        if (object instanceof Float) {
            this.type = 3;
            this.number = ((Float)object).floatValue();
            return;
        }
        if (object instanceof Byte) {
            this.type = 3;
            this.number = ((Byte)object).byteValue();
            return;
        }
        if (object instanceof Short) {
            this.type = 3;
            this.number = ((Short)object).shortValue();
            return;
        }
        if (object instanceof Integer) {
            this.type = 3;
            this.number = ((Integer)object).intValue();
            return;
        }
        if (object instanceof Long) {
            this.type = 3;
            this.number = ((Long)object).longValue();
            return;
        }
        this.type = 5;
        this.object = object;
    }

    public Value convertToNumber() {
        switch (this.type) {
            case 0: {
                this.number = Double.NaN;
                break;
            }
            case 2: {
                this.number = this.bool ? 1.0 : 0.0;
                break;
            }
            case 3: {
                break;
            }
            case 1: 
            case 5: {
                this.convertToString();
            }
            case 4: {
                try {
                    this.number = Double.parseDouble(this.string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.number = Double.NaN;
                }
                break;
            }
            default: {
                throw new RuntimeException("Don't know how to convert " + this.type + " to number");
            }
        }
        this.type = 3;
        this.next = null;
        return this;
    }

    public Value convertToString() {
        switch (this.type) {
            case 0: {
                this.string = "";
                break;
            }
            case 1: {
                this.string = this.event.value;
                break;
            }
            case 2: {
                this.string = this.bool ? "true" : "false";
                break;
            }
            case 3: {
                this.string = Double.toString(this.number);
                if (!this.string.endsWith(".0")) break;
                this.string = this.string.substring(0, this.string.length() - 2);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.string = this.object != null ? this.object.toString() : "";
                break;
            }
            default: {
                throw new RuntimeException("Don't know how to convert " + this.type + " to string");
            }
        }
        this.type = 4;
        this.next = null;
        return this;
    }

    public Value convertToBoolean() {
        switch (this.type) {
            case 0: {
                this.bool = false;
                break;
            }
            case 1: {
                this.bool = true;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.bool = this.number != 0.0;
                break;
            }
            case 4: {
                this.bool = !this.string.equals("");
                break;
            }
            case 5: {
                this.bool = this.object == null ? false : !this.object.toString().equals("");
                break;
            }
            default: {
                throw new RuntimeException("Don't know how to convert " + this.type + " to boolean");
            }
        }
        this.type = 2;
        this.next = null;
        return this;
    }

    public Value setBoolean(boolean bl) {
        this.type = 2;
        this.bool = bl;
        this.next = null;
        return this;
    }

    public Value setNumber(double d) {
        this.type = 3;
        this.number = d;
        this.next = null;
        return this;
    }

    public Value setString(String string) {
        this.type = 4;
        this.string = string;
        this.next = null;
        return this;
    }

    public Value setEmpty() {
        this.type = 0;
        this.next = null;
        return this;
    }

    public Value copy() {
        try {
            Value value = (Value)this.clone();
            if (this.next != null) {
                value.next = this.next.copy();
            }
            return value;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("copy() failed for Value " + cloneNotSupportedException);
        }
    }

    public double getDistanceTo(Class clazz) {
        if (this.type == 5) {
            if (clazz == this.object.getClass()) {
                return 0.0;
            }
            if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = Value.class$("java.lang.Object")) : class$java$lang$Object)) {
                return 2.0;
            }
            if (clazz.isAssignableFrom(this.object.getClass())) {
                return 1.0;
            }
            if (clazz == (class$java$lang$String == null ? (class$java$lang$String = Value.class$("java.lang.String")) : class$java$lang$String)) {
                return 100.0;
            }
        }
        if (clazz == (class$java$util$List == null ? (class$java$util$List = Value.class$("java.util.List")) : class$java$util$List)) {
            return 90.0;
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = Value.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 100.0;
        }
        switch (this.type) {
            case 0: {
                if (clazz.isPrimitive()) break;
                return 1.0;
            }
            case 2: {
                if (clazz == Boolean.TYPE) {
                    return 0.0;
                }
                if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Value.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    return 1.0;
                }
                if (clazz == Byte.TYPE) {
                    return 10.0;
                }
                if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Value.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                    return 11.0;
                }
                if (clazz == Short.TYPE) {
                    return 12.0;
                }
                if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Value.class$("java.lang.Short")) : class$java$lang$Short)) {
                    return 13.0;
                }
                if (clazz == Integer.TYPE) {
                    return 14.0;
                }
                if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Value.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    return 15.0;
                }
                if (clazz == Long.TYPE) {
                    return 16.0;
                }
                if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Value.class$("java.lang.Long")) : class$java$lang$Long)) {
                    return 17.0;
                }
                if (clazz == Character.TYPE) {
                    return 18.0;
                }
                if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Value.class$("java.lang.Character")) : class$java$lang$Character)) {
                    return 19.0;
                }
                if (clazz == (class$java$lang$String == null ? (class$java$lang$String = Value.class$("java.lang.String")) : class$java$lang$String)) {
                    return 20.0;
                }
                if (clazz == Float.TYPE) {
                    return 21.0;
                }
                if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Value.class$("java.lang.Float")) : class$java$lang$Float)) {
                    return 22.0;
                }
                if (clazz == Double.TYPE) {
                    return 23.0;
                }
                if (clazz != (class$java$lang$Double == null ? (class$java$lang$Double = Value.class$("java.lang.Double")) : class$java$lang$Double)) break;
                return 24.0;
            }
            case 3: {
                if (clazz == Double.TYPE) {
                    return 0.0;
                }
                if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Value.class$("java.lang.Double")) : class$java$lang$Double)) {
                    return 1.0;
                }
                if (clazz == Float.TYPE) {
                    return 2.0;
                }
                if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Value.class$("java.lang.Float")) : class$java$lang$Float)) {
                    return 3.0;
                }
                if (clazz == Long.TYPE) {
                    return 4.0;
                }
                if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Value.class$("java.lang.Long")) : class$java$lang$Long)) {
                    return 5.0;
                }
                if (clazz == Integer.TYPE) {
                    return 6.0;
                }
                if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Value.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    return 7.0;
                }
                if (clazz == Short.TYPE) {
                    return 8.0;
                }
                if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Value.class$("java.lang.Short")) : class$java$lang$Short)) {
                    return 9.0;
                }
                if (clazz == Byte.TYPE) {
                    return 10.0;
                }
                if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Value.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                    return 11.0;
                }
                if (clazz == (class$java$lang$String == null ? (class$java$lang$String = Value.class$("java.lang.String")) : class$java$lang$String)) {
                    return 20.0;
                }
                if (clazz == Character.TYPE) {
                    return 31.0;
                }
                if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Value.class$("java.lang.Character")) : class$java$lang$Character)) {
                    return 32.0;
                }
                if (clazz == Boolean.TYPE) {
                    return 33.0;
                }
                if (clazz != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Value.class$("java.lang.Boolean")) : class$java$lang$Boolean)) break;
                return 34.0;
            }
            case 1: 
            case 4: {
                if (clazz == (class$java$lang$String == null ? (class$java$lang$String = Value.class$("java.lang.String")) : class$java$lang$String)) {
                    return 0.0;
                }
                if (clazz == Character.TYPE) {
                    return 1.0;
                }
                if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Value.class$("java.lang.Character")) : class$java$lang$Character)) {
                    return 2.0;
                }
                if (clazz == Double.TYPE) {
                    return 10.0;
                }
                if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Value.class$("java.lang.Double")) : class$java$lang$Double)) {
                    return 11.0;
                }
                if (clazz == Float.TYPE) {
                    return 12.0;
                }
                if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Value.class$("java.lang.Float")) : class$java$lang$Float)) {
                    return 13.0;
                }
                if (clazz == Integer.TYPE) {
                    return 14.0;
                }
                if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Value.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    return 15.0;
                }
                if (clazz == Long.TYPE) {
                    return 16.0;
                }
                if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Value.class$("java.lang.Long")) : class$java$lang$Long)) {
                    return 17.0;
                }
                if (clazz == Short.TYPE) {
                    return 18.0;
                }
                if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Value.class$("java.lang.Short")) : class$java$lang$Short)) {
                    return 19.0;
                }
                if (clazz == Byte.TYPE) {
                    return 20.0;
                }
                if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Value.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                    return 21.0;
                }
                if (clazz == Boolean.TYPE) {
                    return 30.0;
                }
                if (clazz != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Value.class$("java.lang.Boolean")) : class$java$lang$Boolean)) break;
                return 31.0;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    public Object toJavaObject(Class clazz) throws EvalException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = Value.class$("java.lang.Object")) : class$java$lang$Object)) {
            switch (this.type) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.event.value;
                }
                case 2: {
                    return new Boolean(this.bool);
                }
                case 3: {
                    return new Double(this.number);
                }
                case 4: {
                    return this.string;
                }
                case 5: {
                    return this.object;
                }
            }
            throw new RuntimeException("Fatal: unexpected type " + this.type);
        }
        if (this.type == 5 && clazz.isAssignableFrom(this.object.getClass())) {
            return this.object;
        }
        if (clazz == (class$java$util$List == null ? (class$java$util$List = Value.class$("java.util.List")) : class$java$util$List)) {
            if (this.type == 0) {
                return new ArrayList(0);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Value value = this;
            while (value != null) {
                arrayList.add(value.toJavaObject(class$java$lang$Object == null ? Value.class$("java.lang.Object") : class$java$lang$Object));
                value = value.next;
            }
            return arrayList;
        }
        if (this.type == 0 && !clazz.isPrimitive()) {
            return null;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = Value.class$("java.lang.String")) : class$java$lang$String)) {
            this.convertToString();
            return this.string;
        }
        if (clazz == Boolean.TYPE || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Value.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            this.convertToBoolean();
            return new Boolean(this.bool);
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Value.class$("java.lang.Double")) : class$java$lang$Double)) {
            this.convertToNumber();
            return new Double(this.number);
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Value.class$("java.lang.Float")) : class$java$lang$Float)) {
            this.convertToNumber();
            return new Float(this.number);
        }
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Value.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            this.convertToNumber();
            return new Integer((int)this.number);
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Value.class$("java.lang.Long")) : class$java$lang$Long)) {
            this.convertToNumber();
            return new Long((long)this.number);
        }
        if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Value.class$("java.lang.Short")) : class$java$lang$Short)) {
            this.convertToNumber();
            return new Short((short)this.number);
        }
        if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Value.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            this.convertToNumber();
            return new Byte((byte)this.number);
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Value.class$("java.lang.Character")) : class$java$lang$Character)) {
            this.convertToString();
            if (this.string.length() == 1) {
                return new Character(this.string.charAt(0));
            }
            throw new EvalException("Cannot convert string `" + this.string + "' to character (length is not 1)");
        }
        throw new EvalException("Conversion to " + clazz.getName() + " is not supported");
    }

    public String toString() {
        String string;
        switch (this.type) {
            case 0: {
                string = "()";
                break;
            }
            case 3: {
                string = "number " + this.number;
                break;
            }
            case 2: {
                string = "boolean " + this.bool;
                break;
            }
            case 4: {
                string = "string '" + this.string + "'";
                break;
            }
            case 1: {
                string = "node " + this.event;
                break;
            }
            case 5: {
                string = "object " + this.object;
                break;
            }
            default: {
                string = "unknown type in Value object";
            }
        }
        if (this.next != null) {
            string = string + ", " + this.next.toString();
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

