/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import net.sf.joost.TransformerHandlerResolver;
import net.sf.joost.stx.SAXWrapperHandler;
import net.sf.joost.stx.Value;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class TransformerHandlerResolverImpl
implements TransformerHandlerResolver {
    public static final String XSLT_METHOD = "http://www.w3.org/1999/XSL/Transform";
    public static final String SAX_METHOD = "http://xml.org/sax";
    private static String[] knownMethods = new String[]{"http://stx.sourceforge.net/2002/ns", "http://www.w3.org/1999/XSL/Transform", "http://xml.org/sax"};
    private static int M_STX = 0;
    private static int M_XSLT = 1;
    private static int M_SAX = 2;
    public TransformerHandlerResolver customResolver;

    private Hashtable createExternalParameters(Hashtable hashtable) {
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = string.startsWith("{}") ? string.substring(2) : string;
            hashtable2.put(string2, ((Value)hashtable.get((Object)string)).convertToString().string);
        }
        return hashtable2;
    }

    public TransformerHandler resolve(String string, String string2, String string3, Hashtable hashtable) throws SAXException {
        TransformerHandler transformerHandler;
        if (this.customResolver != null && (transformerHandler = this.customResolver.resolve(string, string2, string3, this.createExternalParameters(hashtable))) != null) {
            return transformerHandler;
        }
        return this.resolve(string, string2, string3, null, hashtable);
    }

    public TransformerHandler resolve(String string, XMLReader xMLReader, Hashtable hashtable) throws SAXException {
        TransformerHandler transformerHandler;
        if (this.customResolver != null && (transformerHandler = this.customResolver.resolve(string, xMLReader, this.createExternalParameters(hashtable))) != null) {
            return transformerHandler;
        }
        return this.resolve(string, null, null, xMLReader, hashtable);
    }

    private TransformerHandler resolve(String string, String string2, String string3, XMLReader xMLReader, Hashtable hashtable) throws SAXException {
        int n = 0;
        while (n < knownMethods.length) {
            if (knownMethods[n].equals(string)) break;
            ++n;
        }
        if (n == M_STX || n == M_XSLT) {
            Object object;
            Object object2;
            String string4 = System.getProperty("javax.xml.transform.TransformerFactory");
            boolean bl = false;
            if (n == M_STX) {
                if (!"net.sf.joost.trax.TransformerFactoryImpl".equals(string4)) {
                    System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.joost.trax.TransformerFactoryImpl");
                    bl = true;
                }
            } else {
                object2 = System.getProperty("http://joost.sf.net/attributes/xslt-factory");
                if (object2 != null || "net.sf.joost.trax.TransformerFactoryImpl".equals(string4)) {
                    if (object2 != null) {
                        System.setProperty("javax.xml.transform.TransformerFactory", (String)object2);
                    } else {
                        object = System.getProperties();
                        ((Properties)object).remove("javax.xml.transform.TransformerFactory");
                        System.setProperties((Properties)object);
                    }
                    bl = true;
                }
            }
            object2 = TransformerFactory.newInstance();
            if (bl) {
                if (string4 != null) {
                    System.setProperty("javax.xml.transform.TransformerFactory", string4);
                } else {
                    object = System.getProperties();
                    ((Properties)object).remove("javax.xml.transform.TransformerFactory");
                    System.setProperties((Properties)object);
                }
            }
            if (((TransformerFactory)object2).getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
                Source source;
                object = (SAXTransformerFactory)object2;
                if (xMLReader != null) {
                    source = new SAXSource(xMLReader, new InputSource());
                } else {
                    if (string2 == null) {
                        throw new SAXException("Missing source for " + (n == M_STX ? "STX" : "XSLT") + " transformation");
                    }
                    try {
                        source = new StreamSource(new URL(new URL(string3), string2).toExternalForm());
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new SAXException(malformedURLException);
                    }
                }
                try {
                    TransformerHandler transformerHandler = ((SAXTransformerFactory)object).newTransformerHandler(source);
                    if (!hashtable.isEmpty()) {
                        Transformer transformer = transformerHandler.getTransformer();
                        Enumeration enumeration = hashtable.keys();
                        while (enumeration.hasMoreElements()) {
                            String string5 = (String)enumeration.nextElement();
                            String string6 = string5.startsWith("{}") ? string5.substring(2) : string5;
                            transformer.setParameter(string6, ((Value)hashtable.get((Object)string5)).convertToString().string);
                        }
                    }
                    return transformerHandler;
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    throw new SAXException(transformerConfigurationException);
                }
            }
        }
        if (n == M_SAX) {
            if (string2 != null || xMLReader != null) {
                throw new SAXException("Attribute `filter-src' not allowed for method `" + string + "'");
            }
            return new SAXWrapperHandler();
        }
        return null;
    }

    public boolean available(String string) {
        if (this.customResolver != null && this.customResolver.available(string)) {
            return true;
        }
        int n = 0;
        while (n < knownMethods.length) {
            if (knownMethods[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

