/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import net.sf.joost.Constants;
import net.sf.joost.grammar.EvalException;
import net.sf.joost.grammar.Tree;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.SAXEvent;
import net.sf.joost.stx.Value;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class FunctionTable
implements Constants {
    private static String FNSP = "{http://stx.sourceforge.net/2003/functions}";
    private static String JENSP = "{http://joost.sf.net/functions}";
    private Hashtable functionHash;

    public FunctionTable() {
        Instance[] instanceArray = new Instance[]{new StringConv(), new NumberConv(), new BooleanConv(), new Position(), new HasChildNodes(), new NodeKind(), new Name(), new LocalName(), new NamespaceURI(), new GetNamespaceUriForPrefix(), new GetInScopeNamespaces(), new Not(), new True(), new False(), new Floor(), new Ceiling(), new Round(), new Concat(), new StringJoin(), new StringLength(), new NormalizeSpace(), new Contains(), new StartsWith(), new EndsWith(), new Substring(), new SubstringBefore(), new SubstringAfter(), new Translate(), new StringPad(), new Empty(), new Exists(), new ItemAt(), new IndexOf(), new Subsequence(), new InsertBefore(), new Remove(), new Count(), new Sum(), new Min(), new Max(), new Avg(), new FilterAvailable(), new ExtSequence()};
        this.functionHash = new Hashtable(instanceArray.length);
        int n = 0;
        while (n < instanceArray.length) {
            this.functionHash.put(instanceArray[n].getName(), instanceArray[n]);
            ++n;
        }
    }

    public Instance getFunction(String string, String string2, String string3, Tree tree, Locator locator) throws SAXParseException {
        if (string.startsWith("java:")) {
            return new ExtensionFunction(string.substring(5), string2, tree, locator);
        }
        Instance instance = (Instance)this.functionHash.get("{" + string + "}" + string2);
        if (instance == null) {
            throw new SAXParseException("Unknown function `" + string3 + "'", locator);
        }
        int n = 0;
        if (tree != null) {
            n = 1;
            while (tree.type == 34) {
                tree = tree.left;
                ++n;
            }
        }
        if (n < instance.getMinParCount()) {
            throw new SAXParseException("Too few parameters in call of function `" + string3 + "' (" + instance.getMinParCount() + " needed)", locator);
        }
        if (n > instance.getMaxParCount()) {
            throw new SAXParseException("Too many parameters in call of function `" + string3 + "' (" + instance.getMaxParCount() + " allowed)", locator);
        }
        return instance;
    }

    private static Value getOptionalValue(Context context, int n, Tree tree) throws SAXException {
        if (tree != null) {
            return tree.evaluate(context, n);
        }
        if (n > 0) {
            return new Value((SAXEvent)context.ancestorStack.elementAt(n - 1));
        }
        return new Value();
    }

    public final class ExtensionFunction
    implements Instance {
        private Class targetClass;
        private ArrayList candidateMethods = new ArrayList();
        private int paramCount = 0;
        private boolean isConstructor;

        public ExtensionFunction(String string, String string2, Tree tree, Locator locator) throws SAXParseException {
            try {
                this.targetClass = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SAXParseException("Can't find Java class " + classNotFoundException.getMessage(), locator);
            }
            if (tree != null) {
                this.paramCount = 1;
                while (tree.type == 34) {
                    tree = tree.left;
                    ++this.paramCount;
                }
            }
            String string3 = string2;
            if (string2.equals("new")) {
                this.isConstructor = true;
                int n = this.targetClass.getModifiers();
                if (Modifier.isAbstract(n)) {
                    throw new SAXParseException("Cannot create an object, class " + this.targetClass + " is abstract", locator);
                }
                if (Modifier.isInterface(n)) {
                    throw new SAXParseException("Cannot create an object, " + this.targetClass + " is an interface", locator);
                }
                if (Modifier.isPrivate(n)) {
                    throw new SAXParseException("Cannot create an object, class " + this.targetClass + " is private", locator);
                }
                if (Modifier.isProtected(n)) {
                    throw new SAXParseException("Cannot create an object, class " + this.targetClass + " is protected", locator);
                }
                Constructor<?>[] constructorArray = this.targetClass.getConstructors();
                int n2 = 0;
                while (n2 < constructorArray.length) {
                    Constructor<?> constructor = constructorArray[n2];
                    if (Modifier.isPublic(constructor.getModifiers()) && constructor.getParameterTypes().length == this.paramCount) {
                        this.candidateMethods.add(constructor);
                    }
                    ++n2;
                }
                if (this.candidateMethods.size() == 0) {
                    throw new SAXParseException("No constructor found with " + this.paramCount + " parameter" + (this.paramCount != 1 ? "s" : "") + " in class " + string, locator);
                }
            } else {
                char c;
                int n;
                Method[] methodArray;
                if (string2.indexOf(45) >= 0) {
                    methodArray = new StringBuffer();
                    n = 0;
                    int n3 = 0;
                    while (n3 < string2.length()) {
                        c = string2.charAt(n3);
                        if (c == '-') {
                            n = 1;
                        } else {
                            if (n != 0) {
                                methodArray.append(Character.toUpperCase(c));
                            } else {
                                methodArray.append(c);
                            }
                            n = 0;
                        }
                        ++n3;
                    }
                    string3 = methodArray.toString();
                }
                methodArray = this.targetClass.getMethods();
                n = 0;
                while (n < methodArray.length) {
                    Method method = methodArray[n];
                    if (method.getName().equals(string3) && Modifier.isPublic(c = method.getModifiers())) {
                        int n4 = this.paramCount;
                        if (!Modifier.isStatic(c)) {
                            --n4;
                        }
                        if (method.getParameterTypes().length == n4) {
                            this.candidateMethods.add(method);
                        }
                    }
                    ++n;
                }
                if (this.candidateMethods.size() == 0) {
                    throw new SAXParseException("No function found matching `" + string3 + "' " + (string2.equals(string3) ? "" : "(" + string2 + ") ") + "with " + this.paramCount + " parameter" + (this.paramCount != 1 ? "s" : "") + " in class " + string, locator);
                }
            }
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            int n2;
            Value[] valueArray = null;
            if (this.paramCount > 0) {
                valueArray = new Value[this.paramCount];
                int n3 = this.paramCount - 1;
                while (n3 > 0) {
                    valueArray[n3] = tree.right.evaluate(context, n);
                    tree = tree.left;
                    --n3;
                }
                valueArray[0] = tree.evaluate(context, n);
            }
            if (this.isConstructor) {
                Object object;
                int n4;
                Constructor constructor = null;
                int n5 = this.candidateMethods.size();
                if (n5 == 1) {
                    constructor = (Constructor)this.candidateMethods.get(0);
                } else {
                    double d = -1.0;
                    n4 = 0;
                    int n6 = 0;
                    while (n6 < n5) {
                        Constructor constructor2 = (Constructor)this.candidateMethods.get(n6);
                        double d2 = 0.0;
                        object = constructor2.getParameterTypes();
                        int n7 = 0;
                        while (n7 < ((Class<?>[])object).length) {
                            d2 += valueArray[n7].getDistanceTo(object[n7]);
                            ++n7;
                        }
                        if (d2 < d || d < 0.0) {
                            d = d2;
                            constructor = constructor2;
                            n4 = 0;
                        } else if (d2 == d) {
                            n4 = 1;
                        }
                        ++n6;
                    }
                    if (d == Double.POSITIVE_INFINITY) {
                        throw new EvalException("None of the Java constructors in " + this.targetClass.getName() + " matches this function call to `new'");
                    }
                    if (n4 != 0) {
                        throw new EvalException("There are several Java constructors in " + this.targetClass.getName() + " that match the function call to `new' equally well ");
                    }
                }
                Class<?>[] classArray = constructor.getParameterTypes();
                Object[] objectArray = new Object[classArray.length];
                n4 = 0;
                while (n4 < classArray.length) {
                    objectArray[n4] = valueArray[n4].toJavaObject(classArray[n4]);
                    ++n4;
                }
                try {
                    Object t = constructor.newInstance(objectArray);
                    return new Value(t);
                }
                catch (InstantiationException instantiationException) {
                    throw new EvalException("Cannot instantiate class " + instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new EvalException("Constructor access is illegal " + illegalAccessException.getMessage());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new EvalException("Argument is of wrong type " + illegalArgumentException.getMessage());
                }
                catch (InvocationTargetException invocationTargetException) {
                    object = invocationTargetException.getTargetException();
                    throw new EvalException("Exception in extension constructor " + constructor.getName() + ": " + invocationTargetException.getTargetException().toString());
                }
            }
            Method method = null;
            int n8 = this.candidateMethods.size();
            if (n8 == 1) {
                method = (Method)this.candidateMethods.get(0);
            } else {
                double d = -1.0;
                boolean bl = false;
                n2 = 0;
                while (n2 < n8) {
                    int n9;
                    Method method2 = (Method)this.candidateMethods.get(n2);
                    double d3 = 0.0;
                    Class<?>[] classArray = method2.getParameterTypes();
                    if (Modifier.isStatic(method2.getModifiers())) {
                        n9 = 0;
                        while (n9 < classArray.length) {
                            d3 += valueArray[n9].getDistanceTo(classArray[n9]);
                            ++n9;
                        }
                    } else {
                        d3 = valueArray[0].getDistanceTo(this.targetClass);
                        n9 = 0;
                        while (n9 < classArray.length) {
                            d3 += valueArray[n9 + 1].getDistanceTo(classArray[n9]);
                            ++n9;
                        }
                    }
                    if (d3 < d || d < 0.0) {
                        d = d3;
                        method = method2;
                        bl = false;
                    } else if (d3 == d) {
                        bl = true;
                    }
                    ++n2;
                }
                if (d == Double.POSITIVE_INFINITY) {
                    throw new EvalException("None of the Java methods in " + this.targetClass.getName() + " matches this function call to `" + method.getName() + "'");
                }
                if (bl) {
                    throw new EvalException("There are several Java methods in " + this.targetClass.getName() + " that match function `" + method.getName() + "' equally well");
                }
            }
            Object object = null;
            Class<?>[] classArray = method.getParameterTypes();
            Object[] objectArray = new Object[classArray.length];
            if (Modifier.isStatic(method.getModifiers())) {
                n2 = 0;
                while (n2 < classArray.length) {
                    objectArray[n2] = valueArray[n2].toJavaObject(classArray[n2]);
                    ++n2;
                }
            } else {
                if (n8 == 1 && valueArray[0].getDistanceTo(this.targetClass) == Double.POSITIVE_INFINITY) {
                    throw new EvalException("First parameter in the function call to `" + method.getName() + "' must be the object instance");
                }
                object = valueArray[0].toJavaObject(this.targetClass);
                n2 = 0;
                while (n2 < classArray.length) {
                    objectArray[n2] = valueArray[n2 + 1].toJavaObject(classArray[n2]);
                    ++n2;
                }
            }
            try {
                return new Value(method.invoke(object, objectArray));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new EvalException("Method access is illegal " + illegalAccessException.getMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new EvalException("Argument is of wrong type " + illegalArgumentException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                throw new EvalException("Exception in extension method `" + method.getName() + "': " + invocationTargetException.getTargetException().toString());
            }
        }

        public int getMinParCount() {
            return 0;
        }

        public int getMaxParCount() {
            return 0;
        }

        public String getName() {
            return null;
        }
    }

    public final class ExtSequence
    implements Instance {
        public int getMinParCount() {
            return 1;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return JENSP + "sequence";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.evaluate(context, n);
            if (value.type != 5) {
                return value;
            }
            Object[] objectArray = null;
            if (value.object instanceof Object[]) {
                objectArray = (Object[])value.object;
            } else if (value.object instanceof List) {
                objectArray = ((List)value.object).toArray();
            }
            if (objectArray != null) {
                if (objectArray.length == 0) {
                    return value.setEmpty();
                }
                Value value2 = value = new Value(objectArray[0]);
                int n2 = 1;
                while (n2 < objectArray.length) {
                    value2 = value2.next = new Value(objectArray[n2]);
                    ++n2;
                }
            }
            return value;
        }
    }

    public final class FilterAvailable
    implements Instance {
        public int getMinParCount() {
            return 1;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "filter-available";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.evaluate(context, n);
            return value.setBoolean(context.defaultTransformerHandlerResolver.available(value.convertToString().string));
        }
    }

    public final class Avg
    implements Instance {
        public int getMinParCount() {
            return 1;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "avg";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.evaluate(context, n);
            if (value.type == 0) {
                return value;
            }
            double d = 0.0;
            int n2 = 0;
            while (value != null) {
                Value value2 = value.next;
                if (!Double.isNaN(value.convertToNumber().number)) {
                    d += value.number;
                    ++n2;
                }
                value = value2;
            }
            if (n2 == 0) {
                return new Value();
            }
            return new Value(d / (double)n2);
        }
    }

    public final class Max
    implements Instance {
        public int getMinParCount() {
            return 1;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "max";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.evaluate(context, n);
            if (value.type == 0) {
                return value;
            }
            boolean bl = false;
            double d = 0.0;
            while (value != null) {
                Value value2 = value.next;
                if (!Double.isNaN(value.convertToNumber().number)) {
                    if (bl) {
                        d = value.number > d ? value.number : d;
                    } else {
                        d = value.number;
                        bl = true;
                    }
                }
                value = value2;
            }
            if (bl) {
                return new Value(d);
            }
            return new Value();
        }
    }

    public final class Min
    implements Instance {
        public int getMinParCount() {
            return 1;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "min";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.evaluate(context, n);
            if (value.type == 0) {
                return value;
            }
            boolean bl = false;
            double d = 0.0;
            while (value != null) {
                Value value2 = value.next;
                if (!Double.isNaN(value.convertToNumber().number)) {
                    if (bl) {
                        d = value.number < d ? value.number : d;
                    } else {
                        d = value.number;
                        bl = true;
                    }
                }
                value = value2;
            }
            if (bl) {
                return new Value(d);
            }
            return new Value();
        }
    }

    public final class Sum
    implements Instance {
        public int getMinParCount() {
            return 1;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "sum";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.evaluate(context, n);
            if (value.type == 0) {
                return value.setNumber(0.0);
            }
            double d = 0.0;
            while (value != null) {
                Value value2 = value.next;
                if (!Double.isNaN(value.convertToNumber().number)) {
                    d += value.number;
                }
                value = value2;
            }
            return new Value(d);
        }
    }

    public final class Count
    implements Instance {
        public int getMinParCount() {
            return 1;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "count";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.evaluate(context, n);
            if (value.type == 0) {
                return value.setNumber(0.0);
            }
            int n2 = 1;
            while (value.next != null) {
                ++n2;
                value = value.next;
            }
            return value.setNumber(n2);
        }
    }

    public final class Remove
    implements Instance {
        public int getMinParCount() {
            return 2;
        }

        public int getMaxParCount() {
            return 2;
        }

        public String getName() {
            return FNSP + "remove";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.left.evaluate(context, n);
            Value value2 = tree.right.evaluate(context, n);
            Value value3 = value2.copy();
            double d = value2.convertToNumber().number;
            if (Double.isNaN(d)) {
                throw new EvalException("Parameter `" + value3.convertToString().string + "' is not a valid index for function `" + this.getName().substring(FNSP.length()) + "'");
            }
            long l = Math.round(d);
            if (value.type == 0 || l < 1L) {
                return value;
            }
            Value value4 = null;
            Value value5 = value;
            while (value != null && --l != 0L) {
                value4 = value;
                value = value.next;
            }
            if (value == null) {
                return value5;
            }
            if (value4 == null) {
                if (value5.next == null) {
                    return value5.setEmpty();
                }
                return value5.next;
            }
            value4.next = value.next;
            return value5;
        }
    }

    public final class InsertBefore
    implements Instance {
        public int getMinParCount() {
            return 3;
        }

        public int getMaxParCount() {
            return 3;
        }

        public String getName() {
            return FNSP + "insert-before";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value;
            Value value2 = tree.left.left.evaluate(context, n);
            Value value3 = tree.left.right.evaluate(context, n);
            Value value4 = tree.right.evaluate(context, n);
            Value value5 = value3.copy();
            double d = value3.convertToNumber().number;
            if (Double.isNaN(d)) {
                throw new EvalException("Parameter `" + value5.convertToString().string + "' is not a valid index for function `" + this.getName().substring(FNSP.length()) + "'");
            }
            long l = Math.round(d);
            if (value4.type == 0) {
                return value2;
            }
            if (value2.type == 0) {
                return value4;
            }
            if (l <= 1L) {
                value = value4;
            } else {
                value = value2;
                while (value2.next != null && --l > 1L) {
                    value2 = value2.next;
                }
                Value value6 = value2.next;
                value2.next = value4;
                value2 = value6;
            }
            while (value4.next != null) {
                value4 = value4.next;
            }
            value4.next = value2;
            return value;
        }
    }

    public final class Subsequence
    implements Instance {
        public int getMinParCount() {
            return 2;
        }

        public int getMaxParCount() {
            return 3;
        }

        public String getName() {
            return FNSP + "subsequence";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            long l;
            long l2;
            double d;
            Value value;
            if (tree.left.type == 34) {
                value = tree.left.left.evaluate(context, n);
                d = tree.left.right.evaluate((Context)context, (int)n).convertToNumber().number;
                double d2 = tree.right.evaluate((Context)context, (int)n).convertToNumber().number;
                if (value.type == 0 || Double.isNaN(d) || Double.isNaN(d + d2)) {
                    return value.setEmpty();
                }
                l2 = Math.round(d - 1.0);
                l = l2 + Math.round(d2);
                if (l2 < 0L) {
                    l2 = 0L;
                }
                if (l <= l2) {
                    return value.setEmpty();
                }
            } else {
                value = tree.left.evaluate(context, n);
                d = tree.right.evaluate((Context)context, (int)n).convertToNumber().number;
                if (value.type == 0 || Double.isNaN(d)) {
                    return value.setEmpty();
                }
                if (d < 1.0) {
                    return value;
                }
                l2 = Math.round(d - 1.0);
                l = -1L;
            }
            Value value2 = null;
            while (value != null) {
                if (value2 == null && l2 == 0L) {
                    value2 = value;
                    if (l < 0L) {
                        break;
                    }
                } else {
                    --l2;
                }
                if (--l == 0L) break;
                value = value.next;
            }
            if (value2 != null) {
                if (l == 0L) {
                    value.next = null;
                }
                return value2;
            }
            return value.setEmpty();
        }
    }

    public final class IndexOf
    implements Instance {
        public int getMinParCount() {
            return 2;
        }

        public int getMaxParCount() {
            return 2;
        }

        public String getName() {
            return FNSP + "index-of";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.left.evaluate(context, n);
            Value value2 = tree.right.evaluate(context, n);
            if (value.type == 0) {
                return value;
            }
            Tree tree2 = new Tree(value);
            value2.next = null;
            Tree tree3 = new Tree(value2);
            Tree tree4 = new Tree(24, tree2, tree3);
            Value value3 = null;
            Value value4 = new Value();
            long l = 1L;
            while (value != null) {
                Value value5 = value.next;
                value.next = null;
                if (tree4.evaluate((Context)context, (int)n).bool) {
                    value3 = value3 == null ? (value4 = new Value(l)) : (value3.next = new Value(l));
                }
                value = value5;
                tree2.value = value;
                ++l;
            }
            return value4;
        }
    }

    public final class ItemAt
    implements Instance {
        public int getMinParCount() {
            return 2;
        }

        public int getMaxParCount() {
            return 2;
        }

        public String getName() {
            return FNSP + "item-at";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.left.evaluate(context, n);
            double d = tree.right.evaluate((Context)context, (int)n).convertToNumber().number;
            if (value.type == 0 || Double.isNaN(d)) {
                return value.setEmpty();
            }
            long l = Math.round(d);
            while (value != null && --l != 0L) {
                value = value.next;
            }
            if (value == null) {
                throw new EvalException("Position " + d + " out of bounds in call to function `" + this.getName().substring(FNSP.length()) + "'");
            }
            value.next = null;
            return value;
        }
    }

    public final class Exists
    implements Instance {
        public int getMinParCount() {
            return 1;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "exists";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.evaluate(context, n);
            return value.setBoolean(value.type != 0);
        }
    }

    public final class Empty
    implements Instance {
        public int getMinParCount() {
            return 1;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "empty";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.evaluate(context, n);
            return value.setBoolean(value.type == 0);
        }
    }

    public final class StringPad
    implements Instance {
        public int getMinParCount() {
            return 2;
        }

        public int getMaxParCount() {
            return 2;
        }

        public String getName() {
            return FNSP + "string-pad";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            String string = tree.left.evaluate((Context)context, (int)n).convertToString().string;
            Value value = tree.right.evaluate(context, n);
            double d = value.convertToNumber().number;
            long l = Math.round(d);
            if (Double.isNaN(d) || l < 0L) {
                throw new EvalException("Invalid string-pad count " + value.convertToString().string);
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (l-- > 0L) {
                stringBuffer.append(string);
            }
            return value.setString(stringBuffer.toString());
        }
    }

    public final class Translate
    implements Instance {
        public int getMinParCount() {
            return 3;
        }

        public int getMaxParCount() {
            return 3;
        }

        public String getName() {
            return FNSP + "translate";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            String string = tree.left.left.evaluate((Context)context, (int)n).convertToString().string;
            String string2 = tree.left.right.evaluate((Context)context, (int)n).convertToString().string;
            String string3 = tree.right.evaluate((Context)context, (int)n).convertToString().string;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = string.length();
            int n3 = string3.length();
            int n4 = 0;
            while (n4 < n2) {
                char c = string.charAt(n4);
                int n5 = string2.indexOf(c);
                if (n5 < n3) {
                    stringBuffer.append(n5 < 0 ? c : string3.charAt(n5));
                }
                ++n4;
            }
            return new Value(stringBuffer.toString());
        }
    }

    public final class SubstringAfter
    implements Instance {
        public int getMinParCount() {
            return 2;
        }

        public int getMaxParCount() {
            return 2;
        }

        public String getName() {
            return FNSP + "substring-after";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            String string = tree.left.evaluate((Context)context, (int)n).convertToString().string;
            String string2 = tree.right.evaluate((Context)context, (int)n).convertToString().string;
            int n2 = string.indexOf(string2);
            if (n2 != -1) {
                return new Value(string.substring(n2 + string2.length()));
            }
            return new Value("");
        }
    }

    public final class SubstringBefore
    implements Instance {
        public int getMinParCount() {
            return 2;
        }

        public int getMaxParCount() {
            return 2;
        }

        public String getName() {
            return FNSP + "substring-before";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            String string = tree.left.evaluate((Context)context, (int)n).convertToString().string;
            String string2 = tree.right.evaluate((Context)context, (int)n).convertToString().string;
            int n2 = string.indexOf(string2);
            if (n2 != -1) {
                return new Value(string.substring(0, n2));
            }
            return new Value("");
        }
    }

    public final class Substring
    implements Instance {
        public int getMinParCount() {
            return 2;
        }

        public int getMaxParCount() {
            return 3;
        }

        public String getName() {
            return FNSP + "substring";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            try {
                if (tree.left.type == 34) {
                    String string = tree.left.left.evaluate((Context)context, (int)n).convertToString().string;
                    double d = tree.left.right.evaluate((Context)context, (int)n).convertToNumber().number;
                    double d2 = tree.right.evaluate((Context)context, (int)n).convertToNumber().number;
                    if (Double.isNaN(d) || Double.isNaN(d + d2)) {
                        return new Value("");
                    }
                    int n2 = Math.round((float)(d - 1.0));
                    int n3 = n2 + Math.round((float)d2);
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (n3 > string.length()) {
                        n3 = string.length();
                    }
                    if (n2 > n3) {
                        return new Value("");
                    }
                    return new Value(string.substring(n2, n3));
                }
                String string = tree.left.evaluate((Context)context, (int)n).convertToString().string;
                double d = tree.right.evaluate((Context)context, (int)n).convertToNumber().number;
                if (Double.isNaN(d)) {
                    return new Value("");
                }
                if (d < 1.0) {
                    return new Value(string);
                }
                int n4 = Math.round((float)(d - 1.0));
                if (n4 > string.length()) {
                    return new Value("");
                }
                return new Value(string.substring(n4));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new SAXException(indexOutOfBoundsException);
            }
        }
    }

    public final class EndsWith
    implements Instance {
        public int getMinParCount() {
            return 2;
        }

        public int getMaxParCount() {
            return 2;
        }

        public String getName() {
            return FNSP + "ends-with";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            String string = tree.left.evaluate((Context)context, (int)n).convertToString().string;
            String string2 = tree.right.evaluate((Context)context, (int)n).convertToString().string;
            return new Value(string.endsWith(string2));
        }
    }

    public final class StartsWith
    implements Instance {
        public int getMinParCount() {
            return 2;
        }

        public int getMaxParCount() {
            return 2;
        }

        public String getName() {
            return FNSP + "starts-with";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            String string = tree.left.evaluate((Context)context, (int)n).convertToString().string;
            String string2 = tree.right.evaluate((Context)context, (int)n).convertToString().string;
            return new Value(string.startsWith(string2));
        }
    }

    public final class Contains
    implements Instance {
        public int getMinParCount() {
            return 2;
        }

        public int getMaxParCount() {
            return 2;
        }

        public String getName() {
            return FNSP + "contains";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            String string = tree.left.evaluate((Context)context, (int)n).convertToString().string;
            String string2 = tree.right.evaluate((Context)context, (int)n).convertToString().string;
            return new Value(string.indexOf(string2) != -1);
        }
    }

    public final class NormalizeSpace
    implements Instance {
        public int getMinParCount() {
            return 0;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "normalize-space";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = FunctionTable.getOptionalValue(context, n, tree);
            String string = value.convertToString().string;
            int n2 = string.length();
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n3 = 0;
            while (n3 < n2) {
                char c = string.charAt(n3);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (bl) break;
                        stringBuffer.append(' ');
                        bl = true;
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                        bl = false;
                    }
                }
                ++n3;
            }
            value.string = stringBuffer.toString().trim();
            return value;
        }
    }

    public final class StringLength
    implements Instance {
        public int getMinParCount() {
            return 0;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "string-length";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = FunctionTable.getOptionalValue(context, n, tree);
            value.setNumber(value.convertToString().string.length());
            return value;
        }
    }

    public final class StringJoin
    implements Instance {
        public int getMinParCount() {
            return 2;
        }

        public int getMaxParCount() {
            return 2;
        }

        public String getName() {
            return FNSP + "string-join";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.left.evaluate(context, n);
            String string = tree.right.evaluate((Context)context, (int)n).convertToString().string;
            if (value.type == 0) {
                return value.setString("");
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (value != null) {
                Value value2 = value.next;
                stringBuffer.append(value.convertToString().string);
                if (value2 != null) {
                    stringBuffer.append(string);
                }
                value = value2;
            }
            return new Value(stringBuffer.toString());
        }
    }

    public final class Concat
    implements Instance {
        public int getMinParCount() {
            return 2;
        }

        public int getMaxParCount() {
            return Integer.MAX_VALUE;
        }

        public String getName() {
            return FNSP + "concat";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            if (tree.type == 34) {
                Value value = this.evaluate(context, n, tree.left);
                Value value2 = tree.right.evaluate(context, n).convertToString();
                value.string = value.string + value2.string;
                return value;
            }
            Value value = tree.evaluate(context, n).convertToString();
            return value;
        }
    }

    public final class Round
    implements Instance {
        public int getMinParCount() {
            return 1;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "round";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.evaluate(context, n);
            if (value.type == 0) {
                return value;
            }
            value.convertToNumber();
            if (Double.isNaN(value.number) || Double.isInfinite(value.number)) {
                return value;
            }
            value.number = Math.round(value.number);
            return value;
        }
    }

    public final class Ceiling
    implements Instance {
        public int getMinParCount() {
            return 1;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "ceiling";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.evaluate(context, n);
            if (value.type == 0) {
                return value;
            }
            value.convertToNumber();
            value.number = Math.ceil(value.number);
            return value;
        }
    }

    public final class Floor
    implements Instance {
        public int getMinParCount() {
            return 1;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "floor";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.evaluate(context, n);
            if (value.type == 0) {
                return value;
            }
            value.convertToNumber();
            value.number = Math.floor(value.number);
            return value;
        }
    }

    public final class False
    implements Instance {
        public int getMinParCount() {
            return 0;
        }

        public int getMaxParCount() {
            return 0;
        }

        public String getName() {
            return FNSP + "false";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            return new Value(false);
        }
    }

    public final class True
    implements Instance {
        public int getMinParCount() {
            return 0;
        }

        public int getMaxParCount() {
            return 0;
        }

        public String getName() {
            return FNSP + "true";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            return new Value(true);
        }
    }

    public final class Not
    implements Instance {
        public int getMinParCount() {
            return 1;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "not";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.evaluate(context, n).convertToBoolean();
            value.bool = !value.bool;
            return value;
        }
    }

    public final class GetInScopeNamespaces
    implements Instance {
        public int getMinParCount() {
            return 1;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "get-in-scope-namespaces";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.evaluate(context, n);
            if (value.type != 1) {
                throw new EvalException("The parameter passed to the `" + this.getName().substring(FNSP.length()) + "' function must be a node (got " + value + ")");
            }
            SAXEvent sAXEvent = value.event;
            if (sAXEvent.namespaces == null) {
                return value.setEmpty();
            }
            Value value2 = null;
            Value value3 = null;
            Enumeration enumeration = sAXEvent.namespaces.keys();
            while (enumeration.hasMoreElements()) {
                value = new Value((String)enumeration.nextElement());
                if (value3 != null) {
                    value3.next = value;
                } else {
                    value2 = value;
                }
                value3 = value;
            }
            if (value2 != null) {
                return value2;
            }
            return value.setEmpty();
        }
    }

    public final class GetNamespaceUriForPrefix
    implements Instance {
        public int getMinParCount() {
            return 2;
        }

        public int getMaxParCount() {
            return 2;
        }

        public String getName() {
            return FNSP + "get-namespace-uri-for-prefix";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.left.evaluate(context, n);
            if (value.type != 1) {
                throw new EvalException("The parameter passed to the `" + this.getName().substring(FNSP.length()) + "' function must be a node (got " + value + ")");
            }
            SAXEvent sAXEvent = value.event;
            String string = tree.right.evaluate((Context)context, (int)n).convertToString().string;
            if (sAXEvent.namespaces == null) {
                return value.setEmpty();
            }
            String string2 = (String)sAXEvent.namespaces.get(string);
            if (string2 == null) {
                return value.setEmpty();
            }
            return value.setString(string2);
        }
    }

    public final class NamespaceURI
    implements Instance {
        public int getMinParCount() {
            return 0;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "namespace-uri";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = FunctionTable.getOptionalValue(context, n, tree);
            if (value.type == 0) {
                return value;
            }
            if (value.type != 1) {
                throw new EvalException("The parameter passed to the `" + this.getName().substring(FNSP.length()) + "' function must be a node (got " + value + ")");
            }
            if (value.event.type == 1 || value.event.type == 6) {
                return value.setString(value.event.uri);
            }
            return value.setString("");
        }
    }

    public final class LocalName
    implements Instance {
        public int getMinParCount() {
            return 0;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "local-name";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = FunctionTable.getOptionalValue(context, n, tree);
            if (value.type == 0) {
                return value;
            }
            if (value.type != 1) {
                throw new EvalException("The parameter passed to the `" + this.getName().substring(FNSP.length()) + "' function must be a node (got " + value + ")");
            }
            switch (value.event.type) {
                case 1: 
                case 6: {
                    return value.setString(value.event.lName);
                }
                case 4: {
                    return value.setString(value.event.qName);
                }
            }
            return value.setString("");
        }
    }

    public final class Name
    implements Instance {
        public int getMinParCount() {
            return 0;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "name";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = FunctionTable.getOptionalValue(context, n, tree);
            if (value.type == 0) {
                return value;
            }
            if (value.type != 1) {
                throw new EvalException("The parameter passed to the `" + this.getName().substring(FNSP.length()) + "' function must be a node (got " + value + ")");
            }
            switch (value.event.type) {
                case 1: 
                case 4: 
                case 6: {
                    return value.setString(value.event.qName);
                }
            }
            return value.setString("");
        }
    }

    public final class NodeKind
    implements Instance {
        public int getMinParCount() {
            return 1;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "node-kind";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            Value value = tree.evaluate(context, n);
            if (value.type == 0) {
                return value;
            }
            if (value.type != 1) {
                throw new EvalException("The parameter passed to the `" + this.getName().substring(FNSP.length()) + "' function must be a node (got " + value + ")");
            }
            switch (value.event.type) {
                case 0: {
                    return new Value("document");
                }
                case 1: {
                    return new Value("element");
                }
                case 6: {
                    return new Value("attribute");
                }
                case 2: {
                    return new Value("text");
                }
                case 3: {
                    return new Value("cdata");
                }
                case 4: {
                    return new Value("processing-instruction");
                }
                case 5: {
                    return new Value("comment");
                }
            }
            throw new SAXException("unexpected node type: " + value.event);
        }
    }

    public final class HasChildNodes
    implements Instance {
        public int getMinParCount() {
            return 0;
        }

        public int getMaxParCount() {
            return 0;
        }

        public String getName() {
            return FNSP + "has-child-nodes";
        }

        public Value evaluate(Context context, int n, Tree tree) {
            return new Value(context.ancestorStack.size() == 1 || ((SAXEvent)context.ancestorStack.peek()).hasChildNodes);
        }
    }

    public final class Position
    implements Instance {
        public int getMinParCount() {
            return 0;
        }

        public int getMaxParCount() {
            return 0;
        }

        public String getName() {
            return FNSP + "position";
        }

        public Value evaluate(Context context, int n, Tree tree) {
            return new Value(context.position);
        }
    }

    public final class BooleanConv
    implements Instance {
        public int getMinParCount() {
            return 1;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "boolean";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            return tree.evaluate(context, n).convertToBoolean();
        }
    }

    public final class NumberConv
    implements Instance {
        public int getMinParCount() {
            return 0;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "number";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            return FunctionTable.getOptionalValue(context, n, tree).convertToNumber();
        }
    }

    public final class StringConv
    implements Instance {
        public int getMinParCount() {
            return 0;
        }

        public int getMaxParCount() {
            return 1;
        }

        public String getName() {
            return FNSP + "string";
        }

        public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
            return FunctionTable.getOptionalValue(context, n, tree).convertToString();
        }
    }

    public static interface Instance {
        public int getMinParCount();

        public int getMaxParCount();

        public String getName();

        public Value evaluate(Context var1, int var2, Tree var3) throws SAXException, EvalException;
    }
}

