/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import net.sf.joost.emitter.StxEmitter;
import net.sf.joost.stx.ErrorHandlerImpl;
import net.sf.joost.stx.SAXEvent;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class Emitter {
    private ContentHandler contH;
    private LexicalHandler lexH;
    private ErrorHandlerImpl errorHandler;
    private Hashtable inScopeNamespaces = new Hashtable();
    private Stack namespaceStack;
    private Stack openedElements;
    private Stack emitterStack;
    private String lastUri;
    private String lastLName;
    private String lastQName;
    private AttributesImpl lastAttrs;
    private String lastPublicId;
    private String lastSystemId;
    private int lastLineNo;
    private int lastColNo;
    private boolean insideCDATA = false;

    protected Emitter(ErrorHandlerImpl errorHandlerImpl) {
        this.inScopeNamespaces.put("", "");
        this.inScopeNamespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.namespaceStack = new Stack();
        this.namespaceStack.push(this.inScopeNamespaces.clone());
        this.openedElements = new Stack();
        this.emitterStack = new Stack();
        this.errorHandler = errorHandlerImpl;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contH = contentHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexH = lexicalHandler;
    }

    private void processLastElement() throws SAXException {
        String string;
        Object object;
        int n;
        Hashtable hashtable = (Hashtable)this.namespaceStack.peek();
        if (!this.lastUri.equals("")) {
            String string2 = "";
            n = this.lastQName.indexOf(":");
            if (n != -1) {
                string2 = this.lastQName.substring(0, n);
            }
            this.inScopeNamespaces.put(string2, this.lastUri);
        } else if (!"".equals(hashtable.get(""))) {
            this.inScopeNamespaces.put("", "");
        }
        int n2 = this.lastAttrs.getLength();
        n = 0;
        while (n < n2) {
            object = this.lastAttrs.getURI(n);
            if (!((String)object).equals("")) {
                string = this.lastAttrs.getQName(n);
                int n3 = string.indexOf(":");
                this.inScopeNamespaces.put(string.substring(0, n3), object);
            }
            ++n;
        }
        object = this.inScopeNamespaces.keys();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            String string3 = (String)this.inScopeNamespaces.get(string);
            if (string3.equals(hashtable.get(string))) continue;
            this.contH.startPrefixMapping(string, string3);
        }
        this.namespaceStack.push(this.inScopeNamespaces.clone());
        try {
            this.contH.startElement(this.lastUri, this.lastLName, this.lastQName, this.lastAttrs);
        }
        catch (SAXException sAXException) {
            this.errorHandler.error(sAXException.getMessage(), this.lastPublicId, this.lastSystemId, this.lastLineNo, this.lastColNo);
        }
        this.openedElements.push(this.lastUri);
        this.openedElements.push(this.lastQName);
        this.lastAttrs = null;
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5, String string6, int n, int n2) throws SAXException {
        if (this.lastAttrs == null) {
            this.errorHandler.error("Can't create an attribute if there's no opened element", string5, string6, n, n2);
            return;
        }
        int n3 = this.lastAttrs.getIndex(string, string3);
        if (n3 != -1) {
            this.lastAttrs.setValue(n3, string4);
        } else {
            this.lastAttrs.addAttribute(string, string3, string2, "CDATA", string4);
        }
    }

    public void startDocument() throws SAXException {
        if (this.contH != null) {
            this.contH.startDocument();
        }
    }

    public void endDocument(String string, String string2, int n, int n2) throws SAXException {
        if (this.contH != null) {
            if (this.lastAttrs != null) {
                this.processLastElement();
            }
            if (!this.openedElements.isEmpty()) {
                this.errorHandler.fatalError("Missing end tag for `" + this.openedElements.pop() + "' at the document end", string, string2, n, n2);
            }
            this.contH.endDocument();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, Hashtable hashtable, String string4, String string5, int n, int n2) throws SAXException {
        if (this.contH != null) {
            if (this.lastAttrs != null) {
                this.processLastElement();
            }
            this.lastUri = string;
            this.lastLName = string2;
            this.lastQName = string3;
            this.lastAttrs = attributes.getLength() != 0 ? new AttributesImpl(attributes) : new AttributesImpl();
            if (hashtable != null) {
                this.inScopeNamespaces.putAll(hashtable);
            }
            this.lastPublicId = string4;
            this.lastSystemId = string5;
            this.lastLineNo = n;
            this.lastColNo = n2;
        }
    }

    public void endElement(String string, String string2, String string3, String string4, String string5, int n, int n2) throws SAXException {
        if (this.contH != null) {
            if (this.lastAttrs != null) {
                this.processLastElement();
            }
            if (this.openedElements.isEmpty()) {
                this.errorHandler.fatalError("Attempt to emit unmatched end tag " + (string3 != null ? "`" + string3 + "' " : "") + "(no element opened)", string4, string5, n, n2);
                return;
            }
            String string6 = (String)this.openedElements.pop();
            String string7 = (String)this.openedElements.pop();
            if (!string3.equals(string6)) {
                this.errorHandler.fatalError("Attempt to emit unmatched end tag `" + string3 + "' (`" + string6 + "' expected)", string4, string5, n, n2);
                return;
            }
            if (!string.equals(string7)) {
                this.errorHandler.fatalError("Attempt to emit unmatched end tag `{" + string + "}" + string3 + "' (`{" + string7 + "}" + string6 + "' expected)", string4, string5, n, n2);
                return;
            }
            this.contH.endElement(string, string2, string3);
            this.inScopeNamespaces = (Hashtable)this.namespaceStack.pop();
            Hashtable hashtable = (Hashtable)this.namespaceStack.peek();
            Enumeration enumeration = this.inScopeNamespaces.keys();
            while (enumeration.hasMoreElements()) {
                String string8 = (String)enumeration.nextElement();
                String string9 = (String)this.inScopeNamespaces.get(string8);
                if (string9.equals(hashtable.get(string8))) continue;
                this.contH.endPrefixMapping(string8);
            }
            this.inScopeNamespaces = (Hashtable)hashtable.clone();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 == 0) {
            return;
        }
        if (this.contH != null) {
            if (this.lastAttrs != null) {
                this.processLastElement();
            }
            if (this.insideCDATA) {
                String string = new String(cArray, n, n2);
                int n3 = string.indexOf("]]>");
                while (n3 != -1) {
                    this.contH.characters(string.substring(0, n3 += 2).toCharArray(), 0, n3);
                    this.lexH.endCDATA();
                    this.lexH.startCDATA();
                    string = string.substring(n3);
                    n3 = string.indexOf("]]>");
                }
                this.contH.characters(string.toCharArray(), 0, string.length());
            } else {
                this.contH.characters(cArray, n, n2);
            }
        }
    }

    public void processingInstruction(String string, String string2, String string3, String string4, int n, int n2) throws SAXException {
        block3: {
            if (this.contH == null) break block3;
            if (this.lastAttrs != null) {
                this.processLastElement();
            }
            try {
                this.contH.processingInstruction(string, string2);
            }
            catch (SAXException sAXException) {
                this.errorHandler.error(sAXException.getMessage(), string3, string4, n, n2);
            }
        }
    }

    public void comment(char[] cArray, int n, int n2, String string, String string2, int n3, int n4) throws SAXException {
        block3: {
            if (this.contH != null && this.lastAttrs != null) {
                this.processLastElement();
            }
            if (this.lexH == null) break block3;
            try {
                this.lexH.comment(cArray, n, n2);
            }
            catch (SAXException sAXException) {
                this.errorHandler.error(sAXException.getMessage(), string, string2, n3, n4);
            }
        }
    }

    public void startCDATA(String string, String string2, int n, int n2) throws SAXException {
        if (this.contH != null && this.lastAttrs != null) {
            this.processLastElement();
        }
        if (this.lexH != null) {
            try {
                this.lexH.startCDATA();
            }
            catch (SAXException sAXException) {
                this.errorHandler.error(sAXException.getMessage(), string, string2, n, n2);
            }
            this.insideCDATA = true;
        }
    }

    public void endCDATA() throws SAXException {
        if (this.lexH != null) {
            this.lexH.endCDATA();
            this.insideCDATA = false;
        }
    }

    public void pushEmitter(StxEmitter stxEmitter) throws SAXException {
        this.namespaceStack.push(this.namespaceStack.elementAt(0));
        this.emitterStack.push(this.contH);
        this.emitterStack.push(this.lexH);
        if (this.lastAttrs != null) {
            this.emitterStack.push(SAXEvent.newElement(this.lastUri, this.lastLName, this.lastQName, this.lastAttrs, null));
            this.lastAttrs = null;
        } else {
            this.emitterStack.push(null);
        }
        this.contH = stxEmitter;
        this.lexH = stxEmitter;
    }

    public StxEmitter popEmitter() throws SAXException {
        if (this.lastAttrs != null) {
            this.processLastElement();
        }
        StxEmitter stxEmitter = null;
        if (this.contH instanceof StxEmitter) {
            stxEmitter = (StxEmitter)this.contH;
            Object e = this.emitterStack.pop();
            if (e != null) {
                SAXEvent sAXEvent = (SAXEvent)e;
                this.lastUri = sAXEvent.uri;
                this.lastQName = sAXEvent.qName;
                this.lastLName = sAXEvent.lName;
                this.lastAttrs = (AttributesImpl)sAXEvent.attrs;
            }
        } else {
            throw new SAXException("No StxEmitter on the emitter stack");
        }
        this.lexH = (LexicalHandler)this.emitterStack.pop();
        this.contH = (ContentHandler)this.emitterStack.pop();
        this.namespaceStack.pop();
        return stxEmitter;
    }

    public boolean isEmitterActive(StxEmitter stxEmitter) {
        return this.contH == stxEmitter || this.emitterStack.search(stxEmitter) != -1;
    }
}

