/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Properties;
import net.sf.joost.emitter.StreamEmitter;
import net.sf.joost.grammar.Tree;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ResultDocumentFactory
extends FactoryBase {
    private static Log log;
    private HashSet attrNames = new HashSet();

    public ResultDocumentFactory() {
        this.attrNames.add("href");
        this.attrNames.add("encoding");
    }

    public String getName() {
        return "result-document";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        String string2 = FactoryBase.getAttribute(string, attributes, "href", parseContext);
        Tree tree = FactoryBase.parseAVT(string2, parseContext);
        String string3 = attributes.getValue("encoding");
        FactoryBase.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, nodeBase, parseContext, tree, string3);
    }

    public final class Instance
    extends NodeBase {
        private Tree href;
        private String encoding;

        protected Instance(String string, NodeBase nodeBase, ParseContext parseContext, Tree tree, String string2) {
            super(string, nodeBase, parseContext, true);
            this.href = tree;
            this.encoding = string2;
        }

        public short process(Context context) throws SAXException {
            super.process(context);
            if (this.encoding == null) {
                this.encoding = context.currentProcessor.getOutputEncoding();
            }
            String string = this.href.evaluate((Context)context, (NodeBase)this).string;
            StreamEmitter streamEmitter = null;
            try {
                OutputStreamWriter outputStreamWriter;
                Object object;
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    object = new File(string.substring(0, n));
                    ((File)object).mkdirs();
                }
                object = new FileOutputStream(string);
                try {
                    outputStreamWriter = new OutputStreamWriter((OutputStream)object, this.encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    String string2 = "Unsupported encoding `" + this.encoding + "', using " + "UTF-8";
                    context.errorHandler.warning(string2, this.publicId, this.systemId, this.lineNo, this.colNo);
                    if (log != null) {
                        log.warn((Object)string2);
                    }
                    this.encoding = "UTF-8";
                    outputStreamWriter = new OutputStreamWriter((OutputStream)object, "UTF-8");
                }
                Properties properties = (Properties)context.currentProcessor.outputProperties.clone();
                properties.setProperty("encoding", this.encoding);
                streamEmitter = new StreamEmitter(outputStreamWriter, properties);
            }
            catch (IOException iOException) {
                context.errorHandler.error(iOException.toString(), this.publicId, this.systemId, this.lineNo, this.colNo);
                return 0;
            }
            streamEmitter.startDocument();
            context.emitter.pushEmitter(streamEmitter);
            return 0;
        }

        public short processEnd(Context context) throws SAXException {
            context.emitter.popEmitter().endDocument();
            return super.processEnd(context);
        }
    }
}

