/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.util.Stack;
import java.util.Vector;
import net.sf.joost.Constants;
import net.sf.joost.instruction.AbstractInstruction;
import net.sf.joost.instruction.VariableBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class NodeBase
extends AbstractInstruction
implements Constants {
    public String qName;
    protected NodeBase parent;
    protected AbstractInstruction lastChild;
    protected AbstractInstruction nodeEnd;
    public String publicId;
    public String systemId;
    public int lineNo;
    public int colNo;
    public boolean preserveSpace;
    protected Vector scopedVariables;
    protected Stack localFieldStack = new Stack();

    protected NodeBase(String string, NodeBase nodeBase, ParseContext parseContext, boolean bl) {
        this.qName = string;
        this.parent = nodeBase;
        if (parseContext.locator != null) {
            this.publicId = parseContext.locator.getPublicId();
            this.systemId = parseContext.locator.getSystemId();
            this.lineNo = parseContext.locator.getLineNumber();
            this.colNo = parseContext.locator.getColumnNumber();
        } else {
            this.systemId = "";
            this.publicId = "";
            this.colNo = -1;
            this.lineNo = -1;
        }
        if (bl) {
            this.next = this.nodeEnd = new End(this);
            this.lastChild = this;
        }
    }

    public NodeBase getNode() {
        return this;
    }

    public void insert(NodeBase nodeBase) throws SAXParseException {
        if (this.lastChild == null) {
            throw new SAXParseException("`" + this.qName + "' must be empty", nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
        }
        AbstractInstruction abstractInstruction = nodeBase;
        while (abstractInstruction.next != null) {
            abstractInstruction = abstractInstruction.next;
        }
        abstractInstruction.next = this.lastChild.next;
        this.lastChild.next = nodeBase;
        this.lastChild = abstractInstruction;
        if (nodeBase instanceof VariableBase && this.scopedVariables == null) {
            this.scopedVariables = new Vector();
        }
    }

    public boolean compile(int n) throws SAXException {
        return false;
    }

    protected void declareVariable(String string) {
        this.scopedVariables.addElement(string);
    }

    public short process(Context context) throws SAXException {
        if (this.scopedVariables != null) {
            this.localFieldStack.push(this.scopedVariables.clone());
            this.scopedVariables.clear();
        }
        return 0;
    }

    protected short processEnd(Context context) throws SAXException {
        if (this.scopedVariables != null) {
            Object[] objectArray = this.scopedVariables.toArray();
            int n = 0;
            while (n < objectArray.length) {
                context.localVars.remove(objectArray[n]);
                ++n;
            }
            this.scopedVariables = (Vector)this.localFieldStack.pop();
        }
        return 0;
    }

    public String toString() {
        return this.getClass().getName() + " " + this.lineNo;
    }

    private final class End
    extends AbstractInstruction {
        private NodeBase start;

        private End(NodeBase nodeBase2) {
            this.start = nodeBase2;
        }

        public NodeBase getNode() {
            return this.start;
        }

        public short process(Context context) throws SAXException {
            return this.start.processEnd(context);
        }

        public String toString() {
            return "end " + this.start;
        }
    }
}

