/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.util.HashSet;
import java.util.Hashtable;
import net.sf.joost.emitter.StringEmitter;
import net.sf.joost.grammar.Tree;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.GroupBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import net.sf.joost.stx.Value;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class AssignFactory
extends FactoryBase {
    private HashSet attrNames = new HashSet();

    public AssignFactory() {
        this.attrNames.add("name");
        this.attrNames.add("select");
    }

    public String getName() {
        return "assign";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        String string2 = FactoryBase.getAttribute(string, attributes, "name", parseContext);
        String string3 = FactoryBase.getExpandedName(string2, parseContext);
        String string4 = attributes.getValue("select");
        Tree tree = string4 != null ? FactoryBase.parseExpr(string4, parseContext) : null;
        FactoryBase.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, nodeBase, parseContext, string2, string3, tree);
    }

    public final class Instance
    extends NodeBase {
        private String varName;
        private String expName;
        private Tree select;

        protected Instance(String string, NodeBase nodeBase, ParseContext parseContext, String string2, String string3, Tree tree) {
            super(string, nodeBase, parseContext, tree == null);
            this.varName = string2;
            this.expName = string3;
            this.select = tree;
        }

        public short process(Context context) throws SAXException {
            if (this.select != null) {
                Value value = this.select.evaluate(context, this);
                this.processVar(value, context);
            } else {
                super.process(context);
                context.emitter.pushEmitter(new StringEmitter(new StringBuffer(), "(`" + this.qName + "' started in line " + this.lineNo + ")"));
            }
            return 0;
        }

        public short processEnd(Context context) throws SAXException {
            Value value = new Value(((StringEmitter)context.emitter.popEmitter()).getBuffer().toString());
            this.processVar(value, context);
            return super.processEnd(context);
        }

        private void processVar(Value value, Context context) throws SAXException {
            Hashtable hashtable = null;
            Object v = context.localVars.get(this.expName);
            if (v != null) {
                hashtable = context.localVars;
            } else {
                GroupBase groupBase = context.currentGroup;
                while (v == null && groupBase != null) {
                    hashtable = (Hashtable)groupBase.groupVars.peek();
                    v = hashtable.get(this.expName);
                    groupBase = groupBase.parentGroup;
                }
            }
            if (hashtable == null) {
                context.errorHandler.error("Can't assign to undeclared variable `" + this.varName + "'", this.publicId, this.systemId, this.lineNo, this.colNo);
                return;
            }
            hashtable.put(this.expName, value);
        }
    }
}

